/* hfload.c
 *
 * This file is subject to the terms and conditions of the GNU
 * General Public License.  See the file "COPYING" in the main
 * directory of this archive for more details.
 *
 * Copyright (C) 2000, Jay Carlson
 */

/*
 * Boot loader main program.
 */
#include <linux/config.h>

#include <unistd.h>
#include <linux/elf.h>
#include "hfload.h"
#include <asm/rtl865x/rtl865xc_asicregs.h>

#if defined(CONFIG_RTL865X) || defined(CONFIG_RTL8196B)
	#define BASE_ADDR 0xB8000000
	#define set_io_port_base(base)	\
		do { * (unsigned long *) &mips_io_port_base = (base); } while (0)	
	
	const unsigned long mips_io_port_base;
#endif


int file_offset;

int old_stack_pointer;

#define MAX_PHDRS_SIZE 8

Elf32_Ehdr header;
Elf32_Phdr phdrs[MAX_PHDRS_SIZE];

extern void flush_cache(void);

void
zero_region(char *start, char *end)
{
	char *addr;
	int count;

	count = end - start;
#ifndef __DO_QUIET__
	printf("zeroing from %08x to to %08x, 0x%x bytes\n", start, end, count);
#endif

#ifndef FAKE_COPYING
	memset(start, 0, count);
#endif
}

void
load_phdr(Elf32_Phdr *phdr)
{
	char *addr, *end;
	
	seek_forward(phdr->p_offset);
	
	addr = (char *)phdr->p_vaddr;
	end = ((char *)addr) + phdr->p_memsz;
	
	copy_to_region(addr, phdr->p_filesz);
	
	addr = ((char *)addr) + phdr->p_filesz;
	
	zero_region(addr, end);
}

void main(unsigned long stack_start_addr)
{
	int i;
	file_offset = 0;
	{
		RTL_W32(PCRP0, ((RTL_R32(PCRP0))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP1, ((RTL_R32(PCRP1))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP2, ((RTL_R32(PCRP2))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP3, ((RTL_R32(PCRP3))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP4, ((RTL_R32(PCRP4))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP4, ((RTL_R32(PCRP5))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP4, ((RTL_R32(PCRP6))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP4, ((RTL_R32(PCRP7))&(~EnablePHYIf)) ); /* Disable PHY IF */
		RTL_W32(PCRP4, ((RTL_R32(PCRP8))&(~EnablePHYIf)) ); /* Disable PHY IF */
	}
#ifdef CONFIG_RTL8186_KB
	/* default brightness 100% */
	RTL_W32(PEFGH_DAT,((RTL_R32(PEFGH_DAT)&(~(0xF8<< 24)))|((0x80)<<24)));
	/* power blink blue */
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|((0x1<< 24))));
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x2)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)|((0x2))));
#endif
#if defined(CONFIG_RTL865X) || defined(CONFIG_RTL8196B)
 	set_io_port_base(BASE_ADDR);
#endif

#ifndef __DO_QUIET__
	printf("decompressing kernel:\n");
#endif

#ifndef BZ2_COMPRESS
	decompress_kernel(UNCOMPRESS_OUT, stack_start_addr+4096, FREEMEM_END, 0);
#else
	decompress_kernel(UNCOMPRESS_OUT, stack_start_addr+4096, FREEMEM_END, 0);
#endif

#ifndef __DO_QUIET__
	printf("done decompressing kernel.\n");
#endif

	flush_cache();
	start_kernel(0x80000000);
}
