#ifndef STP_UNI_NETFILTER_H
#define STP_UNI_NETFILTER_H

/* --- STP/RSTP/MSTP Unified Definitions --- */

#include "krnmac.h"
#include "krntype.h"

#define STP_BASE_CTL				64+1024+64+64+600

/* set */
#define STP_SET_EBL				STP_BASE_CTL+1
#define STP_SET_DEBUG				STP_BASE_CTL+2
#define STP_SET_FORCE_VERSION			STP_BASE_CTL+3
#define STP_SET_FRWRD_DLY			STP_BASE_CTL+4
#define STP_SET_HELLO_TIME			STP_BASE_CTL+5
#define STP_SET_MAX_AGE				STP_BASE_CTL+6
#define STP_SET_PRIORITY			STP_BASE_CTL+7
#define STP_SET_MAX_HOPS			STP_BASE_CTL+8
#define STP_SET_NAME				STP_BASE_CTL+9
#define STP_SET_REVISION			STP_BASE_CTL+10
#define STP_SET_PORT_PATH_COST			STP_BASE_CTL+30
#define STP_SET_PORT_PRIORITY			STP_BASE_CTL+31
#define STP_SET_PORT_MCHECK			STP_BASE_CTL+32
#define STP_SET_PORT_EDGE			STP_BASE_CTL+33
#define STP_SET_PORT_NONSTP			STP_BASE_CTL+34
#define STP_SET_PORT_P2P			STP_BASE_CTL+35
#define STP_SET_PORT_DEBUG			STP_BASE_CTL+36
#define STP_SET_MST_PRIORITY			STP_BASE_CTL+60
#define STP_INS_MST				STP_BASE_CTL+61
#define STP_DEL_MST				STP_BASE_CTL+62
#define STP_SET_NOTIFY_VLAN_ADD			STP_BASE_CTL+63
#define STP_SET_NOTIFY_VLAN_DEL			STP_BASE_CTL+64
#define STP_SET_MST_PORT_PATH_COST		STP_BASE_CTL+80
#define STP_SET_MST_PORT_PRIORITY		STP_BASE_CTL+81
#define STP_SET_MAX				STP_BASE_CTL+95

/* get */
#define STP_GET_EBL				STP_BASE_CTL+1 
#define STP_GET_DEBUG				STP_BASE_CTL+2 
#define STP_GET_FORCE_VERSION			STP_BASE_CTL+3 
#define STP_GET_FRWRD_DLY			STP_BASE_CTL+4 
#define STP_GET_HELLO_TIME			STP_BASE_CTL+5 
#define STP_GET_MAX_AGE				STP_BASE_CTL+6 
#define STP_GET_PRIORITY			STP_BASE_CTL+7 
#define STP_GET_MAX_HOPS			STP_BASE_CTL+8 
#define STP_GET_NAME				STP_BASE_CTL+9 
#define STP_GET_REVISION			STP_BASE_CTL+10 
#define STP_GET_ROOT_HELLO_TIME			STP_BASE_CTL+11
#define STP_GET_ROOT_FRWRD_DLY			STP_BASE_CTL+12
#define STP_GET_ROOT_MAX_AGE			STP_BASE_CTL+13
#define STP_GET_ROOT_PRIORITY			STP_BASE_CTL+14
#define STP_GET_ROOT_MAC			STP_BASE_CTL+15
#define STP_GET_ROOT_PORT			STP_BASE_CTL+16
#define STP_GET_ROOT_PATH_COST			STP_BASE_CTL+17
#define STP_GET_NUM_TCN				STP_BASE_CTL+18
#define STP_GET_LAST_TCN			STP_BASE_CTL+19
#define STP_GET_HOLD_TIME			STP_BASE_CTL+20
#define STP_GET_MIGRATION_TIME			STP_BASE_CTL+21
#define STP_GET_PORT_PATH_COST			STP_BASE_CTL+30
#define STP_GET_PORT_PRIORITY			STP_BASE_CTL+31
#define STP_GET_PORT_MCHECK			STP_BASE_CTL+32
#define STP_GET_PORT_EDGE			STP_BASE_CTL+33
#define STP_GET_PORT_NONSTP			STP_BASE_CTL+34
#define STP_GET_PORT_P2P			STP_BASE_CTL+35
#define STP_GET_PORT_DES_PORT_PRIORITY		STP_BASE_CTL+36
#define STP_GET_PORT_DES_PORT_ID		STP_BASE_CTL+37
#define STP_GET_PORT_DES_PATH_COST		STP_BASE_CTL+38
#define STP_GET_PORT_DES_BRIDGE_PRIORITY	STP_BASE_CTL+39
#define STP_GET_PORT_DES_BRIDGE_MAC		STP_BASE_CTL+40
#define STP_GET_PORT_STATE			STP_BASE_CTL+41
#define STP_GET_PORT_ROLE			STP_BASE_CTL+42
#define STP_GET_PORT_UPTIME			STP_BASE_CTL+43
#define STP_GET_PORT_RX_CFG			STP_BASE_CTL+44
#define STP_GET_PORT_TX_CFG			STP_BASE_CTL+45
#define STP_GET_PORT_RX_RST			STP_BASE_CTL+46
#define STP_GET_PORT_TX_RST			STP_BASE_CTL+47
#define STP_GET_PORT_RX_TCN			STP_BASE_CTL+48
#define STP_GET_PORT_TX_TCN			STP_BASE_CTL+49
#define STP_GET_PORT_RX_MST			STP_BASE_CTL+50
#define STP_GET_PORT_TX_MST			STP_BASE_CTL+51
#define STP_GET_MST_PRIORITY			STP_BASE_CTL+60
#define STP_GET_MST_EBL				STP_BASE_CTL+61
#define STP_GET_MST_VLAN			STP_BASE_CTL+62
#define STP_GET_MST_ROOT_PORT_ID		STP_BASE_CTL+63
#define STP_GET_MST_ROOT_PATH_COST		STP_BASE_CTL+64
#define STP_GET_MST_ROOT_PRIORITY		STP_BASE_CTL+65
#define STP_GET_MST_ROOT_MAC			STP_BASE_CTL+66
#define STP_GET_MST_TC				STP_BASE_CTL+67
#define STP_GET_MST_PORT_PATH_COST		STP_BASE_CTL+80
#define STP_GET_MST_PORT_PRIORITY		STP_BASE_CTL+81
#define STP_GET_MST_PORT_DES_PORT_PRIORITY	STP_BASE_CTL+82
#define STP_GET_MST_PORT_DES_PORT_ID		STP_BASE_CTL+83
#define STP_GET_MST_PORT_DES_PATH_COST		STP_BASE_CTL+84
#define STP_GET_MST_PORT_DES_BRIDGE_PRIORITY	STP_BASE_CTL+85
#define STP_GET_MST_PORT_DES_BRIDGE_MAC		STP_BASE_CTL+86
#define STP_GET_MST_PORT_STATE			STP_BASE_CTL+87
#define STP_GET_MST_PORT_ROLE			STP_BASE_CTL+88
#define STP_GET_VLAN_PORT_STATE			STP_BASE_CTL+89
#define STP_GET_MAX				STP_BASE_CTL+95

/* definitions */
#define MAX_STP_NAME_LEN			32
#define MAX_STP_VLAN_MASK_LEN			4096/32
#define MAX_STP_MST_IDS				16
#define MACH_NAME_LEN				10

typedef enum {
	STP_VERSION_NONE,
	STP_VERSION_STP,
	STP_VERSION_RSTP,
	STP_VERSION_MSTP
} STP_VERSION;

typedef enum {
	STP_PORT_STATE_DISABLED,
	STP_PORT_STATE_LISTENING,
	STP_PORT_STATE_LEARNING,
	STP_PORT_STATE_FORWARDING,
	STP_PORT_STATE_BLOCKING,
	STP_PORT_STATE_DISCARDING,
	STP_PORT_STATE_NON_STP
} STP_PORT_STATE;

typedef enum {
	STP_PORT_ROLE_DISABLED,
	STP_PORT_ROLE_ALTERNATE,
	STP_PORT_ROLE_BACKUP,
	STP_PORT_ROLE_DESIGNATED,
	STP_PORT_ROLE_ROOT,
	STP_PORT_ROLE_NON_STP,
	STP_PORT_ROLE_MASTER
} STP_PORT_ROLE;

typedef enum {
	STP_PORT_P2P_FORCE_FALSE,
	STP_PORT_P2P_FORCE_TRUE,
	STP_PORT_P2P_AUTO
} STP_PORT_P2P;

/* structs */
typedef struct {
	Tuint8	ucPortId;
	Tbool	bBool;
} TstStpPortBool;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	ucUByte;
} TstStpPortUByte;

typedef struct {
	Tuint8	ucPortId;
	Tuint16	usUShort;
} TstStpPortUShort;

typedef struct {
	Tuint8	ucPortId;
	Tuint32	ulULong;
} TstStpPortULong;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	aucMac[MAC_ADDR_LEN];
} TstStpPortMac;

typedef struct {
	Tuint8	ucPortId;
	Tuint8	aucMachName[MACH_NAME_LEN];
	Tbool	bEbl;
} TstStpPortMachine;

typedef struct {
	Tuint8	ucMstId;
	Tbool	bBool;
} TstStpMstBool;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucUByte;
} TstStpMstUByte;

typedef struct {
	Tuint8	ucMstId;
	Tuint16	usUShort;
} TstStpMstUShort;

typedef struct {
	Tuint8	ucMstId;
	Tuint32	ulULong;
} TstStpMstULong;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	aucMac[MAC_ADDR_LEN];
} TstStpMstMac;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucPortId;
	Tbool	bBool;
} TstStpMstPortBool;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucPortId;
	Tuint8	ucUByte;
} TstStpMstPortUByte;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucPortId;
	Tuint16	usUShort;
} TstStpMstPortUShort;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucPortId;
	Tuint32	ulULong;
} TstStpMstPortULong;

typedef struct {
	Tuint8	ucMstId;
	Tuint8	ucPortId;
	Tuint8	aucMac[MAC_ADDR_LEN];
} TstStpMstPortMac;

typedef struct {
	Tuint8	ucMstId;
	Tuint32	aulVlanMask[MAX_STP_VLAN_MASK_LEN];
} TstStpMstVlan;

typedef struct {
	Tuint16		usVlanId;
	TstLPortMask	stPortMask;
} TstStpVlan;

typedef struct {
	Tuint8	ucMstId;
	Tuint16	usVlanId;
	Tuint8	ucPortId;
	Tuint8	ucPortState;
} TstStpMstPortState;
#endif

