
/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
// ********************************************
// Name   : stp_netfilter.c
// Author : Pin Chuan Liu(N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : 
// ********************************************
/*
 * $Log: stp_netfilter.c,v $
 * Revision 1.1.1.1  2009/02/17 09:44:45  anderson
 * RTL8196B source code
 *
 * Revision 1.17  2007/08/23 01:41:55  michael
 * Bug: 623
 * linux-2.6.19 fix
 *
 * Revision 1.16  2006/05/10 08:51:03  michael
 * Bug: 585
 * Reverse MAC address.
 *
 * Revision 1.15  2005/11/16 03:09:38  michael
 * Bug: 585
 * Fixed incorrect return value in spanning-tree port information.
 *
 * Revision 1.14  2005/03/16 09:02:13  flash
 * add license notice
 *
 * Revision 1.13  2004/11/18 03:14:44  michael
 * Merged stp/rstp/mstp_netfilter.h into stp_uni_netfilter.h
 *
 * Revision 1.12  2004/09/16 06:06:45  michael
 * *** empty log message ***
 *
 * Revision 1.11  2004/06/08 01:26:03  flash
 * add forward transition
 *
 * Revision 1.10  2004/06/03 01:11:08  flash
 * fix tcn and jiffs number
 *
 * Revision 1.9  2003/09/19 07:11:16  flash
 * fix some bugs to pass ANVL
 *
 * Revision 1.8  2003/09/10 01:33:51  flash
 * change stpd term to stp
 *
 * Revision 1.7  2003/09/10 00:39:02  flash
 * Fix show stp port parameter error
 *
 * Revision 1.6  2003/09/09 08:58:03  flash
 * fix some bugs
 *
 * Revision 1.5  2003/09/09 03:01:38  flash
 * Add some commands
 *
 * Revision 1.4  2003/09/04 08:42:59  flash
 * Fix netfilter return value
 *
 * Revision 1.3  2003/09/04 04:31:24  flash
 * Fix some bugs
 *
 * Revision 1.2  2003/09/03 08:33:56  flash
 * Add some ioctl functions
 *
 */


#include <linux/kernel.h>   
#include <linux/fs.h>       
#include <asm/uaccess.h>
#include <asm/unaligned.h>
#include <linux/netdevice.h>		
#include <linux/skbuff.h>		
#include <linux/stddef.h>		
#include <linux/netfilter.h>		

#include "krndef.h"
#include "krnmac.h"
#include "krntype.h"

#include "stp.h"
#include "../stp_uni/stp_uni_netfilter.h"

extern struct stp_t stp_info;
extern Bridge_data bridge_info; /* (8.5.3) */
extern Port_data port_info[All_ports];
extern int forward_transition[];
int num_tcn;
unsigned long last_tcn;

/* This function is called whenever a process tries to 
 * do an ioctl on our device file. */
int do_stp_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
 {
  Tbool bBool;
  Tuint8 ucUByte;
  Tuint16 usUShort;
  TstStpPortUByte stStpPortUByte;
  TstStpPortULong stStpPortULong;

  /* Switch according to the ioctl called */
  switch (cmd)
   {
    // enable or disable STP protocol      
	case STP_SET_EBL:
      		copy_from_user(&bBool, user, sizeof(Tbool));
		if (bBool) {
			stp_start();
		}
		else {
			stp_stop();
		}
		break;
 
	case STP_SET_FRWRD_DLY:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		stp_info.bridge_info.bridge_forward_delay = ucUByte;
		bridge_info.bridge_forward_delay = (Time)(ucUByte*256); /* (8.5.3.10) */
		break;

	case STP_SET_HELLO_TIME:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		stp_info.bridge_info.bridge_hello_time = ucUByte;
		bridge_info.bridge_hello_time = (Time)(ucUByte*256); /* (8.5.3.9) */
		break;

	case STP_SET_MAX_AGE:
		copy_from_user(&ucUByte, user, sizeof(Tuint8));
		stp_info.bridge_info.bridge_max_age = ucUByte;
		bridge_info.bridge_max_age = (Time)(ucUByte*256); /* (8.5.3.8) */
		break;

	case STP_SET_PRIORITY:
		copy_from_user(&usUShort, user, sizeof(Tuint16));
		(stp_info.bridge_info.bridge_id.four_octets[0]) &= 0x0000FFFFl;	
		(stp_info.bridge_info.bridge_id.four_octets[0]) |= (usUShort<<16l);	
//		(bridge_info.bridge_id.four_octets[0]) &= 0x0000FFFFl; /* (8.5.3.7) */
//		(bridge_info.bridge_id.four_octets[0]) |= (usUShort<<16l); /* (8.5.3.7) */
		{
		Identifier new_bridge_id;

		new_bridge_id.four_octets[0] = (bridge_info.bridge_id.four_octets[0])&0x0000FFFFl; /* (8.5.3.7) */
		new_bridge_id.four_octets[1] = (bridge_info.bridge_id.four_octets[1]); /* (8.5.3.7) */
		new_bridge_id.four_octets[0] |= (usUShort<<16l); /* (8.5.3.7) */
		set_bridge_priority(new_bridge_id);
		}
		break;

	case STP_SET_PORT_PATH_COST:
		copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
		stp_info.port_info[stStpPortULong.ucPortId+1].path_cost = stStpPortULong.ulULong;	
//		port_info[stStpPortULong.ucPortId+1].path_cost=(Int)(stStpPortULong.ulULong); /* (8.5.5.3) */
		set_path_cost(stStpPortULong.ucPortId+1, stStpPortULong.ulULong);
		break;

	case STP_SET_PORT_PRIORITY:
		copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
		(stp_info.port_info[stStpPortUByte.ucPortId+1].port_id) &= 0x00FF;	
		(stp_info.port_info[stStpPortUByte.ucPortId+1].port_id) |= (stStpPortUByte.ucUByte) << 8;	
//		(port_info[stStpPortUByte.ucPortId+1].port_id) &= 0x00FF; /* (8.5.5.1) */
//		(port_info[stStpPortUByte.ucPortId+1].port_id) |= ((Int)(stStpPortUByte.ucUByte) << 8); /* (8.5.5.1) */
		{
	 	Port_id new_port_id;

		new_port_id = port_info[stStpPortUByte.ucPortId+1].port_id & 0x00FF;
		new_port_id |= ((Int)(stStpPortUByte.ucUByte) << 8);

		set_port_priority(stStpPortUByte.ucPortId+1, new_port_id); 
		}
		break;

	default:
		break;  
  }

  return 0;
}


int do_stp_get_ctl(struct sock *sk, int cmd, void *user, int *len)
 {
  Tbool bBool;
  Tuint8 ucUByte;
  Tuint16 usUShort;
  Tuint32 ulULong;
  Tuint8 aucMac[MAC_ADDR_LEN];
  TstStpPortUByte stStpPortUByte;
  TstStpPortUShort stStpPortUShort;
  TstStpPortULong stStpPortULong;
  TstStpPortMac stStpPortMac;

  switch(cmd)
   {
	case STP_GET_EBL:
		bBool = (stp_info.global_enable > 0) ? True : False;
		copy_to_user(user, &bBool, sizeof(Tbool));
		break;

	case STP_GET_PRIORITY:
		usUShort = (bridge_info.bridge_id.four_octets[0] >> 16) & 0xFFFF;
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;

	case STP_GET_HELLO_TIME:
		ucUByte = bridge_info.bridge_hello_time/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_MAX_AGE:
		ucUByte = bridge_info.bridge_max_age/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_FRWRD_DLY:
		ucUByte = bridge_info.bridge_forward_delay/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_ROOT_HELLO_TIME:
		ucUByte = bridge_info.hello_time/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_ROOT_FRWRD_DLY:
		ucUByte = bridge_info.forward_delay/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_ROOT_MAX_AGE:
		ucUByte = bridge_info.max_age/256;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_ROOT_PRIORITY:
		usUShort = ((bridge_info.designated_root.four_octets[0]) >> 16) & 0xFFFF;
		copy_to_user(user, &usUShort, sizeof(Tuint16));
		break;

	case STP_GET_ROOT_MAC:
		aucMac[0] = ((bridge_info.designated_root.four_octets[1]) >> 0) & 0xFF;
		aucMac[1] = ((bridge_info.designated_root.four_octets[1]) >> 8) & 0xFF;
		aucMac[2] = ((bridge_info.designated_root.four_octets[1]) >> 16) & 0xFF;
		aucMac[3] = ((bridge_info.designated_root.four_octets[1]) >> 24) & 0xFF;
		aucMac[4] = ((bridge_info.designated_root.four_octets[0]) >> 0) & 0xFF;
		aucMac[5] = ((bridge_info.designated_root.four_octets[0]) >> 8) & 0xFF;
		copy_to_user(user, aucMac, sizeof(Tuint8)*MAC_ADDR_LEN);
		break;

	case STP_GET_ROOT_PORT:
		ucUByte = bridge_info.root_port;
		copy_to_user(user, &ucUByte, sizeof(Tuint8));
		break;

	case STP_GET_ROOT_PATH_COST:
		ulULong = bridge_info.root_path_cost;
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;

	case STP_GET_NUM_TCN:
		ulULong = num_tcn;
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;

	case STP_GET_LAST_TCN:
		ulULong = (jiffies-last_tcn)/100;		
		copy_to_user(user, &ulULong, sizeof(Tuint32));
		break;

	case STP_GET_PORT_PATH_COST:
		copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
		stStpPortULong.ulULong = port_info[stStpPortULong.ucPortId+1].path_cost;
		copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
		break;

	case STP_GET_PORT_PRIORITY:
		copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
		stStpPortUByte.ucUByte = (port_info[stStpPortUByte.ucPortId+1].designated_port >> 8) & 0xFF;
		copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
		break;

	case STP_GET_PORT_STATE:
		copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
		switch (port_info[stStpPortUByte.ucPortId+1].state)
		{
		case 1:
			stStpPortUByte.ucUByte = STP_PORT_STATE_LISTENING;
			break;
		case 2:
			stStpPortUByte.ucUByte = STP_PORT_STATE_LEARNING;
			break;
		case 3:
			stStpPortUByte.ucUByte = STP_PORT_STATE_FORWARDING;
			break;
		case 4:
			stStpPortUByte.ucUByte = STP_PORT_STATE_BLOCKING;
			break;
		case 0:
		default:
			stStpPortUByte.ucUByte = STP_PORT_STATE_DISABLED;
			break;
		}
		copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
		break;

	case STP_GET_PORT_DES_PORT_PRIORITY:
		copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
		stStpPortUByte.ucUByte = (port_info[stStpPortUByte.ucPortId+1].designated_port >> 8) & 0xFF;
		copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
		break;

	case STP_GET_PORT_DES_PORT_ID:
		copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
		stStpPortUByte.ucUByte = port_info[stStpPortUByte.ucPortId+1].designated_port & 0xFF;
		copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
		break;

	case STP_GET_PORT_DES_PATH_COST:
		copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
		stStpPortULong.ulULong = port_info[stStpPortULong.ucPortId+1].designated_cost;
		copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
		break;

	case STP_GET_PORT_DES_BRIDGE_PRIORITY:
		copy_from_user(&stStpPortUShort, user, sizeof(TstStpPortUShort));
		stStpPortUShort.usUShort = ((port_info[stStpPortUShort.ucPortId+1].designated_bridge.four_octets[0]) >> 16) & 0xFFFF;
		copy_to_user(user, &stStpPortUShort, sizeof(TstStpPortUShort));
		break;

	case STP_GET_PORT_DES_BRIDGE_MAC:
		copy_from_user(&stStpPortMac, user, sizeof(TstStpPortMac));
		stStpPortMac.aucMac[0] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[1]) >> 0) & 0xFF;
		stStpPortMac.aucMac[1] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[1]) >> 8) & 0xFF;
		stStpPortMac.aucMac[2] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[1]) >> 16) & 0xFF;
		stStpPortMac.aucMac[3] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[1]) >> 24) & 0xFF;
		stStpPortMac.aucMac[4] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[0]) >> 0) & 0xFF;
		stStpPortMac.aucMac[5] = ((port_info[stStpPortMac.ucPortId+1].designated_bridge.four_octets[0]) >> 8) & 0xFF;
		copy_to_user(user, &stStpPortMac, sizeof(TstStpPortMac));
		break;

	default:
		break;  
   }
  return 0;
 }

struct nf_sockopt_ops stp_sockopts = {
                { NULL, NULL }, PF_INET,
                STP_BASE_CTL, STP_SET_MAX+1, do_stp_set_ctl, NULL,
                STP_BASE_CTL, STP_GET_MAX+1, do_stp_get_ctl, NULL
};

