
/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
/* stp - spanning tree protocol 
 *
 *
 */

#ifndef __STP_H__
#define __STP_H__

#include "ieee802_1d.h"

#define DFLT_PATH_COST 10
/* Frequency of calling the spanning tree "tick" function in Hz.
 * The tick function implements the spanning tree timers.
 * (256 / SPAN_TREE_TICK_FUNC_FREQ) must be an integer. 
 */
#define SPAN_TREE_TICK_FUNC_FREQ  4

/* Maximum number of ports used at execution */
#define No_of_ports    ulMaxNoPorts

/* Spanning tree tick scaling factor for the tick function, in 1/256 seconds. */
#define SPAN_TREE_TICK_SCALING (256/SPAN_TREE_TICK_FUNC_FREQ)

extern unsigned long ulSpanTreeTickScaling;
/* Global variable for maximum number of ports used */
extern unsigned long ulMaxNoPorts;

extern void CCLSetPortState(Int port_no, State state);

extern void CCLSendConfigBpdu(Int port_no, Config_bpdu *bpdu);

extern void CCLSendTcnBpdu(Int port_no, Tcn_bpdu *bpdu);

void stp_start();
void stp_stop();

#define BPDU_PRIORITY       5
#define CONFIG_BPDU_MESSAGE_BYTES 35
#define CONFIG_BPDU_PROTOCOL_ID 0
#define CONFIG_BPDU_VERSION 0
#define TCN_BPDU_MESSAGE_BYTES 4
#define TCN_BPDU_PROTOCOL_ID   0
#define TCN_BPDU_VERSION       0

#define PORTCTL_1000M_FULL                  0x1C
#define PORTCTL_1000M_HALF                  0x0C
#define PORTCTL_100M_FULL                   0x18
#define PORTCTL_100M_HALF                   0x08
#define PORTCTL_10M_FULL                    0x14
#define PORTCTL_10M_HALF                    0x04  

struct stp_t
 {
  int global_enable;
  Bridge_data bridge_info;
  Port_data port_info[All_ports];
 };

#endif /* __STP_H__ */
