/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
/* stp - spanning tree protocol 
 *
 *
 */


#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/if_ether.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/spinlock.h>
#include <asm/unaligned.h>
#include <linux/netfilter.h>

#include "ieee802_1d.h"
#include "stp.h"

#include "krnmac.h"
#include "krnport.h"
#include "krnportmask.h"
#include "krnstp.h"
#include "krnsys.h"
#include "krntype.h"

#include "../cclmx/ccl.h"
#include "../cclmx/ccl_mx.h"

#undef  STP_DEBUG
#define STP_PORT_MAX 27


extern void (*gvrp_stp_port_forwarding)(int );
extern void (*gvrp_stp_port_disabled)(int );
extern void (*gmrp_stp_port_forwarding)(int );
extern void (*gmrp_stp_port_disabled)(int );
extern void (*igmp_stp_port_forwarding)(int );
extern void (*igmp_stp_port_disabled)(int );
extern int num_tcn;
extern unsigned long last_tcn;
extern struct nf_sockopt_ops stp_sockopts; 
struct stp_t stp_info;
unsigned char bridge_mac[6];
unsigned long ulSpanTreeTickScaling;
unsigned long ulMaxNoPorts = 0; /* port threads will increase this */

static int periodical_thread_pid;
static int port_thread_pid;
static int stp_tick_enable;
static int restart;
//SNMP Bridge MIB
int forward_transition[STP_PORT_MAX];

static void sleep(unsigned howlong)
 {
  if(in_interrupt())
   {
    return;
   }

  current->state = TASK_INTERRUPTIBLE;
  schedule_timeout(howlong);
 }

/* this thread will use portdrv to find out any port changes 
 * and report them to the ieee 802.1d code.
 */

static spinlock_t stp_ieee_sem;

static int stp_port_thread(void * vp)
{
	int	i;
	int	enabled;
	Cost	c; 
	Tbool	bLink;
	Tuint8	ucNego;
	Tuint8	ucSpeed;
	Tuint8	ucDuplex;
	Tbool	link[STP_PORT_MAX];
	Tuint8	nego[STP_PORT_MAX];
	Tuint8	speed[STP_PORT_MAX];
	Tuint8	duplex[STP_PORT_MAX];

	for (i = 0; i < STP_PORT_MAX; ++i) {
		K_PortGetLink(i, &(link[i]));
		K_PortGetNego(i, &(nego[i]));
		K_PortGetSpeedDuplex(i, &(speed[i]), &(duplex[i]));
		enabled = 0;
		c = 0;
		//printk("STP: Port %d PortEbl=%d\n", i+1, link[i]);
		if (link[i] == False) {
#ifdef STP_DEBUG
			printk("STP: Port %d disable\n", i);
#endif
			enabled = 0;
		}
		else if (speed[i]== PORT_SPEED_10) {
#ifdef STP_DEBUG
			printk("STP: Port %d 10M\n", i);
#endif
			c = 100; /* (8.8.6) Table 8.5 */
			enabled = 1;
		}
		else if (speed[i]== PORT_SPEED_100) {
#ifdef STP_DEBUG
			printk("STP: Port %d 100M\n", i);
#endif
			//many product set to 10
			//c = 19;  /* (8.8.6) Table 8.5 */
			c = 10;  /* (8.8.6) Table 8.5 */
			enabled = 1;
		}
		else if (speed[i]== PORT_SPEED_1000) {
#ifdef STP_DEBUG
			printk("STP: Port %d 1000M\n", i);
#endif
			c = 4;   /* (8.8.6) Table 8.5 */
			enabled = 1;
		}
		else {   
			/* warn and disable if bad bitfields */
#ifdef STP_DEBUG
			printk("STP: Error Value %d\n", speed[i]);
#endif
			enabled = 0;
		}

		//printk("STP : port = %d, enabled = %d, cost = %d\n", i+1, enabled, c);

		spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */

		if (enabled) {
			//printk("port %d is enabled cost=%d\n", i, c);
			enable_port(i + 1);
			set_path_cost(i + 1, c);
		}
		else {
			//printk("port %d is disabled\n", i);
			//set_path_cost(i + 1, DEF_PATH_COST);
			disable_port(i + 1);
		}
    
		spin_unlock(&stp_ieee_sem);
	}

	while (1) {
		if (!stp_tick_enable) {
			sleep(1000);
			continue;
		}

		for (i = 0; i < STP_PORT_MAX; ++i) {
			K_PortGetLink(i, &bLink);
			K_PortGetNego(i, &ucNego);
			K_PortGetSpeedDuplex(i, &ucSpeed, &ucDuplex);

#ifdef STP_DEBUG
			//printk("STP: Port %d Link=%d\n", i+1, bLink);
#endif

			if (!restart && (link[i] == bLink) && (nego[i] == ucNego) && (speed[i] == ucSpeed) && (duplex[i] == ucDuplex)) {
				sleep(10);
				continue;
			}

			if (restart) {
				--restart;
			}
			link[i] = bLink;
			nego[i] = ucNego;
			speed[i] = ucSpeed;
			duplex[i] = ucDuplex;

			enabled = 0;
			c = 0;
			if (!bLink) {
#ifdef STP_DEBUG
				printk("STP: Port %d disable\n",i);
#endif
				enabled = 0;
			}
			else if (ucSpeed == PORT_SPEED_10) {
#ifdef STP_DEBUG
				printk("STP: Port %d 10M\n", i);
#endif
				c = 100; /* (8.8.6) Table 8.5 */
				enabled = 1;
			}
			else if (ucSpeed == PORT_SPEED_100) {
#ifdef STP_DEBUG
				printk("STP: Port %d 100M\n", i);
#endif
				//many product set to 10
				//c = 19;  /* (8.8.6) Table 8.5 */
				c = 10;  /* (8.8.6) Table 8.5 */
				enabled = 1;
			}
			else if (ucSpeed == PORT_SPEED_1000) {
#ifdef STP_DEBUG
				printk("STP: Port %d 1000M\n", i);
#endif
				c = 4;   /* (8.8.6) Table 8.5 */
				enabled = 1;
			}
			else {   
				/* warn and disable if bad bitfields */
#ifdef STP_DEBUG
				printk("STP: Error Value %d\n", ucSpeed);
#endif
				enabled = 0;
			}

			//printk("STP : port = %d, enabled = %d, cost = %d\n", i+1, enabled, c);

			spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */

			if (enabled) {
				//printk("port %d is enabled cost=%d\n", i, c);
				enable_port(i + 1);
				set_path_cost(i + 1, c);
			}
			else {
				//printk("port %d is disabled\n", i);
				disable_port(i + 1);
			}
    
			spin_unlock(&stp_ieee_sem);
		}
	}

	return 0;
}


/*
  periodically run
 */

static int stp_periodical_thread(void * vp)
 {
  while(1) 
   {
    if(!stp_tick_enable) {sleep(1000); continue;}
//    printk("STP: Tick\n");
    spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */
    STP_tick();
//    printk("STP: Tick3\n");
    spin_unlock(&stp_ieee_sem);
//    printk("STP: Tick4\n");

//    sleep(10);
//    sleep(23);
    sleep(25);
   }

  return 0;
}

/* The CallBack function.
 * This function will get bpdu packets from
 * the VT6526 and report them to the ieee 802.1d code.
 */

/****************************************************************/
static int ccl_stp(struct sk_buff *skb)
 {

#ifdef STP_DEBUG
  printk("STP: program receives a packet!! %d %d %d %d %d %d\n",CCL_P(skb)->wSize,CCL_P(skb)->wVid,CCL_P(skb)->byPriority,CCL_P(skb)->bySrcPortId,CCL_P(skb)->byFwdReason,CCL_P(skb)->bIfTagged);
#endif

  /* Process the  BPDU packet */
  {
   Config_bpdu receivedConfigBpdu;
   Tcn_bpdu receivedTcnBpdu;
   Bpdu_type bpduMessageType;
   Protocol_version protocolVersion;
   int port_no;
   unsigned int uiProtocolIdentifier;
   unsigned char * pucEthernet;

   pucEthernet = (unsigned char *)skb->mac.raw;
//     printk("len=%d\n",(ntohs(*((unsigned short*)(pucEthernet+12)))) );
//   if (CCL_P(skb)->wSize >= 17)
   if ((ntohs(*((unsigned short*)(pucEthernet+12)))) >= 17)
    {
     unsigned char * pucBPDU;

     pucEthernet = (unsigned char *)skb->mac.raw;
     if(CCL_P(skb)->bIfTagged)
      pucBPDU = &pucEthernet[17 + 4 /* ignore the silly VLAN tag */];
     else
      pucBPDU = &pucEthernet[17];

     /* Find BPDU Protocol Identifier. 
     * First and second byte in configuration message. */
  
     uiProtocolIdentifier = ((unsigned int)pucBPDU[0] << 8) + (unsigned int)pucBPDU[1]; 

     /* Find BPDU Protocol Version. 
      * Third byte in configuration message. */
  
     protocolVersion = pucBPDU[2];

     /* Find BPDU message type. 
      * Fourth byte in configuration message. */

     bpduMessageType = pucBPDU[3];

#ifdef DUMP_RECEIVED_BPDU
   /* test */
   {
     int i;

     for (i = 0;i < 32;i++) {
     
       if ((i % 16) == 0) {
  fprintf(stderr, "\n%02x ",pucEthernet[i]);
       }
       else {
  fprintf(stderr, "%02x ",pucEthernet[i]);
       }
     }
     fprintf(stderr, "\n");
   }
#endif

     if (uiProtocolIdentifier == 0) 
      {
       switch (bpduMessageType) 
        {
         case Config_bpdu_type:
#ifdef STP_DEBUG
  printk("STP: program receives a BPDU packet!! size:%d vid:%d priority:%d portid:%d reason:%d iftag:%d\n",CCL_P(skb)->wSize,CCL_P(skb)->wVid,CCL_P(skb)->byPriority,CCL_P(skb)->bySrcPortId,CCL_P(skb)->byFwdReason,CCL_P(skb)->bIfTagged);
#endif

       /* Check BPDU - is it a sane packet ? */
       {
//        if (!(CCL_P(skb)->wSize >= CONFIG_BPDU_MESSAGE_BYTES))
 //by flash, pass ANVL test case 8.2
//     printk("len=%d bIfTagged=%d\n",(ntohs(*((unsigned short*)(pucEthernet+12)))),CCL_P(skb)->bIfTagged );
     if(CCL_P(skb)->bIfTagged)
     {
      if ((ntohs(*((unsigned short*)(pucEthernet+12)))) <= 34+3+4)
       {
        break;
       }
     }
     else
     {
      if ((ntohs(*((unsigned short*)(pucEthernet+12)))) <= 34+3)
       {
//        printk("too short \n");
        break;
       }
     }
  
  /* check for invalid flag */
        if ( (unsigned long)pucBPDU[4] & 0x7E) 
         {
#ifdef STP_DEBUG
      printk("STP Discard Packet! BPDU Flag invalid\n");
#endif
          break;
         }
   
       }

       /* Copying data from message bytes to 
        * config structure in 802.1D code */
       {
        int i = 4; /* start of Flags */

               receivedConfigBpdu.topology_change_acknowledgment = (unsigned long)pucBPDU[i] & 0x80;
               receivedConfigBpdu.topology_change = (unsigned long)pucBPDU[i++] & 0x01;
               
               receivedConfigBpdu.root_id.four_octets[0]  = (unsigned long)pucBPDU[i++] << 24;
               receivedConfigBpdu.root_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 16;
               receivedConfigBpdu.root_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 8;
               receivedConfigBpdu.root_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.root_id.four_octets[1]  = (unsigned long)pucBPDU[i++] << 24;
               receivedConfigBpdu.root_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 16;
               receivedConfigBpdu.root_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 8;
               receivedConfigBpdu.root_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.root_path_cost  = (unsigned long)pucBPDU[i++] << 24;
               receivedConfigBpdu.root_path_cost |= (unsigned long)pucBPDU[i++] << 16;
               receivedConfigBpdu.root_path_cost |= (unsigned long)pucBPDU[i++] << 8;
               receivedConfigBpdu.root_path_cost |= (unsigned long)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.bridge_id.four_octets[0]  = (unsigned long)pucBPDU[i++] << 24;
               receivedConfigBpdu.bridge_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 16;
               receivedConfigBpdu.bridge_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 8;
               receivedConfigBpdu.bridge_id.four_octets[0] |= (unsigned long)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.bridge_id.four_octets[1]  = (unsigned long)pucBPDU[i++] << 24;
               receivedConfigBpdu.bridge_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 16;
               receivedConfigBpdu.bridge_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 8;
               receivedConfigBpdu.bridge_id.four_octets[1] |= (unsigned long)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.port_id  = (unsigned short)((unsigned short)pucBPDU[i++] << 8);
               receivedConfigBpdu.port_id |= (unsigned short)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.message_age  = (unsigned short)((unsigned short)pucBPDU[i++] << 8);
               receivedConfigBpdu.message_age |= (unsigned short)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.max_age  = (unsigned short)((unsigned short)pucBPDU[i++] << 8);
               receivedConfigBpdu.max_age |= (unsigned short)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.hello_time  = (unsigned short)((unsigned short)pucBPDU[i++] << 8);
               receivedConfigBpdu.hello_time |= (unsigned short)pucBPDU[i++] << 0;
               
               receivedConfigBpdu.forward_delay  = (unsigned short)((unsigned short)pucBPDU[i++] << 8);
               receivedConfigBpdu.forward_delay |= (unsigned short)pucBPDU[i++] << 0;
               
               (void)i;
       }
 
       /* Set BPDU message type  */
       receivedConfigBpdu.type = bpduMessageType;
                  
       /* Copy the topology change bits in the messages
        * 5:th byte to the right fields in the structure */ 
   
       receivedConfigBpdu.topology_change_acknowledgment = (pucBPDU[4] & 0x80) ? 1 : 0 ;
       receivedConfigBpdu.topology_change = (pucBPDU[4] & 0x1) ? 1 : 0 ;
 
         if(receivedConfigBpdu.topology_change)
        {
         num_tcn++;
         last_tcn=jiffies;
	 K_MacClrTbl(MAC_CLR_DYNMC);
        }
       /* Convert VIA port numbering (from 0) 
        * to port_no numbering from 1 */
   
       port_no = CCL_P(skb)->bySrcPortId + 1; //VIA driver start at 0 but IEEE codes start at 1

       /* Call code supplied in 802.1D */
       if (receivedConfigBpdu.message_age < receivedConfigBpdu.max_age)
        {

  spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */
//printk("received_config_bpdu\n");
  received_config_bpdu(port_no, &receivedConfigBpdu);

  spin_unlock(&stp_ieee_sem);
        }
       break;

     case Tcn_bpdu_type:
#ifdef STP_DEBUG
  printk("STP: program receives a TCN packet!! size:%d vid:%d priority:%d portid:%d reason:%d iftag:%d\n",CCL_P(skb)->wSize,CCL_P(skb)->wVid,CCL_P(skb)->byPriority,CCL_P(skb)->bySrcPortId,CCL_P(skb)->byFwdReason,CCL_P(skb)->bIfTagged);
#endif
       num_tcn++;
       last_tcn=jiffies;
// not need, by flash
//       K_MacClrTbl(MAC_CLR_DYNMC);
       /* Check BPDU */
       {
               if (!(CCL_P(skb)->wSize >= 4)) 
                {
                 break;
                }
       }
       
       /* Fill in Tcn_bpdu from message */
       
       receivedTcnBpdu.type = bpduMessageType;

       //VIA driver start at 0 but IEEE codes start at 1
       port_no = CCL_P(skb)->bySrcPortId + 1; 

       /* Call code supplied in 802.1D */

       spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */

       received_tcn_bpdu( port_no, &receivedTcnBpdu);

       spin_unlock(&stp_ieee_sem);
       break;
       
     default:
#ifdef STP_DEBUG
          printk("- Ignored bpduMessageType 0x%02x.\n", 
    (unsigned int) bpduMessageType);
#endif
       break;

     } /* switch */
   } /* if */
        } /* if */
      

    }
  return CCL_MX_DROP;
 }


void CCLSendConfigBpdu(Int port_no, Config_bpdu *bpdu)
 {
  struct sk_buff *skb;
  unsigned char *pucEthernet;
  int iPacketSize;
 
  if(port_no == 0)
   return;

  port_no--; //VIA driver start at 0 
#ifdef STP_DEBUG
  printk("STP: Send out a config BPDU to port %d\n",port_no);  
#endif
  /* Allocate and zero memory for message */
  {
   iPacketSize = 6 /* DA */ + 6 /* SA */ + 2 /* Len */ + 3 /* LLC */ 
      + CONFIG_BPDU_MESSAGE_BYTES;
 
#if 0
   if (iPacketSize < 64) 
    {
     iPacketSize = 64;
    }
#endif
   
   skb=dev_alloc_skb(iPacketSize);  
   if(skb==NULL)
    {
#ifdef STP_DEBUG
     printk("Can't Send Config BPDU!! memory can't be allocated \n");
#endif
     return;
    }
   pucEthernet = skb_put(skb, iPacketSize);
   memset(pucEthernet, 0, iPacketSize);
  }

  /* DA */
  {
   pucEthernet[0] = 0x01;
   pucEthernet[1] = 0x80;
   pucEthernet[2] = 0xC2;
   pucEthernet[3] = 0x00;
   pucEthernet[4] = 0x00;
   pucEthernet[5] = 0x00;
  }
  
  /* SA */
  {
   unsigned char *mac = bridge_mac;

   pucEthernet[6] = mac[0];
   pucEthernet[7] = mac[1];
   pucEthernet[8] = mac[2];
   pucEthernet[9] = mac[3];
   pucEthernet[10] = mac[4];
   pucEthernet[11] = (unsigned char)(mac[5] + (port_no+1)); //MAC Address for port 1 is increased from system
  }
  
  /* length */
  {
   pucEthernet[12] = 0x00;
   pucEthernet[13] = 3 /* LLC */ + CONFIG_BPDU_MESSAGE_BYTES;
  }
  
  /* LLC */
  {
   pucEthernet[14] = 0x42; /* SSAP */
   pucEthernet[15] = 0x42; /* DSAP */
   pucEthernet[16] = 0x03; /* UI   */
  }

  /* Fill in BPDU parameters */
  {
   unsigned char * pucBPDU;

   /* start of BPDU parameters */
   pucBPDU = &(pucEthernet[17]);

   *pucBPDU++ = (unsigned char)(CONFIG_BPDU_PROTOCOL_ID >> 8);
   *pucBPDU++ = (unsigned char)(CONFIG_BPDU_PROTOCOL_ID & 0xFF);
   *pucBPDU++ = (unsigned char)(CONFIG_BPDU_VERSION);
   *pucBPDU++ = (unsigned char)(Config_bpdu_type);

   *pucBPDU   = (unsigned char)(bpdu->topology_change_acknowledgment 
     ? 0x80 : 0x00);
   *pucBPDU  |= (unsigned char)(bpdu->topology_change ? 0x01 : 0x00);
   
   pucBPDU++;
    
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[0] & 0xFF000000) >> 24);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[0] & 0x00FF0000) >> 16);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[0] & 0x0000FF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[0] & 0x000000FF) >> 0);

   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[1] & 0xFF000000) >> 24);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[1] & 0x00FF0000) >> 16);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[1] & 0x0000FF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->root_id.four_octets[1] & 0x000000FF) >> 0);
   
   *pucBPDU++ = (unsigned char)((bpdu->root_path_cost & 0xFF000000) >> 24);
   *pucBPDU++ = (unsigned char)((bpdu->root_path_cost & 0x00FF0000) >> 16);
   *pucBPDU++ = (unsigned char)((bpdu->root_path_cost & 0x0000FF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->root_path_cost & 0x000000FF) >> 0);
   
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[0] & 0xFF000000) >> 24);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[0] & 0x00FF0000) >> 16);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[0] & 0x0000FF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[0] & 0x000000FF) >> 0);
   
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[1] & 0xFF000000) >> 24);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[1] & 0x00FF0000) >> 16);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[1] & 0x0000FF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->bridge_id.four_octets[1] & 0x000000FF) >> 0);

   *pucBPDU++ = (unsigned char)((bpdu->port_id & 0xFF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->port_id & 0x00FF) >> 0);

   *pucBPDU++ = (unsigned char)((bpdu->message_age & 0xFF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->message_age & 0x00FF) >> 0);
   
   *pucBPDU++ = (unsigned char)((bpdu->max_age & 0xFF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->max_age & 0x00FF) >> 0);

   *pucBPDU++ = (unsigned char)((bpdu->hello_time & 0xFF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->hello_time & 0x00FF) >> 0);

   *pucBPDU++ = (unsigned char)((bpdu->forward_delay & 0xFF00) >> 8);
   *pucBPDU++ = (unsigned char)((bpdu->forward_delay & 0x00FF) >> 0);
   (void)pucBPDU;
  }

#ifdef STP_DEBUG
//  printk("Example program receives a packet!! %d %d %d %d %d %d\n",CCL_P(skb)->wSize,CCL_P(skb)->wVid,CCL_P(skb)->byPriority,CCL_P(skb)->bySrcPortId,CCL_P(skb)->byFwdReason,CCL_P(skb)->bIfTagged);
  /* Set parameters to VIA driver */
#endif

//by flash, 2005/05/04
#if 0
  CCL_P(skb)->wSize = iPacketSize;
  CCL_P(skb)->wVid = 0;
  CCL_P(skb)->byPriority = BPDU_PRIORITY;
  put_unaligned(0x1L << port_no, (unsigned long *) &(CCL_P(skb)->dwDstPortMsk));
  put_unaligned(0, (unsigned long *) &(CCL_P(skb)->dwTagPortMsk));
  skb->dev=dev_get_by_name("eth0");

  dev_queue_xmit(skb);
#endif


	K_LPortMaskClrAll (&CCL_LP(skb)->dwDstPortMsk);
	K_LPortMaskSetPort (&CCL_LP(skb)->dwDstPortMsk, port_no);
	K_LPortMaskClrAll (&CCL_LP(skb)->dwTagPortMsk);

	CCL_LP(skb)->bIfTagged = 0;
	CCL_LP(skb)->wVid = 0;

  CCL_LP(skb)->wSize = iPacketSize;
  CCL_LP(skb)->byPriority = BPDU_PRIORITY;
  skb->dev=dev_get_by_name("eth0");

	cclmx_TxPkt (skb);

  //free packet
  //TODO??

 } /* send_config_bpdu */


void CCLSendTcnBpdu(Int port_no, Tcn_bpdu *bpdu)
{
  struct sk_buff *skb;
  unsigned char *pucEthernet;
  int iPacketSize;
  
#ifdef STP_DEBUG
  printk("STP: Send out a TCN BPDU to port %d\n",port_no);  
#endif

  if(port_no == 0)
   return;

  port_no--; //VIA driver start at 0

  /* Allocate and zero memory for message */
  {
   iPacketSize = 6 /* DA */ + 6 /* SA */ + 2 /* Len */ + 3 /* LLC */ 
      + TCN_BPDU_MESSAGE_BYTES;

#if 0
   if (iPacketSize < 64) 
    {
      iPacketSize = 64;
    }
#endif

   skb=dev_alloc_skb(iPacketSize);  
   if(skb==NULL)
    {
#ifdef STP_DEBUG
     printk("Can't Send Config BPDU!! memory can't be allocated \n");
#endif
     return;
    }
   pucEthernet = skb_put(skb, iPacketSize);
   memset(pucEthernet, 0, iPacketSize);
  }
  
  /* DA */
  {
   pucEthernet[0] = 0x01;
   pucEthernet[1] = 0x80;
   pucEthernet[2] = 0xC2;
   pucEthernet[3] = 0x00;
   pucEthernet[4] = 0x00;
   pucEthernet[5] = 0x00;
  }
  
  /* SA */
  {
   unsigned char *mac = bridge_mac;

   pucEthernet[6] = mac[0];
   pucEthernet[7] = mac[1];
   pucEthernet[8] = mac[2];
   pucEthernet[9] = mac[3];
   pucEthernet[10] = mac[4];
   pucEthernet[11] = (unsigned char)(mac[5] + (port_no + 1));
  }

  /* length */
  {
   pucEthernet[12] = 0x00;
   pucEthernet[13] = 3 /* LLC */ + TCN_BPDU_MESSAGE_BYTES;
  }
  
  /* LLC */
  {
   pucEthernet[14] = 0x42; /* SSAP */
   pucEthernet[15] = 0x42; /* DSAP */
   pucEthernet[16] = 0x03; /* UI   */
  }
  
  /* Fill in BPDU parameters */
  {
   unsigned char * pucBPDU;
   
   /* start of BPDU parameters */
   pucBPDU = &pucEthernet[17];
   
   /* Fill in the first four bytes */
   pucBPDU[0] = TCN_BPDU_PROTOCOL_ID >> 8;
   pucBPDU[1] = TCN_BPDU_PROTOCOL_ID & 0xFF;
   pucBPDU[2] = TCN_BPDU_VERSION;
   pucBPDU[3] = Tcn_bpdu_type;
  }
  
  /* Set parameters to VIA driver */

//by flash, 2005/05/04
#if 0
  put_unaligned(iPacketSize, (unsigned short *) &(CCL_P(skb)->wSize)); 
  put_unaligned(0, (unsigned short *) &(CCL_P(skb)->wVid));
  CCL_P(skb)->byPriority = BPDU_PRIORITY;
  put_unaligned(0x1L << port_no, (unsigned long *) &(CCL_P(skb)->dwDstPortMsk));
  put_unaligned(0, (unsigned long *) &(CCL_P(skb)->dwTagPortMsk));
  skb->dev=dev_get_by_name("eth0");

  dev_queue_xmit(skb);
#endif

	K_LPortMaskClrAll (&CCL_LP(skb)->dwDstPortMsk);
	K_LPortMaskSetPort (&CCL_LP(skb)->dwDstPortMsk, port_no);
	K_LPortMaskClrAll (&CCL_LP(skb)->dwTagPortMsk);

	CCL_LP(skb)->bIfTagged = 0;
	CCL_LP(skb)->wVid = 0;

  CCL_LP(skb)->wSize = iPacketSize;
  CCL_LP(skb)->byPriority = BPDU_PRIORITY;
  skb->dev=dev_get_by_name("eth0");

	cclmx_TxPkt (skb);

  //free packet
  //TODO??

} /* send_tcn_bpdu */


void CCLSetPortState(Int port_no, State state)
 {
  
  if(port_no == 0)
   return;

  port_no--; 

  switch (state) 
   {
    case Disabled:
//by flash, 2005/05/04
//    K_StpSetPort(port_no, STP_PORT_DISABLED);
		cclmx_PortSetStpState (port_no, STP_PORT_DISABLED);
#ifdef STP_DEBUG
                  printk("Setting port #%d in state DISABLED\n",port_no);
#endif
    if(gvrp_stp_port_disabled!=NULL)
     gvrp_stp_port_disabled(port_no);
    if(gmrp_stp_port_disabled!=NULL)
     gmrp_stp_port_disabled(port_no);
    if(igmp_stp_port_disabled!=NULL)
     igmp_stp_port_disabled(port_no);
        break;
    
  case Blocking:
//by flash, 2005/05/04
//    K_StpSetPort(port_no, STP_PORT_BLOCKING);
		cclmx_PortSetStpState (port_no, STP_PORT_BLOCKING);
#ifdef STP_DEBUG
                  printk("Setting port #%d in state BLOCKING\n",port_no);
#endif
        break;
  case Listening:
//by flash, 2005/05/04
//    K_StpSetPort(port_no, STP_PORT_LISTENING);
		cclmx_PortSetStpState (port_no, STP_PORT_LISTENING);
#ifdef STP_DEBUG
                  printk("Setting port #%d in state LISTENING\n",port_no);
#endif
        break;
    
  case Learning:
//by flash, 2005/05/04
//    K_StpSetPort(port_no, STP_PORT_LEARNING);
		cclmx_PortSetStpState (port_no, STP_PORT_LEARNING);
#ifdef STP_DEBUG
                  printk("Setting port #%d in state LEARNING\n",port_no);
#endif
        break;
  case Forwarding:
//by flash, 2005/05/04
//    K_StpSetPort(port_no, STP_PORT_FORWARDING);
		cclmx_PortSetStpState (port_no, STP_PORT_FORWARDING);
#ifdef STP_DEBUG
                  printk("Setting port #%d in state FORWARDING\n",port_no);
#endif
    if(gvrp_stp_port_forwarding!=NULL)
     gvrp_stp_port_forwarding(port_no);
    if(gmrp_stp_port_forwarding!=NULL)
     gmrp_stp_port_forwarding(port_no);
    if(igmp_stp_port_forwarding!=NULL)
     igmp_stp_port_forwarding(port_no);
//SNMP Bridge MIB
    forward_transition[port_no]++;
        break;
    
  default:
#ifdef STP_DEBUG
                  printk("Illegal spanning tree state");
#endif
                  break;
  }
  
  
 }  

static int stp_init(void)
 {
  int i;
  unsigned long ulFourOctetsHigh = 0x80008030;
  unsigned long ulFourOctetsLow =  0x01030467;

  ulSpanTreeTickScaling = SPAN_TREE_TICK_SCALING; 
  {
   ulFourOctetsHigh=(0x80000000) | (bridge_mac[0] << 8) | (bridge_mac[1]);
   ulFourOctetsLow= (bridge_mac[2] << 24) | (bridge_mac[3] << 16) | (bridge_mac[4] << 8) | (bridge_mac[5]);
  }

  /* bridge_mac is initialized before this point */

  /* init Bridge_data */
  {
   extern Bridge_data bridge_info; /* (8.5.3) */

   bridge_info.designated_root.four_octets[0] = 0; /* (8.5.3.1) */
   bridge_info.designated_root.four_octets[1] = 0; /* (8.5.3.1) */
   bridge_info.root_path_cost           = (Cost)0; /* (8.5.3.2) */
   bridge_info.root_port                = (Int)0;  /* (8.5.3.3) */
   bridge_info.max_age                  = (Time)0; /* (8.5.3.4) */
   bridge_info.hello_time               = (Time)0; /* (8.5.3.5) */
   bridge_info.forward_delay            = (Time)0; /* (8.5.3.6) */
   bridge_info.bridge_id.four_octets[0] = ulFourOctetsHigh; /* (8.5.3.7) */
   bridge_info.bridge_id.four_octets[1] = ulFourOctetsLow;  /* (8.5.3.7) */
   bridge_info.bridge_max_age           = (Time)(20 * 256); /* (8.5.3.8) */
   bridge_info.bridge_hello_time        = (Time)( 2 * 256); /* (8.5.3.9) */
   bridge_info.bridge_forward_delay     = (Time)(15 * 256); /* (8.5.3.10) */
   bridge_info.topology_change_detected = (Tbool)0;      /* (8.5.3.11) */
   bridge_info.topology_change          = (Tbool)0;       /* (8.5.3.12) */

   bridge_info.topology_change_time     = 
     bridge_info.bridge_max_age 
     + bridge_info.bridge_forward_delay; /* (8.5.3.13) */

   bridge_info.hold_time                = (Time)1*256;          /* (8.5.3.14) */
  }

  /* init IEEE802.1D code */
  initialisation();

  periodical_thread_pid=kernel_thread((int (*)(void *))stp_periodical_thread, NULL, 0);

  spin_lock_init(&stp_ieee_sem);   

  for(i=0;i< STP_PORT_MAX;i++)
   {
    spin_lock(&stp_ieee_sem); /* protect the ieee802.1d code */

    /* make sure the ieee code knows about this port */
    ulMaxNoPorts = STP_PORT_MAX;
    set_port_priority(i + 1, (128 << 8) + (i + 1));

    spin_unlock(&stp_ieee_sem);
   }

  port_thread_pid=kernel_thread((int (*)(void *))stp_port_thread, NULL, 0);

  return 0;
 }

static void stp_cleanup(void)
 {

//  sem_destroy(&stp_ieee_sem);
//  up(&stp_ieee_sem);

 }

/***************Module parameter information*********************/
MODULE_AUTHOR ("PinChuan Flash Liu <flash@itri.org.tw>");
MODULE_DESCRIPTION ("VIA 24+2G Protocol example");
MODULE_LICENSE("GPL");


static  char mac[6]={0x01,0x80,0xC2,0x00,0x00,0x00};
static  char mask[6]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/****************************************************************/
void stp_start()
 {
  int i;

  stp_info.global_enable=1;
  K_StpSetEbl(Enable);
  stp_tick_enable=1;
  for(i=0;i<STP_PORT_MAX;i++)
   {
    set_port_state(i,Disabled);
//SNMP Bridge MIB
    forward_transition[i]=0;
   }
//   disable_port(i + 1);
  restart=STP_PORT_MAX;
//  K_StpSetEbl(True); //enable BPDU forward to CPU
//  ccl_mx_register(mac,mask,ccl_stp);
 }

void stp_stop()
 {
  int i;

  stp_info.global_enable=0;
  K_StpSetEbl(Disable);
  stp_tick_enable=0;
  for(i=0;i<STP_PORT_MAX;i++)
   set_port_state(i,Forwarding);
//  K_StpSetEbl(Disable); //disable BPDU forward to CPU
//  ccl_mx_unregister(mac,mask);
 }

static int __init ccl_stp_init_module(void)
 {
#if 0 
  printk("=============CCL STP program============\n"); 
  printk("CCL STP program\n");
  printk("===========================================\n");     
#endif

  restart=STP_PORT_MAX;

  num_tcn=0;
  last_tcn=jiffies;
  stp_info.global_enable=0;

  K_SysGetMac(bridge_mac);

  stp_init();

  if(nf_register_sockopt(&stp_sockopts))
   {
    printk(" cannot register sockopt \n");
    return False;
   }
   
//  stp_stop();
  ccl_mx_register(mac,mask,ccl_stp);

#if 0
  {
    while(1) {
      sleep(10000);
    }
  }
#endif
  return 0;
 
 } 

/****************************************************************/
static void __exit ccl_stp_cleanup_module(void)
 {

  stp_stop();
  stp_cleanup();
  printk("=============CCL STP program============\n"); 
  printk("Remove CCL STP program\n");
  printk("===========================================\n");     
 
 }

/****************************************************************/
module_init(ccl_stp_init_module);
module_exit(ccl_stp_cleanup_module);

/*
 * Local variables:
 *  compile-command: "gcc -DMODULE -D__KERNEL__ -I/usr/src/linux/net/inet -Wall -Wstrict-prototypes -O6 -c lc_drv.c `[ -f /usr/include/linux/modversions.h ] && echo -DMODVERSIONS`"
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  tab-width: 4
 * End:
 */
