/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 *
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 *
 **************************************************************************/

#ifndef RSTP_NETFILTER_H
#define RSTP_NETFILTER_H


struct set_rstp_port_t {
	unsigned char	port;
	unsigned long	value;
};


/* come from uid_stp.h */
typedef struct {
	unsigned short  prio;
	unsigned char   addr[6];
} NF_BRIDGE_ID_T;

/* come from uid_stp.h */
typedef enum {
	NF_UID_PORT_DISABLED = 0,
	NF_UID_PORT_DISCARDING,
	NF_UID_PORT_LEARNING,
	NF_UID_PORT_FORWARDING,
	NF_UID_PORT_NON_STP
} NF_RSTP_PORT_STATE;

/* come from uid_stp.h */
typedef enum {
	NF_P2P_FORCE_FALSE,
	NF_P2P_FORCE_TRUE,
	NF_P2P_AUTO
} NF_ADMIN_P2P_T;


#endif

