/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Mutual RSTP definitions */
 
#ifndef _STP_BASE_H__
#define _STP_BASE_H__

#ifdef DEBUG
#  define STP_DBG 1
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/if_ether.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/string.h>

#include "../cclmx/ccl.h"
#include "../cclmx/ccl_mx.h"

#define RSTP_STPM_ID 0
#define BRIDGE_NAME "CCL"
#define BRIDGE_NAME_LEN 4

#define u_int32_t unsigned int
#define size_t int
#  include "uid_stp.h"
#  ifndef Print
#    define Print printk
#  endif

#ifndef INOUT
#  define IN      /* consider as comments near 'input' parameters */
#  define OUT     /* consider as comments near 'output' parameters */
#  define INOUT   /* consider as comments near 'input/output' parameters */
#endif

#ifndef Zero
#  define Zero        0
#  define One         1
#endif

#ifndef Bool
#  define Bool        int
#  define False       0
#  define True        1
#endif

#include "stp_bpdu.h"
#include "vector.h"
#include "times.h"

#define RSTP_ERRORS { \
  CHOOSE(STP_OK),                                       \
  CHOOSE(STP_Cannot_Find_Stp),                          \
  CHOOSE(STP_Imlicite_Instance_Create_Failed),          \
  CHOOSE(STP_Small_Bridge_Priority),                    \
  CHOOSE(STP_Large_Bridge_Priority),                    \
  CHOOSE(STP_Small_Hello_Time),                         \
  CHOOSE(STP_Large_Hello_Time),                         \
  CHOOSE(STP_Small_Max_Age),                            \
  CHOOSE(STP_Large_Max_Age),                            \
  CHOOSE(STP_Small_Forward_Delay),                      \
  CHOOSE(STP_Large_Forward_Delay),                      \
  CHOOSE(STP_Forward_Delay_And_Max_Age_Are_Inconsistent),\
  CHOOSE(STP_Hello_Time_And_Max_Age_Are_Inconsistent),  \
  CHOOSE(STP_Had_Not_Yet_Been_Created),                 \
  CHOOSE(STP_Port_Is_Absent_In_The_Stp),                \
  CHOOSE(STP_Big_len8023_Format),                       \
  CHOOSE(STP_Small_len8023_Format),                     \
  CHOOSE(STP_len8023_Format_Gt_Len),                    \
  CHOOSE(STP_Not_Proper_802_3_Packet),                  \
  CHOOSE(STP_Invalid_Protocol),                         \
  CHOOSE(STP_Invalid_Version),                          \
  CHOOSE(STP_Had_Not_Yet_Been_Enabled),                 \
  CHOOSE(STP_Cannot_Create_Instance),                   \
  CHOOSE(STP_Cannot_Create_Instance_For_Port),          \
  CHOOSE(STP_Invalid_Bridge_Priority),                  \
  CHOOSE(STP_There_Are_No_Ports),                       \
  CHOOSE(STP_Cannot_Compute_Bridge_Prio),               \
  CHOOSE(STP_Bridge_Priority_Granularity),              \
  CHOOSE(STP_Port_Priority_Granularity),                \
  CHOOSE(STP_Large_Port_Priority),                      \
  CHOOSE(STP_Large_Port_Path_Cost),                     \
  CHOOSE(STP_Another_Error),                            \
  CHOOSE(STP_Nothing_To_Do),                            \
  CHOOSE(STP_LAST_DUMMY),                               \
}

#define CHOOSE(a) a
typedef enum RSTP_ERRORS RSTP_ERRORS_T;
#undef CHOOSE


#define STP_FATAL(TXT, MSG, EXCOD)                      \
      {\
	 stp_trace ("FATAL:%s failed: %s:%d", TXT, MSG, EXCOD);  \
         return (EXCOD);} 

#define STP_MALLOC(PTR, TYPE, MSG)              \
  {                                             \
    PTR = (TYPE *) kmalloc (sizeof (TYPE), GFP_KERNEL);    \
    if (! PTR) {                                \
      STP_FATAL("malloc", MSG, -6);             \
    }                                           \
  }

#define STP_FREE(PTR, MSG)              \
  {                                     \
    if (! PTR) {                        \
      STP_FATAL("free", MSG, -66);      \
    }                                   \
    kfree (PTR);			\
    PTR = NULL;                         \
  }

#if 0
#define STP_STRDUP(PTR, SRC, MSG)       \
  {                                     \
    PTR = strdup (SRC);                 \
    if (! PTR) {                        \
      STP_FATAL("strdup", MSG, -7);     \
    }                                   \
  }
#endif
#define STP_STRDUP(PTR, SRC, MSG)	\
  {					\
    if (! SRC) {			\
      STP_FATAL("strdup", MSG, -7);	\
    }					\
    PTR = (char *) kmalloc (strlen(SRC), GFP_KERNEL);	\
    if (! PTR) {			\
      STP_FATAL("malloc", MSG, -6);	\
    }					\
    strcpy (PTR, SRC);			\
  }

#define STP_NEW_IN_LIST(WHAT, TYPE, LIST, MSG)  \
  {                                             \
    STP_MALLOC(WHAT, TYPE, MSG);                \
    WHAT->next = LIST;                          \
    LIST = WHAT;                                \
  }

void stp_trace (const char *format, ...);

#ifdef STP_DBG
/* for debug trace messages */
#define SPRINT_TIME UT_sprint_time_stamp
extern char* UT_sprint_time_stamp (char ticks_accuracy);
#endif


#endif /*  _STP_BASE_H__ */

