/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
#ifndef XST_PORT_H
#define XST_PORT_H

#include "base.h"
#include "mstp.h"
#include "xst.h"
#include "statmch.h"

#define TIMERS_NUMBER 9

typedef struct xst_port_t 
 {
  int               port_index;
  Bool              valid;


  struct xst_t      *owner;

  /* per port Timers */
/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and all MSTIs */

  PORT_TIMER_T      mdelayWhile;  /* 17.15.3 */
//  unsigned int      mdelayWhile;  /* 17.15.3 */
  PORT_TIMER_T      helloWhen;    /* 17.15.2 */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */

  PORT_TIMER_T      fdWhile;      /* 17.15.1 */
  PORT_TIMER_T      rrWhile;      /* 17.15.6 */
  PORT_TIMER_T      rbWhile;      /* 17.15.4 */
  PORT_TIMER_T      tcWhile;      /* 17.15.7 */
  PORT_TIMER_T      rcvdInfoWhile;/* 17.15.5 */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
//for edge.c
  PORT_TIMER_T      lnkWhile;

  PORT_TIMER_T*     timers[TIMERS_NUMBER]; /*list of timers */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and all MSTIs */
  unsigned short    HelloTime; /* CIST */

  unsigned long     adminExtPCost; /* may be ADMIN_PORT_PATH_COST_AUTO */
  unsigned long     operExtPCost;
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */


/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */
  unsigned long     adminIntPCost; /* may be ADMIN_PORT_PATH_COST_AUTO */
  unsigned long     operIntPCost;
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and all MSTIs */

  unsigned int      tick; /* CIST */
/* statistics */
  unsigned long     rx_cfg_bpdu_cnt;
  unsigned long     rx_mstp_bpdu_cnt;
  unsigned long     rx_rstp_bpdu_cnt;
  unsigned long     rx_tcn_bpdu_cnt;
  unsigned long     tx_cfg_bpdu_cnt;
  unsigned long     tx_mstp_bpdu_cnt;
  unsigned long     tx_rstp_bpdu_cnt;
  unsigned long     tx_tcn_bpdu_cnt;
  unsigned long     txCount;

  Bool              admin_non_stp;

  Bool              p2p_recompute;
  Bool              operPointToPointMac;
  ADMIN_P2P_T       adminPointToPointMac;

  Bool              operEdge;      /* 17.18.14 */ /* CIST */
  Bool              adminEdge;     /* 17.18.14 */

  Bool              portEnabled;   /* 17.18.15 */ /* CIST */
  unsigned short    infoInternal; /* 13.24.10 */
//  Bool              newInfoXst;       /* 13.24.19 */
//  Bool              putOffNewInfoXst;

  Bool              putOffNewInfoCist;
  Bool              putOffNewInfoMsti;
  Bool              newInfoCist;       /* 13.24.19 */
  Bool              newInfoMsti;       /* 13.24.19 */
  Bool              rcvdInternal; /* 13.24.22 */
  Bool              initPm;        /* 17.18.7  */
  Bool              rcvdBpdu;      /* 17.18.21 */
  Bool              rcvdRSTP;      /* 17/18.23 */
  Bool              rcvdSTP;       /* 17.18.24 */
  Bool              rcvdTcAck;     /* 17.18.26 */
  Bool              rcvdTcn;       /* 17.18.27 */
  Bool              sendRSTP;      /* 17.18.33 */
  Bool              tcAck;         /* 17.18.37 */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */
  Bool              forward;       /* 17.18.4 */
  Bool              forwarding;    /* 17.18.5 */
  INFO_IS_T         infoIs;        /* 17.18.6 */
  Bool              learn;         /* 17.18.8 */
  Bool              learning;      /* 17.18.9 */
  Bool              proposed;      /* 17.18.19 */
  Bool              proposing;     /* 17.18.20 */
  Bool              rcvdTc;        /* 17.18.25 */
  Bool              reRoot;        /* 17.18.28 */
  Bool              reselect;      /* 17.18.29 */
  Bool              selected;      /* 17.18.31 */
  Bool              tcProp;        /* 17.18.38 */
  Bool              updtInfo;      /* 17.18.41 */
  Bool              agreed;        /* 17.18.1 */
  PORT_ID           portId;       /* 17.18.16 */
  RCVD_MSG_T        rcvdInfo;       /* 17.18.22 */
  PORT_ROLE_T       role;          /* 17.18.30 */
  PORT_ROLE_T       selectedRole;  /* 17.18.32 */
  Bool              sync;          /* 17.18.34 */
  Bool              synced;        /* 17.18.35 */

  Bool              agree; /* 13.24.1 */
  Bool              changedMaster; /*13.24.3 */
  Bool              rcvdMsg; /* 13.24.24 */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/*
port priority vector = {RootID : ExtRootPathCost : RRootID : IntRootPathCost : DesignatedBridgeID : DesignatedPortID : RcvPortID}
message priority vector = {RD : ERCD : RRD : IRCD : D : PD : PB}
//not in region
root path priority vector = {RD : ERCD + EPCPB : B : 0 : D : PD : PB)
//in region
root path priority vector = {RD : ERCD : RRD : IRCD + IPCPB : D : PD : PB)
bridge priority vector = {B : 0 : B : 0 : B : 0 : 0}

port priority vector = {RRootID : IntRootPathCost : DesignatedBridgeID : DesignatedPortID : RcvPortID}
message priority vector = {RRD : IRCD : D : PD : PB}
root path priority vector = {RRD : IRCD + IPCPB : D : PD : PB)
bridge priority vector = {B : 0 : B : 0}

*/

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTI*/
  PRIO_VECTOR_T     xstDesignatedPriority;    /* 13.24.4 */
  TIMEVALUES_T      xstDesignatedTimes;   /* 13.24.5 */
  PRIO_VECTOR_T     xstMsgPriority;       /* 13.24.6 */
  TIMEVALUES_T      xstMsgTimes;      /* 13.24.7 */
  PRIO_VECTOR_T     xstPortPriority;      /* 13.24.8 */
  TIMEVALUES_T      xstPortTimes;     /* 13.24.9 */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */


  /* per Port state machines */
/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */

  STATE_MACH_T*     machines; /* list of machines */

  STATE_MACH_T*     info;      /* 17.21 */
  STATE_MACH_T*     roletrns;  /* 17.23 */
  STATE_MACH_T*     sttrans;   /* 17.24 */
  STATE_MACH_T*     topoch;    /* 17.25 */
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST  */
  STATE_MACH_T*     transmit;  /* 17.26 */
  STATE_MACH_T*     migrate;   /* 17.26 */
  STATE_MACH_T*     rcv;   /* 13.28 */
  STATE_MACH_T*     p2p;       /* 6.4.3, 6.5.1 */
  STATE_MACH_T*     edge;      /*  */
  STATE_MACH_T*     extpcost;     /*  */
  STATE_MACH_T*     intpcost;     /*  */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
 

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */

  Bool              mcheck;        /* 17.18.10 */
#if 0
  Bool              tc;            /* 17.18.36 */
#endif

  /* message information */
  unsigned char     msgBpduVersion;
  unsigned char     msgBpduType;
  unsigned char     msgPortRole;
  unsigned char     msgFlags;
  Bool              msgMSTConfId_match;
#if 0
  unsigned char     msgId;
#endif

  unsigned long     operSpeed;
  unsigned long     int_usedSpeed;
  unsigned long     ext_usedSpeed;
  int               LinkDelay;   /* TBD: LinkDelay may be managed ? */
  Bool              adminEnable; /* 'has LINK' */
  Bool              wasInitBpdu;  
  


  unsigned long     uptime;       /* 14.8.2.1.3.a */
  Bool              snmp_topo_change;


/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */


  /* State machine conditions*/
/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and any MSTIs */
  Bool              cistDesignatedPort;
  Bool              cistRootPort;
  Bool              mstiDesignatedPort;
  Bool              mstiRootPort;
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */
 
/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

 } XST_PORT_T;




#endif /*  XST_PORT_H */
