/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * XST PORT instance
 * $Log: xst_port.c,v $
 * Revision 1.1.1.1  2009/02/17 09:44:45  anderson
 * RTL8196B source code
 *
 * Revision 1.29  2007/08/23 02:34:37  michael
 * Bug: 623
 * linux-2.6.19 fix
 *
 * Revision 1.28  2007/06/07 03:19:10  flash
 * Bug: 621
 * check xst created
 *
 * Revision 1.27  2005/04/26 05:53:57  flash
 * BugID:
 *
 * Revision 1.26  2005/04/20 09:35:09  flash
 * BugID:
 *
 * Revision 1.25  2005/03/16 09:54:26  flash
 * *** empty log message ***
 *
 * Revision 1.24  2004/11/13 07:48:01  flash
 * *** empty log message ***
 *
 * Revision 1.23  2004/09/14 06:54:39  flash
 * add extern and intern path cost
 *
 * Revision 1.22  2004/08/12 09:24:55  flash
 * *** empty log message ***
 *
 * Revision 1.21  2004/08/12 00:53:01  flash
 * *** empty log message ***
 *
 * Revision 1.20  2004/07/26 01:46:49  flash
 * *** empty log message ***
 *
 * Revision 1.19  2004/07/22 09:35:43  flash
 * *** empty log message ***
 *
 * Revision 1.18  2004/07/21 02:22:45  flash
 * fix a lot
 *
 * Revision 1.17  2004/07/19 15:34:52  flash
 * *** empty log message ***
 *
 * Revision 1.16  2004/07/07 05:38:38  flash
 * *** empty log message ***
 *
 * Revision 1.15  2004/07/04 12:29:59  flash
 * *** empty log message ***
 *
 * Revision 1.14  2004/06/22 14:15:44  flash
 * *** empty log message ***
 *
 * Revision 1.13  2004/05/21 07:59:55  flash
 * fix hold count bug
 *
 * Revision 1.12  2004/05/10 15:07:31  flash
 * fix priority vector
 *
 * Revision 1.11  2004/05/05 06:35:17  flash
 * fix timer counts
 *
 * Revision 1.10  2004/05/04 01:15:54  flash
 * *** empty log message ***
 *
 * Revision 1.9  2004/05/03 14:50:13  flash
 * move rx function from port info to port rcv
 *
 * Revision 1.8  2004/05/03 14:47:29  flash
 * add port receive state machine
 *
 * Revision 1.7  2004/05/02 13:37:03  flash
 * add bpdu type
 *
 * Revision 1.6  2004/04/28 15:07:42  flash
 * add msti BPDU
 *
 * Revision 1.5  2004/04/27 06:31:38  flash
 * Fix port bug
 *
 * Revision 1.4  2004/04/27 03:30:40  flash
 * review xst
 *
 * Revision 1.3  2004/04/21 15:37:18  flash
 * fix compiler bugs
 *
 * Revision 1.2  2004/03/31 08:25:42  flash
 * fix state machines
 *
 * Revision 1.1  2004/03/31 01:15:17  flash
 * mstp initial version
 *
 **********************************************************************/


#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_in.h"
#include "xst_port.h"

/* #include "rolesel.h" */
#include "portinfo.h"
#include "roletrns.h"
#include "sttrans.h"
#include "topoch.h"
#include "migrate.h"
#include "transmit.h"
#include "p2p.h"
#include "extpcost.h"
#include "intpcost.h"
#include "edge.h"
#include "portrcv.h"

#include "stp_to.h"  /* for STP_OUT_get_port_name & STP_OUT_get_port_link_status */

extern unsigned char mstp_debug;
/*----------------------------------------------------------------------------------------*/
XST_PORT_T *STP_port_create (XST_T *that, int port_index)
{
  XST_PORT_T *this;
  register int iii;
  unsigned short port_prio;
  UID_STP_PORT_CFG_T port_cfg;

  this=&(that->ports[port_index]);

  if(this->valid == True) return this;

  this->valid = True;
  this->owner = that;
  this->port_index = port_index;
  this->adminEnable = False;

#ifdef STP_DBG
//  printk("Create xst %d port %d %d\n",that->xst_id, port_index, this->port_index);
#endif

  this->uptime = 0;

  STP_OUT_get_init_port_cfg (that->xst_id, port_index, &port_cfg);
  port_prio = port_cfg.port_priority;
  this->admin_non_stp = port_cfg.admin_non_stp;
  this->adminEdge = port_cfg.admin_edge;
  this->adminExtPCost = port_cfg.admin_port_path_cost;
  this->adminIntPCost = port_cfg.admin_port_path_cost;
  this->adminPointToPointMac = port_cfg.admin_point2point;

  this->LinkDelay = DEF_LINK_DELAY;
  this->portId = (port_prio << 8) + port_index+1;

  iii = 0;
  if(that->xst_id == 0)
   {
    this->timers[iii++] = &this->mdelayWhile;
    this->timers[iii++] = &this->helloWhen;
   }

  this->timers[iii++] = &this->fdWhile;
  this->timers[iii++] = &this->rrWhile;
  this->timers[iii++] = &this->rbWhile;
  this->timers[iii++] = &this->tcWhile;
  this->timers[iii++] = &this->rcvdInfoWhile;
  this->timers[iii++] = &this->lnkWhile;
  this->timers[iii++] = &this->txCount;

  /* create and bind port state machines */
  this->machines = NULL;

  if(that->xst_id == 0)
   {
    STP_STATE_MACH_IN_LIST (transmit);
    STP_STATE_MACH_IN_LIST (migrate);
    STP_STATE_MACH_IN_LIST (rcv);
    STP_STATE_MACH_IN_LIST (extpcost)
   }
  STP_STATE_MACH_IN_LIST (info);
  STP_STATE_MACH_IN_LIST (roletrns);
  STP_STATE_MACH_IN_LIST (sttrans);
  STP_STATE_MACH_IN_LIST (topoch);

  STP_STATE_MACH_IN_LIST (intpcost)
  if(that->xst_id == 0)
   {
    STP_STATE_MACH_IN_LIST (p2p);
    STP_STATE_MACH_IN_LIST (edge);
   }

  return this;
}

/*----------------------------------------------------------------------------------------*/
void STP_xst_port_init (XST_PORT_T * this, XST_T * that, Bool check_link)
 {
  if (check_link == True) 
   {
    this->adminEnable = STP_OUT_get_port_link_status (that->xst_id,this->port_index);

    STP_VECT_create (&this->xstDesignatedPriority, &that->BridgeIdentifier,0, &that->BridgeIdentifier,0,&that->BridgeIdentifier, this->portId, this->portId);
    STP_copy_times (&this->xstDesignatedTimes, &that->xstRootTimes);
   }

  this->valid=True;

  /* reset timers */
  this->fdWhile =
  this->helloWhen =
  this->mdelayWhile =
  this->rbWhile =
  this->rcvdInfoWhile = this->rrWhile = this->tcWhile = this->txCount = 0;

  this->msgPortRole = RSTP_PORT_ROLE_UNKN;
  this->selectedRole = DisabledPort;
  this->sendRSTP = True;
  this->operSpeed = STP_OUT_get_port_oper_speed (this->port_index);
  this->p2p_recompute = True;
  this->snmp_topo_change = 0;
  if (check_link==False) 
   {
    this->reselect = True;
    this->selected = False;
    STP_xst_update (that);
   }
 }

/*----------------------------------------------------------------------------------------*/
void STP_port_delete (XST_PORT_T * this)
 {
  XST_T *xst1;
  register STATE_MACH_T *stater;
  register void *pv;

  xst1 = this->owner;

  for (stater = this->machines; stater;) 
   {
    pv = (void *) stater->next;
    STP_state_mach_delete (stater);
    stater = (STATE_MACH_T *) pv;
   }
  this->valid = False;
 }

/*----------------------------------------------------------------------------------------*/
int STP_port_rx_bpdu (XST_PORT_T * this, MSTP_BPDU_T * bpdu, size_t len)
 {
  STP_rcv_rx_bpdu (this, bpdu, len);

  return 0;
 }

