/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
#ifndef XST_H
#define XST_H

#include "base.h"
#include "mstp.h"
#include "xst_port.h"
#include "statmch.h"

#define TxHoldCount     3 /* 17.16.6, 17.28.2(Table 17-5) */

typedef struct xst_t 
 {
/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and each MSTIs */
  int                   xst_id;        /*  */
  struct xst_port_t     ports[MAX_LOGIC_PORT];
  UID_STP_MODE_T        admin_state; /* STP_DISABLED or STP_ENABLED; type see in UiD */
  Bool                  valid; /* Created or not */

  PRIO_VECTOR_T         xstBridgePriority; /* 13.23.3 */
  TIMEVALUES_T          xstBridgeTimes; /* 13.23.4 */
  PORT_ID               xstRootPortId; /* 13.23.5 */
  PRIO_VECTOR_T         xstRootPriority; /* 13.23.6 */
  TIMEVALUES_T          xstRootTimes; /* 13.23.7 */
  
  STATE_MACH_T*         rolesel;   /* the Port Role Selection State machione: 17.22 */

  STATE_MACH_T*         machines;


  unsigned long         timeSince_Topo_Change; /* 14.8.1.1.3.b */
  unsigned long         Topo_Change_Count;     /* 14.8.1.1.3.c */
  Bool                  Topo_Change;           /* 14.8.1.1.3.d */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for CIST and all MSTIs */
#if 0
  char                  name[32];        /* name of MSTP*/
  unsigned short        revision; 
#endif

  PROTOCOL_VERSION_T    ForceVersion;   /* 17.12, 13.6.2 */
//  unsigned short        FwdDelay;

//  PORT_TIMER_T          TxHoldCount=3;      /* 17.18.40 */
  PORT_TIMER_T          MigrateTime;      
  
//by flash, 2005/04/26
//  unsigned short        MaxHops;  /* while bridge is the regional Root */
  
  BRIDGE_ID             BridgeIdentifier; /* 13.23.2 */

  Bool                  newRoot;

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */

/* vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv */
/* for each MSTI*/
   Bool             mstiMaster;    /* 13.24.13 */
   Bool             mstiMastered;    /* 13.24.14 */

/* ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ */
  

 /* sttx */
  BITMAP_T              sttx_bmp;
  int                   sttx_numbf;
  int                   sttx_timef;
  int                   sttx_timet;
  int                   sttx_type;
 } XST_T;

XST_T * STP_xst_find (int xst_id);
void STP_xst_init (void);
void STP_xst_stop (XST_T *this);
BRIDGE_ID * STP_compute_bridge_id (XST_T *this);

#endif
