/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * Spanning Trees
 * $Log: xst.c,v $
 * Revision 1.1.1.1  2009/02/17 09:44:45  anderson
 * RTL8196B source code
 *
 * Revision 1.42  2007/08/23 02:34:37  michael
 * Bug: 623
 * linux-2.6.19 fix
 *
 * Revision 1.41  2007/06/07 03:20:15  flash
 * Bug: 621
 * XST ID in bridge MAC
 *
 * Revision 1.40  2005/05/17 05:36:37  flash
 * BugID:
 *
 * Revision 1.39  2005/05/11 09:36:56  flash
 * BugID:
 *
 * Revision 1.38  2005/05/10 10:38:29  flash
 * BugID:
 *
 * Revision 1.37  2005/05/02 06:16:36  flash
 * BugID:
 *
 * Revision 1.36  2005/03/16 09:54:26  flash
 * *** empty log message ***
 *
 * Revision 1.35  2004/11/26 07:17:49  flash
 * *** empty log message ***
 *
 * Revision 1.34  2004/11/13 07:48:01  flash
 * *** empty log message ***
 *
 * Revision 1.33  2004/11/09 02:31:03  flash
 * *** empty log message ***
 *
 * Revision 1.32  2004/08/13 06:07:46  flash
 * *** empty log message ***
 *
 * Revision 1.31  2004/08/12 09:24:55  flash
 * *** empty log message ***
 *
 * Revision 1.30  2004/08/11 06:20:44  flash
 * *** empty log message ***
 *
 * Revision 1.29  2004/07/21 02:22:45  flash
 * fix a lot
 *
 * Revision 1.28  2004/07/19 15:34:52  flash
 * *** empty log message ***
 *
 * Revision 1.27  2004/07/07 06:32:18  flash
 * *** empty log message ***
 *
 * Revision 1.26  2004/07/04 12:29:59  flash
 * *** empty log message ***
 *
 * Revision 1.25  2004/06/30 07:07:15  winfred
 * default force version
 *
 * Revision 1.17  2004/05/24 09:40:46  flash
 * add tx
 *
 * Revision 1.15  2004/05/10 15:07:31  flash
 * fix priority vector
 *
 * Revision 1.11  2004/05/05 06:35:17  flash
 * fix timer counts
 *
 * Revision 1.10  2004/05/04 09:50:28  flash
 * fix stpapi_xst_find compile error
 *
 * Revision 1.9  2004/05/04 09:22:03  winfred
 * little update
 *
 * Revision 1.8  2004/05/02 13:37:03  flash
 * add bpdu type
 *
 * Revision 1.7  2004/04/28 15:07:42  flash
 * add msti BPDU
 *
 * Revision 1.6  2004/04/27 06:31:38  flash
 * Fix port bug
 *
 * Revision 1.5  2004/04/27 03:30:40  flash
 * review xst
 *
 * Revision 1.4  2004/04/26 08:16:20  flash
 * fix some bugs
 *
 * Revision 1.3  2004/04/21 15:37:18  flash
 * fix compiler bugs
 *
 * Revision 1.2  2004/04/21 10:01:26  flash
 * fix compile bugs
 *
 * Revision 1.1  2004/03/31 01:15:17  flash
 * mstp initial version
 *
 **********************************************************************/

//#include <string.h>

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_to.h"  /* for STP_OUT_flush_lt */
#include "stp_in.h"
#include "rolesel.h"

extern unsigned char mstp_debug;

static XST_T xst[MSTP_MAX_INSTANCE] ;

void _stp_xst_init_data(XST_T *this);

/*------------------------------------------------------------------------------------*/
XST_T * STP_xst_find (int xst_id)
 {
  return &(xst[xst_id]);
 }
/*------------------------------------------------------------------------------------*/

void STP_xst_init (void)
 {
  XST_T *this;
  int i;
  int j;

  memset (xst, 0, MSTP_MAX_INSTANCE * sizeof(XST_T));

  for(i=CIST_INSTANCE_ID;i<MSTP_MAX_INSTANCE;i++)
   {
    this=STP_xst_find(i);

    this->xst_id=i;
    for(j=0;j<MAX_LOGIC_PORT;j++)
     {
      this->ports[j].port_index=j;
     }

    this->valid=False;
    this->ForceVersion=DEF_FORCE_VERS;
    this->BridgeIdentifier.prio = (32768 & 0xff00); //default priority

    if (!STP_compute_bridge_id (this)) 
     { /* can't compute bridge id ? :( */
      return STP_Cannot_Compute_Bridge_Prio;
     }


    _stp_xst_init_data (this);
   }
 }
/*------------------------------------------------------------------------------------*/

static int _stp_xst_init_machine (STATE_MACH_T * this)
 {
#ifdef STP_DBG
//  printk("init machine %08X %8X\n",this, *(this->concreteEnterState));
#endif
  this->State = BEGIN;
  (*(this->concreteEnterState)) (this);
#ifdef STP_DBG
//  printk("after init machine\n");
#endif
  return 0;
 }
/*------------------------------------------------------------------------------------*/

static int _stp_xst_iterate_machines (XST_T *this, int (*iter_callb) (STATE_MACH_T *), Bool exit_on_non_zero_ret)
 {
  register STATE_MACH_T *stater;
  register XST_PORT_T *port;
  int iret, mret = 0,i;

  /* state machines per bridge */
  for (stater = this->machines; stater!=NULL; stater = stater->next) 
   {
#ifdef STP_DBG
//  printk("stater this=%08X owner=%08X stater=%08X rolesel=%08x\n",this,stater->owner ,*stater,this->rolesel);
#endif
    iret = (*iter_callb) (stater);
#ifdef STP_DBG
 // printk("after stater\n");
#endif
    if (iret && exit_on_non_zero_ret)
     return iret;
    else
     mret += iret;
   }

  /* state machines per port */
  for (i=0;i<MAX_LOGIC_PORT;i++) 
   {
#ifdef STP_DBG
//    int j=0;
#endif
    port = &(this->ports[i]); 

//by flash, 2005/05/11
#if 0
//by flash, 2005/05/10
  if (port->valid==False)
    continue;

  if(this->xst_id != 0)
   if (port->adminEnable==False)
    continue;
#endif

    for (stater = port->machines; stater!=NULL; stater = stater->next) 
     {
#ifdef STP_DBG
//  printk(" j%d",j++);
#endif
      iret = (*iter_callb) (stater);
#ifdef STP_DBG
//  printk(" x");
#endif
      if (iret && exit_on_non_zero_ret)
       return iret;
      else
       mret += iret;
     }
#ifdef STP_DBG
//   printk("\n");
#endif
   }

  return mret;
 }

/*------------------------------------------------------------------------------------*/
void _stp_xst_init_data (XST_T *this)
 {
//default root bridge is myself

  if(this->xst_id == CIST_INSTANCE_ID)
   {
    STP_VECT_create (&this->xstBridgePriority, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
    STP_VECT_create (&this->xstRootPriority, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
   }
  else
   {
    STP_VECT_create (&this->xstBridgePriority, 0, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
    STP_VECT_create (&this->xstRootPriority, 0, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
   }
  this->xstBridgeTimes.MessageAge = 0;
  this->xstBridgeTimes.MaxAge = 20;
  this->xstBridgeTimes.ForwardDelay = 15;
  this->xstBridgeTimes.HelloTime = 2;
  this->xstBridgeTimes.remainingHops = 20;

  STP_copy_times (&this->xstRootTimes, &this->xstBridgeTimes);
 }

/*------------------------------------------------------------------------------------*/
static Bool _check_topoch(XST_T *this)
 {
  register XST_PORT_T *port;
  register int i;

  for (i=0; i<MAX_LOGIC_PORT;i++) 
   {
    port = &(this->ports[i]);   
    if (port->tcWhile) 
     {
      return True;
     }
   }
  return False;
 }

/*------------------------------------------------------------------------------------*/
void STP_xst_one_second (XST_T *this)
 {
  register XST_PORT_T *port;
  register int iii,i,timer_count;
  Bool newTopoChange, new_root_trap = False;

  if (this->admin_state != STP_ENABLED)
   return;

  if(this->xst_id==0) //cist
   timer_count=TIMERS_NUMBER;
  else
   timer_count=TIMERS_NUMBER-2;

  for (i=0; i<MAX_LOGIC_PORT;i++) 
   {
    port = &(this->ports[i]);

//by flash, 2005/05/11
  if (port->valid==False)
    continue;

  if(this->xst_id != 0)
   if (port->adminEnable==False)
    continue;

    for (iii = 0; iii < timer_count; iii++) 
     {
      if (*(port->timers[iii]) > 0) 
       {
        (*port->timers[iii])--;
       }
     }
    port->uptime++;
#ifdef STP_DBG2
#if 0
    if(port->port_index<=1)
    {
     printk(" xst %d port %d infowhile ----- %d\n",this->xst_id,port->port_index,port->rcvdInfoWhile);
    }
#endif
#endif
#if 0
    if(port->port_index==5)
    {
    printk("***************************************");
    printk("port %d\n",port->port_index);
    printk("role %d\n",port->role);
    printk("valid %d\n",port->valid);
    printk("mdelayWhile %d\n",port->mdelayWhile);
    printk("helloWhen %d\n",port->helloWhen);
    printk("fdWhile %d\n",port->fdWhile);
    printk("rrWhile %d\n",port->rrWhile);
    printk("rbWhile %d\n",port->rbWhile);
    printk("tcWhile %d\n",port->tcWhile);
    printk("rcvdInfoWhile %d\n",port->rcvdInfoWhile);
    printk("lnkWhile %d\n",port->lnkWhile);
    printk("sendRSTP %d\n",port->sendRSTP);
    printk("newInfoCist %d\n",port->newInfoCist);
    printk("cistRootPort %d\n",port->cistRootPort);
    printk("cistDesignatedPort %d\n",port->cistDesignatedPort);
    printk("newInfoMsti %d\n",port->newInfoMsti);
    printk("mstiRootPort %d\n",port->mstiRootPort);
    printk("mstiDesignatedPort %d\n",port->mstiDesignatedPort);
    printk("txCount %d\n",port->txCount);
    }
#endif
   }

  newTopoChange = _check_topoch (this);
  if (newTopoChange != this->Topo_Change) 
   {
    if (newTopoChange)
     this->Topo_Change_Count++;
    this->Topo_Change = newTopoChange;
   }

  if (this->Topo_Change) 
   {
    this->timeSince_Topo_Change = 0;
   } 
  else 
   {
    this->timeSince_Topo_Change++;
    if (this->newRoot) 
     {
      this->newRoot = False;
      new_root_trap = True;
      STP_OUT_set_new_root_trap (0);
     }
   }

  for (i=0; i<MAX_LOGIC_PORT;i++) 
   {
    port = &(this->ports[i]);
    if (port->snmp_topo_change) 
     {
      if (!new_root_trap)
       STP_OUT_set_topology_change_trap (0, port->port_index, (int) port->forwarding);
      port->snmp_topo_change = False;
     }
   }

 if(mstp_debug)
  printk("one second update %d.......................\n",this->xst_id);
  i=STP_xst_update (this);
#if 0
  printk(" number of loop = %d \n",i);
#endif
 }

/*------------------------------------------------------------------------------------*/
XST_T *STP_xst_create (int xst_id)
 {
  XST_T *this;
  this=STP_xst_find(xst_id);

  this->valid=True;
  this->admin_state = STP_DISABLED;

#if 0
  if(this->xst_id == CIST_INSTANCE_ID)
   {
    STP_VECT_create (&this->xstBridgePriority, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
    STP_VECT_create (&this->xstRootPriority, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0,&this->BridgeIdentifier, 0, 0);
   }
  else
   {
    STP_VECT_create (&this->xstBridgePriority, 0, 0, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0, 0);
    STP_VECT_create (&this->xstRootPriority, 0, 0, &this->BridgeIdentifier, 0,&this->BridgeIdentifier, 0, 0);
   }
#endif

  memset (&this->sttx_bmp, 0, sizeof (BITMAP_T));
  this->sttx_numbf = 0;
  this->sttx_timef = 2;
  this->sttx_timet = -1;
  this->sttx_type = 0;

  this->ForceVersion = NORMAL_MSTP;
  this->machines = NULL;

  STP_STATE_MACH_IN_LIST (rolesel);
#ifdef STP_DBG
//    printk("xxx XST=%08X rolesel=%08X machines=%08x Enter=%08X\n",this ,this->rolesel,this->machines, this->rolesel->concreteEnterState);
#endif

  return this;
 }

/*------------------------------------------------------------------------------------*/
int STP_xst_enable (XST_T *this, UID_STP_MODE_T admin_state)
 {
  int rc = 0;

  if (this->admin_state == admin_state ) 
   {
    /* nothing to do :) */
    return 0;
   }

  if (admin_state == STP_ENABLED ) 
   {
    rc = STP_xst_start (this);
    this->admin_state = admin_state;
   } 
  else 
   {
    this->admin_state = admin_state;
    STP_xst_stop (this);
   }

  return rc;
 }

/*------------------------------------------------------------------------------------*/
void STP_xst_delete (XST_T *this)
 {
  register STATE_MACH_T* stater;
  register XST_PORT_T*   port;
  register void *pv;
  int i;

  STP_xst_enable (this, STP_DISABLED);
  
  for (stater = this->machines; stater; ) 
   {
    pv = (void*) stater->next;
    STP_state_mach_delete (stater);
    this->machines = stater = (STATE_MACH_T*) pv;
   }

  for (i=0; i<MAX_LOGIC_PORT;i++) 
   {
    port = &(this->ports[i]); 
    STP_port_delete (port);
   }
  this->valid=False;
 }

/*------------------------------------------------------------------------------------*/
int STP_xst_start (XST_T *this)
 {
  register XST_PORT_T *port;
  int i;

 if(mstp_debug)
  printk("XST start %d\n",this->xst_id);

  if (!STP_compute_bridge_id (this)) 
   { /* can't compute bridge id ? :( */
    return STP_Cannot_Compute_Bridge_Prio;
   }

//  _stp_xst_init_data (this);

  for (i=0; i<MAX_LOGIC_PORT;i++) 
   {
    port = &(this->ports[i]);
    STP_xst_port_init (port, this, True);
   }

#ifndef STRONGLY_SPEC_802_1W
  /* A. see comment near STRONGLY_SPEC_802_1W in topoch.c */
  /* B. port=0 here means: delete for all ports */

  STP_OUT_flush_lt (0xFFFFffffl, "start cist");
#endif


  this->timeSince_Topo_Change = 0;
  this->Topo_Change_Count = 0;
  this->Topo_Change = this->newRoot = False;

  _stp_xst_iterate_machines (this, _stp_xst_init_machine, False);

  STP_xst_update (this);

  return 0;
 }

/*------------------------------------------------------------------------------------*/
void STP_xst_stop (XST_T *this)
 {
  register XST_PORT_T *port;
  register int i;

  for (i=0; i<MAX_LOGIC_PORT; i++) 
   {
    port = &(this->ports[i]);
    STP_OUT_set_port_state (this->xst_id, i, UID_PORT_FORWARDING);
    port->forwarding = port->forward = True;
    port->learning = port->learn = True;
   }
 }

/* ----------------------------------------------------------------------------------------------*/

int STP_xst_update (XST_T *this)
 {    /* returns number of loops */
  register Bool need_state_change;
  register int number_of_loops = 0;

 if(mstp_debug)
  printk("XST update %d.......................\n",this->xst_id);

  need_state_change = False;

  for (;;) 
   {   /* loop until not need changes */
    need_state_change = _stp_xst_iterate_machines (this, STP_check_condition, True);
    if (!need_state_change)
     return number_of_loops;

    number_of_loops++;
    /* here we know, that at least one stater must be
       updated (it has changed state) */
    number_of_loops += _stp_xst_iterate_machines (this, STP_change_state, False);
   }

  return number_of_loops;
 }

/*------------------------------------------------------------------------------------*/
BRIDGE_ID * STP_compute_bridge_id (XST_T *this)
 {

  STP_OUT_get_port_mac (this->xst_id, this->BridgeIdentifier.addr);

  this->BridgeIdentifier.prio = (this->BridgeIdentifier.prio & 0xff00) + this->xst_id;

  return &this->BridgeIdentifier;
 }

/*------------------------------------------------------------------------------------*/
void STP_xst_update_after_bridge_management (XST_T *this)
 {
  register XST_PORT_T *port;
  int i;

  for (i=0; i<MAX_LOGIC_PORT; i++) 
   {
    port = &(this->ports[i]);
    port->reselect = True;
    port->selected = False;
   }
 }

/*------------------------------------------------------------------------------------*/
