/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * Port Transmit state machine 
 * $Log: transmit.c,v $
 * Revision 1.1.1.1  2009/02/17 09:44:45  anderson
 * RTL8196B source code
 *
 * Revision 1.1  2007/08/23 02:34:37  michael
 * Bug: 623
 * linux-2.6.19 fix
 *
 * Revision 1.59  2005/05/17 08:50:21  flash
 * BugID:
 *
 * Revision 1.58  2005/05/10 10:38:29  flash
 * BugID:
 *
 * Revision 1.57  2005/05/06 01:46:21  flash
 * BugID:
 *
 * Revision 1.56  2005/05/05 03:55:40  flash
 * BugID:
 *
 * Revision 1.55  2005/04/27 06:04:33  flash
 * BugID:
 *
 * Revision 1.54  2005/04/20 09:35:09  flash
 * BugID:
 *
 * Revision 1.53  2005/04/06 14:50:31  flash
 * fix msti non blocking bug
 *
 * Revision 1.52  2005/04/06 02:54:37  flash
 * BugID:
 *
 * Revision 1.51  2005/03/27 16:51:43  flash
 * *** empty log message ***
 *
 * Revision 1.50  2005/03/16 09:54:26  flash
 * *** empty log message ***
 *
 * Revision 1.49  2005/03/15 16:58:42  flash
 * *** empty log message ***
 *
 * Revision 1.48  2005/03/02 09:36:18  flash
 * *** empty log message ***
 *
 * Revision 1.47  2005/02/02 10:18:22  flash
 * *** empty log message ***
 *
 * Revision 1.46  2005/01/09 04:45:21  flash
 * *** empty log message ***
 *
 * Revision 1.45  2004/12/28 09:41:55  flash
 * *** empty log message ***
 *
 * Revision 1.44  2004/12/24 08:38:41  flash
 * *** empty log message ***
 *
 * Revision 1.43  2004/12/16 14:09:47  flash
 * *** empty log message ***
 *
 * Revision 1.42  2004/12/14 09:20:29  flash
 * *** empty log message ***
 *
 * Revision 1.41  2004/11/24 05:02:25  flash
 * *** empty log message ***
 *
 * Revision 1.40  2004/11/13 07:48:01  flash
 * *** empty log message ***
 *
 * Revision 1.39  2004/09/13 09:15:23  flash
 * *** empty log message ***
 *
 * Revision 1.38  2004/08/31 08:34:33  flash
 * fix region root bug
 *
 * Revision 1.37  2004/08/17 02:59:37  flash
 * *** empty log message ***
 *
 * Revision 1.36  2004/08/11 06:20:44  flash
 * *** empty log message ***
 *
 * Revision 1.35  2004/08/10 02:02:13  flash
 * *** empty log message ***
 *
 * Revision 1.34  2004/08/04 14:14:45  flash
 * *** empty log message ***
 *
 * Revision 1.33  2004/08/04 09:42:55  flash
 * transmit STP/RSTP bpdu
 *
 * Revision 1.32  2004/08/04 00:51:18  flash
 * *** empty log message ***
 *
 * Revision 1.31  2004/07/22 05:22:24  flash
 * check xst->valid
 *
 * Revision 1.30  2004/07/21 06:20:21  flash
 * fix transmit bugs
 *
 * Revision 1.29  2004/07/19 15:34:52  flash
 * *** empty log message ***
 *
 * Revision 1.28  2004/07/14 14:34:39  flash
 * *** empty log message ***
 *
 * Revision 1.27  2004/06/25 07:20:38  flash
 * fix config ID
 *
 * Revision 1.26  2004/06/23 15:10:27  flash
 * *** empty log message ***
 *
 * Revision 1.25  2004/06/22 10:31:13  flash
 * *** empty log message ***
 *
 * Revision 1.24  2004/06/02 14:15:39  flash
 * print instance map
 *
 * Revision 1.23  2004/05/31 15:02:28  flash
 * fix show spanning
 *
 * Revision 1.22  2004/05/30 13:23:23  flash
 * *** empty log message ***
 *
 * Revision 1.21  2004/05/28 04:57:51  flash
 * *** empty log message ***
 *
 * Revision 1.20  2004/05/26 14:10:40  flash
 * *** empty log message ***
 *
 * Revision 1.19  2004/05/24 09:40:46  flash
 * add tx
 *
 * Revision 1.18  2004/05/24 03:58:44  flash
 * fix TX_MSTP_BPDU_T and MSTP_BPDU_T bug
 *
 * Revision 1.17  2004/05/21 09:42:20  flash
 * *** empty log message ***
 *
 * Revision 1.16  2004/05/21 07:59:55  flash
 * fix hold count bug
 *
 * Revision 1.15  2004/05/10 15:07:31  flash
 * fix priority vector
 *
 * Revision 1.14  2004/05/04 09:50:28  flash
 * fix stpapi_xst_find compile error
 *
 * Revision 1.13  2004/05/04 09:22:03  winfred
 * little update
 *
 * Revision 1.12  2004/05/02 13:37:03  flash
 * add bpdu type
 *
 * Revision 1.11  2004/05/02 12:59:25  flash
 * set MST Confiuration Identifier
 *
 * Revision 1.10  2004/04/30 08:50:10  winfred
 * update txMstp()
 *
 * Revision 1.9  2004/04/29 09:36:09  flash
 * bpdu type is wrong..
 *
 * Revision 1.8  2004/04/29 08:54:13  winfred
 * 1. update transmit.c txMstp() and build_bpdu_header()
 * 2. change 0 to CIST_INSTANCE_ID
 *
 * Revision 1.7  2004/04/28 15:07:42  flash
 * add msti BPDU
 *
 * Revision 1.6  2004/04/16 15:14:40  flash
 * fix compiler bugs
 *
 * Revision 1.5  2004/04/16 08:17:20  flash
 * fix compiler bug
 *
 * Revision 1.4  2004/04/12 03:50:46  flash
 * fix state machines
 *
 * Revision 1.3  2004/04/11 22:17:40  flash
 * fix state machines
 *
 * Revision 1.2  2004/03/31 08:25:42  flash
 * fix state machines
 *
 * Revision 1.1  2004/03/31 01:15:37  flash
 * cvs initial version
 *
 **********************************************************************/


#include <asm/byteorder.h>
#include <linux/byteorder/generic.h>
#include <asm/unaligned.h>

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_to.h"
#include "stp_in.h"
#include "stp_bpdu.h"

#define BPDU_LEN8023_OFF    12

#define STATES {        \
  CHOOSE(TRANSMIT_INIT),    \
  CHOOSE(TRANSMIT_PERIODIC),    \
  CHOOSE(IDLE),         \
  CHOOSE(TRANSMIT_CONFIG),  \
  CHOOSE(TRANSMIT_TCN),     \
  CHOOSE(TRANSMIT_RSTP),    \
}

#define GET_STATE_NAME STP_transmit_get_state_name
#include "choose.h"

extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;
/* ----------------------------------------------------------------------------------------------*/
extern unsigned short vlan_instance_map[4096];
extern unsigned char MSTP_ConfigName[32];
extern unsigned short MSTP_RevisionLevel;         /* 0 */
extern unsigned short vlan_valid[4096];
extern TstLPortMask vlan_member[4096];
extern unsigned char mstp_debug;

typedef struct tx_tcn_bpdu_t
{
  MAC_HEADER_T mac;
  ETH_HEADER_T eth;
  BPDU_HEADER_T hdr;
}
TCN_BPDU_T;

typedef struct tx_stp_bpdu_t
{
  MAC_HEADER_T mac;
  ETH_HEADER_T eth;
  BPDU_HEADER_T hdr;
  BPDU_BODY_T body;
}
CONFIG_BPDU_T;

typedef struct tx_rstp_bpdu_t
{
  MAC_HEADER_T mac;
  ETH_HEADER_T eth;
  BPDU_HEADER_T hdr;
  BPDU_BODY_T body;
  unsigned char ver_1_length;
}
RSTP_BPDU_T;

typedef struct tx_mstp_bpdu_t
 {
  MAC_HEADER_T mac;
  ETH_HEADER_T eth;
  BPDU_HEADER_T hdr;
  BPDU_BODY_T cist_body;
  unsigned char ver_1_length;
  unsigned char ver_3_length[2];
  unsigned char MST_config_id[51];
  unsigned char Cist_internal_root_path_cost[4];
  unsigned char Cist_bridge_id[8];
  unsigned char Cist_remainingHops;
  MSTI_CONFIG_T msti_conf[MSTP_MAX_INSTANCE];
 } TX_MSTP_BPDU_T;

/* ----------------------------------------------------------------------------------------------*/

static TX_MSTP_BPDU_T bpdu_packet = 
 {
  {    /* MAC_HEADER_T */
   {0x01, 0x80, 0xc2, 0x00, 0x00, 0x00}, /* dst_mac */
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00} /* src_mac */
  },
  {    /* ETH_HEADER_T */
   {0x00, 0x00},  /* len8023 */
   BPDU_L_SAP, BPDU_L_SAP, LLC_UI /* dsap, ssap, llc */
  },
  {    /* BPDU_HEADER_T */
   {0x00, 0x00},  /* protocol */
   BPDU_VERSION_ID, 0x00 /* version, bpdu_type */
  },
  {    /* BPDU_BODY_T */
   0x00,   /*  flags; */
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /*  root_id[8]; */
   {0x00, 0x00, 0x00, 0x00}, /*  root_path_cost[4]; */
   {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /*  bridge_id[8]; */
   {0x00, 0x00},  /*  port_id[2]; */
   {0x00, 0x00},  /*  message_age[2]; */
   {0x00, 0x00},  /*  max_age[2]; */
   {0x00, 0x00},  /*  hello_time[2]; */
   {0x00, 0x00}   /*  forward_delay[2]; */
  },
  0x00,   /*  ver_1_length; */
  {0x00, 0x00},   /*  ver_3_length[2]; */
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00}, /* MST_config_id[51] */
  {0x00, 0x00, 0x00, 0x00}, /* Cist_internal_root_path_cost[4] */
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, /* Cist_bridge_id[8]; */
  0x00, /* Cist_remainingHops */
  {    /* MSTI_CONFIG_T totol 15 */
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   },
   {
    0x00,
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},/* msti_internal_root_id */
    {0x00, 0x00, 0x00, 0x00}, /* msti_internal_root_path_cost[4] */
    0x00, 0x00, 0x00
   }
  }
 };

/* ----------------------------------------------------------------------------------------------*/
static void build_llc_header()
 {
  bpdu_packet.eth.dsap = BPDU_L_SAP;
  bpdu_packet.eth.ssap = BPDU_L_SAP;
  bpdu_packet.eth.llc = LLC_UI;

 }
/* ----------------------------------------------------------------------------------------------*/
static size_t build_bpdu_header (int port_index, unsigned char bpdu_type, unsigned short pkt_len)
 {
  unsigned short len8023;

  STP_OUT_get_port_mac (port_index, bpdu_packet.mac.src_mac);
  
  if(bpdu_type == BPDU_MSTP)
   bpdu_packet.hdr.bpdu_type = BPDU_RSTP;
  else
   bpdu_packet.hdr.bpdu_type = bpdu_type;

  switch(bpdu_type)
  {
   case BPDU_TOPO_CHANGE_TYPE:
   case BPDU_CONFIG_TYPE:
    bpdu_packet.hdr.version = BPDU_VERSION_ID;
    break;
   case BPDU_RSTP:
    bpdu_packet.hdr.version = BPDU_VERSION_RSTP_ID;
    break;
   case BPDU_MSTP:
    bpdu_packet.hdr.version = BPDU_VERSION_MSTP_ID;
    break;
   default:
    bpdu_packet.hdr.version = BPDU_VERSION_ID;
    break;
  }

  /* NOTE: I suppose, that sizeof(unsigned short)=2 ! */
  len8023 = htons ((unsigned short) (pkt_len + 3)); /* 3 is len of LLC */
  memcpy (&(bpdu_packet.eth.len8023), &len8023, 2);

  return pkt_len+3;
 }

/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
static int txTcn (STATE_MACH_T * this)
 {    /* 17.19.17 (page 68) & 9.3.2 (page 25) */
  register size_t pkt_len;
  register int port_index;
  register XST_PORT_T *port;

  port = this->owner.port;

if(mstp_debug)
 printk("Tx TCN on port %d\n",port->port_index);

  if(port->owner->xst_id!=CIST_INSTANCE_ID)
   return -1;

  if (port->admin_non_stp)
    return 1;
  port_index = port->port_index;

  build_llc_header();

  pkt_len = build_bpdu_header (port_index, BPDU_TOPO_CHANGE_TYPE, BPDU_HEADER_T_SZ);

  port->tx_tcn_bpdu_cnt++;
//  port->txCount++;
  return STP_OUT_tx_bpdu (port_index, (unsigned char *) &bpdu_packet, pkt_len);
 }

/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
static void build_config_bpdu (XST_PORT_T * port, Bool set_topo_ack_flag)
 {
  MSTP_BPDU_T *b;

  bpdu_packet.cist_body.flags = 0;
  if (port->tcWhile) 
   {
    bpdu_packet.cist_body.flags |= TOPOLOGY_CHANGE_BIT;
   }

  if (set_topo_ack_flag && port->tcAck) 
   {
    bpdu_packet.cist_body.flags |= TOPOLOGY_CHANGE_ACK_BIT;
   }

  STP_VECT_set_vector (&(port->xstPortPriority), (MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T)) );

  b=(MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T));
  stp_vect_set_bridge_id (&(port->xstPortPriority.design_bridge), (b->cist_body.bridge_id)); //STP BPDU in this field

//   should be transmit port
  stp_vect_set_short (port->portId, (b->cist_body.port_id));

//  STP_set_times (&(port->xstPortTimes), &(bpdu_packet.cist_body));
  STP_set_times (&(port->xstPortTimes), (MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T)));
 }

/* ----------------------------------------------------------------------------------------------*/
static int txConfig (STATE_MACH_T * this)
 {    /* 13.26.21 (page 154) */
  register size_t pkt_len;
  register XST_PORT_T *port;
  register int port_index;

  port = this->owner.port;

if(mstp_debug)
 printk("Tx config on port %d\n",port->port_index);

  if(port->owner->xst_id!=CIST_INSTANCE_ID)
   return -1;

  if (port->admin_non_stp)
    return 1;

  port_index = port->port_index;

  build_llc_header();

#ifdef STP_DBG1
#if 0
 {
  int i;

  printk(" tx1: bpdu data:");
  for(i=0;i<30;i++)
   printk(" %02X", ((unsigned char*)&bpdu_packet)[i]);
  printk("\n");
 }
#endif
#endif

  pkt_len = build_bpdu_header (port->port_index, BPDU_CONFIG_TYPE, BPDU_HEADER_T_SZ + BPDU_BODY_T_SZ);

#ifdef STP_DBG1
#if 0
 {
  int i;

  printk(" tx2: bpdu data:");
  for(i=0;i<30;i++)
   printk(" %02X", ((unsigned char*)&bpdu_packet)[i]);
  printk("\n");
 }
#endif
#endif

  build_config_bpdu (port, True);

#ifdef STP_DBG1
#if 0
 {
  int i;

  printk(" tx3: bpdu data:");
  for(i=0;i<30;i++)
   printk(" %02X", ((unsigned char*)&bpdu_packet)[i]);
  printk("\n");
 }
#endif
#endif
  port->tx_cfg_bpdu_cnt++;
//  port->txCount++;
  return STP_OUT_tx_bpdu (port_index, (unsigned char *) &bpdu_packet, pkt_len);
 }

/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
char mstp_digest[16];

#if 0
char *get_digest(void)
 {
  return mstp_digest;
 }
#endif
/* ----------------------------------------------------------------------------------------------*/
void compute_digest(void)
 {    /* 13.7 (page 121) & 14.6 (page 171) */
  unsigned char key[16]={0x13,0xAC,0x06,0xA6,0x2E,0x47,0xFD,0x51,0xF9,0x5D,0x2B,0xA2,0x43,0xCD,0x03,0x46};

/* configuration digest signature */
  mstp_hmac_md5(vlan_instance_map, 4096*2, key, 16, mstp_digest);  
 }
/* ----------------------------------------------------------------------------------------------*/
static void build_mstp_config_id (void)
 {    /* 13.7 (page 121) & 14.6 (page 171) */
//  unsigned char key[16]={0x13,0xAC,0x06,0xA6,0x2E,0x47,0xFD,0x51,0xF9,0x5D,0x2B,0xA2,0x43,0xCD,0x03,0x46};

/* Configuration Identifier Format Selector */
  bpdu_packet.MST_config_id[0] = 0;  

/* Configuration Name */  //from CLI
  snprintf(&(bpdu_packet.MST_config_id[1]), BRIDGE_NAME_LEN, "%s", MSTP_ConfigName);

//  printk("bpdu_packet MSTID 0 =%X 1=%x\n",(bpdu_packet.MST_config_id[0]),(bpdu_packet.MST_config_id[1]));
/* Revision Level */  //from CLI
  bpdu_packet.MST_config_id[33] = (MSTP_RevisionLevel)>>8;
  bpdu_packet.MST_config_id[34] = (MSTP_RevisionLevel)&0xff;

/* configuration digest signature */
//  mstp_hmac_md5(vlan_instance_map, 4096*2, key, 16, &(bpdu_packet.MST_config_id[35]));  
  memcpy(&(bpdu_packet.MST_config_id[35]), mstp_digest, 16);
 }

/* ----------------------------------------------------------------------------------------------*/
static void build_cist_params (XST_PORT_T * port)
 {
  XST_T *cist;
  unsigned char role;
  unsigned short usTemp;
  static char explan[80];
  MSTP_BPDU_T *b;

  cist=STP_xst_find(CIST_INSTANCE_ID);
  
  bpdu_packet.cist_body.flags = 0;
  if (port->tcWhile) 
   {
    bpdu_packet.cist_body.flags |= TOPOLOGY_CHANGE_BIT;
   }

  if (port->tcAck) 
   {
    bpdu_packet.cist_body.flags |= TOPOLOGY_CHANGE_ACK_BIT;
   }

  switch (port->role) 
   {
    default:
    case DisabledPort:
      strcpy (explan, "Unkn ");
      role = RSTP_PORT_ROLE_UNKN;
      break;
    case AlternatePort:
      strcpy (explan, "Altr ");
      role = RSTP_PORT_ROLE_ALTBACK;
      break;
    case BackupPort:
      strcpy (explan, "Back ");
      role = RSTP_PORT_ROLE_ALTBACK;
      break;
    case RootPort:
      strcpy (explan, "Root ");
      role = RSTP_PORT_ROLE_ROOT;
      break;
    case DesignatedPort:
      strcpy (explan, "Dsgn ");
      role = RSTP_PORT_ROLE_DESGN;
      break;
   }

  if (port->tcWhile) 
   {
    strcat (explan, "TC ");
   }

  bpdu_packet.cist_body.flags |= (role << PORT_ROLE_OFFS);

  if (port->synced) 
   {
    strcat (explan, "AGREEMENT ");
    bpdu_packet.cist_body.flags |= AGREEMENT_BIT;
   }

  if (port->proposing) 
   {
    strcat (explan, "PROPOSAL ");
    bpdu_packet.cist_body.flags |= PROPOSAL_BIT;
   }

  if (port->forwarding) 
   {
    strcat (explan, "FWD ");
    bpdu_packet.cist_body.flags |= FORWARD_BIT;
   }

  if (port->learning) 
   {
    strcat (explan, "LRN ");
    bpdu_packet.cist_body.flags |= LEARN_BIT;
   }

  STP_VECT_set_vector (&(port->xstPortPriority), (MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T)) );

#if 0
  b=(MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T));
//   should be transmit port
  stp_vect_set_short (port->portId, (b->cist_body.port_id));
#endif

  STP_set_times (&(port->xstPortTimes), (MSTP_BPDU_T *) (((unsigned char *)&bpdu_packet)+sizeof(MAC_HEADER_T)));

//  memcpy(bpdu_packet.cist_body.port_id, &(cist->xstRootPriority.design_port),2);  
  usTemp=htons(port->portId);
  memcpy(bpdu_packet.cist_body.port_id, &usTemp,2);

 }

/* ----------------------------------------------------------------------------------------------*/
static int txMstp (STATE_MACH_T * this)
 {    /* 13.26.22 (page 155) */
  register size_t pkt_len;
  register XST_PORT_T *port;
  register int port_index;
  int i,msti_num;
  unsigned long ulTemp;
  unsigned short usTemp;

  port = this->owner.port;

#ifdef STP_DBG1
if(mstp_debug)
 printk("Tx MSTP on port %d\n",port->port_index);
#endif

  if (port->owner->xst_id!=CIST_INSTANCE_ID)
   return -1;
  if (port->admin_non_stp)
   return 1;

  port_index = port->port_index;

  build_llc_header();

#ifdef STP_DBG1
#if 0
 {
  int i;

  printk(" tx1: bpdu data:");
  for(i=0;i<30;i++)
   printk(" %02X", ((unsigned char*)&bpdu_packet)[i]);
  printk("\n");
 }
#endif
#endif
                

  /*
   * Add CIST  ...
   */


  build_cist_params(port);

  build_mstp_config_id();

  bpdu_packet.ver_1_length = 0;

  /*
   * Add MSTIs ...
   */

  msti_num=0;

  for(i=1;i<MSTP_MAX_INSTANCE;i++)
   {
    XST_T *xst1=STP_xst_find(i);
    XST_PORT_T *port1=&(xst1->ports[port->port_index]);
    unsigned char role1;
    int vid;
    unsigned long vlan_mem;

    if(xst1->valid==False)
     continue;
    if(xst1->admin_state==STP_DISABLED)
     continue;

    for(vid=0;vid<4095;vid++)
     {
      if(vlan_valid[vid]==0) continue;

#if 0
      if(port->port_index>=0 && port->port_index<=6)
      {
      vlan_mem=vlan_member[vid];
      printk("*******************************************\n");
      printk(" vlan_member %08X port %d xst %d vlan %d\n", vlan_mem,port->port_index,xst1->xst_id,vid);
      vlan_mem=vlan_mem>>port->port_index;
      printk(" vlan_member2 %08X\n", vlan_mem);
      vlan_mem=vlan_mem&0x1L;
      printk(" vlan_member3 %08X\n", vlan_mem);

      printk(" vlan_instance_map %d %d\n",ntohs(vlan_instance_map[vid]),ntohs(vlan_instance_map[vid+1]));
      }
#endif

      if(ntohs(vlan_instance_map[vid+1])!=xst1->xst_id) continue;

      if(((vlan_member[vid].ulMask[port->port_index/MASK_BIT_LEN])>>(port->port_index%MASK_BIT_LEN)&0x1L))break;
     }
    if(vid>=4095) continue;

    bpdu_packet.msti_conf[msti_num].msti_flag=0;

    if (port1->tcWhile) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= TOPOLOGY_CHANGE_BIT;
     }

    switch (port1->role) 
     {
      default:
      case DisabledPort:
        role1 = RSTP_PORT_ROLE_UNKN;
        break;

      case AlternatePort:
        role1 = RSTP_PORT_ROLE_ALTBACK;
        break;

      case BackupPort:
        role1 = RSTP_PORT_ROLE_ALTBACK;
        break;

      case RootPort:
        role1 = RSTP_PORT_ROLE_ROOT;
        break;

      case DesignatedPort:
        role1 = RSTP_PORT_ROLE_DESGN;
        break;
     }

    bpdu_packet.msti_conf[msti_num].msti_flag |= (role1 << PORT_ROLE_OFFS);

    if (port1->synced) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= AGREEMENT_BIT;
     }

    if (port1->proposing) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= PROPOSAL_BIT;
     }

    if (port1->forwarding) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= FORWARD_BIT;
     }

    if (port1->learning) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= LEARN_BIT;
     }

    if (((port1->role == RootPort)||(port1->role == DesignatedPort)) && (/*xst1->mstiMastered || */xst1->mstiMaster)) 
     {
      bpdu_packet.msti_conf[msti_num].msti_flag |= MASTER_BIT;
     }

    usTemp=port1->xstPortPriority.region_root_bridge.prio;  
#ifdef STP_DBG1
#if 0
    printk(" ........... uSTemp %04X\n",usTemp);
#endif
#endif
    bpdu_packet.msti_conf[msti_num].msti_internal_root_id[0]=(usTemp >> 8)& 0xf0;  
//    bpdu_packet.msti_conf[msti_num].msti_internal_root_id[1]=usTemp & 0xff;  
    bpdu_packet.msti_conf[msti_num].msti_internal_root_id[1]=0;  
    bpdu_packet.msti_conf[msti_num].msti_internal_root_id[1]+=xst1->xst_id;
    memcpy(bpdu_packet.msti_conf[msti_num].msti_internal_root_id+2, &(port1->xstPortPriority.region_root_bridge.addr), 6);  

    ulTemp=htonl(port1->xstPortPriority.intern_path_cost);
    memcpy(bpdu_packet.msti_conf[msti_num].msti_internal_root_path_cost, &(ulTemp), 4);
    
    bpdu_packet.msti_conf[msti_num].msti_bridge_priority=xst1->BridgeIdentifier.prio >> 8;
//    bpdu_packet.msti_conf[msti_num].msti_port_priority=port1->xstPortPriority.root_bridge.prio;
    bpdu_packet.msti_conf[msti_num].msti_port_priority=port1->portId>>8;
    bpdu_packet.msti_conf[msti_num].msti_remainingHops=port1->xstPortTimes.remainingHops;

    msti_num++;

   }

#ifdef STP_DBG1
//    printk(" TX:msti_num %d\n",msti_num);
#endif

/* 15 MSTI_CONFIG_T */
  put_unaligned(htons(64+msti_num*MSTI_CFG_SZ), (unsigned short *)bpdu_packet.ver_3_length); 

#if 0
  printk("MSTP version %d\n",port->owner->ForceVersion );
#endif

  if (port->owner->ForceVersion < NORMAL_MSTP)
   {
    pkt_len = build_bpdu_header (port->port_index, BPDU_RSTP,BPDU_HEADER_T_SZ + BPDU_BODY_T_SZ + BPDU_V1_LEN_SZ);
   }
  else
   {
    pkt_len = build_bpdu_header (port->port_index, BPDU_MSTP,BPDU_HEADER_T_SZ + BPDU_BODY_T_SZ + BPDU_V1_LEN_SZ +BPDU_V3_LEN_SZ + MSTP_CFG_ID_SZ + CIST_PARAMS_SZ +MSTI_CFG_SZ * msti_num);
   }

#if 0
  printk("msti_num=%d \n ",msti_num);
  printk("pktlen %d\n",pkt_len);
#endif

  return STP_OUT_tx_bpdu (port_index, (unsigned char *) &bpdu_packet, pkt_len);
 }

/* ----------------------------------------------------------------------------------------------*/
static Bool check_mstiDesignatedPort(int port_index)
{
 int i;
 struct xst_t *xst;
 struct xst_port_t *xst_port;
 Bool ret=False;

 for(i=1;i<MSTP_MAX_INSTANCE;i++)
 {
  xst=STP_xst_find(i);
  xst_port=&(xst->ports[port_index]);

  if(xst->valid == False)
   continue;
  if(xst->admin_state == STP_DISABLED)
   continue;

  if(xst_port->mstiDesignatedPort == True)
  {
//   printk(" port %d mstiDesignate is True xst %d\n",port_index,i);
   ret=True;
   break;
  }
 }

 return ret;
}
/* ----------------------------------------------------------------------------------------------*/
static Bool check_mstiRootPort(int port_index)
{
 int i;
 struct xst_t *xst;
 struct xst_port_t *xst_port;
 Bool ret=False;

 for(i=1;i<MSTP_MAX_INSTANCE;i++)
 {
  xst=STP_xst_find(i);
  xst_port=&(xst->ports[port_index]);

  if(xst->valid == False)
   continue;
  if(xst->admin_state == STP_DISABLED)
   continue;

  if(xst_port->mstiRootPort == True)
  {
//   printk(" port %d mstiRoot is True xst %d \n",port_index,i);
   ret=True;
   break;
  }
 }

 return ret;

}
/* ----------------------------------------------------------------------------------------------*/
static Bool check_mstiTcWhile(int port_index)
{
 int i;
 struct xst_t *xst;
 struct xst_port_t *xst_port;
 Bool ret=False;

 for(i=1;i<MSTP_MAX_INSTANCE;i++)
 {
  xst=STP_xst_find(i);
  xst_port=&(xst->ports[port_index]);

  if(xst->valid == False)
   continue;
  if(xst->admin_state == STP_DISABLED)
   continue;

  if(xst_port->tcWhile)
  {
//   printk(" port %d mstiRoot is True xst %d \n",port_index,i);
   ret=True;
   break;
  }
 }

 return ret;

}
/* ----------------------------------------------------------------------------------------------*/
void STP_transmit_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port;
  register XST_T *cist;
  
  port = this->owner.port;

  if(port->owner->xst_id!=CIST_INSTANCE_ID)
   return;

  cist=port->owner;

#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: transmit state:%s xst %d port %d\n", GET_STATE_NAME(this->State),port->owner->xst_id,port->port_index);
#endif

  switch (this->State) 
   {
    case BEGIN:
    case TRANSMIT_INIT:
       port->newInfoCist = False;
       port->putOffNewInfoCist = False;
       port->newInfoMsti = False;
       port->putOffNewInfoMsti = False;

       port->helloWhen = 0;
       port->txCount = 0;       
       port->tx_cfg_bpdu_cnt=0;
       port->tx_mstp_bpdu_cnt=0;
       port->tx_tcn_bpdu_cnt=0;
       break;
    case TRANSMIT_PERIODIC:
      port->newInfoCist = port->newInfoCist || ((port->cistDesignatedPort) || ((port->cistRootPort) && port->tcWhile));
      port->newInfoMsti = port->newInfoMsti || ((check_mstiDesignatedPort(port->port_index)) || ((check_mstiRootPort(port->port_index)) && check_mstiTcWhile(port->port_index)));
      port->helloWhen = cist->xstRootTimes.HelloTime;
      break;
    case IDLE:
      break;
    case TRANSMIT_CONFIG:
      port->newInfoCist = False;
      port->newInfoMsti = False;
      txConfig (this);
      port->txCount++;
      port->tx_cfg_bpdu_cnt++;
      port->tcAck = False;
      break;
    case TRANSMIT_TCN:
      port->newInfoCist = False;
      port->newInfoMsti = False;
      txTcn (this);
      port->txCount++;
      port->tx_tcn_bpdu_cnt++;
      break;
    case TRANSMIT_RSTP:
      port->newInfoCist = False;
      port->newInfoMsti = False;
      txMstp (this);
      port->tx_mstp_bpdu_cnt++;
      port->txCount++;
      port->tcAck = False;
      break;
   };
 }

/* ----------------------------------------------------------------------------------------------*/
Bool STP_transmit_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port;
  register XST_T *cist;
  Bool bPutOffNewInfo;
  
  port = this->owner.port;

  if(port->owner->xst_id!=CIST_INSTANCE_ID)
   return False;

  cist=port->owner;
  if (BEGIN == this->State)
   return STP_hop_2_state (this, TRANSMIT_INIT);

  switch (this->State) 
   {
    case TRANSMIT_INIT:
      return STP_hop_2_state (this, IDLE);
    case TRANSMIT_PERIODIC:
      return STP_hop_2_state (this, IDLE);
    case IDLE:
      bPutOffNewInfo=False;

      if (port->helloWhen && port->newInfoCist && port->putOffNewInfoCist) 
       {
        port->putOffNewInfoCist = False;
        bPutOffNewInfo=True;
       }
      if (port->helloWhen && port->newInfoMsti && port->putOffNewInfoMsti) 
       {
        port->putOffNewInfoMsti = False;
        bPutOffNewInfo=True;
       }
      if(bPutOffNewInfo==True)
       break;

      if (!port->helloWhen)
       return STP_hop_2_state (this, TRANSMIT_PERIODIC);

//if(mstp_debug && port->port_index==0)
//      printk(" IDLE: %d %d %d %d %d\n", port->sendRSTP,port->newInfoCist, port->cistRootPort , port->txCount,port->helloWhen) ;
      if (!port->sendRSTP && port->newInfoCist && port->cistDesignatedPort && (port->txCount < TxHoldCount) && port->helloWhen) 
       return STP_hop_2_state (this, TRANSMIT_CONFIG);

//ANVL 28.13
      if (!port->sendRSTP && port->newInfoCist && port->cistRootPort && (port->txCount < TxHoldCount) && port->helloWhen) 
       return STP_hop_2_state (this, TRANSMIT_TCN);

#if 0
      if(port->port_index >= 6 && port->port_index <= 7)
       printk(" port %d check_mstiDesignatedPort %d check_mstiRootPort %d  newinfomsti %d sendrstp %d\n",port->port_index,check_mstiDesignatedPort(port->port_index), check_mstiRootPort(port->port_index),port->newInfoMsti, port->sendRSTP); 

#endif
      if (port->sendRSTP && ((port->newInfoCist && (port->cistRootPort || port->cistDesignatedPort)) || (port->newInfoMsti && (check_mstiRootPort(port->port_index) || check_mstiDesignatedPort(port->port_index)))) && (port->txCount < TxHoldCount) && port->helloWhen)
       return STP_hop_2_state (this, TRANSMIT_RSTP);

      break;
    case TRANSMIT_CONFIG:
      return STP_hop_2_state (this, IDLE);
    case TRANSMIT_TCN:
      return STP_hop_2_state (this, IDLE);
    case TRANSMIT_RSTP:
      return STP_hop_2_state (this, IDLE);
   };
  return False;
 }

