/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Topolgy Change state machine : 17.25 */

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_to.h"  /* for STP_OUT_flush_lt */

#define STATES { \
  CHOOSE(INIT),             \
  CHOOSE(INACTIVE),         \
  CHOOSE(TCACTIVE),         \
  CHOOSE(DETECTED),         \
  CHOOSE(NOTIFIED_TC),      \
  CHOOSE(PROPAGATING),      \
  CHOOSE(ACKNOWLEDGED),     \
  CHOOSE(NOTIFIED_TCN),     \
  CHOOSE(TCFLUSH),          \
}

#define GET_STATE_NAME STP_topoch_get_state_name
#include "choose.h"
extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;
/* ----------------------------------------------------------------------------------------------*/

static Bool flush (STATE_MACH_T * this, char *reason)
 {    /* 17.19.9 */
  register XST_PORT_T *port = this->owner.port;

  if (port->operEdge)
    return False;
  if (!port->adminEnable) 
   { /* we have just flushed it in stp_in_enable_port */
    return False;
   }

  STP_OUT_flush_single_lt (port->port_index, reason);
  return True;
 }
/* ----------------------------------------------------------------------------------------------*/
#ifndef STRONGLY_SPEC_802_1S
/* 
 * In many kinds of hardware the function
 * STP_OUT_flush_lt is a) is very hard and b) cannot
 * delete learning emtries per port. The alternate
 * method may be used: we don't care operEdge flag here,
 * but clean learning table once for TopologyChange
 * for all ports, except the received port. I am ready to discuss :(
 * See below word STRONGLY_SPEC_802_1S
 */
#endif
/* ----------------------------------------------------------------------------------------------*/
/*
 * Sets tcProp TRUE for the given tree (the CIST or anMSTI) for all Ports except the Port that invoked the procedure.
 */

static void setTcPropTree (STATE_MACH_T * this, char *reason)
 {    /* 17.19.14 */
  register XST_PORT_T *port = this->owner.port;
  register XST_PORT_T *tmp;
  int i;
  
#ifndef STRONGLY_SPEC_802_1S
  BITMAP_T ports_to_flush;

//  BitmapCopy (&ports_to_flush, port->owner->portmap);
  ports_to_flush.part0=0xFFFFffffL;
  BitmapClearBit (&ports_to_flush, port->port_index);
#endif

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    tmp = &(port->owner->ports[i]);
    if (tmp->port_index != port->port_index) 
     {
      tmp->tcProp = True;
     }
    else
     {
      tmp->tcProp = False;
     }
#ifndef STRONGLY_SPEC_802_1S
    if (tmp->operEdge) 
     {
      BitmapClearBit (&ports_to_flush, tmp->port_index);
     }
#endif
   }

#ifndef STRONGLY_SPEC_802_1S
  if (!BitmapIsZero (&ports_to_flush)) 
   {
#if 1
  //for speed up, not flush table //flash ???
    STP_OUT_flush_lt (&ports_to_flush, reason);
#endif
   }
#endif
 }
/* ----------------------------------------------------------------------------------------------*/
/*
 * This procedure sets the value of tcWhile, if and only if it is currently zero, to twice HelloTime on point-topoint
 * links (i.e., links where the operPointToPointMAC parameter is TRUE; see 6.4.3) where the partner
 * bridge port is RSTP capable, and to the sum of the Max Age and Forward Delay components of rootTimes
 * otherwise (non-RSTP capable partners or shared media). The value of HelloTime is taken from cistPort-
 * Times (13.24.9) for this Port.
 */

static unsigned int newTcWhile(STATE_MACH_T * this, char *reason)
 {    /* 17.19.7 */
  register XST_PORT_T *port = this->owner.port;
  register XST_T *cist;
  unsigned long newValue;

  cist=STP_xst_find(CIST_INSTANCE_ID);
  if (port->sendRSTP && port->operPointToPointMac) 
   {
    newValue = 2 * cist->ports[port->port_index].xstPortTimes.HelloTime;
   } 
  else 
   {
    newValue = port->owner->xstRootTimes.MaxAge + port->owner->xstRootTimes.ForwardDelay;
   }
  return newValue;
 }
/* ----------------------------------------------------------------------------------------------*/

void STP_topoch_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;
  register XST_T *cist=STP_xst_find(CIST_INSTANCE_ID);
  register XST_PORT_T *cist_port = &(cist->ports[port->port_index]);

#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: topoch state:%s xst %d port %d\n", GET_STATE_NAME(this->State),port->owner->xst_id,port->port_index);
#endif

  that=port->owner;
  switch (this->State) 
   {
    case BEGIN:
    case INIT:
#ifdef STRONGLY_SPEC_802_1S
              flush (this, "topoch INIT");
#endif
              port->tcWhile = 0;

              if(that->xst_id==CIST_INSTANCE_ID)
               port->tcAck = False;
              break;
    case INACTIVE:
              if(that->xst_id==CIST_INSTANCE_ID)
               port->rcvdTc = port->rcvdTcn = port->rcvdTcAck = False;
              port->rcvdTc = port->tcProp = False;
              break;
    case TCACTIVE:
              break;
    case DETECTED:
              if(port->tcWhile == 0)
               port->tcWhile = newTcWhile (this, "DETECTED");
              setTcPropTree (this, "DETECTED");
/* flash ? */              
              if(that->xst_id==CIST_INSTANCE_ID)
               cist_port->newInfoCist = True; 
              else
               cist_port->newInfoMsti = True; 
              break;
    case NOTIFIED_TC:
              if(that->xst_id==CIST_INSTANCE_ID)
               port->rcvdTcn = False;
              port->rcvdTc = False;
              if (that->xst_id==CIST_INSTANCE_ID && port->role==DesignatedPort) 
               {
                port->tcAck = True;
               }
              setTcPropTree (this, "NOTIFIED_TC");
              break;
    case PROPAGATING:
              if(port->tcWhile == 0)
               port->tcWhile = newTcWhile (this, "PROPAGATING");
#ifdef STRONGLY_SPEC_802_1S
              flush (this, "topoch PROPAGATING");
#endif
              port->tcProp = False;
/* flash ? */              
              if(that->xst_id==CIST_INSTANCE_ID)
               cist_port->newInfoCist = True; 
              else
               cist_port->newInfoMsti = True; 
              break;
    case ACKNOWLEDGED:
              port->tcWhile = 0;
              if(that->xst_id==CIST_INSTANCE_ID)
               port->rcvdTcAck = False;
              break;
    case NOTIFIED_TCN:
              if(port->tcWhile == 0)
               port->tcWhile = newTcWhile (this, "PROPAGATING");
              break;
    case TCFLUSH:
#ifndef STRONGLY_SPEC_802_1S
              flush (this, "TCFLUSH");
#endif
              break;
   };
 }
/* ----------------------------------------------------------------------------------------------*/
Bool STP_topoch_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;

#if 0
  printk(" chk state=%d ",this->State);
#endif
  that=port->owner;
  if (this->State == BEGIN) 
   {
    return STP_hop_2_state (this, INIT);
   }

  switch (this->State) 
   {
    case INIT:
              return STP_hop_2_state (this, INACTIVE);
    case INACTIVE:
              if (((port->role == RootPort) || (port->role == DesignatedPort) || (port->role == MasterPort)) && port->forward && !port->operEdge)
               return STP_hop_2_state (this, DETECTED);
              if (port->rcvdTc || ((that->xst_id==CIST_INSTANCE_ID) && port->rcvdTcn) || ((that->xst_id==CIST_INSTANCE_ID) && port->rcvdTcAck) || port->tcProp) 
               return STP_hop_2_state (this, INACTIVE);
              break;
    case TCACTIVE:
              if (port->role != RootPort && (port->role != DesignatedPort) && (port->role != MasterPort))
#ifdef STRONGLY_SPEC_802_1S
               return STP_hop_2_state (this, INIT);
#else
               return STP_hop_2_state (this, TCFLUSH);
#endif

              if ((that->xst_id==CIST_INSTANCE_ID) && port->rcvdTcn)
                return STP_hop_2_state (this, NOTIFIED_TCN);
              if (port->rcvdTc)
                return STP_hop_2_state (this, NOTIFIED_TC);
              if (port->tcProp)
                return STP_hop_2_state (this, PROPAGATING);
              if ((that->xst_id==CIST_INSTANCE_ID) && port->rcvdTcAck)
                return STP_hop_2_state (this, ACKNOWLEDGED);
              break;
    case DETECTED:
              return STP_hop_2_state (this, TCACTIVE);
    case NOTIFIED_TC:
              return STP_hop_2_state (this, TCACTIVE);
    case PROPAGATING:
              return STP_hop_2_state (this, TCACTIVE);
    case ACKNOWLEDGED:
              return STP_hop_2_state (this, TCACTIVE);
    case NOTIFIED_TCN:
              return STP_hop_2_state (this, NOTIFIED_TC);
    case TCFLUSH:
              return STP_hop_2_state (this, INIT);
  };
  return False;
 }
