/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* "Times" API : bridgeTime, rootTimes, portTimes, designatedTimes, msgTimes */

#include <asm/unaligned.h>

#include "mstp.h"
#include "base.h"

/*----------------------------------------------------------------------------------*/
int STP_compare_times (IN TIMEVALUES_T * t1, IN TIMEVALUES_T * t2)
{
  if (t1->MessageAge < t2->MessageAge)
    return -1;
  if (t1->MessageAge > t2->MessageAge)
    return 1;

  if (t1->MaxAge < t2->MaxAge)
    return -2;
  if (t1->MaxAge > t2->MaxAge)
    return 2;

  if (t1->ForwardDelay < t2->ForwardDelay)
    return -3;
  if (t1->ForwardDelay > t2->ForwardDelay)
    return 3;

  if (t1->HelloTime < t2->HelloTime)
    return -4;
  if (t1->HelloTime > t2->HelloTime)
    return 4;

  if (t1->remainingHops < t2->remainingHops)
    return -5;
  if (t1->remainingHops > t2->remainingHops)
    return 5;

  return 0;
}

/*----------------------------------------------------------------------------------*/
int STP_compare_msti_times (IN TIMEVALUES_T * t1, IN TIMEVALUES_T * t2)
{
  if (t1->MessageAge < t2->MessageAge)
    return -1;
  if (t1->MessageAge > t2->MessageAge)
    return 1;

  if (t1->MaxAge < t2->MaxAge)
    return -2;
  if (t1->MaxAge > t2->MaxAge)
    return 2;

  if (t1->ForwardDelay < t2->ForwardDelay)
    return -3;
  if (t1->ForwardDelay > t2->ForwardDelay)
    return 3;

  if (t1->HelloTime < t2->HelloTime)
    return -4;
  if (t1->HelloTime > t2->HelloTime)
    return 4;

  if (t1->remainingHops < t2->remainingHops)
    return -5;
  if (t1->remainingHops > t2->remainingHops)
    return 5;

  return 0;
}


/*----------------------------------------------------------------------------------*/
void STP_get_times (IN MSTP_BPDU_T * b, OUT TIMEVALUES_T * v)
{
#if 0
  v->MessageAge = ntohs (*((unsigned short *) b->message_age)) >> 8;
  v->MaxAge = ntohs (*((unsigned short *) b->max_age)) >> 8;
  v->ForwardDelay = ntohs (*((unsigned short *) b->forward_delay)) >> 8;
  v->HelloTime = ntohs (*((unsigned short *) b->hello_time)) >> 8;
#endif
  v->MessageAge = get_unaligned((unsigned short *) b->cist_body.message_age);
  v->MaxAge = get_unaligned((unsigned short *) b->cist_body.max_age);
  v->ForwardDelay = get_unaligned((unsigned short *) b->cist_body.forward_delay);
  v->HelloTime = get_unaligned((unsigned short *) b->cist_body.hello_time);
  v->remainingHops = (b->Cist_remainingHops)-1;
}

/*----------------------------------------------------------------------------------*/
void STP_get_msti_times (IN MSTP_BPDU_T * b, IN int msti, OUT TIMEVALUES_T * v)
{
  v->MessageAge = get_unaligned((unsigned short *) b->cist_body.message_age);
  v->MaxAge = get_unaligned((unsigned short *) b->cist_body.max_age);
  v->ForwardDelay = get_unaligned((unsigned short *) b->cist_body.forward_delay);
  v->HelloTime = get_unaligned((unsigned short *) b->cist_body.hello_time);
  v->remainingHops = b->msti_conf[msti].msti_remainingHops-1;
}

/*----------------------------------------------------------------------------------*/
void STP_set_times (IN TIMEVALUES_T * v, OUT MSTP_BPDU_T * b)
{
  unsigned short mt;
#define STP_SET_TIME(f, t)        \
     mt = htons (f << 8);           \
     memcpy (t, &mt, 2);

  STP_SET_TIME ((v->MessageAge), (b->cist_body.message_age));
  STP_SET_TIME ((v->MaxAge), (b->cist_body.max_age));
  STP_SET_TIME ((v->HelloTime), (b->cist_body.hello_time));
  STP_SET_TIME ((v->ForwardDelay), (b->cist_body.forward_delay));

  b->Cist_remainingHops=v->remainingHops;

#if 0
  mt=htons(v->MessageAge);
  memcpy((b->message_age),&mt,2);
  mt=htons(v->MaxAge);
  memcpy((b->max_age),&mt,2);
  mt=htons(v->ForwardDelay);
  memcpy((b->forward_delay),&mt,2);
  mt=htons(v->HelloTime);
  memcpy((b->hello_time),&mt,2);
#endif
}

/*----------------------------------------------------------------------------------*/
void STP_copy_times (OUT TIMEVALUES_T * t, IN TIMEVALUES_T * f)
 {
  t->MessageAge = f->MessageAge;
  t->MaxAge = f->MaxAge;
  t->ForwardDelay = f->ForwardDelay;
  t->HelloTime = f->HelloTime;
  t->remainingHops = f->remainingHops;
 }
