/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Port State Transition state machine : 17.24 */

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_to.h"

#define STATES { \
  CHOOSE(DISCARDING),   \
  CHOOSE(LEARNING), \
  CHOOSE(FORWARDING),   \
}

#define GET_STATE_NAME STP_sttrans_get_state_name
#include "choose.h"

extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;

#ifdef STRONGLY_SPEC_802_1S
static Bool disableLearning (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;

  that=port->owner;

  return STP_OUT_set_learning (that->xst_id, port->port_index, False);
 }

static Bool enableLearning (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;

  that=port->owner;

  return STP_OUT_set_learning (that->xst_id, port->port_index, True);
 }

static Bool disableForwarding (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;

  that=port->owner;

  return STP_OUT_set_forwarding (that->xst_id, port->port_index, False);
 }

static Bool enableForwarding (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;

  that=port->owner;

  return STP_OUT_set_forwarding (that->xst_id, port->port_index, True);
 }
#endif

void STP_sttrans_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that;
  that=port->owner;

#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: state trans state:%s inst %d port %d \n", GET_STATE_NAME(this->State),that->xst_id,port->port_index);
#endif 

  switch (this->State) 
   {
    case BEGIN:
#if 0
               port->learning = False;
               port->forwarding = False;
#ifdef STRONGLY_SPEC_802_1S
               disableLearning (this);
               disableForwarding (this);
#else
               STP_OUT_set_all_port_state (that->xst_id, UID_PORT_DISCARDING);
#endif
               break;
#endif
    case DISCARDING:
               port->learning = False;
               port->forwarding = False;
#ifdef STRONGLY_SPEC_802_1S
               disableLearning (this);
               disableForwarding (this);
#else
               STP_OUT_set_port_state (that->xst_id, port->port_index, UID_PORT_DISCARDING);
#endif
               break;
    case LEARNING:
               port->learning = True;
#ifdef STRONGLY_SPEC_802_1S
               enableLearning (this);
#else
               STP_OUT_set_port_state (that->xst_id, port->port_index, UID_PORT_LEARNING);
#endif
               break;
    case FORWARDING:
               port->forwarding = True;
#ifdef STRONGLY_SPEC_802_1S
               enableForwarding (this);
#else
               STP_OUT_set_port_state (that->xst_id, port->port_index, UID_PORT_FORWARDING);
#endif
               break;
   }

 }

Bool STP_sttrans_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;

  if (this->State == BEGIN ) 
   {
    return STP_hop_2_state (this, DISCARDING);
   }

  switch (this->State) 
   {
    case DISCARDING:
               if (port->learn) 
                {
                 return STP_hop_2_state (this, LEARNING);
                }
               break;
    case LEARNING:
               if (port->forward) 
                {
/*                  port->snmp_topo_change = !port->operEdge; */
                 return STP_hop_2_state (this, FORWARDING);
                }
               if (!port->learn) 
                {
                 return STP_hop_2_state (this, DISCARDING);
                }
               break;
    case FORWARDING:
               if (!port->forward) 
                {
/*                 port->snmp_topo_change = !port->operEdge; */
                 return STP_hop_2_state (this, DISCARDING);
                }
               break;
   }

  return False;
 }
