/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* This file contains prototypes for system dependent API
   from the RSTP to an operation system */
  
#ifndef _STP_OUT_H__
#define _STP_OUT_H__

int
STP_OUT_flush_lt (IN BITMAP_T* ports, IN char* reason);

int
STP_OUT_flush_single_lt (IN int port_index, char* reason);

void /* for bridge id calculation */
STP_OUT_get_port_mac (IN int port_index, OUT unsigned char* mac);

unsigned long
STP_OUT_get_port_oper_speed (IN unsigned int portNo);

int /* 1- Up, 0- Down */
STP_OUT_get_port_link_status (int xst_id, IN int port_index);

int /* 1- Full, 0- Half */
STP_OUT_get_duplex (IN int port_index);

#ifdef STRONGLY_SPEC_802_1W
int
STP_OUT_set_learning (IN int port_index, IN int enable);

int
STP_OUT_set_forwarding (IN int port_index, IN int enable);
#else
/*
 * In many kinds of hardware the state of ports may
 * be changed with another method
 */
int
STP_OUT_set_all_port_state (IN unsigned short instance, IN RSTP_PORT_STATE state);
int
STP_OUT_set_port_state (IN unsigned short instance, IN int port_index, IN RSTP_PORT_STATE state);
#endif

int
STP_OUT_set_hardware_mode (UID_STP_MODE_T mode);

int
STP_OUT_tx_bpdu (IN int port_index,
                 IN unsigned char* bpdu,
                 IN size_t bpdu_len);

int
STP_OUT_get_init_xst_cfg (IN int xst_id,
                           INOUT UID_STP_CFG_T* cfg);


int
STP_OUT_get_init_port_cfg (IN int xst_id,
                           IN int port_index,
                           INOUT UID_STP_PORT_CFG_T* cfg);

int
STP_OUT_trace_snmp_traps (Bool newValue);

int
STP_OUT_set_new_root_trap (IN int xst_id);

int
STP_OUT_set_topology_change_trap (IN int xst_id,
                                  IN int port_index,
                                  IN int forward);

void STP_OUT_psos_init_semaphore (void);
void STP_OUT_psos_close_semaphore (void);
void STP_OUT_psos_open_semaphore (void);

#endif /* _STP_OUT_H__ */

