/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 **********************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* This file contains system dependent API
   from the RStp to a operation system (see stp_to.h) */

/* stp_to API for Linux */

#include <stdarg.h>
#include <linux/spinlock.h>

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_in.h"
#include "stp_to.h"

#include "krnmac.h"
#include "krnport.h"
#include "krnstp.h"
#include "krntype.h"

static spinlock_t mstp_OUT_inner_sem;

extern TstLPortMask enabled_ports;
/*-----------------------------------------------------------------------------------*/
extern unsigned char mstp_bridge_mac[6];


#if 0
int STP_OUT_set_all_port_state (unsigned short instance, RSTP_PORT_STATE state)
 { 
  CCL_MSTP_SetAllPortState(instance, state);
  return STP_OK;
 }
#endif

/*-----------------------------------------------------------------------------------*/
/* 
 * In many kinds of hardware the state of ports may
 * be changed with another method
 */
int STP_OUT_set_port_state (IN unsigned short instance, IN int port_index, IN RSTP_PORT_STATE state)
 { 
     
  CCL_MSTP_SetPortState(instance, port_index, state);
  return STP_OK;
 }


/*-----------------------------------------------------------------------------------*/
void STP_OUT_get_port_mac (int port_index, unsigned char *mac)
 {
  memcpy (mac, mstp_bridge_mac, 6);
  /* by flash, add port_index to mac address */
  mac[5]+=(port_index+1);
 }

/*-----------------------------------------------------------------------------------*/
/* Only called from STP_xst_port_init() */
/* 1- Up, 0- Down */
int STP_OUT_get_port_link_status (int xst_id, int port_index)
 {
 Tuint8 new_link;

 if (!K_LPortMaskGetPort (&enabled_ports, (port_index)))
  return 0;
#if 0
 new_link = cclmx_PortGetLink (port_index);
 if(new_link != CCLMX_PORT_LINKUP)
 {
  return 0;
 }
#endif 

 if(mstp_check_vlan_member(xst_id, port_index)==False)
 {
  return 0;
 }

 return 1;
 }

/*-----------------------------------------------------------------------------------*/
int STP_OUT_flush_lt (IN BITMAP_T * port_map, char *reason)
{
	K_MacClrTbl(MAC_CLR_DYNMC);
	return STP_OK;
	//return AR_INT_STP_flush_lt (port_index);
}

/*-----------------------------------------------------------------------------------*/
int STP_OUT_flush_single_lt (IN int port_index, char *reason)
{
	BITMAP_T ports_to_flush;

	BitmapClear(&ports_to_flush);
	BitmapSetBit(&ports_to_flush, port_index);
	return STP_OUT_flush_lt(&ports_to_flush, reason);
}

/*-----------------------------------------------------------------------------------*/
int STP_OUT_set_hardware_mode (UID_STP_MODE_T mode)
 {
  if(mode == STP_DISABLED)
   {
    K_StpSetEbl(False);//disable BPDU forward to CPU
   }
  else if(mode == STP_ENABLED)
   {
    K_StpSetEbl(True);//enable BPDU forward to CPU
   } 

  return STP_OK;
 }


/*-----------------------------------------------------------------------------------*/
int STP_OUT_tx_bpdu (int port_index, unsigned char *bpdu, size_t bpdu_len)
 {
  extern int bridge_tx_bpdu (int port_index, unsigned char *bpdu, size_t bpdu_len);

  return bridge_tx_bpdu (port_index, bpdu, bpdu_len);
 }

/*-----------------------------------------------------------------------------------*/
const char *STP_OUT_get_port_name (IN int port_index)
 {
  static char tmp[7];
  sprintf (tmp, "port%02d", (int)port_index);
  return tmp;
 }

/*-----------------------------------------------------------------------------------*/
unsigned long STP_OUT_get_deafult_port_path_cost (IN unsigned int portNo)
 {
  return 20000;
 }

/*-----------------------------------------------------------------------------------*/
unsigned long STP_OUT_get_port_oper_speed (unsigned int port_index)
{
	Tuint8	ucSpeed;
	Tuint8	ucDuplex;

	cclmx_PortGetSpeedDuplex (port_index, &ucSpeed, &ucDuplex);
	switch (ucSpeed) {
	case CCLMX_PORT_SPEED_0:	return 0L;
	case CCLMX_PORT_SPEED_10:	return 10L;
	case CCLMX_PORT_SPEED_20:	return 20L;
	case CCLMX_PORT_SPEED_30:	return 30L;
	case CCLMX_PORT_SPEED_40:	return 40L;
	case CCLMX_PORT_SPEED_100:	return 100L;
	case CCLMX_PORT_SPEED_200:	return 200L;
	case CCLMX_PORT_SPEED_300:	return 300L;
	case CCLMX_PORT_SPEED_400:	return 400L;
	case CCLMX_PORT_SPEED_1000:	return 1000L;
	case CCLMX_PORT_SPEED_2000:	return 2000L;
	default:			return 100L;
	}

}

/*-----------------------------------------------------------------------------------*/
 /* 1- Full, 0- Half */
int STP_OUT_get_duplex (IN int port_index)
{
	Tuint8	ucSpeed;
	Tuint8	ucDuplex;

	K_PortGetSpeedDuplex(port_index, &ucSpeed, &ucDuplex);

	if (ucDuplex == PORT_DUPLEX_HALF) {
		return 0;
	}
	else {
		return 1;
	}
}

/*-----------------------------------------------------------------------------------*/
int STP_OUT_get_init_xst_cfg (IN int xst_id, INOUT UID_STP_CFG_T * cfg)
 {
  cfg->bridge_priority = DEF_BR_PRIO;
  cfg->max_age = DEF_BR_MAXAGE;
  cfg->hello_time = DEF_BR_HELLOT;
  cfg->forward_delay = DEF_BR_FWDELAY;
  cfg->force_version = DEF_FORCE_VERS;
  cfg->max_hop = DEF_BR_MAXHOP;
  cfg->revision = DEF_BR_REVISION;
  strcpy(cfg->name, "CCL");

  return STP_OK;
 }


/*-----------------------------------------------------------------------------------*/
int STP_OUT_get_init_port_cfg (int xst_id,int port_index, UID_STP_PORT_CFG_T * cfg)
 {
  cfg->port_priority = DEF_PORT_PRIO;
  cfg->admin_non_stp = DEF_ADMIN_NON_STP;
  cfg->admin_edge = DEF_ADMIN_EDGE;
  cfg->admin_port_path_cost = ADMIN_PORT_PATH_COST_AUTO;
  cfg->admin_point2point = DEF_P2P;

  return 0;
 }

/*-----------------------------------------------------------------------------------*/
static Bool trace_snmp_traps = False;

/*-----------------------------------------------------------------------------------*/
int STP_OUT_trace_snmp_traps (Bool newValue)
 {
  trace_snmp_traps = newValue;
  return 0;
 }

/*-----------------------------------------------------------------------------------*/
int STP_OUT_set_new_root_trap (IN int xst_id)
 {
  if (trace_snmp_traps);
  return 0;
 }

/*-----------------------------------------------------------------------------------*/
int STP_OUT_set_topology_change_trap (IN int xst_id,IN int port_index, IN int forward)
 {
  if (trace_snmp_traps);
   return 0;
 }

/*-----------------------------------------------------------------------------------*/
void STP_OUT_psos_init_semaphore (void)
 {
  spin_lock_init(&mstp_OUT_inner_sem);   
 }

/*-----------------------------------------------------------------------------------*/
void STP_OUT_psos_close_semaphore (void)
 {
  spin_lock(&mstp_OUT_inner_sem);
 }

/*-----------------------------------------------------------------------------------*/
void STP_OUT_psos_open_semaphore (void)
 {
  spin_unlock(&mstp_OUT_inner_sem);
 }


