/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

 /* This file contains prototypes for API from an operation
    system to the RSTP */
    
#ifndef _STP_API_H__
#define _STP_API_H__

/************************
 * Common base constants
 ************************/

#ifndef INOUT
#  define IN      /* consider as comments near 'input' parameters */
#  define OUT     /* consider as comments near 'output' parameters */
#  define INOUT   /* consider as comments near 'input/output' parameters */
#endif

#ifndef Zero
#  define Zero        0
#  define One         1
#endif

#ifndef Bool
#  define Bool        int
#  define False       0
#  define True        1
#endif

/********************************************
 * constants: default values and linitations
 *********************************************/
 
/* bridge configuration */

#define DEF_BR_PRIO 32768
#define MIN_BR_PRIO 0
#define MAX_BR_PRIO 61440
#define BR_PRIO_STEP 4096

#define DEF_BR_HELLOT   2
#define MIN_BR_HELLOT   1
#define MAX_BR_HELLOT   10

#define DEF_BR_MAXAGE   20
#define MIN_BR_MAXAGE   6
#define MAX_BR_MAXAGE   40

#define DEF_BR_FWDELAY  15
#define MIN_BR_FWDELAY  4
#define MAX_BR_FWDELAY  30

#define DEF_BR_MAXHOP  20
#define MIN_BR_MAXHOP  1
#define MAX_BR_MAXHOP  40

#define DEF_BR_REVISION  0
#define MIN_BR_REVISION  0
#define MAX_BR_REVISION  65535

#define DEF_FORCE_VERS  3 /* NORMAL_MSTP */

/* port configuration */

#define DEF_PORT_PRIO   128
#define MIN_PORT_PRIO   0
#define MAX_PORT_PRIO   240
#define PORT_PRIO_STEP  16
 
#define MAX_ADMIN_PORT_PATH_COST        200000000L

#define DEF_ADMIN_NON_STP   False
#define DEF_ADMIN_EDGE      False
#define DEF_LINK_DELAY      3 /* see edge.c */
#define DEF_P2P         P2P_AUTO

/* Section 1: Create/Delete/Start/Stop the RSTP instance */

/* init the engine */
void STP_IN_init ();

int STP_IN_xst_create (int xst_id, char* name);

int
STP_IN_xst_delete (int xst_id);

int
STP_IN_stop_all (void);

int
STP_IN_delete_all (void);

/* Section 2. "Get" management */

Bool STP_IN_get_is_xst_enabled (int xst_id);

const char*
STP_IN_get_error_explanation (int rstp_err_no);

#ifdef _UID_STP_H__
int STP_IN_get_mstp_info (SMstpInfo * info);
int STP_IN_get_port_info (SMstpPortInfo * info);
int STP_IN_get_inst_info (SMstpInstInfo * info);
int STP_IN_get_instport_info (SMstpInstPortInfo * info);
#endif

/* Section 3. "Set" management */

int
STP_IN_xst_set_cfg (int xst_id, UID_STP_CFG_T* uid_cfg);

int
STP_IN_set_port_cfg (int xst_id, UID_STP_PORT_CFG_T* uid_cfg);


/* Section 4. RSTP functionality events */

int 
STP_IN_one_second (void);

int /* for Link UP/DOWN */
STP_IN_enable_port (int port_index, Bool enable);

int /* call it, when port speed has been changed, speed in Kb/s  */
STP_IN_changed_port_speed (int port_index, long speed);

int /* call it, when current port duplex mode has been changed  */
STP_IN_changed_port_duplex (int port_index);

#ifdef _STP_BPDU_H__
int
STP_IN_check_bpdu_header (MSTP_BPDU_T* bpdu, size_t len);

int
STP_IN_rx_bpdu (int port_index, MSTP_BPDU_T* bpdu, size_t len);
#endif

#ifdef XST_H
/* Inner usage definitions & functions */

extern int max_port;

#define MSTP_INIT_CRITICAL_PATH_PROTECTIO STP_OUT_psos_init_semaphore()
#define MSTP_CRITICAL_PATH_START          STP_OUT_psos_close_semaphore()
#define MSTP_CRITICAL_PATH_END            STP_OUT_psos_open_semaphore()
extern void STP_OUT_psos_init_semaphore (void);
extern void STP_OUT_psos_close_semaphore (void);
extern void STP_OUT_psos_open_semaphore (void);

int STP_IN_refersh();
int stp_in_xst_enable (int xst_id, char* name,UID_STP_MODE_T admin_state);
void* stp_in_xst_create (int xst_id, int* err_code);
                          

#endif /* XST_H */


#endif /* _STP_API_H__ */
