/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Port Role Selection state machine : 17.22 */

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "xst_port.h"
#include "vector.h"

#define STATES \
 { \
  CHOOSE(INIT_BRIDGE),      \
  CHOOSE(RECEIVE),   \
 }

#define GET_STATE_NAME STP_rolesel_get_state_name
#include "choose.h"


extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;
/* ----------------------------------------------------------------------------------------------*/
Bool STP_rolesel_update_root_priority (XST_T * this)
 {
  register XST_PORT_T *port;
  Bool bret = False;
  int i;

  if(this->valid == False)
   return False;
  if(this->admin_state == STP_DISABLED)
   return False;

  if(this->xst_id == CIST_INSTANCE_ID)
   {
    STP_VECT_create (&this->xstRootPriority, &this->BridgeIdentifier, 0, &this->BridgeIdentifier, 0,&this->BridgeIdentifier, 0, 0);


    for(i=0;i<MAX_LOGIC_PORT;i++)
     {
      port=&(this->ports[i]);
      if (port->admin_non_stp)
        continue;

      if (port->infoIs != Received && port->infoIs != Mine)
        continue;
      STP_VECT_create (&port->xstPortPriority, &this->xstRootPriority.root_bridge, this->xstRootPriority.extern_path_cost, &this->xstRootPriority.region_root_bridge, this->xstRootPriority.intern_path_cost,&this->BridgeIdentifier, port->portId, port->portId);
      bret = True;

     }
   }
  else
   {
    STP_VECT_create (&this->xstRootPriority, 0, 0, &this->BridgeIdentifier, 0,&this->BridgeIdentifier, 0, 0);

    for(i=0;i<MAX_LOGIC_PORT;i++)
     {
      port=&(this->ports[i]);
      if (port->admin_non_stp)
        continue;

      if (port->infoIs != Received && port->infoIs != Mine)
        continue;
      STP_VECT_create (&port->xstPortPriority, 0, 0, &this->xstRootPriority.region_root_bridge, this->xstRootPriority.intern_path_cost,&this->BridgeIdentifier, port->portId, port->portId);
      bret = True;

     }
   }
  return bret;
 }

/* ----------------------------------------------------------------------------------------------*/
static void updtRoleDisableTree (XST_T * this)
 {    /* 17.10.20 */
  register int i;

  for (i=0;i<MAX_LOGIC_PORT;i++) 
   {
#ifdef STP_DBG1
//  printk("state:set selectedRole to disabledport %d \n", i);
#endif
    this->ports[i].selectedRole = DisabledPort;
   }
 }

/* ----------------------------------------------------------------------------------------------*/
static void clearReselectTree (XST_T * this)
 {    /* 17.19.1 */
  register int i;

  for (i=0;i<MAX_LOGIC_PORT;i++) 
   {
    this->ports[i].reselect = False;
   }
 }

/* ----------------------------------------------------------------------------------------------*/
#if 0
static const char *getRoleName (PORT_ROLE_T role)
 {
  switch (role) 
   {
    case DisabledPort:
     return "Disabled";
     break;
    case AlternatePort:
     return "Alternate";
     break;
    case BackupPort:
     return "Backup";
     break;
    case RootPort:
     return "Root";
     break;
    case DesignatedPort:
     return "Designated";
     break;
    case MasterPort:
     return "Master";
     break;
    case NonStpPort:
     return "NonStp";
     break;
    default:
     stp_trace ("Can't get role name %d", (int) role);
     return "???";
   }
 }
#endif
/* ----------------------------------------------------------------------------------------------*/



/* ----------------------------------------------------------------------------------------------*/
static Bool _is_backup_port (XST_PORT_T * port, XST_T *this)
 {

  if (!STP_VECT_compare_bridge_id(&port->xstPortPriority.design_bridge, &this->BridgeIdentifier))
   {
    return True;
   } 
  else 
   {
    return False;
   }
 }

/* ----------------------------------------------------------------------------------------------*/
static void setRoleSelected (char *reason, XST_PORT_T * port, PORT_ROLE_T newRole)
 {
  if (newRole == port->selectedRole && NonStpPort != newRole)
    return;

#if 0
if(mstp_debug)
 printk(" setRoleSelected newRole %d port %d\n",newRole, port->port_index);
#endif

  port->selectedRole = newRole;

  if (newRole == NonStpPort)
   port->role = newRole;
 }

/* ----------------------------------------------------------------------------------------------*/
static void updtRootPrio (STATE_MACH_T * this)
{
  PRIO_VECTOR_T rootPathPrio; /* 17.4.2.2 */
  register XST_PORT_T *port;
  register XST_T *that;
  register unsigned int dm;
  int cmp;
  int i;

  that = this->owner.xst;

  for (i=0;i<MAX_LOGIC_PORT;i++) 
   {
    port=&(that->ports[i]);
    if (port->admin_non_stp) 
     {
      continue;
     }

    if (port->infoIs == Disabled) 
     {
      continue;
     }
    if (port->infoIs == Aged) 
     {
      continue;
     }
    if (port->infoIs == Mine) 
     {
      continue;
     }

#ifdef STP_DBG1
#if 0
    printk(" updtRootPrio %d ", port->port_index);
    STP_VECT_br_id_print("design", &port->xstPortPriority.design_bridge,False);
    STP_VECT_br_id_print("bridgeId", &that->BridgeIdentifier,True);
#endif
#endif
//by flash, 2005/03/23
#if 1
    if (!STP_VECT_compare_bridge_id (&port->xstPortPriority.design_bridge, &that->BridgeIdentifier)) 
     {
      continue;
     }
#endif

    STP_VECT_copy (&rootPathPrio, &port->xstPortPriority);

#ifdef STP_DBG1
//    printk(" root inter %d   port inter %d operpcost %d\n", rootPathPrio.intern_path_cost, that->xstRootPriority.intern_path_cost,port->operPCost);
#endif

  if(that->xst_id == 0)  //cist
//     if(port->msgMSTConfId_match==False) //not in region
    if(port->infoInternal == False) //??
     rootPathPrio.extern_path_cost += port->operExtPCost;
    
    rootPathPrio.intern_path_cost += port->operIntPCost;

#ifdef STP_DBG3
if(mstp_debug)
 printk(" extern pcost %d operextpcost %d   intern pcost %d  operintpcost %d\n",rootPathPrio.extern_path_cost, port->operExtPCost,rootPathPrio.intern_path_cost, port->operIntPCost);
#endif


#if 0

#define PR_MAC(mac) mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]

if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
{
        printk("*********************xst %d port %d\n      rootPathPrio: root Bridge ID %04X %02X%02X%02X%02X%02X%02X\n xstRootPriority :%04X %02X%02X%02X%02X%02X%02X \n",that->xst_id,port->port_index,rootPathPrio.root_bridge.prio,PR_MAC(rootPathPrio.root_bridge.addr),that->xstRootPriority.root_bridge.prio,PR_MAC(that->xstRootPriority.root_bridge.addr));
        printk("      rootPathPrio: region root Bridge ID :%04X %02X%02X%02X%02X%02X%02X\n xstRootPriority port:%04X %02X%02X%02X%02X%02X%02X \n",rootPathPrio.region_root_bridge.prio,PR_MAC(rootPathPrio.region_root_bridge.addr),that->xstRootPriority.region_root_bridge.prio,PR_MAC(that->xstRootPriority.region_root_bridge.addr));
        printk("      rootPathPrio: design Bridge ID :%04X %02X%02X%02X%02X%02X%02X\n  xstRootPriority port:%04X %02X%02X%02X%02X%02X%02X \n   rootPathPrio:design port:%04X xstRootPrio:design port:%04X\n",rootPathPrio.design_bridge.prio,PR_MAC(rootPathPrio.design_bridge.addr),that->xstRootPriority.design_bridge.prio,PR_MAC(that->xstRootPriority.design_bridge.addr),rootPathPrio.design_port, that->xstRootPriority.design_port);
        printk("     extern path rootPathPrio:%d xstRootPrio:%d\n intern path rootPathPrio: %d xstRootPrio:%d\n ",rootPathPrio.extern_path_cost,that->xstRootPriority.extern_path_cost,rootPathPrio.intern_path_cost,that->xstRootPriority.intern_path_cost);

}
#endif

    if(that->xst_id == 0)  //cist
     {
      cmp = STP_VECT_compare_vector(&rootPathPrio, &that->xstRootPriority, True, (port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)));
     }
    else
     {
      cmp = STP_VECT_compare_msti_vector (&rootPathPrio, &that->xstRootPriority, True);
//      printk(" msti %d cmp %d \n",that->xst_id,cmp);
#ifdef STP_DBG1
#if 0
    printk(" root port rcv %d port rcv %d \n", rootPathPrio.rcv_port, that->xstRootPriority.rcv_port);
#endif
#endif
     }

    if (cmp < 0) 
     {
      STP_VECT_copy (&that->xstRootPriority, &rootPathPrio);
      STP_copy_times (&that->xstRootTimes, &port->xstPortTimes);
      dm = (that->xstRootTimes.MaxAge + 8) / 16;
      if (!dm)
       dm = 1;
      that->xstRootTimes.MessageAge += dm;
     }
   }
 }

/* ----------------------------------------------------------------------------------------------*/
/*
 * This procedure calculates the following CIST Spanning Tree priority vectors (13.9, 13.10) and timer values:
 * a) The root path priority vector for each Bridge Port that is not Disabled and has a port priority vector
 * (cistPortPriority plus portIdXsee 13.24.8 and 13.24.21) that has been recorded from a received message
 * and not aged out (infoIs == Received); and
 * b) The Bridges root priority vector (cistRootPortId, cistRootPriorityX13.23.5, 13.23.6), chosen as the
 * best of the CIST Spanning Tree priority vectors comprising the Bridges own bridge priority vector
 * (CistBridgePriorityX13.23.3) plus all the calculated root path priority vectors whose Designated-
 * BridgeID component is not equal to the DesignatedBridgeID component of the Bridges own bridge
 * priority vector (13.10); and
 * c) The Bridges root times, (cistRootTimesX13.23.7), determined as follows:
 * 1) If the chosen root priority vector is the bridge priority vector, root times is equal to CistBridge-
 * Times (13.23.4).
 * 2) If the chosen root priority vector is not the bridge priority vector, root times is equal to the value
 * of cistPortTimes (13.24.9) for the port associated with the chosen root priority vector.
 * d) The designated priority vector (cistDesignatedPriorityX13.24.4) for each port; and
 * e) The designated times for each Port (cistDesignatedTimesX13.24.5) set equal to the value of root
 * times.
 * The CIST port role for each Port is assigned, and its port priority vector and Spanning Tree timer information
 * are updated as follows:
 * f) If the Port is Disabled (infoIs = Disabled), selectedRole is set to DisabledPort. Otherwise:
 * g) If the port priority vector information was aged (infoIs = Aged), updtInfo is set and selectedRole is
 * set to DesignatedPort;
 * h) If the port priority vector was derived from another port on the Bridge or from the Bridge itself as
 * the Root Bridge (infoIs = Mine), selectedRole is set to DesignatedPort. Additionally, updtInfo is set
 * if the port priority vector differs from the designated priority vector or the Ports associated timer
 * parameters differ from those for the Root Port;
 * i) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), and the root priority vector is now derived from it, selectedRole is set to RootPort and
 * updtInfo is reset;
 * j) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is not
 * better than the port priority vector, and the designated bridge and designated port components of the
 * port priority vector do not reflect another port on this bridge, selectedRole is set to AlternatePort and
 * updtInfo is reset;
 * k) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is not
 * better than the port priority vector, and the designated bridge and designated port components of the
 * port priority vector reflect another port on this bridge, selectedRole is set to BackupPort and
 * updtInfo is reset.
 * l) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is better
 * than the port priority vector, selectedRole is set to DesignatedPort and updtInfo is set.
 * NOTEXThe port role assignment is almost identical to that in 17.19.8 of IEEE Std 802.1D, 1998 Edition, with the addition
 * of the final bullet, erroneously omitted from that specification.
 */
void updtRolesCist (STATE_MACH_T * this)
 {    /* 17.19.21 */
  register XST_PORT_T *port;
  register XST_T *that;
  int i;
  PORT_ID old_root_port; /* for tracing of root port changing */

  that = this->owner.xst;
  old_root_port = that->xstRootPortId;

  STP_VECT_create (&that->xstRootPriority, &that->BridgeIdentifier, 0, &that->BridgeIdentifier, 0, &that->BridgeIdentifier, 0, 0);

  STP_copy_times (&that->xstRootTimes, &that->xstBridgeTimes);

  that->xstRootPortId = 0;

/* a) cistPortPriority + portId*/
/* b) cistRootPriority + cistRootPortId*/
/* c) cistRootTimes*/
  updtRootPrio (this);

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    port=&(that->ports[i]);
    if (port->admin_non_stp) 
     {
      continue;
     }

/* d) */
    STP_VECT_create (&port->xstDesignatedPriority, &that->xstRootPriority.root_bridge, that->xstRootPriority.extern_path_cost, &that->xstRootPriority.region_root_bridge, that->xstRootPriority.intern_path_cost, &that->BridgeIdentifier, port->portId, port->portId);
/* e) */
    STP_copy_times (&port->xstDesignatedTimes, &that->xstRootTimes);
   }

  that->xstRootPortId = that->xstRootPriority.rcv_port;

  if (old_root_port != that->xstRootPortId) 
   {
    if (!that->xstRootPortId) 
     {
      that->newRoot = True;
     } 
    else 
     {
      that->newRoot = False;
     }
   }

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    port=&(that->ports[i]);
    if (port->admin_non_stp) 
     {
#ifdef STP_DBG1
      printk("non STP port %d\n",i);
#endif
      setRoleSelected ("Non", port, NonStpPort);

      port->cistDesignatedPort=False;
      port->cistRootPort=False;

      port->forward = port->learn = True;

      continue;
     }

#if 0
if(mstp_debug)
 printk(" CIST infoIs %d xst %d port %d\n",port->infoIs,that->xst_id,port->port_index);
#endif

    switch (port->infoIs) 
     {
/* f) */
      case Disabled:
       setRoleSelected ("Dis", port, DisabledPort);

       port->cistDesignatedPort=False;
       port->cistRootPort=False;

       break;
/* g) */
      case Aged:
       setRoleSelected ("Age", port, DesignatedPort);

       port->cistDesignatedPort=True;
       port->cistRootPort=False;

       port->updtInfo = True;
       break;
/* h) */
      case Mine:
       setRoleSelected ("Mine", port, DesignatedPort);

       port->cistDesignatedPort=True;
       port->cistRootPort=False;

       if (STP_VECT_compare_vector (&port->xstPortPriority, &port->xstDesignatedPriority, True, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) !=0 || STP_compare_times (&port->xstPortTimes, &port->xstDesignatedTimes) !=0) 
        {
         port->updtInfo = True;
        }
       break;
      case Received:
#ifdef STP_DBG1
//         printk(" cist %d %d xstRoot %04X %04X\n",that->xst_id, port->port_index,that->xstRootPortId,port->portId);
#endif
       if ((that->xstRootPortId & 0xff) == (port->portId & 0xff)) 
        {
/* i) */
         setRoleSelected ("Rcv", port, RootPort);

         port->cistDesignatedPort=False;
         port->cistRootPort=True;

        } 
       else if (STP_VECT_compare_vector (&(port->xstDesignatedPriority), &(port->xstPortPriority), True, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) < 0)
        {
#ifdef STP_DBG1
// printk("   %08X %08X   %08X %08X\n",&(port->xstDesignatedPriority),&(port->xstDesignatedPriority.region_root_bridge),&(port->xstPortPriority),&(port->xstPortPriority.region_root_bridge));
//if(port->port_index >=15 && port->port_index <=16)
//         printk(" cist %d %d Designate %s \n ",that->xst_id, port->port_index,STP_VECT_sprint(&(port->xstDesignatedPriority)));
//         printk(" Port %s\n",STP_VECT_sprint(&(port->xstPortPriority)));
#endif
/* l) */
 /* Note: this important piece has been inserted after
  * discussion with Mick Sieman and reading 802.1y Z1 */
         setRoleSelected ("Rcv", port, DesignatedPort);

         port->cistDesignatedPort=True;
         port->cistRootPort=False;

         port->updtInfo = True;
         break;
        } 
       else 
        {
         if (_is_backup_port (port, that)) 
          {
/* k) */
           setRoleSelected ("Rcv", port, BackupPort);

           port->cistDesignatedPort=False;
           port->cistRootPort=False;

          } 
         else 
          {
/* j) */
           setRoleSelected ("Rcv", port, AlternatePort);

           port->cistDesignatedPort=False;
           port->cistRootPort=False;

          }
        }
       port->updtInfo = False;
       break;
      default:
       break;
     }
   }

 }

/* ----------------------------------------------------------------------------------------------*/
/*
 * This procedure calculates the following MST Spanning Tree priority vectors (13.9, 13.11) and timer values
 * for an MSTI:
 * a) The root path priority vector for each Bridge Port that is not Disabled and has a port priority vector
 * (mstiPortPriority plus portIdXsee 13.24.17 and 13.24.21) that has been recorded from a received
 * message and not aged out (infoIs == Received); and
 * b) The Bridges root priority vector (mstiRootPortId, mstiRootPriorityX13.23.11, 13.23.12), chosen as
 * the best of the MSTI Spanning Tree priority vectors for this MSTI comprising the Bridges own
 * bridge priority vector (MstiBridgePriorityX13.23.9) plus all the calculated root path priority vectors
 * whose DesignatedBridgeID component is not equal to the DesignatedBridgeID component of the
 * Bridges own bridge priority vector (13.11); and
 * c) The Bridges root times, (mstiRootTimesX13.23.13), determined as follows:
 * 1) If the chosen root priority vector is the bridge priority vector, root times is equal to MstiBridge-
 * Times (13.23.10).
 * 2) If the chosen root priority vector is not the bridge priority vector, root times is equal to the value
 * of mstiPortTimes (13.24.18) for the port associated with the chosen root priority vector.
 * d) The designated priority vector (mstiDesignatedPriorityX13.24.11) for each port; and
 * e) The designated times for each Port (mstiDesignatedTimesX13.24.12) set equal to the value of root
 * times.
 * The MSTI port role for each Port is assigned, and its port priority vector and Spanning Tree timer information
 * are updated as follows:
 * f) If the Port is Disabled (infoIs = Disabled), selectedRole is set to DisabledPort;
 * g) If the Port is not Disabled, the selected CIST Port Role (calculated prior to invoking this procedure)
 * is RootPort, and the CIST port priority information was received from a Bridge external to the MST
 * Region (infoIs == Received and infoInternal == FALSE), selectedRole is set to MasterPort. Additionally,
 * updtInfo is set if the MSTI port priority vector differs from the designated priority vector or
 * the Ports associated timer parameters differ from those for the Root Port;
 * h) If the Port is not Disabled, the selected CIST Port Role (calculated prior to invoking this procedure)
 * is AlternatePort, and the CIST port priority information was received from a Bridge external to the
 * MST Region (infoIs == Received and infoInternal == FALSE), selectedRole is set to AlternatePort.
 * Additionally, updtInfo is set if the MSTI port priority vector differs from the designated priority vector
 * or the Ports associated timer parameters differ from those for the Root Port.
 * Otherwise, if the Port is not Disabled and the CIST port priority information was not received from a Bridge
 * external to the Region (infoIs != Received or infoInternal == TRUE):
 * i) If the port priority vector information was aged (infoIs = Aged), updtInfo is set and selectedRole is
 * set to DesignatedPort;
 * j) If the port priority vector was derived from another port on the Bridge or from the Bridge itself as
 * the Root Bridge (infoIs = Mine), selectedRole is set to DesignatedPort. Additionally, updtInfo is set
 * if the port priority vector differs from the designated priority vector or the Ports associated timer
 * parameters differ from those for the Root Port;
 * k) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), and the root priority vector is now derived from it, selectedRole is set to RootPort and
 * updtInfo is reset;
 * l) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is not
 * better than the port priority vector, and the designated bridge and designated port components of the
 * port priority vector do not reflect another port on this bridge, selectedRole is set to AlternatePort and
 * updtInfo is reset;
 * m) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is not
 * better than the port priority vector, and the designated bridge and designated port components of the
 * port priority vector reflect another port on this bridge, selectedRole is set to BackupPort and
 * updtInfo is reset.
 * n) If the port priority vector was received in a Configuration Message and is not aged (infoIs ==
 * Received), the root priority vector is not now derived from it, the designated priority vector is better
 * than the port priority vector, selectedRole is set to DesignatedPort and updtInfo is set.
 */

void updtRolesMsti (STATE_MACH_T * this)
 {    /* 17.19.21 */
  register XST_PORT_T *port, *cist_port;
  register XST_T *that,*cist;
  int i;
  PORT_ID old_root_port; /* for tracing of root port changing */
 
  cist=STP_xst_find(CIST_INSTANCE_ID);
  that = this->owner.xst;
  old_root_port = that->xstRootPortId;

 
  STP_VECT_create (&that->xstRootPriority, &that->BridgeIdentifier, 0, &that->BridgeIdentifier, 0, &that->BridgeIdentifier, 0, 0);

  STP_copy_times (&that->xstRootTimes, &that->xstBridgeTimes);

  that->xstRootPortId = 0;

/* b) */
/* c) */
  updtRootPrio (this);

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    port=&(that->ports[i]);
    if (port->admin_non_stp) 
     {
      continue;
     }

/* d) */
#ifdef STP_DBG1
//    printk(" msti update desig %d \n", that->xstRootPriority.intern_path_cost);
#endif
    STP_VECT_create (&port->xstDesignatedPriority, &that->xstRootPriority.root_bridge, that->xstRootPriority.extern_path_cost, &that->xstRootPriority.region_root_bridge, that->xstRootPriority.intern_path_cost, &that->BridgeIdentifier, port->portId, port->portId);
/* e) */
    STP_copy_times (&port->xstDesignatedTimes, &that->xstRootTimes);
   }

  that->xstRootPortId = that->xstRootPriority.rcv_port;

//  printk("root port  old:%d  new:%d\n",old_root_port, that->xstRootPortId);

  if (old_root_port != that->xstRootPortId) 
   {
    if (!that->xstRootPortId) 
     {
      that->newRoot = True;
     } 
    else 
     {
      that->newRoot = False;
     }
   }


  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    cist_port=&(cist->ports[i]);
    port=&(that->ports[i]);

    if (port->admin_non_stp) 
     {
#ifdef STP_DBG1
      printk("non STP port %d\n",i);
#endif
      setRoleSelected ("Non", port, NonStpPort);

      port->mstiDesignatedPort=False;
      port->mstiRootPort=False;

      port->forward = port->learn = True;

      continue;
     }
#ifdef STP_DBG1
if(port->port_index >=15 && port->port_index <=16)
 printk(" MSTI infoIs %d %d %d\n",port->infoIs,that->xst_id,port->port_index);
#endif

    switch (port->infoIs) 
     {
/* f) */
      case Disabled:

       setRoleSelected ("Dis", port, DisabledPort);

       port->mstiDesignatedPort=False;
       port->mstiRootPort=False;

       break;
/* i) */
      case Aged:

       setRoleSelected ("Age", port, DesignatedPort);

       port->mstiDesignatedPort=True;
       port->mstiRootPort=False;

       port->updtInfo = True;
       break;
/* j) */
      case Mine:

       setRoleSelected ("Mine", port, DesignatedPort);

       port->mstiDesignatedPort=True;
       port->mstiRootPort=False;

       if (STP_VECT_compare_msti_vector (&(port->xstPortPriority), &(port->xstDesignatedPriority), True) !=0 || STP_compare_times (&port->xstPortTimes, &port->xstDesignatedTimes) !=0) 
        {
         port->updtInfo = True;
        }
       break;
      case Received:
//       printk(" info is receive %d info internal %d\n",port->port_index, cist_port->infoInternal);
       if(cist_port->infoInternal == False)
        {
#if 0
        if(port->port_index == 4 || port->port_index == 6)
         printk("msti %d port %d reselect %d \n",that->xst_id, port->port_index, cist_port->selectedRole); 
#endif
         if(cist_port->selectedRole == RootPort)
          {
/* g) */
           setRoleSelected ("Rcv", port, MasterPort);
#ifdef STP_DBG1
//printk(" Master Port %d %d\n",that->xst_id,port->port_index);
#endif
           that->mstiMaster=True;
           port->mstiDesignatedPort=False;
           port->mstiRootPort=True;


           if (STP_VECT_compare_msti_vector (&(port->xstPortPriority), &(port->xstDesignatedPriority), True) !=0 || STP_compare_times (&port->xstPortTimes, &port->xstDesignatedTimes) !=0) 
            {
             port->updtInfo = True;
             break;
            }
          }
         else if(cist_port->selectedRole == AlternatePort)
          {
/* h) */
    if(port->selectedRole == MasterPort) 
     that->mstiMaster=False;

           setRoleSelected ("Rcv", port, AlternatePort);

           port->mstiDesignatedPort=False;
           port->mstiRootPort=False;


           if (STP_VECT_compare_msti_vector (&(port->xstPortPriority), &(port->xstDesignatedPriority), True) !=0 || STP_compare_times (&port->xstPortTimes, &port->xstDesignatedTimes) !=0) 
            {
             port->updtInfo = True;
             break;
            }
          }
        }
       else
        {
    if(port->selectedRole == MasterPort) 
     that->mstiMaster=False;
#ifdef STP_DBG1
//         printk(" internal %d %d xstRoot %04X %04X\n",that->xst_id, port->port_index,that->xstRootPortId,port->portId);
#endif
#ifdef STP_DBG1
if(port->port_index >=15 && port->port_index <=16)
{
         printk(" msti %d %d Designate %s \n ",that->xst_id, port->port_index,STP_VECT_sprint(&(port->xstDesignatedPriority)));
         printk(" Port %s\n",STP_VECT_sprint(&(port->xstPortPriority)));
}
#endif
/* k) */
//     printk(" xstRootPortId %d portId %d \n",that->xstRootPortId, port->portId);
#if 0
     printk(" msti %d port %d Designate %s \n ",that->xst_id, port->port_index,STP_VECT_sprint(&(port->xstDesignatedPriority)));
     printk("               port  %s \n ",STP_VECT_sprint(&(port->xstPortPriority)));
#endif
         if ((that->xstRootPortId & 0xff) == (port->portId & 0xff)) 
          {
//  printk("root port is %d  \n", that->xstRootPortId);
           setRoleSelected ("Rcv", port, RootPort);

           port->mstiDesignatedPort=False;
           port->mstiRootPort=True;

          } 
         else if (STP_VECT_compare_msti_vector (&(port->xstDesignatedPriority), &(port->xstPortPriority), True) < 0)
          {
/* n) */
 /* Note: this important piece has been inserted after
  * discussion with Mick Sieman and reading 802.1y Z1 */
           setRoleSelected ("Rcv", port, DesignatedPort);

           port->mstiDesignatedPort=True;
           port->mstiRootPort=False;

           port->updtInfo = True;
           break;
          } 
         else 
          {
           if (_is_backup_port (port, that)) 
            {
#ifdef STP_DBG1
//         printk(" backup port\n");
#endif
/* m) */
             setRoleSelected ("Rcv", port, BackupPort);

             port->mstiDesignatedPort=False;
             port->mstiRootPort=False;

            } 
           else 
            {
#ifdef STP_DBG1
//         printk(" alternate port\n");
#endif
/* l) */
             setRoleSelected ("Rcv", port, AlternatePort);

             port->mstiDesignatedPort=False;
             port->mstiRootPort=False;

            }
          }
        }
       port->updtInfo = False;
       break;
      default:
       break;
     }
   }

 }


/* ----------------------------------------------------------------------------------------------*/
/*
 * Sets selected TRUE for this tree (the CIST or a given MSTI) for all Ports of the Bridge.
 */

static Bool setSelectedTree (XST_T * this)
{
  register XST_PORT_T *port;
  int i;

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    port=&(this->ports[i]);
    if (port->reselect) 
     {
      return False;
     }
   }

  for(i=0;i<MAX_LOGIC_PORT;i++)
   {
    port=&(this->ports[i]);
    port->selected = True;
   }

  return True;
 }

/* ----------------------------------------------------------------------------------------------*/
void STP_rolesel_enter_state (STATE_MACH_T * this)
 {
  XST_T *that;

  that = this->owner.xst;
#ifdef STP_DBG2
if(mstp_debug)
  printk(" STATE MACHINE : role sel xst %d state:%s $$$$$$$$$$$$$$$$$$$$$$$$\n", that->xst_id, GET_STATE_NAME(this->State));
#endif
  switch (this->State) 
   {
    case BEGIN:
    case INIT_BRIDGE:
     updtRoleDisableTree (that);
     break;
    case RECEIVE:
     clearReselectTree (that);
     if(that->xst_id==CIST_INSTANCE_ID)
     {
      updtRolesCist (this);

//      updtRolesMsti (this);
     }
     else
     {
      updtRolesMsti (this);
     }
     setSelectedTree (that);
     break;
   }
 }

/* ----------------------------------------------------------------------------------------------*/
Bool STP_rolesel_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port;
  XST_T *that;
  int i;

  that = this->owner.xst;

  if (this->State == BEGIN) 
   {
    STP_hop_2_state (this, INIT_BRIDGE);
   }

  switch (this->State) 
   {
    case BEGIN:
     return STP_hop_2_state (this, INIT_BRIDGE);
    case INIT_BRIDGE:
     return STP_hop_2_state (this, RECEIVE);
    case RECEIVE:
     for(i=0;i<MAX_LOGIC_PORT;i++)
      {
       port=&(that->ports[i]);

       if (port->reselect) 
        {
#ifdef STP_DBG1
//     printk("  rolesel RECEIVE %d %d\n",that->xst_id, port->port_index);
#endif
         return STP_hop_2_state (this, RECEIVE);
        }
      }
     break;
   }

  return False;
 }
