/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
 /************************************************************************ 
 * $Log: portrcv.c,v $
 * Revision 1.1.1.1  2009/02/17 09:44:45  anderson
 * RTL8196B source code
 *
 * Revision 1.1  2007/08/23 02:34:37  michael
 * Bug: 623
 * linux-2.6.19 fix
 *
 * Revision 1.44  2005/06/02 10:09:15  flash
 * Bug: 560
 * fix InfoIs while in RSTP/STP mode
 *
 * Revision 1.43  2005/05/17 08:50:21  flash
 * BugID:
 *
 * Revision 1.42  2005/05/17 05:36:38  flash
 * BugID:
 *
 * Revision 1.41  2005/05/10 10:38:29  flash
 * BugID:
 *
 * Revision 1.40  2005/05/02 06:16:36  flash
 * BugID:
 *
 * Revision 1.39  2005/04/06 14:50:31  flash
 * fix msti non blocking bug
 *
 * Revision 1.38  2005/04/06 02:54:37  flash
 * BugID:
 *
 * Revision 1.37  2005/03/30 03:32:27  flash
 * BugID:
 *
 * Revision 1.36  2005/03/27 16:51:43  flash
 * *** empty log message ***
 *
 * Revision 1.35  2005/03/16 09:54:26  flash
 * *** empty log message ***
 *
 * Revision 1.34  2005/03/15 16:58:42  flash
 * *** empty log message ***
 *
 * Revision 1.33  2005/03/02 09:36:18  flash
 * *** empty log message ***
 *
 * Revision 1.32  2004/12/28 09:41:55  flash
 * *** empty log message ***
 *
 * Revision 1.31  2004/12/16 14:09:47  flash
 * *** empty log message ***
 *
 * Revision 1.30  2004/11/24 05:02:25  flash
 * *** empty log message ***
 *
 * Revision 1.29  2004/08/12 00:11:37  winfred
 * new version cli
 *
 * Revision 1.28  2004/08/11 06:20:44  flash
 * *** empty log message ***
 *
 * Revision 1.27  2004/08/10 01:16:58  flash
 * *** empty log message ***
 *
 * Revision 1.26  2004/08/04 09:42:55  flash
 * transmit STP/RSTP bpdu
 *
 * Revision 1.25  2004/08/04 08:51:27  flash
 * fix msti blocking bug
 *
 * Revision 1.24  2004/08/04 00:51:18  flash
 * *** empty log message ***
 *
 * Revision 1.23  2004/07/23 06:28:32  flash
 * *** empty log message ***
 *
 * Revision 1.22  2004/07/22 05:22:24  flash
 * check xst->valid
 *
 * Revision 1.21  2004/07/19 15:34:52  flash
 * *** empty log message ***
 *
 * Revision 1.20  2004/07/17 02:23:52  flash
 * *** empty log message ***
 *
 * Revision 1.19  2004/07/07 06:32:18  flash
 * *** empty log message ***
 *
 * Revision 1.18  2004/07/07 05:38:38  flash
 * *** empty log message ***
 *
 * Revision 1.17  2004/06/30 08:06:01  flash
 * *** empty log message ***
 *
 * Revision 1.16  2004/06/25 13:33:22  flash
 * fix v3 len
 *
 * Revision 1.15  2004/06/25 07:20:38  flash
 * fix config ID
 *
 * Revision 1.14  2004/05/31 05:58:28  flash
 * *** empty log message ***
 *
 * Revision 1.13  2004/05/30 13:23:23  flash
 * *** empty log message ***
 *
 * Revision 1.12  2004/05/28 04:57:51  flash
 * *** empty log message ***
 *
 * Revision 1.11  2004/05/26 14:10:40  flash
 * *** empty log message ***
 *
 * Revision 1.10  2004/05/12 05:27:48  flash
 * fix number of MSTI
 *
 * Revision 1.9  2004/05/12 01:55:13  flash
 * insert rcvd msti msg into each XSTCVS: ----------------------------------------------------------------------
 *
 * Revision 1.8  2004/05/10 15:07:31  flash
 * fix priority vector
 *
 * Revision 1.7  2004/05/04 14:52:09  flash
 * *** empty log message ***
 *
 * Revision 1.6  2004/05/04 09:45:31  flash
 * fix rx
 *
 * Revision 1.5  2004/05/04 09:22:03  winfred
 * little update
 *
 * Revision 1.4  2004/05/04 01:15:54  flash
 * *** empty log message ***
 *
 * Revision 1.3  2004/05/03 15:23:08  flash
 * *** empty log message ***
 *
 * Revision 1.2  2004/05/03 14:50:13  flash
 * move rx function from port info to port rcv
 *
 * Revision 1.1  2004/05/03 14:48:00  flash
 * add port receive state machine
 *
 **********************************************************************/

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "stp_bpdu.h"
#include <asm/unaligned.h>

/* The Port Receive State Machine : 13.28 */

#define STATES \
 { \
  CHOOSE(DISCARD), \
  CHOOSE(RECEIVE),     \
 }

#define GET_STATE_NAME STP_rcv_get_state_name
#include "choose.h"

extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;
/* ----------------------------------------------------------------------------------------------*/
static Bool setRcvdMsgs(int port_index)
 {    
  register XST_T *this;
  register XST_PORT_T *port;
  int i;

  this = STP_xst_find(CIST_INSTANCE_ID);
  port=&(this->ports[port_index]);
  port->rcvdMsg=True;

  if(port->rcvdInternal == True)
   {
    for(i=1;i<MSTP_MAX_INSTANCE;i++)
     {
      this = STP_xst_find(i);

      if(this->valid == False)
       continue;
      if(this->admin_state == STP_DISABLED)
       continue;

      port=&(this->ports[port_index]);

      port->rcvdMsg=port->rcvdBpdu;
//      printk(" receive msg %d xst %d port %d\n",port->rcvdMsg, this->xst_id, port->port_index);
      port->rcvdBpdu=False;
     }
   } 
  return True;
}
/* ----------------------------------------------------------------------------------------------*/
static Bool setTcFlags (int port_index)
 {    /* 13.26.19 */
  register XST_T *this;
  register XST_PORT_T *port;
  int i;

  this = STP_xst_find(CIST_INSTANCE_ID);
  port=&(this->ports[port_index]);

  if (port->msgBpduType == BPDU_TOPO_CHANGE_TYPE ) 
   {
    port->rcvdTcn = True;
    for(i=1;i<MSTP_MAX_INSTANCE;i++)
     {
      this = STP_xst_find(i);

      if(this->valid == False)
       continue;
      if(this->admin_state == STP_DISABLED)
       continue;

      port=&(this->ports[port_index]);
      port->rcvdTc=True;
     }
   } 
  else 
   {
    if (port->msgFlags & TOPOLOGY_CHANGE_ACK_BIT) 
     {
      port->rcvdTcAck = True;
     }
    if ((port->rcvdInternal == False) && (port->msgFlags & TOPOLOGY_CHANGE_BIT)) 
     {
      port->rcvdTc = True;
      for(i=1;i<MSTP_MAX_INSTANCE;i++)
       {
        this = STP_xst_find(i);

      if(this->valid == False)
       continue;
      if(this->admin_state == STP_DISABLED)
       continue;

        port=&(this->ports[port_index]);
        port->rcvdTc=True;
       }
     }
    if (port->rcvdInternal == True) 
     {
      for(i=0;i<MSTP_MAX_INSTANCE;i++)
       {
        this = STP_xst_find(i);
        port=&(this->ports[port_index]);

      if(this->valid == False)
       continue;
      if(this->admin_state == STP_DISABLED)
       continue;

        if(port->rcvdMsg == False)
         continue;

        if(port->msgFlags & TOPOLOGY_CHANGE_BIT)
         port->rcvdTc=True;
       }
     }
  }

  return True;
}
/* ----------------------------------------------------------------------------------------------*/
static Bool updtBPDUVersion (STATE_MACH_T * this)
{    /* 17.19.18 */
  register XST_PORT_T *port = this->owner.port;

  if (port->msgBpduType == BPDU_TOPO_CHANGE_TYPE) 
   {
    port->rcvdSTP = True;
   }

  if (port->msgBpduVersion < 2 /* || port->msgPortRole == RSTP_PORT_ROLE_UNKN*/) 
   {
    port->rcvdSTP = True;
//    printk("rcvSTP is true port %d\n",port->port_index);
   }

  if (port->msgBpduType == BPDU_RSTP) 
   {
    port->rcvdRSTP = True;
   }

  return True;
 }

/* ----------------------------------------------------------------------------------------------*/
static Bool fromSameRegion(STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;

  if(port->rcvdRSTP==True && port->msgMSTConfId_match==True)
   return True;

  return False; 
 }

/* ----------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------*/
static void clearAllRcvdMsgs(int port_index)
 {
  int i;
  XST_T *this;
  XST_PORT_T *port;

  for(i=0;i<MSTP_MAX_INSTANCE;i++)
   {
    this=STP_xst_find(i);
    port=&(this->ports[port_index]);
    
    if(this->valid == False)
     continue;
      if(this->admin_state == STP_DISABLED)
       continue;

    port->rcvdMsg=False;
   }

 }

/* ----------------------------------------------------------------------------------------------*/
void STP_rcv_rx_bpdu(XST_PORT_T * port, MSTP_BPDU_T *bpdu, size_t len)
 {
  int i;
  unsigned short usTemp;
  int msti=0;
  struct xst_t *this = STP_xst_find(CIST_INSTANCE_ID);


#if 0
printk("ttt\n");
#endif 
#if 0
  port->msgId = 0;
#endif
  /* check bpdu type */
  switch (bpdu->hdr.bpdu_type) 
   {
    case BPDU_CONFIG_TYPE:
      port->rx_cfg_bpdu_cnt++;
      if (port->admin_non_stp)
       return;
      port->rcvdBpdu = True;
      break;
    case BPDU_TOPO_CHANGE_TYPE:
      port->rx_tcn_bpdu_cnt++;
      if (port->admin_non_stp)
       return;
      port->rcvdBpdu = True;
      port->msgBpduVersion = bpdu->hdr.version;
      port->msgBpduType = bpdu->hdr.bpdu_type;
      return;
    default:
      return;
    case BPDU_RSTP:
      if(bpdu->hdr.version==BPDU_MSTP) 
       {
        port->rx_mstp_bpdu_cnt++;
       }
      else if(bpdu->hdr.version==BPDU_RSTP) 
       {
        port->rx_rstp_bpdu_cnt++;
       }
      else
       return;
      if (port->admin_non_stp)
       return;
      if (port->owner->ForceVersion >= FORCE_RSTP) 
        port->rcvdBpdu = True;
      break;
  }

#if 0
printk("xxx\n");
#endif 
  port->msgBpduVersion = bpdu->hdr.version;
  port->msgBpduType = bpdu->hdr.bpdu_type;
  port->msgFlags = bpdu->cist_body.flags;

/* compare MST CONF ID and set MSTConfId_match */
  if(bpdu->hdr.version==BPDU_MSTP) 
  {
extern unsigned char MSTP_ConfigName[32];
extern unsigned short MSTP_RevisionLevel;         /* 0 */
extern char mstp_digest[16];
   int temp;


   port->msgMSTConfId_match = True;

   if((bpdu->MST_config_id[0] != 0) ||
      (strncmp(&(bpdu->MST_config_id[1]),MSTP_ConfigName,31)) ||
      (ntohs(*((unsigned short *)&(bpdu->MST_config_id[33]))) != MSTP_RevisionLevel) 
     ) 
    {
     port->msgMSTConfId_match=False;
    }
   else 
    {
     for(temp=0;temp<16;temp++)
      {
       if(bpdu->MST_config_id[35+temp] != mstp_digest[temp])
        {
         port->msgMSTConfId_match=False;
         break;
        }
      } 
    }
  }
 else
  port->msgMSTConfId_match=False;

#if 0
printk("config id match %d\n",port->msgMSTConfId_match);
#endif 
#define PR_MAC(mac) mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]
  /* 17.18.11 */
  STP_VECT_get_vector (bpdu, &(port->xstMsgPriority));

//if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
//      printk(" port rcv Msg bridge %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstMsgPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
  if(bpdu->hdr.bpdu_type == BPDU_CONFIG_TYPE || (bpdu->hdr.bpdu_type == BPDU_RSTP && bpdu->hdr.version == BPDU_VERSION_RSTP_ID)) 
   {
    stp_vect_get_bridge_id (bpdu->cist_body.bridge_id, &((port->xstMsgPriority).design_bridge));

//    if(port->msgFlags == Root);
//by flash, 2005/05/09
#if 0
    port->xstMsgPriority.region_root_bridge.prio= this->BridgeIdentifier.prio;
    memcpy(port->xstMsgPriority.region_root_bridge.addr, this->BridgeIdentifier.addr, 6);
#else
    stp_vect_get_bridge_id (bpdu->cist_body.bridge_id, &((port->xstMsgPriority).region_root_bridge));
#endif

    port->xstMsgPriority.intern_path_cost = 0;
   }


  if(port->msgMSTConfId_match==False)
    {
     port->xstMsgPriority.region_root_bridge.prio= this->BridgeIdentifier.prio;
     memcpy(port->xstMsgPriority.region_root_bridge.addr, this->BridgeIdentifier.addr, 6);
    }
//if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
//      printk(" port rcv1 Msg bridge %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstMsgPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
  port->xstMsgPriority.rcv_port = port->portId;

  /* 17.18.12 */
  STP_get_times (bpdu, &(port->xstMsgTimes));

  /* 17.18.25, 17.18.26 : see setTcFlags() */

#ifdef STP_DBG1
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
printk(" msgMSTConfId %d xst %d port %d version %d\n",port->msgMSTConfId_match,port->owner->xst_id, port->port_index,bpdu->hdr.version);
#endif 

//clear all messages
   {
    for(i=1;i<MSTP_MAX_INSTANCE;i++)
     {
      XST_T *xst;
      XST_PORT_T *xst_port;
      unsigned int inst_id;

      xst=STP_xst_find(i);
      if(xst->valid == False)
      {
//       printk(" xst %d port %d not valid\n",xst->xst_id,port->port_index);
       continue;
      }

      if(xst->admin_state == STP_DISABLED) 
      {
//       printk(" xst %d port %d not enable\n",xst->xst_id,port->port_index);
       continue;
      }

      xst_port=&(xst->ports[port->port_index]);

      if(xst_port->valid == False)
      {
//       printk(" port %d xst %d not valid\n",xst_port->port_index,xst->xst_id);
       continue;
      }

      xst_port->rcvdBpdu = False;
      xst_port->rcvdMsg = False;

     }
   }

  if(port->msgMSTConfId_match == True)
   {

    usTemp=get_unaligned((unsigned short *)bpdu->ver_3_length);
#if 0
printk("ustemp %d\n",usTemp);
#endif 
    if(usTemp > 64)
     msti=(usTemp-64)/MSTI_CFG_SZ; 

#ifdef STP_DBG1
#if 0
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
{
printk("msti %d\n",msti);
//printk(" BPDU ");
//for(i=0;i<8;i++)
// printk("%02X",bpdu->msti_conf[0].msti_internal_root_id[i]);
//printk(" \n ");
}
#endif

#endif 

    for(i=0;i<msti;i++)
     {
      XST_T *xst;
      XST_PORT_T *xst_port;
      unsigned int inst_id;

      if(msti==0) break; //flash ??

      inst_id=bpdu->msti_conf[i].msti_internal_root_id[1];

      xst=STP_xst_find(inst_id);
      if(xst->valid == False)
      {
//       printk(" xst %d port %d not valid\n",xst->xst_id,port->port_index);
       continue;
      }

      if(xst->admin_state == STP_DISABLED) 
      {
//       printk(" xst %d port %d not enable\n",xst->xst_id,port->port_index);
       continue;
      }

      xst_port=&(xst->ports[port->port_index]);
      if(xst_port->valid == False)
      {
//       printk(" port %d xst %d not valid\n",xst_port->port_index,xst->xst_id);
       continue;
      }

      xst_port->msgBpduVersion = bpdu->hdr.version;
      xst_port->msgBpduType = bpdu->hdr.bpdu_type;

      xst_port->rcvdBpdu = True;

      STP_VECT_get_msti_vector (bpdu,i, &xst_port->xstMsgPriority);
//if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
//      printk(" port rcv msti Msg bridge %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(xst_port->xstMsgPriority.design_bridge.addr),xst_port->owner->xst_id, xst_port->port_index);
      xst_port->xstMsgPriority.rcv_port = xst_port->portId;

      STP_get_msti_times (bpdu, i, &(xst_port->xstMsgTimes));

      xst_port->msgFlags=bpdu->msti_conf[i].msti_flag;
#ifdef STP_DBG1
//      printk(" portrcv:  bpdu type %d xst %d port %d port %d\n",xst_port->msgBpduType,xst->xst_id,xst_port->port_index,port->port_index);
#endif
     }
   }
#ifdef STP_DBG1
#define PR_MAC(mac) mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]
printk("receive BPDU port %d\n",port->port_index);

#if 0
printk(" BPDU version %d\n",port->msgBpduVersion);
printk(" BPDU type %d\n",port->msgBpduType);
printk(" BPDU flag %08X\n",port->msgFlags);
printk(" ConfId match %d\n",port->msgMSTConfId_match);

printk("  internal root %02X%02X%02X%02X%02X%02X\n",PR_MAC(port->xstMsgPriority.root_bridge.addr));
printk("  internal path cost %08X\n",port->xstMsgPriority.intern_path_cost);
printk("  design bridge %02X%02X%02X%02X%02X%02X\n",PR_MAC(port->xstMsgPriority.design_bridge.addr));
printk("  design port %04X\n",port->xstMsgPriority.design_port);
printk("  portID %04X\n",port->xstMsgPriority.rcv_port);
printk("  message age %d\n",port->xstMsgTimes.MessageAge);
printk("  max age %d\n",port->xstMsgTimes.MaxAge);
printk("  forward delay %d\n",port->xstMsgTimes.ForwardDelay);
printk("  hello time %d\n",port->xstMsgTimes.HelloTime);

if(msti > 0)
{
    for(i=1;i<msti;i++)
     {
      XST_T *xst=STP_xst_find(i);
      XST_PORT_T *xst_port=&(xst->ports[port->port_index]);

      printk(" inst %d\n",i);
      printk("  internal root %02X%02X%02X%02X%02X%02X\n",PR_MAC(xst_port->xstMsgPriority.root_bridge.addr));
      printk("  internal path cost %08X\n",xst_port->xstMsgPriority.intern_path_cost);
      printk("  design bridge %02X%02X%02X%02X%02X%02X\n",PR_MAC(xst_port->xstMsgPriority.design_bridge.addr));
      printk("  design port %04X\n",xst_port->xstMsgPriority.design_port);
      printk("  portID %04X\n",xst_port->xstMsgPriority.rcv_port);
      printk("  message age %d\n",xst_port->xstMsgTimes.MessageAge);
      printk("  max age %d\n",xst_port->xstMsgTimes.MaxAge);
      printk("  forward delay %d\n",xst_port->xstMsgTimes.ForwardDelay);
      printk("  hello time %d\n",xst_port->xstMsgTimes.HelloTime);

     }

}
#endif
#endif 

 }


/* ----------------------------------------------------------------------------------------------*/
void STP_rcv_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;

#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: portrcv state:%s port %d\n", GET_STATE_NAME(this->State),port->port_index);
#endif

  switch (this->State) 
   {
    case BEGIN:
    case DISCARD:
      port->rcvdBpdu = port->rcvdRSTP = port->rcvdSTP = False;
      clearAllRcvdMsgs(port->port_index);
#if 0
      port->msgBpduType = -1;
      port->msgPortRole = RSTP_PORT_ROLE_UNKN;
      port->msgFlags = 0;
      /* clear port statistics */
      port->rx_cfg_bpdu_cnt = port->rx_mstp_bpdu_cnt = port->rx_tcn_bpdu_cnt = 0; 
      port->tx_cfg_bpdu_cnt = port->tx_mstp_bpdu_cnt = port->tx_tcn_bpdu_cnt = 0;
#endif

      break;
    case RECEIVE:
      updtBPDUVersion(this);
      port->rcvdInternal=fromSameRegion(this);
      setRcvdMsgs(port->port_index);
      setTcFlags(port->port_index);
      port->rcvdBpdu=False;
#ifdef STP_DBG3
if(mstp_debug)
  printk("        portrcv: internal %d\n", port->rcvdInternal);
#endif
      break;
   }

 }
/* ----------------------------------------------------------------------------------------------*/
static Bool rcvdAnyMsg(int port_index)
 {
  XST_T *this;
  XST_PORT_T *port;
  int i;
   
  for(i=0;i<MSTP_MAX_INSTANCE;i++)
   {
    this=STP_xst_find(i);
    port=&(this->ports[port_index]);
   
    if(this->valid == False)
     continue;
      if(this->admin_state == STP_DISABLED)
       continue;

    if(port->rcvdMsg == True)
     return True;
   }
  return False;
 }
/* ----------------------------------------------------------------------------------------------*/
Bool STP_rcv_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *cist=STP_xst_find(CIST_INSTANCE_ID);
  register XST_PORT_T *cist_port = &(cist->ports[port->port_index]);

  if (this->State == BEGIN) 
   {
    return STP_hop_2_state (this, DISCARD);
   }

  switch (this->State) 
   {
    case DISCARD:
      if (cist_port->portEnabled && cist_port->rcvdBpdu) 
       {
        return STP_hop_2_state (this, RECEIVE);
       }
      if (!cist_port->portEnabled && cist_port->rcvdBpdu) 
       {
        return STP_hop_2_state (this, DISCARD);
       }
      break;
    case RECEIVE:
      if (cist_port->portEnabled && cist_port->rcvdBpdu && rcvdAnyMsg(port->port_index)==False) 
       {
        return STP_hop_2_state (this, RECEIVE);
       }
      if (!cist_port->portEnabled && cist_port->rcvdBpdu) 
       {
        return STP_hop_2_state (this, DISCARD);
       }
      break;
   }

  return False;
 }
