/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

#include "mstp.h"
#include "base.h"
#include "xst.h"

/* The Port Information State Machine : 17.21 */

#define STATES \
 { \
  CHOOSE(DISABLED), \
  CHOOSE(AGED),     \
  CHOOSE(UPDATE),   \
  CHOOSE(CURRENT),  \
  CHOOSE(RECEIVE),  \
  CHOOSE(SUPERIOR_DESIGNATED), \
  CHOOSE(REPEATED_DESIGNATED),   \
  CHOOSE(ROOT),    \
  CHOOSE(OTHER),    \
 }

#define GET_STATE_NAME STP_info_get_state_name
#include "choose.h"

extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;
/* ----------------------------------------------------------------------------------------------*/
static RCVD_MSG_T rcvInfoXst (STATE_MACH_T * this)
 {    /* 17.19.8 */
  int bridcmp, timecmp;
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that=port->owner;
  register XST_PORT_T *cist_port;
  register XST_T *cist;

  cist=STP_xst_find(0);
  cist_port=&(cist->ports[port->port_index]);

  if (port->msgBpduType == BPDU_TOPO_CHANGE_TYPE) 
   {
    return OtherInfo;
   }

  port->msgPortRole = RSTP_PORT_ROLE_UNKN;

  if (port->msgBpduType == BPDU_RSTP) 
   {
    port->msgPortRole = (port->msgFlags & PORT_ROLE_MASK) >> PORT_ROLE_OFFS;
   }

////by flash, 2005/05/13
  if (port->msgPortRole == RSTP_PORT_ROLE_DESGN || port->msgBpduType == BPDU_CONFIG_TYPE || port->msgPortRole == RSTP_PORT_ROLE_UNKN)
   {
    if(that->xst_id == CIST_INSTANCE_ID)
     {
       bridcmp = STP_VECT_compare_vector (&port->xstMsgPriority, &port->xstPortPriority, True, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2));
      timecmp = STP_compare_times (&port->xstMsgTimes, &port->xstPortTimes);

#ifdef STP_DBG3
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk("    portinfo: compare cist time : %d %d %d %d %d   %d %d %d %d %d\n",port->xstMsgTimes.MessageAge,port->xstMsgTimes.MaxAge,port->xstMsgTimes.ForwardDelay,port->xstMsgTimes.HelloTime,port->xstMsgTimes.remainingHops,port->xstPortTimes.MessageAge,port->xstPortTimes.MaxAge,port->xstPortTimes.ForwardDelay,port->xstPortTimes.HelloTime,port->xstPortTimes.remainingHops);

if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
      printk("    portinfo: xst %d port %d cist bridcmp %d  timecmp %d \n",that->xst_id, port->port_index ,bridcmp,timecmp);
#endif
     }
    else
     {
      bridcmp = STP_VECT_compare_msti_vector (&port->xstMsgPriority, &port->xstPortPriority, True);
      timecmp = STP_compare_msti_times (&port->xstMsgTimes, &port->xstPortTimes);
#ifdef STP_DBG3
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
      printk("    portinfo: xst %d port %d msti bridcmp %d  timecmp %d \n",that->xst_id, port->port_index,bridcmp,timecmp);
#endif

#ifdef STP_DBG3
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk("    portinfo: compare msti time : %d %d %d %d %d   %d %d %d %d %d\n",port->xstMsgTimes.MessageAge,port->xstMsgTimes.MaxAge,port->xstMsgTimes.ForwardDelay,port->xstMsgTimes.HelloTime,port->xstMsgTimes.remainingHops,port->xstPortTimes.MessageAge,port->xstPortTimes.MaxAge,port->xstPortTimes.ForwardDelay,port->xstPortTimes.HelloTime,port->xstPortTimes.remainingHops);
#endif
     }

//#ifdef STP_DBG3
#define PR_MAC(mac) mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
{
        printk("      rcvInfoXst: root Bridge ID msg:%04X %02X%02X%02X%02X%02X%02X  \n                   port:%04X %02X%02X%02X%02X%02X%02X \n",port->xstMsgPriority.root_bridge.prio,PR_MAC(port->xstMsgPriority.root_bridge.addr),port->xstPortPriority.root_bridge.prio,PR_MAC(port->xstPortPriority.root_bridge.addr));
        printk("      rcvInfoXst: region root Bridge ID msg:%04X %02X%02X%02X%02X%02X%02X  \n                   port:%04X %02X%02X%02X%02X%02X%02X \n",port->xstMsgPriority.region_root_bridge.prio,PR_MAC(port->xstMsgPriority.region_root_bridge.addr),port->xstPortPriority.region_root_bridge.prio,PR_MAC(port->xstPortPriority.region_root_bridge.addr));
        printk("      rcvInfoXst: design Bridge ID msg:%04X %02X%02X%02X%02X%02X%02X  \n                   port:%04X %02X%02X%02X%02X%02X%02X \n                      msg:port:%04X port:port:%04X   timecmp:%d\n",port->xstMsgPriority.design_bridge.prio,PR_MAC(port->xstMsgPriority.design_bridge.addr),port->xstPortPriority.design_bridge.prio,PR_MAC(port->xstPortPriority.design_bridge.addr),port->xstMsgPriority.design_port, port->xstPortPriority.design_port, timecmp);
        printk("     extern path msg:%d port:%d    intern path msg: %d port:%d\n ",port->xstMsgPriority.extern_path_cost,port->xstPortPriority.extern_path_cost,port->xstMsgPriority.intern_path_cost,port->xstPortPriority.intern_path_cost);
}
//#endif

    if (bridcmp < 0 || (!STP_VECT_compare_bridge_id (&port->xstMsgPriority.design_bridge, &port->xstPortPriority.design_bridge) && port->xstMsgPriority.design_port == port->xstPortPriority.design_port && timecmp)) 
     {
      if (bridcmp > 0) 
       {
#if 1
//by flash, 20050505
        if(that->xst_id == CIST_INSTANCE_ID)
         cist_port->putOffNewInfoCist = True;
	else
         cist_port->putOffNewInfoMsti = True;
#else
//by flash, 20050421
        if(that->xst_id == CIST_INSTANCE_ID)
         cist_port->newInfoCist = True;
	else
         cist_port->newInfoMsti = True;
#endif
       }
#ifdef STP_DBG3
if(mstp_debug)
 printk("       portinfo: Superior Designated Info\n");
#endif
      return SuperiorDesignatedInfo;
     }
    if (!bridcmp && !timecmp) 
     {
#ifdef STP_DBG3
if(mstp_debug)
 printk("       portinfo: Repeated Designated Info\n");
#endif
      return RepeatedDesignatedInfo;
     }
   }

//printk(" xst1 %d port %d role %d \n",that->xst_id,port->port_index, port->msgPortRole);
  if (port->msgPortRole == RSTP_PORT_ROLE_ROOT && port->msgBpduType == BPDU_RSTP && port->operPointToPointMac && !STP_VECT_compare_vector (&port->xstMsgPriority, &port->xstPortPriority, False, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) && AGREEMENT_BIT & port->msgFlags) 
   {
#ifdef STP_DBG3
if(mstp_debug)
 printk("       portinfo: Root Info\n");
#endif
    return RootInfo;
   }

#ifdef STP_DBG3
if(mstp_debug)
 printk("       portinfo: Other Info\n");
#endif
  return OtherInfo;
 }

/* ----------------------------------------------------------------------------------------------*/
static Bool recordProposalXst (STATE_MACH_T * this)
 {    /* 17.19.9 */
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that=port->owner;
  register XST_T *these;
  register XST_PORT_T *these_port;
  int i;
  Bool ret;

  if ((PROPOSAL_BIT & port->msgFlags) && port->operPointToPointMac)  
   {
    ret = port->proposed=True;
   }
  else
   {
    ret = port->proposed=False;
   }

  if(that->xst_id==CIST_INSTANCE_ID)
   {
    if(port->rcvdInternal)
     {
      for(i=1;i<MSTP_MAX_INSTANCE;i++)
       {
        these=STP_xst_find(i);
        these_port=&(these->ports[i]);

    if(these->valid == False)
     continue;
    if(these->admin_state == STP_DISABLED)
     continue;


        these_port->proposed=ret;
       }
     }
   }
  return ret;
 }
/* ----------------------------------------------------------------------------------------------*/
static Bool recordAgreementXst(STATE_MACH_T * this)
 {    /* 17.19.9 */
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that=port->owner;
  register XST_T *these;
  register XST_PORT_T *these_port;
  register XST_T *cist;
  register XST_PORT_T *cist_port;
  int i=0;
  Bool ret;


  if(that->xst_id==CIST_INSTANCE_ID)   /* 13.26.9 */
   {
    if ((AGREEMENT_BIT & port->msgFlags) && port->operPointToPointMac)  
     {
      if((port->role==RootPort)&&(STP_VECT_compare_vector (&port->xstMsgPriority, &port->xstPortPriority, False, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) >= 0))
       ret = port->agreed=True;
      else if((port->role==DesignatedPort)&&(STP_VECT_compare_vector (&port->xstMsgPriority, &port->xstPortPriority, False, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) <= 0))
       ret = port->agreed=True;
      else
       ret = port->agreed=False;
     }
    else
     {
      ret = port->agreed=False;
     }

    if(port->rcvdInternal)
     {
      for(i=1;i<MSTP_MAX_INSTANCE;i++)
       {
        these=STP_xst_find(i);
        these_port=&(these->ports[i]);

        if(these->valid == False)
         continue;

        if(these->admin_state == STP_DISABLED)
         continue;

        these_port->agreed=ret;
       }
     }
   }
  else  //MSTI  /* 13.26.10 */
   {
  /*
If the MSTI Message was received on a point to point link and:
a) the message priority vector of the CIST Message accompanying this MSTI Message (i.e. received in
the same BPDU) has the same CIST Root Identifier, CIST External Root Path Cost, and Regional
Root Identifier as the CIST port priority vector, and
b) the MSTI Message has the Agreement flag set, and conveys either
1) a Root Port Role with message priority the same as or worse than the MSTI port priority vector,
or
2) a Designated Port Role with message priority the same as or better than the port priority vector,
the MSTI agreed flag is set. Otherwise the MSTI agreed flag is cleared.
NOTEXMSTI Messages received from Bridges external to the MST Region are discarded and not processed by
recordAgreeementMsti() or recordProposalMsti().
*/
    cist=STP_xst_find(CIST_INSTANCE_ID);
    cist_port=&(cist->ports[i]);

    if (STP_VECT_compare_vector (&cist_port->xstMsgPriority, &cist_port->xstPortPriority, False, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) <= 0 ) 
     {
      if ((AGREEMENT_BIT & port->msgFlags) && port->operPointToPointMac)  
       {
        if((port->role==RootPort)&&(STP_VECT_compare_msti_vector (&port->xstMsgPriority, &port->xstPortPriority, False) >= 0))
         ret = port->agreed=True;
        else if((port->role==DesignatedPort)&&(STP_VECT_compare_msti_vector (&port->xstMsgPriority, &port->xstPortPriority, False) <= 0))
         ret = port->agreed=True;
        else
         ret = port->agreed=False;
       }
      else
       {
        ret = port->agreed=False;
       }
     }
    else
     {
      ret = port->agreed=False;
     }
   }
  return ret;
 }
/* ----------------------------------------------------------------------------------------------*/
static Bool recordMasteredXst (STATE_MACH_T * this)
 {    /* 17.19.9 */
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that=port->owner;
  register XST_T *these;
  register XST_PORT_T *these_port;
  int i;
  Bool ret;

  if(that->xst_id==CIST_INSTANCE_ID)   /* 13.26.9 */
   {
    if(port->rcvdInternal == False)
     { 
      for(i=1;i<MSTP_MAX_INSTANCE;i++)
       {
        these=STP_xst_find(i);
        these_port=&(these->ports[i]);

        if(these->valid == False)
         continue;

        if(these->admin_state == STP_DISABLED)
         continue;

        these->mstiMastered=False;
       }
      return False;
     }
    return True;
   }
  else
   {
    if ((MASTER_BIT & port->msgFlags) && port->operPointToPointMac)  
     {
      ret=that->mstiMastered=True;
     }
    else
     {
      ret=that->mstiMastered=False;
     }
   }

  return ret;
 }

/* ----------------------------------------------------------------------------------------------*/
#if 0
static Bool setTcFlags (STATE_MACH_T * this)
 {    /* 17.19.13 */
  register XST_PORT_T *port = this->owner.port;

  if (port->msgBpduType == BPDU_TOPO_CHANGE_TYPE ) 
   {
    port->rcvdTcn = True;
   } 
  else 
   {
    if (TOPOLOGY_CHANGE_BIT & port->msgFlags) 
     {
      port->rcvdTc = True;
     }
    if (TOPOLOGY_CHANGE_ACK_BIT & port->msgFlags) 
     {
      port->rcvdTcAck = True;
     }
  }

  return True;
}

#endif
/* ----------------------------------------------------------------------------------------------*/
static Bool updtRcvdInfoWhileXst (STATE_MACH_T * this)
{    /* 17.19.19 */
  register int eff_age;
  register int hello3;
  register XST_PORT_T *port = this->owner.port;

  eff_age = (8 + port->xstPortTimes.MaxAge) / 16;
  if (eff_age < 1)
   eff_age = 1;
  eff_age += port->xstPortTimes.MessageAge;

  if (eff_age <= port->xstPortTimes.MaxAge) 
   {
    hello3 = 3 * port->xstPortTimes.HelloTime;
    eff_age = port->xstPortTimes.MaxAge - eff_age;
    if (eff_age > hello3)
     eff_age = hello3;
    port->rcvdInfoWhile = eff_age;
   } 
  else 
   {
    port->rcvdInfoWhile = 0;
   }

#ifdef STP_DBG1
#if 0
  printk(" ******* rcvdinfo while %d hellotime %d\n",port->rcvdInfoWhile,port->xstPortTimes.HelloTime);
#endif
#endif

  return True;
 }

/* ----------------------------------------------------------------------------------------------*/
Bool compute_rcvdXstMsg(port_index)
 {    
  register XST_T *this;
  register XST_PORT_T *port;
  int i;

  for(i=0;i<MSTP_MAX_INSTANCE;i++)
   {
    this = STP_xst_find(i);
    port=&(this->ports[port_index]);

    if(this->valid == False)
     continue;
    if(this->admin_state == STP_DISABLED)
     continue;

    if(this->admin_state == STP_DISABLED)
     continue;

    if(port->rcvdMsg==True)
     {
      return True;
     }
   }
  return False;
 }
/* ----------------------------------------------------------------------------------------------*/
Bool compute_updtXstInfo(port_index)
 {    
  register XST_T *this;
  register XST_PORT_T *port;
  int i;

  for(i=0;i<MSTP_MAX_INSTANCE;i++)
   {
    this = STP_xst_find(i);
    port=&(this->ports[port_index]);

    if(this->valid == False)
     continue;
    if(this->admin_state == STP_DISABLED)
     continue;

    if(this->admin_state == STP_DISABLED)
     continue;
    if(port->updtInfo==True)
     {
      return True;
     }
   }
  return False;
 }
/* ----------------------------------------------------------------------------------------------*/
Bool compute_rcvdXstInfo(port_index)
 {    
  register XST_T *this;
  register XST_PORT_T *port;
  int i;

  for(i=0;i<MSTP_MAX_INSTANCE;i++)
   {
    this = STP_xst_find(i);
    port=&(this->ports[port_index]);

    if(this->valid == False)
     continue;
    if(this->admin_state == STP_DISABLED)
     continue;

 //??????
    if(port->rcvdMsg==True)
     {
      return True;
     }
   }
  return False;
 }
/* ----------------------------------------------------------------------------------------------*/
//????????????????????????????????
/* ----------------------------------------------------------------------------------------------*/
Bool betterorsameInfoXst(XST_PORT_T *port)
 {
  register XST_T *that=port->owner;


  if(that->xst_id==CIST_INSTANCE_ID)   /* 13.26.9 */
   {
    if (STP_VECT_compare_vector (&port->xstMsgPriority, &port->xstPortPriority, False, port->rcvdSTP || (port->rcvdRSTP && port->msgBpduVersion==2)) <= 0 ) 
     return True;
   }
  else
   {
    if (STP_VECT_compare_msti_vector (&port->xstMsgPriority, &port->xstPortPriority, False) <= 0 ) 
     return True;
   }
  return False;
 }

/* ----------------------------------------------------------------------------------------------*/
void STP_info_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_PORT_T *port1;
  register XST_T *xst;
  register XST_T *cist=STP_xst_find(CIST_INSTANCE_ID);
  register XST_PORT_T *cist_port = &(cist->ports[port->port_index]);


#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: portinfo state:%s xst %d port %d \n", GET_STATE_NAME(this->State),port->owner->xst_id,port->port_index);
#endif

  switch (this->State) 
   {
    case BEGIN:
      port->rcvdMsg = False;
      port->rcvdBpdu = port->rcvdRSTP = port->rcvdSTP = False;
      port->msgBpduType = -1;
      port->msgPortRole = RSTP_PORT_ROLE_UNKN;
      port->msgFlags = 0;
      /* clear port statistics */
      port->rx_cfg_bpdu_cnt = port->rx_rstp_bpdu_cnt =
          port->rx_mstp_bpdu_cnt = port->rx_tcn_bpdu_cnt = 0; 
      port->tx_cfg_bpdu_cnt = port->tx_rstp_bpdu_cnt =
          port->tx_mstp_bpdu_cnt = port->tx_tcn_bpdu_cnt = 0;

    case DISABLED:
      port->rcvdMsg = False;
//by flash, 2005/05/02
      STP_VECT_copy (&port->xstPortPriority, &port->xstDesignatedPriority);
      port->proposing = port->proposed = port->agree = port->agreed = False;
      port->rcvdInfoWhile = 0;
      port->infoIs = Disabled;
      //??
      port->reselect = True;
      port->selected = False;
     if(cist_port->rcvdInternal == False)
      {
       int i; 

       if(port->owner->xst_id==0)
        {
         for(i=1;i<MSTP_MAX_INSTANCE;i++)
          {
           xst=STP_xst_find(i);
           if(xst->valid == False) continue;
           if(xst->admin_state == STP_DISABLED) continue;
           port1=&(xst->ports[port->port_index]);
//printk("update reselect xst %d port %d\n",xst->
           port1->reselect = True;
//           port1->selected = True;
           port1->selected = False;
           port1->infoIs = Disabled;
          }
        }

      }
      break;
    case AGED:
      port->infoIs = Aged;
      port->reselect = True;
      port->selected = False;
     if(cist_port->rcvdInternal == False)
      {
       int i; 

       if(port->owner->xst_id==0)
        {
         for(i=1;i<MSTP_MAX_INSTANCE;i++)
          {
           xst=STP_xst_find(i);
           if(xst->valid == False) continue;
           if(xst->admin_state == STP_DISABLED) continue;
           port1=&(xst->ports[port->port_index]);

           port1->infoIs = Aged;
           port1->reselect = True;
           port1->selected = False;
          }
        }

      }
      break;
    case UPDATE:
      port->proposing = port->proposed = False; /* in UPDATE */
      port->synced = False; /* In UPDATE */
      port->sync=port->changedMaster;
      port->agreed = port->agreed && betterorsameInfoXst(port) && !port->changedMaster; 

#ifdef STP_DBG1
//      printk(" Design inter %ld  inst %d port %d\n",port->xstDesignatedPriority.intern_path_cost,port->owner->xst_id, port->port_index);
#endif

//#define PR_MAC(mac) mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]
//      printk(" Design bridge %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstPortPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
      STP_VECT_copy (&port->xstPortPriority, &port->xstDesignatedPriority);
//      printk(" Design bridge1 %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstPortPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
      STP_copy_times (&port->xstPortTimes, &port->xstDesignatedTimes);
      port->changedMaster = port->updtInfo = False;
      port->infoIs = Mine;

//by flash, 2005/05/05
      if(port->owner->xst_id == CIST_INSTANCE_ID)
       cist_port->newInfoCist = True;
      else 
       cist_port->newInfoMsti = True;

     if(cist_port->rcvdInternal == False)
      {
       int i; 

       if(port->owner->xst_id==0)
        {
         for(i=1;i<MSTP_MAX_INSTANCE;i++)
          {
           xst=STP_xst_find(i);
           if(xst->valid == False) continue;
           if(xst->admin_state == STP_DISABLED) continue;
           port1=&(xst->ports[port->port_index]);

           port1->infoIs = Mine;
          }
        }

      }
      break;
    case CURRENT:
      break;
    case RECEIVE:
#ifdef STP_DBG1
      printk("    flags %08X \n",port->msgFlags);
#endif

//printk(" xst %d port %d role %d \n",port->owner->xst_id,port->port_index, port->msgPortRole);
      port->rcvdInfo = rcvInfoXst (this);
      recordMasteredXst(this);
      break;
    case SUPERIOR_DESIGNATED:
      cist_port->infoInternal = cist_port->rcvdInternal;
      port->proposing = False;
      recordProposalXst(this);
      port->agree=port->agree && betterorsameInfoXst(port);
      recordAgreementXst(this);
      port->synced=port->synced && port->agreed;
//      printk(" Msg bridge %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstPortPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
      STP_VECT_copy (&port->xstPortPriority, &port->xstMsgPriority);
//      printk(" Msg bridge1 %X%X%X%X%X%X  inst %d port %d\n",PR_MAC(port->xstPortPriority.design_bridge.addr),port->owner->xst_id, port->port_index);
      STP_copy_times (&port->xstPortTimes, &port->xstMsgTimes);
      updtRcvdInfoWhileXst(this);
      port->infoIs = Received;
      port->reselect = True;
      port->selected = False;
     if(cist_port->rcvdInternal == False)
      {
       int i; 

       if(port->owner->xst_id==0)
        {
         for(i=1;i<MSTP_MAX_INSTANCE;i++)
          {
           xst=STP_xst_find(i);
           if(xst->valid == False) continue;
           if(xst->admin_state == STP_DISABLED) continue;
           port1=&(xst->ports[port->port_index]);
//printk("update reselect xst %d port %d\n",xst->
           port1->reselect = True;
//           port1->selected = True;
           port1->selected = False;
           port1->infoIs = Received;
          }
        }

      }
      port->rcvdMsg=False;
      break;
    case REPEATED_DESIGNATED:
      cist_port->infoInternal=cist_port->rcvdInternal;
      recordProposalXst(this);
      recordAgreementXst(this);
      updtRcvdInfoWhileXst(this);
      port->rcvdMsg=False;
      break;
    case ROOT:
      recordAgreementXst(this);
      port->rcvdMsg = False; 
      break;
    case OTHER:
      port->rcvdMsg=False;
      break;
   }

 }

/* ----------------------------------------------------------------------------------------------*/
Bool STP_info_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;
  register XST_T *that = port->owner;
  register XST_T *cist=STP_xst_find(CIST_INSTANCE_ID);
  register XST_PORT_T *cist_port = &(cist->ports[port->port_index]);
//  unsigned char rcvdXstMsg,updtXstInfo,rcvdXstInfo; 

  if ((!cist_port->portEnabled && port->infoIs != Disabled) || this->State == BEGIN) 
   {
    return STP_hop_2_state (this, DISABLED);
   }

#if 1
  if (port->adminEnable==False && port->infoIs != Disabled)
   {
    return STP_hop_2_state (this, DISABLED);
   }

#endif

  switch (this->State) 
   {
    case DISABLED:
//by flash, 2005/04/20
//      if (cist_port->portEnabled) 
      if (cist_port->portEnabled && port->adminEnable) 
       {
        return STP_hop_2_state (this, AGED);
       }
      if (port->rcvdMsg) 
       {
        return STP_hop_2_state (this, DISABLED);
       }
      break;
    case AGED:
      if (port->selected && port->updtInfo) 
       {
        return STP_hop_2_state (this, UPDATE);
       }
      break;
    case UPDATE:
      return STP_hop_2_state (this, CURRENT);
      break;
    case CURRENT:
      if (port->selected && port->updtInfo) 
       {
        return STP_hop_2_state (this, UPDATE);
       }

/*
 * 13.25.8 rcvdCistInfo
 * rcvdCistInfo is TRUE for a given Port if and only if rcvdMsg is TRUE for the CIST for that Port.
 *
 * 13.25.9 rcvdMstiInfo
 * rcvdMstiInfo is TRUE for a given Port and MSTI if and only if rcvdMsg is FALSE for the CIST for that Port and rcvdMsg is TRUE for the MSTI for that Port.
 *
 */

////      rcvdXstInfo=compute_rcvdXstInfo(port->port_index);
////      if (port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !rcvdXstInfo) 
      if (that->xst_id == 0 && port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !port->rcvdMsg) 
       {
        return STP_hop_2_state (this, AGED);
       }

//by flash, 2005/03/31
////      if (that->xst_id != 0 && port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !(port->rcvdMsg==True && cist_port->rcvdMsg==False)) 
//by flash, 2005/05/10
//      if (that->xst_id != 0 && port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !port->rcvdMsg && !cist_port->rcvdMsg) 
//      if (that->xst_id != 0 && port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !port->rcvdMsg) 
//by flash, 2005/05/25
      if (that->xst_id != 0 && port->infoIs == Received && !port->rcvdInfoWhile && !port->updtInfo && !port->rcvdMsg && !(cist_port->rcvdSTP || cist_port->rcvdRSTP)) 
       {
        return STP_hop_2_state (this, AGED);
       }


/*
 * 13.25.11 updtCistInfo
 * updtCistInfo is TRUE for a given Port if and only if updtInfo is TRUE for the CIST for that Port.
 *
 * 13.25.12 updtMstiInfo
 * updtMstiInfo is TRUE for a given Port and MSTI if and only if updtInfo is TRUE for the MSTI for that Port or either updtInfo or selected are TRUE for the CIST for that Port.
 *
 */

//      rcvdXstMsg=compute_rcvdXstMsg(port->port_index);
//      updtXstInfo=compute_updtXstInfo(port->port_index);
//      if (rcvdXstMsg && !updtXstInfo) 
      if (that->xst_id == 0 && port->rcvdMsg && !port->updtInfo) 
       {
        return STP_hop_2_state (this, RECEIVE);
       }

//by flash 2005/03/23
//      if (that->xst_id != 0 && port->rcvdMsg && !(port->updtInfo == True ||  cist_port-> updtInfo == True || cist_port->selected == True)) 
//by flash 2005/03/30
      if (that->xst_id != 0 && port->rcvdMsg && !port->updtInfo) 
//by flash 2005/03/31
//      if (that->xst_id != 0 && port->rcvdMsg && !port->updtInfo && !cist_port->updtInfo && !cist_port->selected) 
//by flash 2005/05/13
////      if (that->xst_id != 0 && port->rcvdMsg && !(port->updtInfo == True ||  cist_port-> updtInfo == True || cist_port->selected == True)) 
       {
        return STP_hop_2_state (this, RECEIVE);
       }
      break;
    case RECEIVE:
      switch (port->rcvdInfo) 
       {
        case SuperiorDesignatedInfo:
               return STP_hop_2_state (this, SUPERIOR_DESIGNATED);
        case RepeatedDesignatedInfo:
               return STP_hop_2_state (this, REPEATED_DESIGNATED);
        case RootInfo:
               return STP_hop_2_state (this, ROOT);
        case OtherInfo:
               return STP_hop_2_state (this, OTHER);
        default:
               return STP_hop_2_state (this, CURRENT);
       }
      break;
    case SUPERIOR_DESIGNATED:
      return STP_hop_2_state (this, CURRENT);
      break;
    case REPEATED_DESIGNATED:
      return STP_hop_2_state (this, CURRENT);
      break;
    case ROOT:
      return STP_hop_2_state (this, CURRENT);
      break;
    case OTHER:
      return STP_hop_2_state (this, CURRENT);
      break;
   }

  return False;
 }
