/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
 
#ifndef MSTP_NETFILTER_H
#define MSTP_NETFILTER_H

#include "krntype.h"

#include "mstp.h"

/* structs */
typedef struct _mstp_vlan_table 
 {
 	Tuint16		vlan_id;
 	Tuint32		member_port;
 } mstp_vlan_table;


/* come from uid_stp.h */
typedef struct 
 {
	unsigned short  prio;
	unsigned char   addr[6];
 } MSTP_NF_BRIDGE_ID_T;

/* come from uid_stp.h */
typedef enum 
 {
	MSTP_NF_UID_PORT_DISABLED = 0,
	MSTP_NF_UID_PORT_DISCARDING,
	MSTP_NF_UID_PORT_LEARNING,
	MSTP_NF_UID_PORT_FORWARDING,
	MSTP_NF_UID_PORT_NON_STP
 } MSTP_NF_MSTP_PORT_STATE;

/* come from uid_stp.h */
typedef enum 
 {
	MSTP_NF_P2P_FORCE_TRUE,
	MSTP_NF_P2P_FORCE_FALSE,
	MSTP_NF_P2P_AUTO,
 } MSTP_NF_ADMIN_P2P_T;


struct set_mstp_bridge_t
 {
	unsigned char   inst_id;
	unsigned long   value;
	unsigned char   name[MAX_STP_NAME_LEN];
 };

struct set_mstp_port_t
 {
	unsigned char	inst_id;
	unsigned char	port;
	unsigned long	value;
 };


struct show_mstp_port_status_t 
{
	unsigned char	port_no;
	unsigned char	inst_id;

	unsigned char	priority;
	unsigned char	mcheck;
	unsigned char	edge;
	unsigned char	nonstp;
	unsigned char	force;
	unsigned char	p2p;

	unsigned short	port_id;
	MSTP_NF_MSTP_PORT_STATE	state;
	unsigned long	path_cost;

	MSTP_NF_BRIDGE_ID_T	designated_root;
	unsigned long	designated_cost;
	MSTP_NF_BRIDGE_ID_T	designated_bridge;
	unsigned short	designated_port;

	int		fdWhile;	/* 17.15.1 */
	int		helloWhen;	/* 17.15.2 */
	int		mdelayWhile;	/* 17.15.3 */
	int		rbWhile;	/* 17.15.4 */
	int		rcvdInfoWhile;	/* 17.15.5 */
	int		rrWhile;	/* 17.15.6 */
	int		tcWhile;	/* 17.15.7 */
	int		infoIs;		/* 17.18.6 */
	int		txCount;	/* 17.18.40 */
	int		lnkWhile;

	unsigned short	port_priority;
	unsigned long	admin_port_path_cost;
	MSTP_NF_ADMIN_P2P_T	admin_p2p;
	unsigned char	admin_edge;
	unsigned char	admin_non_stp; /* 1- not STP, 0 - regular */
	unsigned char	admin_mcheck;

	unsigned long	uptime;		/* 14.8.2.1.3.a */
	unsigned long	oper_port_path_cost;
	unsigned char	role;
	unsigned char	oper_point2point;
	unsigned char	oper_edge;
	unsigned char	oper_stp_neigb;
	unsigned char	top_change_ack;
	unsigned char	tc;

	unsigned long	rx_cfg_bpdu_cnt;
	unsigned long	rx_mstp_bpdu_cnt;
	unsigned long	rx_tcn_bpdu_cnt;
	unsigned long	tx_cfg_bpdu_cnt;
	unsigned long	tx_mstp_bpdu_cnt;
	unsigned long	tx_tcn_bpdu_cnt;
};


struct show_mstp_instance_status_t 
{
	struct show_mstp_port_status_t port[MAX_LOGIC_PORT];

	unsigned char	inst_id;

	unsigned char	valid;
	unsigned char	enable;
	unsigned char	debug;

	MSTP_NF_BRIDGE_ID_T	bridgeid;
	MSTP_NF_BRIDGE_ID_T	rootid;
	unsigned char	rootport;
	unsigned long	rpcost;

	unsigned short	frwrddly;
	unsigned short	hellotime;
	unsigned short	maxage;
};


struct show_mstp_status_t 
{
	struct show_mstp_instance_status_t inst[MAX_STP_MST_IDS]; 

	unsigned short	cfgfrwrddly;
	unsigned short	cfghellotime;
	unsigned short	cfgmaxage;
	unsigned short	priority;

	unsigned char   max_hop;
	unsigned char   name[32];
	unsigned short  revision;
	unsigned char 	forceversion;
};


struct show_mstp_port_statistics_t 
{
	unsigned char	port;
	unsigned long	rx_cfg_bpdu_cnt;
	unsigned long	rx_mstp_bpdu_cnt;
	unsigned long	rx_tcn_bpdu_cnt;
	unsigned long	tx_cfg_bpdu_cnt;
	unsigned long	tx_mstp_bpdu_cnt;
	unsigned long	tx_tcn_bpdu_cnt;
};

struct show_mstp_vlan_cfg_t 
{
 unsigned char cfg_name[MAX_STP_NAME_LEN];
 unsigned short revision;
 unsigned short vlan[4096];
};

struct set_mstp_inst_cfg_t 
{
 unsigned short instance;
 unsigned long vlan[MAX_STP_VLAN_MASK_LEN];
};

#endif

