
/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/
#include <linux/netfilter.h>
#include <asm/uaccess.h>

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "xst_port.h"
#include "stp_in.h"
#include "../stp_uni/stp_uni_netfilter.h"
#include "mstp_netfilter.h"
#include "krntype.h"
#include "krnerr.h"
//#include "../gvrp/gvrp_netfilter.h"
#include "uid_stp.h"

extern unsigned short vlan_instance_map[4096];
extern unsigned char MSTP_ConfigName[MAX_STP_NAME_LEN];
extern unsigned short MSTP_RevisionLevel;         /* 0 */
extern unsigned short vlan_valid[4096];
extern TstLPortMask vlan_member[4096];
extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;

static int bMstp_enable = 0;
void mstp_convert_port_state(Tuint8 *pucState, unsigned char port_state)
{
        switch (port_state)
        {
        case UID_PORT_DISCARDING:
            *pucState = STP_PORT_STATE_DISCARDING;
            break;
        case UID_PORT_LEARNING:
            *pucState = STP_PORT_STATE_LEARNING;
            break;
        case UID_PORT_FORWARDING:
            *pucState = STP_PORT_STATE_FORWARDING;
            break;
        case UID_PORT_NON_STP:
            *pucState = STP_PORT_STATE_NON_STP;
            break;
        case UID_PORT_DISABLED:
        default:
            *pucState = STP_PORT_STATE_DISABLED;
            break;
        }
}

void mstp_convert_port_role(Tuint8 *pucRole, unsigned char port_role)
{
        switch (port_role)
        {
        case 'A':
            *pucRole = STP_PORT_ROLE_ALTERNATE;
            break;
        case 'B':
            *pucRole = STP_PORT_ROLE_BACKUP;
            break;
        case 'R':
            *pucRole = STP_PORT_ROLE_ROOT;
            break;
        case 'D':
            *pucRole = STP_PORT_ROLE_DESIGNATED;
            break;
        case 'M':
            *pucRole = STP_PORT_ROLE_MASTER;
            break;
        case '-':
            *pucRole = STP_PORT_ROLE_NON_STP;
            break;
        case ' ':
        default:
            *pucRole = STP_PORT_ROLE_DISABLED;
            break;
        }
}

int do_mstp_get_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
 {
  SMstpInfo stMstpInfo = {0};
  SMstpInstInfo stMstpInstInfo = {0};
  SMstpPortInfo stMstpPortInfo = {0};
  SMstpInstPortInfo stMstpInstPortInfo = {0};
  int i;
  Tbool bBool;
  Tuint8 ucUByte;
  Tuint16 usUShort;
  Tuint32 ulULong;
  Tchar acName[MAX_STP_NAME_LEN];
  Tuint8 aucMac[MAC_ADDR_LEN];
  TstStpPortBool stStpPortBool;
  TstStpPortUByte stStpPortUByte;
  TstStpPortUShort stStpPortUShort;
  TstStpPortULong stStpPortULong;
  TstStpPortMac stStpPortMac;
  TstStpMstVlan stStpMstVlan;
  TstStpMstBool stStpMstBool;
  TstStpMstUByte stStpMstUByte;
  TstStpMstUShort stStpMstUShort;
  TstStpMstULong stStpMstULong;
  TstStpMstMac stStpMstMac;
  TstStpMstPortUByte stStpMstPortUByte;
  TstStpMstPortUShort stStpMstPortUShort;
  TstStpMstPortULong stStpMstPortULong;
  TstStpMstPortMac stStpMstPortMac;
  TstStpMstPortState stStpMstPortState;

  switch (cmd)
   {
    case STP_GET_EBL:
#if 0
        STP_IN_get_mstp_info(&stMstpInfo);
        bBool = stMstpInfo.bGenEnable;
#endif
        bBool=bMstp_enable;
        copy_to_user(user, &bBool, sizeof(Tbool));
        break;

    case STP_GET_DEBUG:
        STP_IN_get_mstp_info(&stMstpInfo);
        bBool = stMstpInfo.bGenDebugEnable;
        copy_to_user(user, &bBool, sizeof(Tbool));
        break;

    case STP_GET_FORCE_VERSION:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.ucGenForceVersion;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_FRWRD_DLY:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenBridgeForwardDelay;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_HELLO_TIME:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenBridgeHelloTime;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_MAX_AGE:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenBridgeMaxAge;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_PRIORITY:
        STP_IN_get_mstp_info(&stMstpInfo);
        usUShort = stMstpInfo.stGenBridgeId.prio;
        copy_to_user(user, &usUShort, sizeof(Tuint16));
        break;

    case STP_GET_MAX_HOPS:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenMaxHops;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_NAME:
        STP_IN_get_mstp_info(&stMstpInfo);
        strncpy(acName, stMstpInfo.aucGenCfgName, MAX_STP_NAME_LEN-1);
        acName[MAX_STP_NAME_LEN-1] = '\0';
        copy_to_user(user, acName, sizeof(char)*MAX_STP_NAME_LEN);
        break;

    case STP_GET_REVISION:
        STP_IN_get_mstp_info(&stMstpInfo);
        usUShort = stMstpInfo.usGenRevLevel;
        copy_to_user(user, &usUShort, sizeof(Tuint16));
        break;

    case STP_GET_ROOT_HELLO_TIME:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenHelloTime;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_ROOT_FRWRD_DLY:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenForwardDelay;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_ROOT_MAX_AGE:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usGenMaxAge;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_ROOT_PRIORITY:
        STP_IN_get_mstp_info(&stMstpInfo);
        usUShort = stMstpInfo.stGenCistRoot.prio;
        copy_to_user(user, &usUShort, sizeof(Tuint16));
        break;

    case STP_GET_ROOT_MAC:
        STP_IN_get_mstp_info(&stMstpInfo);
        memcpy(aucMac, stMstpInfo.stGenCistRoot.addr, MAC_ADDR_LEN);
        copy_to_user(user, aucMac, sizeof(Tuint8)*MAC_ADDR_LEN);
        break;

    case STP_GET_ROOT_PORT:
        STP_IN_get_mstp_info(&stMstpInfo);
        ucUByte = stMstpInfo.usRootPort - 1;
        copy_to_user(user, &ucUByte, sizeof(Tuint8));
        break;

    case STP_GET_ROOT_PATH_COST:
        STP_IN_get_mstp_info(&stMstpInfo);
        ulULong = stMstpInfo.ulGenExternalRootCost;
        copy_to_user(user, &ulULong, sizeof(Tuint32));
        break;

    case STP_GET_NUM_TCN:
        copy_from_user(&stStpMstUByte, user, sizeof(TstStpMstUByte));
//        stMstpInstInfo.ucXstId = stStpMstUByte.ucMstId;
        stMstpInstInfo.ucXstId = 0;
        STP_IN_get_inst_info(&stMstpInstInfo);
        ulULong = stMstpInstInfo.ulXstTopologyChangeCnt;
        copy_to_user(user, &ulULong, sizeof(Tuint32));
        break;

    case STP_GET_LAST_TCN:
        copy_from_user(&stStpMstUByte, user, sizeof(TstStpMstUByte));
//        stMstpInstInfo.ucXstId = stStpMstUByte.ucMstId;
        stMstpInstInfo.ucXstId = 0;
        STP_IN_get_inst_info(&stMstpInstInfo);
        ulULong = stMstpInstInfo.ulXstTimeSinceTopologyChange;
        copy_to_user(user, &ulULong, sizeof(Tuint32));
        break;

    case STP_GET_HOLD_TIME:
        STP_IN_get_mstp_info(&stMstpInfo);
        ulULong = stMstpInfo.ucGenHoldTime;
        copy_to_user(user, &ulULong, sizeof(Tuint32));
        break;

    case STP_GET_MIGRATION_TIME:
        STP_IN_get_mstp_info(&stMstpInfo);
        ulULong = stMstpInfo.ucGenMigrateTime;
        copy_to_user(user, &ulULong, sizeof(Tuint32));
        break;

    case STP_GET_PORT_PATH_COST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortOperExternalPathCost;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_PRIORITY:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpPortUByte.ucUByte = stMstpInstPortInfo.usXstPortPriority;
        copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
        break;

    case STP_GET_PORT_MCHECK:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        stMstpPortInfo.ucPortIndex = stStpPortBool.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortBool.bBool = False;
        copy_to_user(user, &stStpPortBool, sizeof(TstStpPortBool));
        break;

    case STP_GET_PORT_EDGE:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        stMstpPortInfo.ucPortIndex = stStpPortBool.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortBool.bBool = stMstpPortInfo.bPortOperEdge ? True : False;
        copy_to_user(user, &stStpPortBool, sizeof(TstStpPortBool));
        break;

    case STP_GET_PORT_NONSTP:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        stMstpPortInfo.ucPortIndex = stStpPortBool.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortBool.bBool = stMstpPortInfo.bPortAdminNonStp ? True : False;
        copy_to_user(user, &stStpPortBool, sizeof(TstStpPortBool));
        break;

    case STP_GET_PORT_P2P:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        stMstpPortInfo.ucPortIndex = stStpPortBool.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortBool.bBool = stMstpPortInfo.bPortOperPointToPoint ? True : False;
        copy_to_user(user, &stStpPortBool, sizeof(TstStpPortBool));
        break;

    case STP_GET_PORT_DES_PORT_PRIORITY:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpPortUByte.ucUByte = stMstpInstPortInfo.usXstPortDesignatedPort>>8;
        copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
        break;

    case STP_GET_PORT_DES_PORT_ID:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpPortUByte.ucUByte = (stMstpInstPortInfo.usXstPortDesignatedPort&0xff) - 1;
        copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
        break;

    case STP_GET_PORT_DES_PATH_COST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulDesPortPathCost;

        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_DES_BRIDGE_PRIORITY:
        copy_from_user(&stStpPortUShort, user, sizeof(TstStpPortUShort));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUShort.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpPortUShort.usUShort = stMstpInstPortInfo.stXstPortDesignatedBridge.prio;
        copy_to_user(user, &stStpPortUShort, sizeof(TstStpPortUShort));
        break;

    case STP_GET_PORT_DES_BRIDGE_MAC:
        copy_from_user(&stStpPortMac, user, sizeof(TstStpPortMac));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortMac.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        memcpy(stStpPortMac.aucMac, stMstpInstPortInfo.stXstPortDesignatedBridge.addr, MAC_ADDR_LEN);
        copy_to_user(user, &stStpPortMac, sizeof(TstStpPortMac));
        break;

    case STP_GET_PORT_STATE:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        mstp_convert_port_state(&stStpPortUByte.ucUByte, stMstpInstPortInfo.ucXstPortState);
        copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
        break;

    case STP_GET_PORT_ROLE:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        stMstpInstPortInfo.ucXstId = 0;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        mstp_convert_port_role(&stStpPortUByte.ucUByte, stMstpInstPortInfo.ucXstPortRole);
        copy_to_user(user, &stStpPortUByte, sizeof(TstStpPortUByte));
        break;

    case STP_GET_PORT_UPTIME:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortUptime;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_RX_CFG:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortRxCfgBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_TX_CFG:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortTxCfgBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_RX_RST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortRxRstBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_TX_RST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortTxRstBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_RX_TCN:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortRxTcnBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_TX_TCN:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortTxTcnBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_RX_MST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortRxMstBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_PORT_TX_MST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        stMstpPortInfo.ucPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_port_info(&stMstpPortInfo);
        stStpPortULong.ulULong = stMstpPortInfo.ulPortTxMstBpduCnt;
        copy_to_user(user, &stStpPortULong, sizeof(TstStpPortULong));
        break;

    case STP_GET_MST_PRIORITY:
        copy_from_user(&stStpMstUShort, user, sizeof(TstStpMstUShort));
        stMstpInstInfo.ucXstId = stStpMstUShort.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        stStpMstUShort.usUShort = stMstpInstInfo.usXstPriority;
        copy_to_user(user, &stStpMstUShort, sizeof(TstStpMstUShort));
        break;

    case STP_GET_MST_EBL:
        copy_from_user(&stStpMstBool, user, sizeof(TstStpMstBool));
        /* XXX */
        copy_to_user(user, &stStpMstBool, sizeof(TstStpMstBool));
        break;

    case STP_GET_MST_VLAN:
        copy_from_user(&stStpMstVlan, user, sizeof(TstStpMstVlan));
        stMstpInstInfo.ucXstId = stStpMstVlan.ucMstId;
        for (i = 0; i < MAX_STP_VLAN_MASK_LEN; ++i) {
            stStpMstVlan.aulVlanMask[i] = 0;
        }
        for (i = 0; i < 4095; ++i) {
            if (ntohs(vlan_instance_map[i+1]) == stStpMstVlan.ucMstId) {
               stStpMstVlan.aulVlanMask[i/32] |= (1L << (i%32));
            }
        }
        copy_to_user(user, &stStpMstVlan, sizeof(TstStpMstVlan));
        break;

    case STP_GET_MST_ROOT_PORT_ID:
        copy_from_user(&stStpMstUByte, user, sizeof(TstStpMstUByte));
        stMstpInstInfo.ucXstId = stStpMstUByte.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        stStpMstUByte.ucUByte = stMstpInstInfo.ucXstRootPort;
        copy_to_user(user, &stStpMstUByte, sizeof(TstStpMstUByte));
        break;

    case STP_GET_MST_ROOT_PATH_COST:
        copy_from_user(&stStpMstULong, user, sizeof(TstStpMstULong));
        stMstpInstInfo.ucXstId = stStpMstULong.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        stStpMstULong.ulULong = stMstpInstInfo.ulXstInternalRootCost;
        copy_to_user(user, &stStpMstULong, sizeof(TstStpMstULong));
        break;

    case STP_GET_MST_ROOT_PRIORITY:
        copy_from_user(&stStpMstUShort, user, sizeof(TstStpMstUShort));
        stMstpInstInfo.ucXstId = stStpMstUShort.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        stStpMstUShort.usUShort = stMstpInstInfo.stXstRegionaldRoot.prio;
        copy_to_user(user, &stStpMstUShort, sizeof(TstStpMstUShort));
        break;

    case STP_GET_MST_ROOT_MAC:
        copy_from_user(&stStpMstMac, user, sizeof(TstStpMstMac));
        stMstpInstInfo.ucXstId = stStpMstMac.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        memcpy(stStpMstMac.aucMac, stMstpInstInfo.stXstRegionaldRoot.addr, MAC_ADDR_LEN);
//        printk(" regional root %X%X%X%X%X%X\n",stStpMstMac.aucMac[0],stStpMstMac.aucMac[1],stStpMstMac.aucMac[2],stStpMstMac.aucMac[3],stStpMstMac.aucMac[4],stStpMstMac.aucMac[5]);
//        printk(" regional root1 %X%X%X%X%X%X\n",stStpMstMac.aucMac[0],stStpMstMac.aucMac[1],stStpMstMac.aucMac[2],stStpMstMac.aucMac[3],stStpMstMac.aucMac[4],stStpMstMac.aucMac[5]);
        copy_to_user(user, &stStpMstMac, sizeof(TstStpMstMac));
        break;

    case STP_GET_MST_TC:
        copy_from_user(&stStpMstBool, user, sizeof(TstStpMstBool));
        stMstpInstInfo.ucXstId = stStpMstBool.ucMstId;
        STP_IN_get_inst_info(&stMstpInstInfo);
        stStpMstBool.bBool = stMstpInstInfo.bXstTopologyChangeFlag ? True : False;
        copy_to_user(user, &stStpMstBool, sizeof(TstStpMstBool));
        break;

    case STP_GET_MST_PORT_PATH_COST:
        copy_from_user(&stStpMstPortULong, user, sizeof(TstStpMstPortULong));
        stMstpInstPortInfo.ucXstId = stStpMstPortULong.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortULong.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpMstPortULong.ulULong = stMstpInstPortInfo.ulXstPortOperInternalPathCost;
        copy_to_user(user, &stStpMstPortULong, sizeof(TstStpMstPortULong));
        break;

    case STP_GET_MST_PORT_PRIORITY:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        stMstpInstPortInfo.ucXstId = stStpMstPortUByte.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpMstPortUByte.ucUByte = stMstpInstPortInfo.usXstPortPriority;
        copy_to_user(user, &stStpMstPortUByte, sizeof(TstStpMstPortUByte));
        break;

    case STP_GET_MST_PORT_DES_PORT_PRIORITY:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        stMstpInstPortInfo.ucXstId = stStpMstPortUByte.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpMstPortUByte.ucUByte = stMstpInstPortInfo.usXstPortDesignatedPort>>8;
        copy_to_user(user, &stStpMstPortUByte, sizeof(TstStpMstPortUByte));
        break;

    case STP_GET_MST_PORT_DES_PORT_ID:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        stMstpInstPortInfo.ucXstId = stStpMstPortUByte.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpMstPortUByte.ucUByte = stMstpInstPortInfo.usXstPortDesignatedPort - 1;
        copy_to_user(user, &stStpMstPortUByte, sizeof(TstStpMstPortUByte));
        break;

    case STP_GET_MST_PORT_DES_PATH_COST:
        copy_from_user(&stStpMstPortULong, user, sizeof(TstStpMstPortULong));
        stMstpInstPortInfo.ucXstId = stStpMstPortULong.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpPortULong.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpPortULong.ulULong = stMstpInstPortInfo.ulXstDesPathCost;
        copy_to_user(user, &stStpMstPortULong, sizeof(TstStpMstPortULong));
        break;

    case STP_GET_MST_PORT_DES_BRIDGE_PRIORITY:
        copy_from_user(&stStpMstPortUShort, user, sizeof(TstStpMstPortUShort));
        stMstpInstPortInfo.ucXstId = stStpMstPortUShort.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUShort.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        stStpMstPortUShort.usUShort = stMstpInstPortInfo.stXstPortDesignatedBridge.prio;
        copy_to_user(user, &stStpMstPortUShort, sizeof(TstStpMstPortUShort));
        break;

    case STP_GET_MST_PORT_DES_BRIDGE_MAC:
        copy_from_user(&stStpMstPortMac, user, sizeof(TstStpMstPortMac));
        stMstpInstPortInfo.ucXstId = stStpMstPortMac.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortMac.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        memcpy(stStpMstPortMac.aucMac, stMstpInstPortInfo.stXstPortDesignatedBridge.addr, MAC_ADDR_LEN);
        copy_to_user(user, &stStpMstPortMac, sizeof(TstStpMstPortMac));
        break;

    case STP_GET_MST_PORT_STATE:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        stMstpInstPortInfo.ucXstId = stStpMstPortUByte.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        mstp_convert_port_state(&stStpMstPortUByte.ucUByte, stMstpInstPortInfo.ucXstPortState);
        copy_to_user(user, &stStpMstPortUByte, sizeof(TstStpMstPortUByte));
        break;

    case STP_GET_MST_PORT_ROLE:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        stMstpInstPortInfo.ucXstId = stStpMstPortUByte.ucMstId;
        stMstpInstPortInfo.ucXstPortIndex = stStpMstPortUByte.ucPortId;
        STP_IN_get_instport_info(&stMstpInstPortInfo);
        mstp_convert_port_role(&stStpMstPortUByte.ucUByte, stMstpInstPortInfo.ucXstPortRole);
        copy_to_user(user, &stStpMstPortUByte, sizeof(TstStpMstPortUByte));
        break;

    case STP_GET_VLAN_PORT_STATE:
        copy_from_user(&stStpMstPortState, user, sizeof(TstStpMstPortState));

        usUShort=K_StpGetInstPort(ntohs(vlan_instance_map[stStpMstPortState.usVlanId]), stStpMstPortState.usVlanId, stStpMstPortState.ucPortId, &stStpMstPortState.ucPortState);

        copy_to_user(user, &stStpMstPortState, sizeof(TstStpMstPortState));

        return ((usUShort!=KRN_RET_OK)?(-usUShort):0);
        break;

    default:
        break;
   }
  return 0;
 }


static void set_bridge_cfg_value (struct set_mstp_bridge_t b, unsigned long mask)
 {
  UID_STP_CFG_T cfg;
  int rc;

  cfg.field_mask = mask;

#ifdef STP_DBG
//  printk("mask %08X\n",mask);
#endif
  switch (mask)
   {
    case BR_CFG_STATE:
        return;
        break;
    case BR_CFG_PRIO:
               cfg.bridge_priority = b.value;
               break;
    case BR_CFG_AGE:
               cfg.max_age = b.value;
               break;
    case BR_CFG_HELLO:
               cfg.hello_time = b.value;
               break;
    case BR_CFG_DELAY:
               cfg.forward_delay = b.value;
               break;
    case BR_CFG_FORCE_VER:
               if (1 == b.value)
                cfg.force_version = FORCE_STP;
               else if (2 == b.value)
                cfg.force_version = FORCE_RSTP;
               else if (3 == b.value)
                cfg.force_version = NORMAL_MSTP;
               else
                cfg.force_version = NORMAL_MSTP;
               break;
    case BR_CFG_MAX_HOP:
               cfg.max_hop = b.value;
               break;
    case BR_CFG_REVISION:
               cfg.revision = b.value;
               break;
    case BR_CFG_NAME:
               strncpy(cfg.name, b.name, MAX_STP_NAME_LEN);
               break;
   }

  rc = STP_IN_xst_set_cfg (b.inst_id, &cfg);
  if (STP_OK != rc)
   {
  if(mstp_debug)
    printk ("MSTP: STP_IN_xst_set_cfg error, err_code=%d\n", rc);
   }
#if 0

  if(mask == BR_CFG_PRIO)
   {
    int i;
    for(i=1;i<MSTP_MAX_INSTANCE;i++)
     STP_IN_xst_set_cfg (i, &cfg);
   }
#endif
 }


static void set_port_cfg_value (struct set_mstp_port_t p, unsigned long mask)
 {
  UID_STP_PORT_CFG_T cfg;
  int rc;

  cfg.port=p.port;
  cfg.field_mask = mask;

  switch (mask)
   {
   case PT_CFG_STATE:
       return;
       break;
   case PT_CFG_EXTCOST:
       cfg.admin_port_path_cost = p.value;
       break;
   case PT_CFG_INTCOST:
       cfg.admin_port_path_cost = p.value;
       break;
   case PT_CFG_PRIO:
       cfg.port_priority = p.value;
       break;
   case PT_CFG_P2P:
       cfg.admin_point2point =
          (p.value == True) ? P2P_FORCE_TRUE : P2P_FORCE_FALSE;
       break;
   case PT_CFG_EDGE:
       cfg.admin_edge = p.value;
       break;
   case PT_CFG_MCHECK:
       cfg.admin_mcheck=p.value;
       break;
   case PT_CFG_NON_STP:
       cfg.admin_non_stp = p.value;
       break;
   default:
       return;
   }
  if(mstp_debug)
   printk("         stp in set inst %d port %d value %d\n",p.inst_id, cfg.port, p.value);
  rc = STP_IN_set_port_cfg (p.inst_id, &cfg);
  if (STP_OK != rc)
   {
    if(STP_Large_Port_Priority == rc)
     printk(" Port priority is too large!!\n");
    else if(STP_Port_Priority_Granularity == rc)
     printk(" Port priority limited to a multiple of 16!!\n");
    else if(STP_Large_Port_Path_Cost == rc)
     printk(" Port path cost is too large!!\n");
  if(mstp_debug)
    printk ("MSTP: STP_IN_set_port_cfg error, err_code=%d\n", rc);
   }
 }


int do_mstp_set_ctl (struct sock *sk, int cmd, void *user, unsigned int len)
 {
  struct set_mstp_bridge_t b_data;
  struct set_mstp_port_t p_data;
  Tbool bBool;
  Tuint8 ucUByte;
  Tuint16 usUShort;
  Tchar acName[MAX_STP_NAME_LEN];
  TstStpPortBool stStpPortBool;
  TstStpPortUByte stStpPortUByte;
  TstStpPortULong stStpPortULong;
  TstStpMstVlan stStpMstVlan;
  TstStpMstUShort stStpMstUShort;
  TstStpMstPortUByte stStpMstPortUByte;
  TstStpMstPortULong stStpMstPortULong;
  TstStpVlan stStpVlan;
  int i;

  switch (cmd)
   {
    case STP_SET_EBL:
        copy_from_user(&bBool, user, sizeof(Tbool));
        if (bBool) {
  if(mstp_debug)
   printk("MSTP netfilter: init\n");
            mstp_enable();
            bMstp_enable = 1;
        }
        else {
  if(mstp_debug)
   printk("MSTP netfilter: stop\n");
            mstp_disable();
            bMstp_enable = 0;
        }
        break;

    case STP_SET_DEBUG:
        copy_from_user(&bBool, user, sizeof(Tbool));
        mstp_debug=bBool;
        break;

    case STP_SET_FORCE_VERSION:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
        b_data.inst_id = 0;
        b_data.value = ucUByte;
        set_bridge_cfg_value(b_data, BR_CFG_FORCE_VER);
  if(mstp_debug)
        printk("MSTP netfilter: set forceversion %d\n", b_data.value);
        break;

    case STP_SET_FRWRD_DLY:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
        b_data.inst_id = 0;
        b_data.value = ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set fwdelay %d\n", b_data.value);
        set_bridge_cfg_value(b_data, BR_CFG_DELAY);
        break;

    case STP_SET_HELLO_TIME:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
        b_data.inst_id = 0;
        b_data.value = ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set hellotime %d\n", b_data.value);
        set_bridge_cfg_value(b_data, BR_CFG_HELLO);
        break;

    case STP_SET_MAX_AGE:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
        b_data.inst_id = 0;
        b_data.value = ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set maxage %d\n", b_data.value);
        set_bridge_cfg_value(b_data, BR_CFG_AGE);
        break;

    case STP_SET_PRIORITY:
        copy_from_user(&usUShort, user, sizeof(Tuint16));
        if(mstp_debug)
         printk("MSTP netfilter: set prio %d\n", usUShort);

        for(i=0;i<MSTP_MAX_INSTANCE;i++)
         {
          b_data.inst_id = i;
          b_data.value = usUShort;
          set_bridge_cfg_value(b_data, BR_CFG_PRIO);
         }
        break;

    case STP_SET_MAX_HOPS:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
  if(mstp_debug)
        printk("MSTP netfilter: set max hop %d\n", b_data.value);

        for(i=0;i<MSTP_MAX_INSTANCE;i++)
         {
          b_data.inst_id = i;
          b_data.value = ucUByte;
          set_bridge_cfg_value(b_data, BR_CFG_MAX_HOP);
         }
        break;

    case STP_SET_NAME:
        copy_from_user(acName, user, sizeof(Tchar)*MAX_STP_NAME_LEN);
        b_data.inst_id = 0;
        strncpy(b_data.name, acName, MAX_STP_NAME_LEN-1);
        b_data.name[MAX_STP_NAME_LEN-1] = '\0';
  if(mstp_debug)
        printk("MSTP netfilter: set name %s\n", b_data.name);
        set_bridge_cfg_value(b_data, BR_CFG_NAME);
        break;

    case STP_SET_REVISION:
        copy_from_user(&usUShort, user, sizeof(Tuint16));
        b_data.inst_id = 0;
        b_data.value = usUShort;
  if(mstp_debug)
        printk("MSTP netfilter: set revision %d\n", b_data.value);
        set_bridge_cfg_value(b_data, BR_CFG_REVISION);
        break;

    case STP_SET_PORT_PATH_COST:
        copy_from_user(&stStpPortULong, user, sizeof(TstStpPortULong));
        p_data.inst_id = 0;
        p_data.port = stStpPortULong.ucPortId;
        p_data.value = stStpPortULong.ulULong;
  if(mstp_debug)
   printk("MSTP netfilter: set port cost inst %d port %d val %d\n", p_data.inst_id, p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_EXTCOST);
        set_port_cfg_value(p_data, PT_CFG_INTCOST);
        break;

    case STP_SET_PORT_PRIORITY:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        p_data.inst_id = 0;
        p_data.port = stStpPortUByte.ucPortId;
        p_data.value = stStpPortUByte.ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set port prio inst %d port %d val %d\n", p_data.inst_id, p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_PRIO);
        break;

    case STP_SET_PORT_MCHECK:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        p_data.inst_id = 0;
        p_data.port = stStpPortBool.ucPortId;
        p_data.value = stStpPortBool.bBool;
  if(mstp_debug)
        printk("MSTP netfilter: set port %d mcheck %d \n", p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_MCHECK);
        break;

    case STP_SET_PORT_EDGE:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        p_data.inst_id = 0;
        p_data.port = stStpPortBool.ucPortId;
        p_data.value = stStpPortBool.bBool;
  if(mstp_debug)
        printk("MSTP netfilter: set port %d edge %d\n", p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_EDGE);
        break;

    case STP_SET_PORT_NONSTP:
        copy_from_user(&stStpPortBool, user, sizeof(TstStpPortBool));
        p_data.inst_id = 0;
        p_data.port = stStpPortBool.ucPortId;
        p_data.value = stStpPortBool.bBool;
  if(mstp_debug)
        printk("MSTP netfilter: set port %d nonstp %d\n", p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_NON_STP);
        break;

    case STP_SET_PORT_P2P:
        copy_from_user(&stStpPortUByte, user, sizeof(TstStpPortUByte));
        p_data.inst_id = 0;
        p_data.port = stStpPortUByte.ucPortId;
        p_data.value = stStpPortUByte.ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set port %d p2p %d\n", p_data.port, p_data.value);
        set_port_cfg_value(p_data, PT_CFG_P2P);
        break;

    case STP_SET_MST_PRIORITY:
        copy_from_user(&stStpMstUShort, user, sizeof(TstStpMstUShort));
        b_data.inst_id = stStpMstUShort.ucMstId;
        b_data.value = stStpMstUShort.usUShort;
  if(mstp_debug)
        printk("MSTP netfilter: set mst %d prio %d\n", b_data.inst_id, b_data.value);
        set_bridge_cfg_value(b_data, BR_CFG_PRIO);
        break;

    case STP_INS_MST:
        copy_from_user(&stStpMstVlan, user, sizeof(TstStpMstVlan));
  if(mstp_debug)
        printk("MSTP netfilter: add inst %d\n", stStpMstVlan.ucMstId);
        mstp_add_inst(stStpMstVlan.ucMstId, stStpMstVlan.aulVlanMask);
        STP_IN_refersh();
        break;

    case STP_DEL_MST:
        copy_from_user(&ucUByte, user, sizeof(Tuint8));
  if(mstp_debug)
        printk("MSTP netfilter: del inst %d\n", ucUByte);
        mstp_del_inst(ucUByte);
        STP_IN_refersh();
        break;

    case STP_SET_NOTIFY_VLAN_ADD:
  mstp_refresh_vlan_member();
#if 0
        copy_from_user(&stStpVlan, user, sizeof(TstStpVlan));
  if(mstp_debug)
        printk("MSTP netfilter: vlan add %d\n", stStpVlan.usVlanId);

        vlan_valid[stStpVlan.usVlanId-1] = 1;

        for(i=0;i<LOGIC_MASK_LEN;i++)
         vlan_member[stStpVlan.usVlanId-1].ulMask[i] = stStpVlan.stPortMask.ulMask[i];
#endif
        STP_IN_refersh();
        break;

    case STP_SET_NOTIFY_VLAN_DEL:
  mstp_refresh_vlan_member();
#if 0
        copy_from_user(&usUShort, user, sizeof(Tuint16));
  if(mstp_debug)
        printk("MSTP netfilter: vlan del %d\n", usUShort);

        vlan_valid[usUShort-1] = 0;
        for(i=0;i<LOGIC_MASK_LEN;i++)
         vlan_member[usUShort-1].ulMask[i] = 0;
#endif
        STP_IN_refersh();
        break;

    case STP_SET_MST_PORT_PATH_COST:
        copy_from_user(&stStpMstPortULong, user, sizeof(TstStpMstPortULong));
        p_data.inst_id = stStpMstPortULong.ucMstId;
        p_data.port = stStpMstPortULong.ucPortId;
        p_data.value = stStpMstPortULong.ulULong;
  if(mstp_debug)
        printk("MSTP netfilter: set port cost inst %d port %d val %d\n", p_data.inst_id, p_data.port, p_data.value);

        set_port_cfg_value(p_data, PT_CFG_INTCOST);
        break;

    case STP_SET_MST_PORT_PRIORITY:
        copy_from_user(&stStpMstPortUByte, user, sizeof(TstStpMstPortUByte));
        p_data.inst_id = stStpMstPortUByte.ucMstId;
        p_data.port = stStpMstPortUByte.ucPortId;
        p_data.value = stStpMstPortUByte.ucUByte;
  if(mstp_debug)
        printk("MSTP netfilter: set port prio inst %d port %d val %d\n", p_data.inst_id, p_data.port, p_data.value);

        set_port_cfg_value(p_data, PT_CFG_PRIO);
        break;

    default:
  if(mstp_debug)
        printk("MSTP netfilter: unknown\n");
  }
  return 0;
 }

/*==================================================================================*/
struct nf_sockopt_ops mstp_sockopts =
{
list:           {NULL, NULL},
pf:             PF_INET,
set_optmin:     STP_BASE_CTL,
set_optmax:     STP_SET_MAX+1,
set:            do_mstp_set_ctl,
compat_set: 	NULL,
get_optmin:     STP_BASE_CTL,
get_optmax:     STP_GET_MAX+1,
get:            do_mstp_get_ctl,
compat_get: 	NULL,
use:            0,
cleanup_task:   NULL
};

