
/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

/*
 * mstp - multiple spanning tree protocol 
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/if_ether.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <asm/unaligned.h>
#include <linux/netfilter.h>
#include <linux/spinlock.h>

#include "krndef.h"
#include "krnerr.h"
#include "krnstp.h"
#include "krnvlan.h"
#include "mstp.h"
#include "base.h"
#include "stp_in.h"
#include "stp_bpdu.h"

#include "xst.h"
#include "xst_port.h"

#define Config_bpdu_type    0
#define Tcn_bpdu_type       128
#define BPDU_PRIORITY       5

/*-------------------------------------------------------------------------------*/
extern void (*gvrp_stp_port_forwarding)(int );
extern void (*gvrp_stp_port_disabled)(int );

extern void (*gmrp_stp_port_forwarding)(int );
extern void (*gmrp_stp_port_disabled)(int );

extern void (*igmp_stp_port_forwarding)(int );
extern void (*igmp_stp_port_disabled)(int );

extern void (*mstp_vlan_add)(int,unsigned long);
extern void (*mstp_vlan_del)(int,unsigned long);

extern struct nf_sockopt_ops mstp_sockopts; 
/*-------------------------------------------------------------------------------*/
static spinlock_t mstp_sem;
TstLPortMask enabled_ports;


unsigned char mstp_bridge_mac[6];

//vlan_instance_map[0] = vlan_instance_map[4095]=0
unsigned short vlan_instance_map[4096];

unsigned short vlan_valid[4096];
TstLPortMask vlan_member[4096];

unsigned char MSTP_ConfigName[32];
unsigned short MSTP_RevisionLevel;         /* 0 */

static int periodical_thread_pid;
static int port_thread_pid;
int mstp_tick_enable;
static Bool mstp_vlan_member_refreshed;

unsigned char mstp_debug=0,mstp_debug_min=13,mstp_debug_max=15;
/*-------------------------------------------------------------------------------*/
void mstp_refresh_vlan_member()
{
 unsigned short i,j;
 Tuint8 ucVlanMode;
 Tuint16  usTblSize, usIndex=0;
 Tuint16        usVlanId;
 Tbool          bStatic;
 TstPPortMask   stPortPhyMask, stTagPhyMask;
 TstLPortMask   stPortLogMask;

 K_VlanGetMode(&ucVlanMode);

 if(ucVlanMode==VLAN_MODE_DOT1Q)
  {

 for(i=1;i<4095;i++)
  {
   vlan_valid[i-1]=0;

   for(j=0;j<LOGIC_MASK_LEN;j++)
    vlan_member[i-1].ulMask[j]=0;
  }

   K_VlanGetTblSize(&usTblSize);
   for (usIndex= 0; usIndex < usTblSize; ++usIndex) 
    {
     if (K_VlanGetTblEntry(usIndex, &usVlanId, &bStatic,  &stPortPhyMask, &stTagPhyMask) == KRN_RET_OK) 
      {
       vlan_valid[usVlanId-1]=1;

       cclmx_PMask2LMask( &stPortLogMask, &stPortPhyMask);
                 
       for(j=0;j<LOGIC_MASK_LEN;j++)
        vlan_member[usVlanId-1].ulMask[j]=stPortLogMask.ulMask[j] ;

      }//if
    }
  }
 mstp_vlan_member_refreshed=True;
}
/*-------------------------------------------------------------------------------*/
Bool mstp_check_vlan_member(int xst_id, int port_index)
{
 //check vlan member port
//extern unsigned short vlan_instance_map[4096];
//extern unsigned short vlan_valid[4096];
//extern TstLPortMask vlan_member[4096];
  Bool member=False;
  int vid;
  unsigned long ulTemp,ulMask;
#if 0
  struct xst_t *xst;

  xst = STP_xst_find (xst_id);

  if (xst->valid!=True) return False;
  if (xst->admin_state!=STP_ENABLED) return False;
#endif

     for(vid=1;vid<4095;vid++)
     {
      if(vlan_valid[vid-1]==0)
       continue;
#if 0
      if(port_index==8)
       printk("---  check member vlan %d  inst %d port %d xst %d\n",vid,vlan_instance_map[vid],port_index, xst_id);
#endif
      if(ntohs(vlan_instance_map[vid])!=xst_id)
       continue;

#if 0
      if(port_index==8)
       printk("  check member vlan %d  port %d ulmask %08X  /=%d %=%d %d \n",vid,port_index,vlan_member[vid-1].ulMask[port_index/32], port_index/32, port_index%32, (vlan_member[vid-1].ulMask[port_index/32] & (0x1L<< (port_index%32))));
#endif
      if((vlan_member[vid-1].ulMask[port_index/32] & (0x1L<< (port_index%32))))
      {
       member=True;
       break;
      }
     }

  return member;

}
/*-------------------------------------------------------------------------------*/
static void mstp_vlan_valid(int vid,TstLPortMask *pstMember)
{
#if 0
 int i;

 vlan_valid[vid-1]=1;

 for(i=0;i<LOGIC_MASK_LEN;i++)
  vlan_member[vid-1].ulMask[i]|=pstMember->ulMask[i];
#endif
  mstp_refresh_vlan_member();
}
/*-------------------------------------------------------------------------------*/
static void mstp_vlan_invalid(int vid,TstLPortMask *pstMember)
{
#if 0
 unsigned long i,j=0;

 for(i=0;i<LOGIC_MASK_LEN;i++)
 {
  vlan_member[vid-1].ulMask[i]&=~(pstMember->ulMask[i]);
  j=j?j:(vlan_member[vid-1].ulMask[i]);
 }

 if(j==0)
  vlan_valid[vid-1]=0;
#endif
  mstp_refresh_vlan_member();
}
/*-------------------------------------------------------------------------------*/
static void mstp_sleep(unsigned howlong)
{
  if(in_interrupt())
   {
    return;
   }
 current->state = TASK_INTERRUPTIBLE;
 schedule_timeout(howlong);
}

/*-------------------------------------------------------------------------------*/
/* this thread will use portdrv to find out any port changes 
 * and report them to the ieee 802.1s code.
 */

static int mstp_port_thread(void * vp)
{
 int i,enabled;
 Tuint8 new_link, new_ebl, new_speed, new_duplex;
 Tuint8 link[MAX_LOGIC_PORT], ebl[MAX_LOGIC_PORT], speed[MAX_LOGIC_PORT], duplex[MAX_LOGIC_PORT];

 memset (link, 0, sizeof(link));
 memset (ebl, 0, sizeof(ebl));
 memset (speed, 0, sizeof(speed));
 memset (duplex, 0, sizeof(duplex));

 while (1) 
  {
   Bool recheck_link;

   if (!mstp_tick_enable) 
    {
     mstp_sleep (200);
     continue;
    }
   
   recheck_link=False;
   for (i = 0; i < MAX_LOGIC_PORT; i++) 
    {
     if(mstp_vlan_member_refreshed == True)
      {
       i=0;
       mstp_vlan_member_refreshed=False;
       recheck_link=True;
      }

     new_link = cclmx_PortGetLink (i);
     new_ebl = cclmx_PortGetEbl (i);
     cclmx_PortGetSpeedDuplex (i, &new_speed, &new_duplex);

//port duplex
     if (new_duplex != duplex[i] && new_duplex != CCLMX_PORT_DUPLEX_UNKNOWN) 
      {
       spin_lock(&mstp_sem);
       STP_IN_changed_port_duplex (i);
       spin_unlock(&mstp_sem);

       duplex[i] = new_duplex;
      }


//port speed
     if (new_speed != speed[i]) 
      {
       spin_lock(&mstp_sem);
       switch (new_speed) 
        {
         case CCLMX_PORT_SPEED_0:
          K_LPortMaskClrPort (&enabled_ports, i);
          STP_IN_changed_port_speed (i, 0);
          break;
         case CCLMX_PORT_SPEED_10:
          STP_IN_changed_port_speed (i, 10);
          break;
         case CCLMX_PORT_SPEED_20:
          STP_IN_changed_port_speed (i, 20);
          break;
         case CCLMX_PORT_SPEED_30:
          STP_IN_changed_port_speed (i, 30);
          break;
         case CCLMX_PORT_SPEED_40:
          STP_IN_changed_port_speed (i, 40);
          break;
         case CCLMX_PORT_SPEED_100:
          STP_IN_changed_port_speed (i, 100);
          break;
         case CCLMX_PORT_SPEED_200:
          STP_IN_changed_port_speed (i, 200);
          break;
         case CCLMX_PORT_SPEED_300:
          STP_IN_changed_port_speed (i, 300);
          break;
         case CCLMX_PORT_SPEED_400:
          STP_IN_changed_port_speed (i, 400);
          break;
         case CCLMX_PORT_SPEED_1000:
          STP_IN_changed_port_speed (i, 1000);
          break;
         case CCLMX_PORT_SPEED_2000:
          STP_IN_changed_port_speed (i, 2000);
          break;
        }
       spin_unlock(&mstp_sem);

       speed[i] = new_speed;
      }

//port link
//     if(recheck_link==False)
      {
       if (recheck_link==False && new_link == link[i] && new_ebl == ebl[i]) 
        {
         mstp_sleep (10);
         continue;
        }
       else if (new_link == CCLMX_PORT_LINKUP && new_ebl == CCLMX_PORT_ON) 
        {
        /* state: off -> on */
        spin_lock(&mstp_sem);
        K_LPortMaskSetPort (&enabled_ports, i);
        STP_IN_enable_port (i, True);
//printk("enable %d true\n",i);
        spin_unlock(&mstp_sem);
       }
      else if (link[i] == CCLMX_PORT_LINKUP && ebl[i] == CCLMX_PORT_ON) 
       {
       /* state: on -> off */
        spin_lock(&mstp_sem);
        K_LPortMaskClrPort (&enabled_ports, i);
        STP_IN_enable_port (i, False);
//printk("enable %d false\n",i);
        spin_unlock(&mstp_sem);
       }
      else
       ; /* state unchanged */
      }

     link[i] = new_link;
     ebl[i] = new_ebl;
#if 0
     if (new_link == CCLMX_PORT_LINKDOWN || new_link == CCLMX_PORT_INTRUNK) 
      {
       spin_lock(&mstp_sem);
 //      printk("link down\n");
       STP_IN_enable_port (i, False);
       spin_unlock(&mstp_sem);

       continue;
      }

     /* else: new_link == CCLMX_PORT_LINKUP */
     spin_lock(&mstp_sem);
  //     printk("link up\n");
     STP_IN_enable_port (i, True);
     spin_unlock(&mstp_sem);
#endif
    }
  }
 return 0;

}


/*-------------------------------------------------------------------------------*/
/*
   periodically run
 */

static int mstp_periodical_thread(void * vp)
{
#if 0
 int i;
#endif

 while(1) 
 {
  if(!mstp_tick_enable) 
   {
    mstp_sleep(1000);
    continue;
   }

  spin_lock(&mstp_sem); /* protect the ieee802.1s code */
  STP_IN_one_second();
  spin_unlock(&mstp_sem);

//rescan VLAN table
#if 0
  for(i=1;i<4095;i++)
  {
   struct SVlanEntry SEntry;

   if (HIiVLAN_GetTblEntry(i, &SEntry) != TBL_OP_OK) 
    {
     vlan_valid[i-1]=0;
    }
   else
    {
     vlan_valid[i-1]=1;
    }

  }
#endif

  mstp_sleep(100);
 }
 return 0;
}

/*-------------------------------------------------------------------------------*/
/* The CallBack function.
 * This function will get bpdu packets from
 * the VT6526 and report them to the ieee 802.1s code.
 */

/****************************************************************/
static int ccl_mstp_rx_bpdu(struct sk_buff *skb)
{
 MSTP_BPDU_T bpdu;
 unsigned char * ptr;
 int port_no;
 int i,v3_len;
 unsigned char * pucEthernet;
 unsigned short usL2len;

   if (!mstp_tick_enable) 
    {
     return CCL_MX_DROP;
    }

#ifdef STP_DBG3
 if(mstp_debug)
  printk("mstp receives a packet!! size=%d vid=%d pri=%d port=%d reason=%d tag=%d *************\n",
   CCL_LP(skb)->wSize, CCL_LP(skb)->wVid,
   CCL_LP(skb)->byPriority, CCL_LP(skb)->bySrcPortId,
   CCL_LP(skb)->byFwdReason,CCL_LP(skb)->bIfTagged);
#endif

 pucEthernet = (unsigned char *)skb->mac.raw;

#ifdef STP_DBG1
 if(mstp_debug)
 {
  for(i=0;i<20;i++)
   printk("%02X ",pucEthernet[i]);
  printk("\n");
 }
#endif

 usL2len=ntohs(*((unsigned short*)(pucEthernet+12)));
 if(usL2len==ntohs(0x8100)) //VLAN tag
  usL2len=ntohs(*((unsigned short*)(pucEthernet+16)));

// if (CCL_LP(skb)->wSize < 17) 
// if (usL2len < 17)
 if (usL2len < 7)
  {
  if(mstp_debug)
   printk("mstp: Error, packet too short! %d\n",usL2len);

   return CCL_MX_DROP;
  }

 /* SrcPortId starts from 0 in VIA driver,
  * and port_index starts from 0 in mstp */
 port_no = CCL_LP(skb)->bySrcPortId;

 if(CCL_LP(skb)->bIfTagged) 
  {
  if(mstp_debug)
   printk("mstp: tagged BPDU rcvd!\n"); /* TODO */
   return CCL_MX_DROP;
  }
 else 
  {
  /* skip DA,SA */
 
   ptr = (unsigned char *)(skb->mac.raw) + MAC_HEADER_T_SZ;
  /* Becuse cpu will auto-align structs, we copy them one by one
   * !!And, avoid to use sizeof(struct name) */
   memcpy (&bpdu.eth, ptr, ETH_HEADER_T_SZ);

   if(bpdu.eth.dsap!=0x42 || bpdu.eth.ssap != 0x42 || bpdu.eth.llc != 0x3)
    {
     return CCL_MX_DROP;
    }

   ptr += ETH_HEADER_T_SZ;
   memcpy (&bpdu.hdr, ptr, BPDU_HEADER_T_SZ);

   if(bpdu.hdr.protocol[0]!=0 || bpdu.hdr.protocol[1]!=0)
    {
     return CCL_MX_DROP;
    }

   ptr += BPDU_HEADER_T_SZ;
   memcpy (&bpdu.cist_body, ptr, BPDU_BODY_T_SZ);
#if 0
   printk("bpdu fg:%x root id:%02x%02x%02x%02x%02x%02x%02x%02x  ",
     bpdu.body.flags, bpdu.body.root_id[0],
     bpdu.body.root_id[1], bpdu.body.root_id[2],
     bpdu.body.root_id[3], bpdu.body.root_id[4],
     bpdu.body.root_id[5], bpdu.body.root_id[6],
     bpdu.body.root_id[7]);
   printk("ptr fg:%x root id:%02x%02x%02x%02x%02x%02x%02x%02x\n",
     *ptr, *(ptr+1), *(ptr+2), *(ptr+3), *(ptr+4),
     *(ptr+5), *(ptr+6), *(ptr+7), *(ptr+8));
   printk("bpdu RPC:%02x%02x%02x%02x  ptrRPC:%02x%02x%02x%02x\n",
     bpdu.body.root_path_cost[0], bpdu.body.root_path_cost[1],
     bpdu.body.root_path_cost[2], bpdu.body.root_path_cost[3],
     *(ptr+9), *(ptr+10), *(ptr+11), *(ptr+12));
   printk("bpdu bridge id:%02x%02x%02x%02x%02x%02x%02x%02x  ",
     bpdu.body.bridge_id[0], bpdu.body.bridge_id[1],
     bpdu.body.bridge_id[2], bpdu.body.bridge_id[3],
     bpdu.body.bridge_id[4], bpdu.body.bridge_id[5],
     bpdu.body.bridge_id[6], bpdu.body.bridge_id[7]);
   printk("ptr bridge id:%02x%02x%02x%02x%02x%02x%02x%02x\n",
     *(ptr+13), *(ptr+14), *(ptr+15), *(ptr+16),
     *(ptr+17), *(ptr+18), *(ptr+19), *(ptr+20));
   printk("bpdu port id:%02x%02x  ptr port id:%02x%02x\n",
     bpdu.body.port_id[0], bpdu.body.port_id[1],
     *(ptr+21), *(ptr+22));
   printk("bpdu msg age:%02x%02x  ptr msg age:%02x%02x\n",
     bpdu.body.message_age[0], bpdu.body.message_age[1],
     *(ptr+23), *(ptr+24));
   printk("bpdu max age:%02x%02x  ptr max age:%02x%02x\n",
     bpdu.body.max_age[0], bpdu.body.max_age[1],
     *(ptr+25), *(ptr+26));
   printk("bpdu hello:%02x%02x  ptr hello:%02x%02x\n",
     bpdu.body.hello_time[0], bpdu.body.hello_time[1],
     *(ptr+27), *(ptr+28));
   printk("bpdu fwd delay:%02x%02x  ptr fwd delay:%02x%02x\n",
     bpdu.body.forward_delay[0], bpdu.body.forward_delay[1],
     *(ptr+29), *(ptr+30));
#endif
   ptr += BPDU_BODY_T_SZ;
   memcpy (&(bpdu.ver_1_length), ptr, BPDU_V1_LEN_SZ);
   ptr += BPDU_V1_LEN_SZ;
 
  //ANVL 30.1 
   if((bpdu.hdr.protocol[0]==0 && bpdu.hdr.protocol[1]==0) && (bpdu.hdr.version>=3))
    {
     unsigned short bpdu_ver3_len;

     {
      unsigned short temp;

      temp=get_unaligned((unsigned short *)ptr);
      put_unaligned(ntohs(temp),(unsigned short *)bpdu.ver_3_length);
      ptr += BPDU_V3_LEN_SZ;
      v3_len=0;
     }
    
     memcpy (bpdu.MST_config_id, ptr, MSTP_CFG_ID_SZ);
     ptr += MSTP_CFG_ID_SZ;
     v3_len+=MSTP_CFG_ID_SZ;
  
     memcpy (bpdu.Cist_internal_root_path_cost, ptr, 4);
     ptr += 4;
     v3_len+=4;
  
     memcpy (bpdu.Cist_bridge_id, ptr, 8);
     ptr += 8;
     v3_len+=8;
  
     memcpy (&(bpdu.Cist_remainingHops), ptr, 1);
     ptr += 1;
     v3_len+=1;
   
     bpdu_ver3_len=get_unaligned((unsigned short *)(bpdu.ver_3_length));
     if((bpdu_ver3_len) > 64) 
      {
        
       for(i=0;i<((bpdu_ver3_len)-64)/MSTI_CFG_SZ;i++)
        {
         memcpy (&(bpdu.msti_conf[i].msti_flag), ptr, 1);
         ptr += 1;
         v3_len+=1;
         
         memcpy (bpdu.msti_conf[i].msti_internal_root_id, ptr, 8);
         ptr += 8;
         v3_len+=8;
         
         memcpy (bpdu.msti_conf[i].msti_internal_root_path_cost, ptr, 4);
         ptr += 4;
         v3_len+=4;
         
         memcpy (&(bpdu.msti_conf[i].msti_bridge_priority), ptr, 1);
         ptr += 1;
         v3_len+=1;
         
         memcpy (&(bpdu.msti_conf[i].msti_port_priority), ptr, 1);
         ptr += 1;
         v3_len+=1;
         
         memcpy (&(bpdu.msti_conf[i].msti_remainingHops), ptr, 1);
         ptr += 1;
         v3_len+=1;
        }
  if(mstp_debug)
       {
        if((bpdu_ver3_len) != v3_len)
         printk("Ver 3 length not match %d  %d\n",*(unsigned short *)(bpdu.ver_3_length),v3_len);
       }
      }
    }  
  }

  spin_lock(&mstp_sem);

// STP_IN_rx_bpdu (port_no, &bpdu , CCL_LP(skb)->wSize - sizeof(MAC_HEADER_T));
 STP_IN_rx_bpdu (port_no, &bpdu , (ntohs(*((unsigned short*)(pucEthernet+12)))) - sizeof(MAC_HEADER_T));

  spin_unlock(&mstp_sem);
#if 0
 {
  #include <xst.h>
  #include <xst_port.h>

  XST_T *cist;
  XST_PORT_T *port;
  int iii;

  cist=STP_xst_find(0);
  for(iii=0;iii<MAX_LOGIC_PORT;iii++)
   {
    port=&(cist->ports[iii]);
    if(port->transmit == NULL) 
     {
      printk("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"); 
      continue;
     }
    printk("      port %d tx state %d\n",iii,port->transmit->State);
   }
 }
#endif
 return CCL_MX_DROP;
}

/*-------------------------------------------------------------------------------*/
/* functions called by the code from ieee 802.1s */


void bridge_tx_bpdu(int port_no, unsigned char *bpdu_packet, size_t bpdu_len)
 {
  struct sk_buff *skb;
  MSTP_BPDU_T * bpdu = (MSTP_BPDU_T *) (bpdu_packet + MAC_HEADER_T_SZ);
  unsigned char *ptr;
  unsigned int msti_len;

 /* should not happen (mstp port_index also starts from 0) */
 if (port_no < 0) return;

#ifdef STP_DBG
#if 0
   printk("0: mst %02x %02x %02x \n",bpdu->MST_config_id[0],bpdu->MST_config_id[1],bpdu->MST_config_id[2]);
#endif
#endif

 bpdu_len += MAC_HEADER_T_SZ + 2; /* 2 is 802.3 len in BPDU_T */

 msti_len = bpdu_len;
#ifdef STP_DBG
#if 1
 printk("mstp: xmit a pkt %d in len on port %d\n", bpdu_len, port_no);
#endif
#endif

 /* Allocate and zero memory for message */
 {
  skb = dev_alloc_skb (bpdu_len);
  if (NULL == skb)
  {
#ifdef STP_DBG
   printk("mstp: memory allocation error while tx BPDU\n");
#endif
   return;
  }
  ptr = skb_put (skb, bpdu_len);
  memset (ptr, 0, bpdu_len);
 }
#ifdef STP_DBG
#if 0
 {
  int i;

  printk(" mstp: bpdu data:");
  for(i=0;i<30;i++)
   printk(" %02X", bpdu_packet[i]);
  printk("\n");
 }
#endif
#endif

 /* copy data */
 memcpy (ptr, bpdu_packet, MAC_HEADER_T_SZ);
 ptr += MAC_HEADER_T_SZ;
 msti_len -= MAC_HEADER_T_SZ;

 memcpy (ptr, &bpdu->eth, ETH_HEADER_T_SZ);
 if (bpdu->hdr.bpdu_type == BPDU_TOPO_CHANGE_TYPE) //TCN
  {
   ptr += ETH_HEADER_T_SZ;
   msti_len -= ETH_HEADER_T_SZ;
   memcpy (ptr, &bpdu->hdr, BPDU_HEADER_T_SZ);
  }

 if (bpdu->hdr.bpdu_type == BPDU_CONFIG_TYPE || bpdu->hdr.bpdu_type == BPDU_RSTP )
  {
   ptr += ETH_HEADER_T_SZ;
   msti_len -= ETH_HEADER_T_SZ;
   memcpy (ptr, &bpdu->hdr, BPDU_HEADER_T_SZ);
   ptr += BPDU_HEADER_T_SZ;
   msti_len -= BPDU_HEADER_T_SZ;
   memcpy (ptr, &bpdu->cist_body, BPDU_BODY_T_SZ);
  }
 if (bpdu->hdr.bpdu_type == BPDU_RSTP )
  {
   ptr += BPDU_BODY_T_SZ;
   msti_len -= BPDU_BODY_T_SZ;
   memcpy (ptr, &bpdu->ver_1_length, BPDU_V1_LEN_SZ);
  }

 if (bpdu->hdr.version >= BPDU_MSTP )
  {
   ptr += BPDU_V1_LEN_SZ;
   msti_len -= BPDU_V1_LEN_SZ;
   memcpy (ptr, (bpdu->ver_3_length), BPDU_V3_LEN_SZ);

   ptr += BPDU_V3_LEN_SZ;
   msti_len -= BPDU_V3_LEN_SZ;
   memcpy (ptr, &(bpdu->MST_config_id), MSTP_CFG_ID_SZ);
#if 0
   printk("ptr %02x %02x %02x \n",ptr[0],ptr[1],ptr[2]);
   printk("mst %02x %02x %02x \n",bpdu->MST_config_id[0],bpdu->MST_config_id[1],bpdu->MST_config_id[2]);
#endif

   ptr += MSTP_CFG_ID_SZ;
   msti_len -= MSTP_CFG_ID_SZ;
   memcpy (ptr, &bpdu->Cist_internal_root_path_cost, 4);

   ptr += 4;
   msti_len -= 4;
   memcpy (ptr, &bpdu->Cist_bridge_id, 8);

   ptr += 8;
   msti_len -= 8;
   memcpy (ptr, &bpdu->Cist_remainingHops, 1);

   ptr += 1;
   msti_len -= 1;
   memcpy(ptr,&bpdu->msti_conf,msti_len);
  }

 CCL_LP(skb)->wSize = bpdu_len;
 CCL_LP(skb)->wVid = 0;
 CCL_LP(skb)->byPriority = BPDU_PRIORITY;
//by flash, 2005/05/04
// put_unaligned (0x1L << port_no, (unsigned long *)&(CCL_LP(skb)->dwDstPortMsk));
	K_LPortMaskClrAll (&CCL_LP(skb)->dwDstPortMsk);
	K_LPortMaskSetPort (&CCL_LP(skb)->dwDstPortMsk, port_no);
     
//by flash, 2005/05/04
// put_unaligned (0, (unsigned long *) &(CCL_LP(skb)->dwTagPortMsk));
	K_LPortMaskClrAll (&CCL_LP(skb)->dwTagPortMsk);

 skb->dev=dev_get_by_name("eth0");

//by flash, 2005/05/04
// dev_queue_xmit(skb);
	cclmx_TxPkt (skb);

 //TODO: free packet?
} /* send_config_bpdu */

/*-------------------------------------------------------------------------------*/
#if 0
void CCL_MSTP_SetAllPortState(unsigned short vid, IN RSTP_PORT_STATE state)
{
  {
   switch (state) 
    {
     case UID_PORT_DISABLED:
      HIvMSTP_SetAllPortVlanState(vid, DISABLED);
      break;

     case UID_PORT_DISCARDING:
      HIvMSTP_SetAllPortVlanState(vid, BLOCKING);
      break;

     case UID_PORT_LEARNING:
      HIvMSTP_SetAllPortVlanState(vid, LEARNING);
      break;
     case UID_PORT_FORWARDING:
      HIvMSTP_SetAllPortVlanState(vid, FORWARDING);
      break;

     case UID_PORT_NON_STP:
     default:
      break;
    }

  }
}  

#endif
/*-------------------------------------------------------------------------------*/
void CCL_MSTP_SetPortState(unsigned short instance, int port_no, IN RSTP_PORT_STATE state)
{
 unsigned int vid;
 TstVlanMask stVlanMask;
 unsigned int i;

 if(instance>=MSTP_MAX_INSTANCE)  //single STP
  {
   switch (state) 
    {
     case UID_PORT_DISABLED:
  if(mstp_debug)
     printk("Setting port #%d in state DISABLED\n",port_no);

		    cclmx_PortSetStpState (port_no, STP_PORT_DISABLED);
      if(instance==0 && gvrp_stp_port_disabled!=NULL)
       gvrp_stp_port_disabled(port_no);
		    if (instance==0 && gmrp_stp_port_disabled != NULL)
			    gmrp_stp_port_disabled (port_no);
      if(instance==0 && igmp_stp_port_disabled!=NULL)
       igmp_stp_port_disabled(port_no);
      break;

     case UID_PORT_DISCARDING:
  if(mstp_debug)
   printk("Setting port #%d in state BLOCKING\n",port_no);

		    cclmx_PortSetStpState (port_no, STP_PORT_BLOCKING);
      break;

     case UID_PORT_LEARNING:
  if(mstp_debug)
   printk("Setting port #%d in state LEARNING\n",port_no);

    		cclmx_PortSetStpState (port_no, STP_PORT_LEARNING);
      break;
     case UID_PORT_FORWARDING:
  if(mstp_debug)
   printk("Setting port #%d in state FORWARDING\n",port_no);

		    cclmx_PortSetStpState (port_no, STP_PORT_FORWARDING);
      if(instance==0 && gvrp_stp_port_forwarding!=NULL)
       gvrp_stp_port_forwarding(port_no);
		    if (instance==0 && gmrp_stp_port_forwarding != NULL)
	    		gmrp_stp_port_forwarding (port_no);
      if(instance==0 && igmp_stp_port_forwarding!=NULL)
       igmp_stp_port_forwarding(port_no);
      break;

     case UID_PORT_NON_STP:
     default:
#ifdef STP_DBG
     printk("Illegal spanning tree state");
#endif
      break;
    }
  }
 else /*if(instance>=0 && instance < MSTP_MAX_INSTANCE) */ //multiple STP
  {
#if 0
   {
    static char rotate=0; 
    switch(rotate)
    {
     case 0:
            printk("%c",8);
            printk("-");
            break;
     case 1:
            printk("%c",8);
            printk("\\");
            break;
     case 2:
            printk("%c",8);
            printk("|");
            break;
     case 3:
            printk("%c",8);
            printk("-");
            break;
     case 4:
            printk("%c",8);
            printk("/");
            break;
    }
    rotate=(++rotate)%5;
   }
#endif
   memset((void *)stVlanMask.ulMask, 0, sizeof(unsigned long)*4096/32);

   for(vid=1;vid<4095;vid++)
    {
     if(!vlan_valid[vid-1]) continue;

     if(ntohs(vlan_instance_map[vid]) == instance)
      {
       stVlanMask.ulMask[vid/32]|=(1<<vid%32); 
      }
    }

   for(i=0;i<4096/32;i++)
   {
    if(stVlanMask.ulMask[i] != 0)
     break; 
   }
   if(i>=4096/32) //vlan mask == 0
    return;

   switch (state) 
    {
     case UID_PORT_DISABLED:
      cclmx_PortSetMStpState(instance, &stVlanMask, port_no, STP_PORT_DISABLED);
  if(mstp_debug)
     printk("Setting inst %d vlan %08X port #%d in state DISABLED\n",instance ,stVlanMask.ulMask[0],port_no);
  
      if(gvrp_stp_port_disabled!=NULL)
       gvrp_stp_port_disabled(port_no);
      if(igmp_stp_port_disabled!=NULL)
       igmp_stp_port_disabled(port_no);
      break;

     case UID_PORT_DISCARDING:
      cclmx_PortSetMStpState(instance, &stVlanMask, port_no, STP_PORT_BLOCKING);
  if(mstp_debug)
   printk("Setting inst %d vlan %08X port #%d in state BLOCKING\n",instance ,stVlanMask.ulMask[0],port_no);

      break;

     case UID_PORT_LEARNING:
      cclmx_PortSetMStpState(instance, &stVlanMask, port_no, STP_PORT_LEARNING);
  if(mstp_debug)
   printk("Setting inst %d vlan %08X port #%d in state LEARNING\n",instance ,stVlanMask.ulMask[0],port_no);
      break;
     case UID_PORT_FORWARDING:
      cclmx_PortSetMStpState(instance, &stVlanMask, port_no, STP_PORT_FORWARDING);
  if(mstp_debug)
   printk("Setting inst %d vlan %08X port #%d in state FORWARDING\n",instance ,stVlanMask.ulMask[0],port_no);
      if(gvrp_stp_port_forwarding!=NULL)
       gvrp_stp_port_forwarding(port_no);
      if(igmp_stp_port_forwarding!=NULL)
       igmp_stp_port_forwarding(port_no);
      break;

     case UID_PORT_NON_STP:
     default:
  if(mstp_debug)
     printk("Illegal spanning tree state");
      break;
    }

  }
}  

/*-------------------------------------------------------------------------------*/
static int mstp_thread_create(void)
{
#if 0
 unsigned long ulFourOctetsHigh = 0x80008030;
 unsigned long ulFourOctetsLow =  0x01030467;

 /* get switch MAC address and store into mstp_bridge_mac */
 ulFourOctetsHigh = (0x80000000) |
                    (mstp_bridge_mac[0] << 8) |
                    (mstp_bridge_mac[1]);
 ulFourOctetsLow = (mstp_bridge_mac[2] << 24) |
                   (mstp_bridge_mac[3] << 16) |
                   (mstp_bridge_mac[4] << 8) |
                   (mstp_bridge_mac[5]);
#endif

 spin_lock_init(&mstp_sem);

 periodical_thread_pid = kernel_thread ((int (*)(void *))mstp_periodical_thread, NULL, 0);
   
 port_thread_pid = kernel_thread ((int (*)(void *))mstp_port_thread, NULL, 0);
   

 return 1;
}

/*-------------------------------------------------------------------------------*/
static void mstp_cleanup(void)
 {
 //sem_destroy(&mstp_sem);
 //up(&mstp_sem);

 }

/*-------------------------------------------------------------------------------*/
/***************Module parameter information*********************/
MODULE_AUTHOR ("PinChuan Flash Liu <flash@itri.org.tw>");

static char mac[6]={0x01,0x80,0xC2,0x00,0x00,0x00};
static char mask[6]={0xFF,0xFF,0xFF,0xFF,0xFF,0xFF};
/*-------------------------------------------------------------------------------*/
/****************************************************************/
int mstp_enable(void)
 {
 int i;
 int j;

 for(i=0;i<MAX_LOGIC_PORT;i++)
		cclmx_PortSetStpState (i, STP_PORT_DISABLED);

 for(j=0;j<MSTP_MAX_INSTANCE;j++)
  for(i=0;i<MAX_LOGIC_PORT;i++)
   CCL_MSTP_SetPortState(j, i,UID_PORT_DISABLED);


  mstp_refresh_vlan_member();

  K_StpSetEbl(True);//enable BPDU forward to CPU

  K_StpSetMstpEbl(True);

  mstp_tick_enable=1;
 }

/*-------------------------------------------------------------------------------*/
int mstp_disable(void)
{
 int i;
 int j;

 K_StpSetEbl(False);
 K_StpSetMstpEbl(False);
 mstp_tick_enable=0;

 for(i=0;i<MAX_LOGIC_PORT;i++)
		cclmx_PortSetStpState (i, STP_PORT_FORWARDING);

 for(j=0;j<MSTP_MAX_INSTANCE;j++)
  for(i=0;i<MAX_LOGIC_PORT;i++)
   CCL_MSTP_SetPortState(j, i,UID_PORT_FORWARDING);

 return (0);
}
/*-------------------------------------------------------------------------------*/

int mstp_init(void)
 {
  UID_STP_CFG_T uid_cfg;
  int iii;
  int err_code;

  K_LPortMaskClrAll (&enabled_ports);

  strncpy(MSTP_ConfigName,"CCL",32);
  MSTP_RevisionLevel=0;         /* 0 */

  for(iii=0;iii<4096;iii++)
   {
    vlan_instance_map[iii]=0;
   }

  compute_digest(); //init mstp_digest

  mstp_refresh_vlan_member();

  STP_xst_init();
  STP_IN_init(MAX_LOGIC_PORT);
 
  for(iii=0;iii<MSTP_MAX_INSTANCE;iii++)
   {
    stp_in_xst_create (iii, &err_code); //create all instance

    if(iii==CIST_INSTANCE_ID)
     {
      memset(&uid_cfg, 0, sizeof(UID_STP_CFG_T));

      uid_cfg.field_mask = BR_CFG_STATE;
      uid_cfg.stp_enabled = STP_ENABLED;
 //flash, 20070523
 //     uid_cfg.stp_enabled = STP_DISABLED;
 
      snprintf (uid_cfg.name, BRIDGE_NAME_LEN, BRIDGE_NAME);
      STP_IN_xst_set_cfg (iii, &uid_cfg); //enable CIST
     }
   }

#ifdef STP_DBG
//  printk("end of mstp_init\n");
#endif   
  return 0;
 }

/*-------------------------------------------------------------------------------*/
int mstp_stop(void)
{
 mstp_disable();

#if 0
 for(i=MSTP_MAX_INSTANCE-1;i>=0;i--)
  {
   rc = STP_IN_xst_delete (i);
   if (STP_OK != rc) 
    {
#ifdef STP_DBG
//     printk ("FATAL: can't delete:%s\n", STP_IN_get_error_explanation (rc));
#endif
     return (-1);
    }
  }
#endif
 return (0);
}

/*-------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------*/
void mstp_add_inst(unsigned short instance, unsigned long *vlan)
{
 unsigned long i;
 UID_STP_CFG_T uid_cfg;
 XST_T *xst;
 int err_code;

 xst=STP_xst_find(instance);
 if(xst->valid==False)
  {
   stp_in_xst_create (instance, &err_code); //create MST
  }

 if(xst->valid==False) return;

 //set vlan_instance_map
 for(i=0;i<4094;i++)
  {
   /* clear old instance */
   if(ntohs(vlan_instance_map[i+1])==instance)
    vlan_instance_map[i+1]=0;

   if(((vlan[i/32]>>i%32)&0x01L)) 
   {
    vlan_instance_map[i+1]=htons(instance);
   }

  } 

 compute_digest(); //recompute mstp_digest


 memset(&uid_cfg, 0, sizeof(UID_STP_CFG_T));

 uid_cfg.field_mask = BR_CFG_STATE;
 uid_cfg.stp_enabled = STP_ENABLED;
 snprintf (uid_cfg.name, BRIDGE_NAME_LEN, BRIDGE_NAME);
 STP_IN_xst_set_cfg (instance, &uid_cfg); //enable MST


}
/*-------------------------------------------------------------------------------*/
void mstp_del_inst(unsigned short instance)
{
 int i;
 XST_T *xst;

 xst=STP_xst_find(instance);
 if(xst->valid==False) return;

// STP_IN_xst_delete (instance);
 STP_xst_enable(xst, STP_DISABLED); 

 //set vlan_instance_map
 for(i=0;i<4096;i++)
  {
   if(ntohs(vlan_instance_map[i+1])==instance)
    vlan_instance_map[i+1]=0;
  } 


 compute_digest(); //recompute mstp_digest
}
/*-------------------------------------------------------------------------------*/
static int __init ccl_mstp_init_module(void)
{
  int iii,j;

#if 0
 printk("============= CCL mstp program ============\n"); 
 printk("CCL mstp program\n");
 printk("===========================================\n");     
#endif

/*    num_tcn=0;*/
/*    last_tcn=jiffies;*/

 mstp_tick_enable = 0;
 mstp_vlan_member_refreshed=False;

 K_SysGetMac((Tuint8 *)mstp_bridge_mac);

//default disable
 mstp_disable();
 mstp_thread_create();

 if(nf_register_sockopt(&mstp_sockopts))
 {
  printk(" cannot register sockopt \n");
  return 1; /* 1 means something error */
 }
 ccl_mx_register(mac, mask, ccl_mstp_rx_bpdu);

 mstp_vlan_add=mstp_vlan_valid;
 mstp_vlan_del=mstp_vlan_invalid;

  for(iii=0;iii<4096;iii++)
   {
    vlan_instance_map[iii]=0;
    vlan_valid[iii]=0;
    for(j=0;j<LOGIC_MASK_LEN;j++)
     vlan_member[iii].ulMask[j]=0;
   }

  vlan_valid[0]=1;
  for(j=0;j<LOGIC_MASK_LEN;j++)
   vlan_member[0].ulMask[j]=0xFFFFffffl;

  strncpy(MSTP_ConfigName,"CCL",32);
  MSTP_RevisionLevel=0;         /* 0 */

  compute_digest(); //init mstp_digest
  
  mstp_init();

 return 0;
} 

/*-------------------------------------------------------------------------------*/
/****************************************************************/
static void __exit ccl_mstp_cleanup_module(void)
{
 mstp_vlan_add=NULL;
 mstp_vlan_del=NULL;

 mstp_stop();
 mstp_cleanup();
#if 0
 printk("=============CCL mstp program============\n"); 
 printk("Remove CCL mstp program\n");
 printk("===========================================\n");     
#endif

}


/****************************************************************/
module_init(ccl_mstp_init_module);
module_exit(ccl_mstp_cleanup_module);


