/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Path Cost monitoring state machine */

#include "mstp.h"
#include "base.h"
#include "xst.h"
#include "statmch.h"
#include "stp_to.h"		/* for STP_OUT_get_port_oper_speed */

#define STATES {        \
  CHOOSE(AUTO),         \
  CHOOSE(FORCE),        \
  CHOOSE(STABLE),       \
}

#define GET_STATE_NAME STP_extpcost_get_state_name
#include "choose.h"

static long computeAutoPCost (STATE_MACH_T *this)
 {
  long lret;
  register XST_PORT_T *port = this->owner.port;

  if (port->sendRSTP) { /* winfred: neighbor is rstp */
    if (port->ext_usedSpeed < 10L) { /* < 10Mb/s */
      lret = 20000000;
    } else if (port->ext_usedSpeed <= 10L) {
      lret = 2000000;
    } else if (port->ext_usedSpeed <= 20L) {
      lret = 1800000;
    } else if (port->ext_usedSpeed <= 30L) {
      lret = 1600000;
    } else if (port->ext_usedSpeed <= 40L) {
      lret = 1400000;
    } else if (port->ext_usedSpeed <= 100L) {
      lret = 200000;
    } else if (port->ext_usedSpeed <= 200L) {
      lret = 180000;
    } else if (port->ext_usedSpeed <= 300L) {
      lret = 160000;
    } else if (port->ext_usedSpeed <= 400L) {
      lret = 140000;
    } else if (port->ext_usedSpeed <= 1000L) {
      lret = 20000;
    } else if (port->ext_usedSpeed <= 2000L) {
      lret = 18000;
    } else if (port->ext_usedSpeed <= 10000L) {
      lret = 2000;
    } else if (port->ext_usedSpeed <= 100000L) {
      lret = 200;
    } else if (port->ext_usedSpeed <= 1000000L) {
      lret = 20;
    } else if (port->ext_usedSpeed <= 10000000L) {
      lret = 2;
    } else {
      /* > Tb/s */
      lret = 1;
    }
  }
  else {
    if (port->ext_usedSpeed < 10L) { /* < 10Mb/s */
      lret = 250;
    } else if (port->ext_usedSpeed <= 10L) {
      lret = 100;
    } else if (port->ext_usedSpeed <= 20L) {
      lret = 60;
    } else if (port->ext_usedSpeed <= 30L) {
      lret = 42;
    } else if (port->ext_usedSpeed <= 40L) {
      lret = 30;
    } else if (port->ext_usedSpeed <= 100L) {
      lret = 19;
    } else if (port->ext_usedSpeed <= 200L) {
      lret = 16;
    } else if (port->ext_usedSpeed <= 300L) {
      lret = 14;
    } else if (port->ext_usedSpeed <= 400L) {
      lret = 12;
    } else if (port->ext_usedSpeed <= 1000L) {
      lret = 4;
    } else if (port->ext_usedSpeed <= 2000L) {
      lret = 3;
    } else {
      lret = 1;
    }
  }

  return lret;
 }

static void updPortPathCost (XST_PORT_T * port)
 {
  port->reselect = True;
  port->selected = False;
 }

void STP_extpcost_enter_state (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;

  switch (this->State) 
   {
    case BEGIN:
       break;

    case AUTO:
       port->operSpeed = STP_OUT_get_port_oper_speed (port->port_index);
       port->ext_usedSpeed = port->operSpeed;
       port->operExtPCost = computeAutoPCost (this);
       break;

    case FORCE:
       port->operExtPCost = port->adminExtPCost;
       port->ext_usedSpeed = -1;
       break;

    case STABLE:
       updPortPathCost (port);
       break;
   }
 }

#define TRUNK_PORT_PATH_COST_AUTO /* force trunk path cost to be auto */
Bool STP_extpcost_check_conditions (STATE_MACH_T * this)
 {
  register XST_PORT_T *port = this->owner.port;

  switch (this->State) 
   {
    case BEGIN:
       return STP_hop_2_state (this, AUTO);

    case AUTO:
       return STP_hop_2_state (this, STABLE);

    case FORCE:
       return STP_hop_2_state (this, STABLE);

    case STABLE:
       if (ADMIN_PORT_PATH_COST_AUTO == port->adminExtPCost && port->operSpeed != port->ext_usedSpeed) 
        {
         return STP_hop_2_state (this, AUTO);
        }

       if (ADMIN_PORT_PATH_COST_AUTO != port->adminExtPCost && port->operExtPCost != port->adminExtPCost)  
        {

#ifdef TRUNK_PORT_PATH_COST_AUTO
               if (port->port_index <= PORT_ID_CPU)
                {
                 return STP_hop_2_state (this, FORCE);
                }
#else
         return STP_hop_2_state (this, FORCE);
#endif
        }


#ifdef TRUNK_PORT_PATH_COST_AUTO
        if (port->port_index > PORT_ID_CPU &&
            port->operSpeed != port->ext_usedSpeed) 
        {
              return STP_hop_2_state (this, AUTO);
        }
#endif
       break;
   }
  return False;
 }
