/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Note: this state mashine distinkts from described in P802.1t Clause 18. */
/* I am ready to discuss it                                                */

#include "mstp.h"
#include "base.h"
#include "xst.h"

#define STATES {        \
  CHOOSE(DISABLED),         \
  CHOOSE(DETECTED),     \
  CHOOSE(DELEAYED),     \
  CHOOSE(RESOLVED),     \
}

#define GET_STATE_NAME STP_edge_get_state_name
#include "choose.h"

#define DEFAULT_LINK_DELAY  3

extern unsigned char mstp_debug,mstp_debug_min,mstp_debug_max;

void STP_edge_enter_state (STATE_MACH_T * s)
 {
  register XST_PORT_T *port = s->owner.port;

#ifdef STP_DBG2
if(mstp_debug && port->port_index>=mstp_debug_min && port->port_index<=mstp_debug_max)
  printk(" STATE MACHINE: edge state:%s port %d \n", GET_STATE_NAME(s->State),port->port_index);
#endif 

  switch (s->State) 
   {
    case BEGIN:
       break;

    case DISABLED:
       port->operEdge = port->adminEdge;
       port->wasInitBpdu = False;
       port->lnkWhile = 0;
       port->portEnabled = False;
       break;

    case DETECTED:
       port->portEnabled = True;
       port->lnkWhile = port->LinkDelay;
       port->operEdge = False;
       break;

    case DELEAYED:
       break;

    case RESOLVED:
       port->lnkWhile = 0;
       if (!port->wasInitBpdu) 
        {
         port->operEdge = port->adminEdge;
        }
       break;
   }
 }

Bool STP_edge_check_conditions (STATE_MACH_T * s)
 {
  register XST_PORT_T *port = s->owner.port;

  switch (s->State) 
   {
    case BEGIN:
       return STP_hop_2_state (s, DISABLED);
    case DISABLED:
       if (port->adminEnable) 
        {
         return STP_hop_2_state (s, DETECTED);
        }
       break;
    case DETECTED:
       return STP_hop_2_state (s, DELEAYED);
    case DELEAYED:
       if (port->wasInitBpdu) 
        {
         return STP_hop_2_state (s, RESOLVED);
        }

       if (!port->lnkWhile) 
        {
         return STP_hop_2_state (s, RESOLVED);
        }

       if (!port->adminEnable) 
        {
         return STP_hop_2_state (s, DISABLED);
        }
       break;
    case RESOLVED:
       if (!port->adminEnable) 
        {
         return STP_hop_2_state (s, DISABLED);
        }
       break;
   }
  return False;
 }
