/***************************************************************************
 *
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *

***************************************************************************
*
 *  This work includes source codes from the http://www.st.rim.or.jp/~yumo/
 *  Copyright (C) Yumo (Katsuyuki Yumoto) 2000-2002
*/

/* $Id: vethcom.h,v 1.1.1.1 2009/02/17 09:44:45 anderson Exp $ */
/* VETH: A virtual ethernet device driver for Linux. 
 *
 * This device driver is an implementation of Aggregation of Multiple
 * Link Segments (IEEE 802.3ad).
 *
 * Author: Yumo (Katsuyuki Yumoto) 2000-2002
 *         yumoto@jpn.hp.com or yumo@st.rim.or.jp
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */ 

#include "krndef.h"
#include "krntrk.h"

/* Maximum number of devices to support. */
#define MAX_VETH	MAX_TRK_PORT
#define MAX_PHYIF	MAX_PHY_PORT
#define MAX_MEMBER	MAX_PORTS_PER_TRK

#define VETH_VER_MAJOR 0
#define VETH_VER_MINOR 1
#define VETH_VER_PATCH 0
#define LACP_ALIVE 	999
#define LACP_NOALIVE 888

#define VETH_MAGIC 0x3be5

#define LACP_BASE_CTL		     64+1024+64+64+500  //1716

/* actions */
#define VETHCTL_SET_MAX 	LACP_BASE_CTL+5
#define VETHCTL_GET_SYS_PRI 	LACP_BASE_CTL+9      //1725
#define VETHCTL_SET_SYS_PRI 	LACP_BASE_CTL+10
#define VETHCTL_ADD_PHYIF 	LACP_BASE_CTL+11
#define VETHCTL_DEL_PHYIF 	LACP_BASE_CTL+12
#define VETHCTL_GET_PORT_INFO 	LACP_BASE_CTL+13
#define VETHCTL_SET_PORT_INFO 	LACP_BASE_CTL+14
#define VETHCTL_GET_AGG_INFO 	LACP_BASE_CTL+15
#define VETHCTL_SET_AGG_INFO 	LACP_BASE_CTL+16
#define VETHCTL_VERSION 	LACP_BASE_CTL+17     //1733
#define VETHCTL_START	 	LACP_BASE_CTL+18
#define VETHCTL_STOP	 	LACP_BASE_CTL+19
#define VETHCTL_ALIVE	 	LACP_BASE_CTL+20
#define VETHCTL_MAX 		LACP_BASE_CTL+30

#define SUBKEY_UNKNOWN 0
#define SUBKEY_10M 1
#define SUBKEY_100M 2
#define SUBKEY_1000M 3

#define SUBKEY_MASK_UPPER 0xff00
#define SUBKEY_MASK_LOWER 0x00ff

	/* 43.4.2.2 */
#define PS_LACP_ACTIVITY    0x1
#define PS_LACP_TIMEOUT     0x2
#define PS_AGGREGATION      0x4
#define PS_SYNCHRONIZATION  0x8
#define PS_COLLECTING      0x10
#define PS_DISTRIBUTING    0x20
#define PS_DEFAULTED       0x40
#define PS_EXPIRED         0x80


/* Distributing Algorithm */
#define DIST_TCPUDPHASH 0x1
#define DIST_ROUNDROBIN 0x2

enum selected_val {
		SELECTED,
		UNSELECTED,
		STANDBY
};

struct u_port_info
{
	unsigned short actor_port_num; /* this is the port # assigned to this port */
	unsigned short actor_port_pri;
	int actor_port_agg_id;
	unsigned short actor_admin_port_key;
	unsigned short actor_oper_port_key;
	unsigned char actor_admin_port_state;
	unsigned char actor_oper_port_state;

	unsigned char partner_admin_sys[ETH_ALEN];
	unsigned char partner_oper_sys[ETH_ALEN];
	unsigned short partner_admin_sys_pri;
	unsigned short partner_oper_sys_pri;
	unsigned short partner_admin_key;
	unsigned short partner_oper_key;
	unsigned short partner_admin_port_num;
	unsigned short partner_oper_port_num;
	unsigned short partner_admin_port_pri;
	unsigned short partner_oper_port_pri;
	unsigned char partner_admin_port_state;
	unsigned char partner_oper_port_state;

	enum selected_val selected;
};


struct u_agg_info
{
	unsigned char agg_mac[ETH_ALEN];
	int agg_id;
	int ind_agg;
	int actor_admin_agg_key;
	int actor_oper_agg_key;
	unsigned char partner_sys[ETH_ALEN];
	int partner_sys_pri;
	int partner_oper_agg_key;
	int ready; /* calculated from ready_N of each port */

	unsigned long distmode;
};


struct u_drv_info {
	unsigned char major;
	unsigned char minor;
	unsigned char patch;
	char name[20]; /* driver name */
	char author[50];
};



/* vethconf is used for adding or removing physical i/f to/from
   virtual i/f by using ioctl() */

struct vethconf {
	unsigned short magic;
	int action;

	unsigned short pifId;
	unsigned short vifNo;
	char pif_module[40];
	unsigned int size;
	unsigned char *buf;
};

/*
 * Local variables:
 *  c-indent-level: 4
 *  c-basic-offset: 4
 *  tab-width: 4
 *  indent-tabs-mode: t
 * End:
 */
