#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnvlan.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_VlanTest_16_1 ()
{
        Tbool   bEbl;

        bEbl = Enable;
        K_VlanSetProtocolVlanEbl(bEbl);
        K_VlanGetProtocolVlanEbl(&bEbl);
        if (bEbl == Enable) {
                DBG0(printk("  [ OK ] K_VlanSetProtocolVlanEbl(Enable)\n"));
        }
        else {
                DBG0(printk("  [FAIL] K_VlanSetProtocolVlanEbl(Enable)\n"));
        }

        bEbl = Disable;
        K_VlanSetProtocolVlanEbl(bEbl);
        K_VlanGetProtocolVlanEbl(&bEbl);
        if (bEbl == Disable) {
                DBG0(printk("  [ OK ] K_VlanSetProtocolVlanEbl(Disable)\n"));
        }
        else {
                DBG0(printk("  [FAIL] K_VlanSetProtocolVlanEbl(Disable)\n"));
        }
}

void
K_VlanTest_16_2 ()
{
	Tuint8	aucMode[3];
	Tuint8	ucModeRet;
	Tuint8	ucI;
	
	aucMode[0] = 0;
	aucMode[1] = 1;
	aucMode[2] = 2;

	for (ucI = 0; ucI < 3; ucI++) {
		K_VlanSetMode(aucMode[ucI]);
		K_VlanGetMode(&ucModeRet);
        	if (ucModeRet == aucMode[ucI]) {
        	        DBG0(printk("  [ OK ] K_VlanSetMode(%d)\n", aucMode[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_VlanSetMode(%d)\n", aucMode[ucI]));
			DBG1(printk("         Step 1: Set K_VlanSetMode = %d\n", aucMode[ucI]));
                	DBG1(printk("         Step 2: Get K_VlanGetMode\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucMode[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucModeRet));
        	}
	}
}

void 
K_VlanTest_16_3 ()
{
	Tuint8	aucPortId[5];
	Tuint16	ausVlanId[1];
	Tuint16	usVlanIdRet;
	Tuint8	ucI;
	Tuint8	ucJ;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	ausVlanId[0] = 5;

	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 1; ucJ++) {
			K_VlanSetPvid(aucPortId[ucI], ausVlanId[ucJ]);
			K_VlanGetPvid(aucPortId[ucI], &usVlanIdRet);
			if (usVlanIdRet == ausVlanId[ucJ]) {
                		DBG0(printk("  [ OK ] K_VlanSetPvid(%d, %d)\n", aucPortId[ucI], ausVlanId[ucJ]));
			}
			else {
				DBG0(printk("  [FAIL] K_VlanSetPvid(%d, %d)\n", aucPortId[ucI], ausVlanId[ucJ]));
				DBG1(printk("         Step 1: Set K_VlanSetPvid with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  vlan id = %d\n", ausVlanId[ucJ]));
                		DBG1(printk("         Step 2: Get K_VlanGetPvid\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  vlan id = %d\n", ausVlanId[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  vlan id = %d\n", usVlanIdRet));
			}
		}
	}
}

void
K_VlanTest_16_4 ()
{
        Tuint8  aucPortId[5];
        Tuint8  aucFltrCfg[4];
        Tuint8  ucFltrCfgRet;
        Tuint8  ucI;
        Tuint8  ucJ;

        aucPortId[0] = 0;
        aucPortId[1] = 5;
        aucPortId[2] = 23;
        aucPortId[3] = 24;
        aucPortId[4] = 25;

        aucFltrCfg[0] = 0;
        aucFltrCfg[1] = 1;
        aucFltrCfg[2] = 2;
        aucFltrCfg[3] = 3;

        for (ucI = 0; ucI < 5; ucI++) {
                for (ucJ = 0; ucJ < 4; ucJ++) {
                        K_VlanSetIngrsFltrCfg(aucPortId[ucI], aucFltrCfg[ucJ]);
                        K_VlanGetIngrsFltrCfg(aucPortId[ucI], &ucFltrCfgRet);
                        if (ucFltrCfgRet == aucFltrCfg[ucJ]) {
                                DBG0(printk("  [ OK ] K_VlanSetIngrsFltrCfg(%d, %d)\n", aucPortId[ucI], aucFltrCfg[ucJ]));
                        }
                        else {
				DBG0(printk("  [FAIL] K_VlanSetIngrsFltrCfg(%d, %d)\n", aucPortId[ucI], aucFltrCfg[ucJ]));
				DBG1(printk("         Step 1: Set K_VlanSetIngrsFltrCfg with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  ingress filter = %d\n", aucFltrCfg[ucJ]));
                		DBG1(printk("         Step 2: Get K_VlanGetIngrsFltrCfg\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  ingress filter = %d\n", aucFltrCfg[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  ingress filter = %d\n", ucFltrCfgRet));
                        }
                }
        }
}

void
K_VlanTest_16_5 (
	)
{
	Tuint16		ausVlanId[3];
	Tbool		bStatic;
	Tbool		bStaticRet;
	TstPPortMask	astPortMask[3];
	TstPPortMask	stPortMaskRet;
	TstPPortMask	astTagMask[3];
	TstPPortMask	stTagMaskRet;
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint8		ucK;
	Tuint16		usRet;

	ausVlanId[0] = 1;			//vlan id: 1
	ausVlanId[1] = 5;			//vlan id: 5
	ausVlanId[2] = 4094;			//vlan id: 4094

	astPortMask[0].ulMask[0] = 0x2;		//port 1
	astPortMask[1].ulMask[0] = 0x1E;	//port 1, 2, 3, 4
	astPortMask[2].ulMask[0] = 0x7FFFFFF;	//all port
	
	astTagMask[0].ulMask[0] = 0x2;		//port 1 has tag
	astTagMask[1].ulMask[0] = 0x6;		//port 1, 2 has tag, 
						//port 3, 4 does not have tag
	astTagMask[2].ulMask[0] = 0xFFFF;	//port 	0 ~ port 15 has tag
						//port 16 ~ port 31 does not have tag
	/* static */
	DBG0(printk("  Static Vlan Test:\n"));
	bStatic = True;
	for (ucI = 0; ucI < 3; ucI++) {
		for (ucJ = 0; ucJ < 3; ucJ++) {
			K_VlanInsEntry(ausVlanId[ucI], bStatic, &(astPortMask[ucJ]), &(astTagMask[ucJ]));
			K_VlanGetEntry(ausVlanId[ucI], &bStaticRet, &stPortMaskRet, &stTagMaskRet);
			if (bStaticRet == bStatic && stPortMaskRet.ulMask[0] == astPortMask[ucJ].ulMask[0] && stTagMaskRet.ulMask[0] == astTagMask[ucJ].ulMask[0]) {
				DBG0(printk("  [ OK ] k_VlanInsEntry(%d, True, 0x%x, 0x%x)\n", ausVlanId[ucI], astPortMask[ucJ].ulMask[0], astTagMask[ucJ].ulMask[0]));
			}
			else {
				DBG0(printk("  [FAIL] K_VlanInsEntry(%d, True, 0x%x, 0x%x)\n", ausVlanId[ucI], astPortMask[ucJ].ulMask[0], astTagMask[ucJ].ulMask[0]));
				DBG1(printk("         Step 1: Set K_VlanInsEntry with parameter:\n"));
				DBG1(printk("         	  vlan id = %d\n", ausVlanId[ucI]));
				DBG1(printk("         	  static\n"));
				DBG1(printk("         	  member port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", astTagMask[ucJ].ulMask[0]));
                		DBG1(printk("         Step 2: Get K_VlanGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  static\n"));
				DBG1(printk("         	  member port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", astTagMask[ucJ].ulMask[0]));
                		DBG1(printk("                 But return value is\n"));
				if (bStaticRet == bStatic) {
					DBG1(printk("         	  static\n"));
				}
				else {
					DBG1(printk("         	  dynamic\n"));
				}
				DBG1(printk("         	  member port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", stTagMaskRet.ulMask[0]));
			}
			K_VlanDelEntry(ausVlanId[ucI]);
			usRet = K_VlanGetEntry(ausVlanId[ucI], &bStaticRet, &stPortMaskRet, &stTagMaskRet);
			if (usRet != KRN_RET_OK) {
				DBG0(printk("  [ OK ] k_VlanDelEntry(%d)\n", ausVlanId[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_VlanDelEntry(%d)\n", ausVlanId[ucI]));
				DBG1(printk("         Step 1: Set K_VlanDelEntry with vlan id: %d\n", ausVlanId[ucI]));
                		DBG1(printk("         Step 2: Get K_VlanGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                		DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
			}
		}
	}

	/* dynamic */
	DBG0(printk("  Dynamic Vlan Test:\n"));
	bStatic = False;
	for (ucI = 0; ucI < 3; ucI++) {
		for (ucJ = 0; ucJ < 3; ucJ++) {
			K_VlanInsEntry(ausVlanId[ucI], bStatic, &(astPortMask[ucJ]), &(astTagMask[ucJ]));
			K_VlanGetEntry(ausVlanId[ucI], &bStaticRet, &stPortMaskRet, &stTagMaskRet);
			if (bStaticRet == bStatic && stPortMaskRet.ulMask[0] == astPortMask[ucJ].ulMask[0] && stTagMaskRet.ulMask[0] == astTagMask[ucJ].ulMask[0]) {
				DBG0(printk("  [ OK ] k_VlanInsEntry(%d, Flase, 0x%x, 0x%x)\n", ausVlanId[ucI], astPortMask[ucJ].ulMask[0], astTagMask[ucJ].ulMask[0]));
			}
			else {
				DBG0(printk("  [FAIL] K_VlanInsEntry(%d, False, 0x%x, 0x%x)\n", ausVlanId[ucI], astPortMask[ucJ].ulMask[0], astTagMask[ucJ].ulMask[0]));
				DBG1(printk("         Step 1: Set K_VlanInsEntry with parameter:\n"));
				DBG1(printk("         	  vlan id = %d\n", ausVlanId[ucI]));
				DBG1(printk("         	  dynamic\n"));
				DBG1(printk("         	  member port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", astTagMask[ucJ].ulMask[0]));
                		DBG1(printk("         Step 2: Get K_VlanGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  dynamic\n"));
				DBG1(printk("         	  member port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", astTagMask[ucJ].ulMask[0]));
                		DBG1(printk("                 But return value is\n"));
				if (bStaticRet == bStatic) {
					DBG1(printk("         	  dynamic\n"));
				}
				else {
					DBG1(printk("         	  static\n"));
				}
				DBG1(printk("         	  member port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
				DBG1(printk("         	  tagged port mask = 0x%x\n", stTagMaskRet.ulMask[0]));
			}
			K_VlanDelEntry(ausVlanId[ucI]);
			usRet = K_VlanGetEntry(ausVlanId[ucI], &bStaticRet, &stPortMaskRet, &stTagMaskRet);
			if (usRet != KRN_RET_OK) {
				DBG0(printk("  [ OK ] k_VlanDelEntry(%d)\n", ausVlanId[ucI]));
			}
			else if (usRet == KRN_RET_OK) {
				DBG0(printk("  [FAIL] K_VlanDelEntry(%d)\n", ausVlanId[ucI]));
				DBG1(printk("         Step 1: Set K_VlanDelEntry with vlan id: %d\n", ausVlanId[ucI]));
                		DBG1(printk("         Step 2: Get K_VlanGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                		DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
			}
		}
	}
}

void
K_VlanTest_16_6 ()
{
	Tuint16		ausVlanId[2];
	Tuint16		usVlanIdRet;
	Tbool		bStatic;
	Tbool		bStaticRet;
	TstPPortMask	astPortMask[2][3];
	TstPPortMask	stPortMaskRet;
	TstPPortMask	astTagMask[2][3];
	TstPPortMask	stTagMaskRet;
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint16		usK;
	Tuint16		usRet;
	Tuint16		usSize;
	Tuint16		usCount;
	Tuint16		usStaticCount;
	Tuint16		usDynamicCount;
	Tuint8		aucType[3];

	ausVlanId[0] = 2;				//vlan id: 1
	ausVlanId[1] = 3;				//vlan id: 5

        astPortMask[0][0].ulMask[0] = 0x1;              //port 1
        astPortMask[0][1].ulMask[0] = 0x1E;             //port 1, 2, 3, 4
        astPortMask[0][2].ulMask[0] = 0xFFFFFFFF;       //all port

        astPortMask[1][0].ulMask[0] = 0x2;              //port 2
        astPortMask[1][1].ulMask[0] = 0x1E0;            //port 5, 6, 7, 8
        astPortMask[1][2].ulMask[0] = 0xFFFFFFFF;       //all port

	astTagMask[0][0].ulMask[0] = 0x2;		//port 1 has tag
	astTagMask[0][1].ulMask[0] = 0x6;		//port 1, 2 has tag, 
							//port 3, 4 does not have tag
	astTagMask[0][2].ulMask[0] = 0xFFFF;		//port 0 ~ port 15 has tag
							//port 16 ~ port 31 does not have tag

	astTagMask[1][0].ulMask[0] = 0x20;		//port 5 has tag
	astTagMask[1][1].ulMask[0] = 0x60;		//port 5, 6 has tag, 
							//port 7, 8 does not have tag
	astTagMask[1][2].ulMask[0] = 0xFFFF;		//port 	0 ~ port 15 has tag
							//port 16 ~ port 31 does not have tag

	aucType[0] = 0;		//all entries
	aucType[1] = 1;		//static entries
	aucType[2] = 2;		//dynamic entries
		
	for (ucI = 0; ucI < 3; ucI++) {
		DBG0(printk("vlan id %d:\n", ausVlanId[0]));
		DBG0(printk("  Port mask: 0x%x\n", astPortMask[0][ucI].ulMask[0]));
		DBG0(printk("   Tag mask: 0x%x\n", astTagMask[0][ucI].ulMask[0]));
		DBG0(printk("vlan id %d:\n", ausVlanId[1]));
		DBG0(printk("  Port mask: 0x%x\n", astPortMask[1][ucI].ulMask[0]));
		DBG0(printk("   Tag mask: 0x%x\n", astTagMask[1][ucI].ulMask[0]));
		for (ucJ = 0; ucJ < 3; ucJ++) {
                	usCount = 0;
			usStaticCount = 0;
			usDynamicCount = 0;
                	/* insert a static vlan entry */
                	bStatic = True;
			K_VlanInsEntry(ausVlanId[0], bStatic, &(astPortMask[0][ucI]), &(astTagMask[0][ucI]));
                	/* insert a dynamic vlan entry */
                	bStatic = False;
			K_VlanInsEntry(ausVlanId[1], bStatic, &(astPortMask[1][ucI]), &(astTagMask[1][ucI]));

                	K_VlanClrTbl(aucType[ucJ]);
                	K_VlanGetTblSize(&usSize);
                        for (usK = 0; usK < usSize; usK++) {
                                usRet = K_VlanGetTblEntry(usK, &usVlanIdRet, &bStaticRet, &stPortMaskRet, &stTagMaskRet);
                                if (usRet == KRN_RET_OK) {
                                        usCount++;
					if( bStaticRet == True)
						usStaticCount++;
					if( bStaticRet == False)
						usDynamicCount++;
				}
                        }
                        if (usCount == 0 && aucType[ucJ] == 0) {
                                DBG0(printk("  [ OK ] K_VlanClrTbl(%d)\n", aucType[ucJ]));
                        }
                        else if (usStaticCount == 0 && aucType[ucJ] == 1) {
                                DBG0(printk("  [ OK ] K_VlanClrTbl(%d)\n", aucType[ucJ]));
                        }
                        else if (usDynamicCount == 0 && aucType[ucJ] == 2) {
                                DBG0(printk("  [ OK ] K_VlanClrTbl(%d)\n", aucType[ucJ]));
                        }
                        else if (aucType[ucJ] == 0) {
				DBG0(printk("  [FAIL] K_VlanClrTbl(%d)\n", aucType[ucJ]));
				DBG1(printk("         Step 1: Set K_VlanClrTbl with type: %d\n", aucType[ucJ]));
                		DBG1(printk("         Step 2: Get K_VlanGetTblSize and K_VlanGetTblEntry\n"));
				DBG1(printk("         Step 3: K_vlanGetTblEntry should not return any \"KRN_RET_OK\"\n"));
                		DBG1(printk("                 But there are %d return vlaue is \"KRN_RET_OK\"\n", usCount));
                        }
                        else if (aucType[ucJ] == 1) {
				DBG0(printk("  [FAIL] K_VlanClrTbl(%d)\n", aucType[ucJ]));
				DBG1(printk("         Step 1: Set K_VlanClrTbl with type: %d\n", aucType[ucJ]));
                		DBG1(printk("         Step 2: Get K_VlanGetTblSize and K_VlanGetTblEntry\n"));
				DBG1(printk("         Step 3: K_vlanGetTblEntry should not return any \"KRN_RET_OK\" where vlan type is \"Static\"\n"));
                		DBG1(printk("                 But there are %d return vlaue is \"KRN_RET_OK\"\n", usCount));
                        }
                        else if ( aucType[ucJ] == 2) {
				DBG0(printk("  [FAIL] K_VlanClrTbl(%d)\n", aucType[ucJ]));
				DBG1(printk("         Step 1: Set K_VlanClrTbl with type: %d\n", aucType[ucJ]));
                		DBG1(printk("         Step 2: Get K_VlanGetTblSize and K_VlanGetTblEntry\n"));
				DBG1(printk("         Step 3: K_vlanGetTblEntry should not return any \"KRN_RET_OK\" where vlan type is \"Dynamic\"\n"));
                		DBG1(printk("                 But there are %d return vlaue is \"KRN_RET_OK\"\n", usCount));
                        }
		}
        }
}

void
K_VlanTest_16_7 ()
{
	TstPPortMask	stPortMask;
	Tuint8		ucI;
	Tuint16		usSize;
	Tuint16		usRet;
	Tuint16		usVlanIdRet;
	Tbool		bStaticRet;
	TstPPortMask	stPortMaskRet;
	TstPPortMask	stTagMaskRet;
	Tuint16		usCount;

	K_VlanSetProtocolVlanEbl(Disable);
	K_VlanSetMode(VLAN_MODE_PORT_BASED);
	K_VlanClrPortBased();
	stPortMask.ulMask[0] = 0x3FF;
	K_VlanAddPortBased(&stPortMask);
	K_VlanGetTblSize(&usSize);
	for (ucI = 0; ucI < usSize; ucI++) {
		usRet = K_VlanGetTblEntry(ucI, &usVlanIdRet, &bStaticRet, &stPortMaskRet, &stTagMaskRet);
		if (usRet == KRN_RET_OK) {
			usCount++;
		}
	}
	if (usCount == 10) {
		DBG0(printk("  [ OK ] K_VlanAddPortBased()\n"));
	}
	else {
		DBG0(printk("  [FAIL] K_VlanAddPortBased()\n"));
	}
	K_VlanClrPortBased();
	K_VlanGetTblSize(&usSize);
	for (ucI = 0; ucI < usSize; ucI++) {
		usRet = K_VlanGetTblEntry(ucI, &usVlanIdRet, &bStaticRet, &stPortMaskRet, &stTagMaskRet);
		if (usRet == KRN_RET_OK) {
			usCount++;
		}
	}
	if (usCount == 0) {
		DBG0(printk("  [ OK ] K_VlanClrPortBased()\n"));
	}
	else {
		DBG0(printk("  [FAIL] K_VlanClrPortBased()\n"));
	}
}

void
K_Test_Case_16 ()
{
        DBG0(printk("Case ID: 16.1\n"));
        K_VlanTest_16_1();
        DBG0(printk("Case ID: 16.2\n"));
        K_VlanTest_16_2();
        DBG0(printk("Case ID: 16.3\n"));
        K_VlanTest_16_3();
        DBG0(printk("Case ID: 16.4\n"));
        K_VlanTest_16_4();
        DBG0(printk("Case ID: 16.5\n"));
        K_VlanTest_16_5();
        DBG0(printk("Case ID: 16.6\n"));
        K_VlanTest_16_6();
#if 0
        DBG0(printk("Case ID: 16.7\n"));
        K_VlanTest_16_7();
#endif
}

