#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krntrk.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_TrkTest_15_1 ()
{
        Tuint8	aucHash[2];
	Tuint8	ucHashRet;
	Tuint8	ucI;

        aucHash[0] = 0;
	aucHash[1] = 1;
	
	for (ucI = 0; ucI < 2; ucI++) {
        	K_TrkSetMacHash(aucHash[ucI]);
        	K_TrkGetMacHash(&ucHashRet);
        	if (ucHashRet == aucHash[ucI]) {
        	        DBG0(printk("  [ OK ] K_TrkSetMacHash(%d)\n", aucHash[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_TrkSetMacHash(%d)\n", aucHash[ucI]));
			DBG1(printk("         Step 1: Set K_TrkSetMacHash = %d\n", aucHash[ucI]));
                	DBG1(printk("         Step 2: Get K_TrkGetMacHash\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucHash[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucHashRet));
        	}
	}
}

void
K_TrkTest_15_2 ()
{
        Tuint8	aucAlg[2];
	Tuint8	ucAlgRet;
	Tuint8	ucI;

        aucAlg[0] = 0;
	aucAlg[1] = 1;
	
	for (ucI = 0; ucI < 2; ucI++) {
        	K_TrkSetTcktGenAlg(aucAlg[ucI]);
        	K_TrkGetTcktGenAlg(&ucAlgRet);
        	if (ucAlgRet == aucAlg[ucI]) {
        	        DBG0(printk("  [ OK ] K_TrkSetTcktGenAlg(%d)\n", aucAlg[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_TrkSetTcktGenAlg(%d)\n", aucAlg[ucI]));
			DBG1(printk("         Step 1: Set K_TrkSetTcktGenAlg = %d\n", aucAlg[ucI]));
                	DBG1(printk("         Step 2: Get K_TrkGetTcktGenAlg\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucAlg[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucAlgRet));
        	}
	}
}

void
K_TrkTest_15_3 ()
{
        Tuint8	aucPortId[5];
	Tuint8	aucAggrId[1];
	Tuint8	ucAggrIdRet;
	Tuint8	ucI;
	Tuint8	ucJ;

        aucPortId[0] = 0;
	aucPortId[1] = 5;
        aucPortId[2] = 23;
        aucPortId[3] = 24;
        aucPortId[4] = 25;

	aucAggrId[0] = 1;
	
	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 1; ucJ++) {
        		K_TrkSetPortAggrId(aucPortId[ucI], aucAggrId[ucJ]);
        		K_TrkGetPortAggrId(aucPortId[ucI], &ucAggrIdRet);
        		if (ucAggrIdRet == aucAggrId[ucJ]) {
        		        DBG0(printk("  [ OK ] K_TrkSetPortAggrId(%d, %d)\n", aucPortId[ucI], aucAggrId[ucJ]));
        		}
        		else {
				DBG0(printk("  [FAIL] K_TrkSetPortAggrId(%d, %d)\n", aucPortId[ucI], aucAggrId[ucJ]));
				DBG1(printk("         Step 1: Set K_TrkSetPortAggrId with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  algorithm = %d\n", aucAggrId[ucJ]));
                		DBG1(printk("         Step 2: Get K_TrkGetPortAggrId\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  algorithm = %d\n", aucAggrId[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  algorithm = %d\n", ucAggrIdRet));
        		}
		}
	}
}

void
K_TrkTest_15_4 ()
{
        Tuint8	aucPortId[5];
	Tbool	bEbl;
	Tuint8	ucI;

        aucPortId[0] = 0;
	aucPortId[1] = 5;
        aucPortId[2] = 23;
        aucPortId[3] = 24;
        aucPortId[4] = 25;
	
	for (ucI = 0; ucI < 5; ucI++) {
		bEbl = Enable;
        	K_TrkSetPortStatus(aucPortId[ucI], bEbl);
        	K_TrkGetPortStatus(aucPortId[ucI], &bEbl);
        	if (bEbl == Enable) {
        	        DBG0(printk("  [ OK ] K_TrkSetPortStatus(%d, Enable)\n", aucPortId[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_TrkSetPortStatus(%d, Enable)\n", aucPortId[ucI]));
			DBG1(printk("         Step 1: Set K_TrkSetPortStatus with parameter :\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Enable\n"));
                	DBG1(printk("         Step 2: Get K_TrkGetPortStatus\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Enable\n"));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Disable\n"));
        	}

		bEbl = Disable;
        	K_TrkSetPortStatus(aucPortId[ucI], bEbl);
        	K_TrkGetPortStatus(aucPortId[ucI], &bEbl);
        	if (bEbl == Disable) {
        	        DBG0(printk("  [ OK ] K_TrkSetPortStatus(%d, Disable)\n", aucPortId[ucI]));
        	}
        	else {
			DBG1(printk("         Step 1: Set K_TrkSetPortStatus with parameter :\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Disable\n"));
                	DBG1(printk("         Step 2: Get K_TrkGetPortStatus\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Disable\n"));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  state = Enable\n"));
        	}
	}
}

void
K_TrkTest_15_5 ()
{
        Tuint8	aucPortId[5];
	Tuint8	aucAdmCri[1];
	Tuint8	ucAdmCriRet;
	Tuint8	ucI;
	Tuint8	ucJ;

        aucPortId[0] = 0;
	aucPortId[1] = 5;
        aucPortId[2] = 23;
        aucPortId[3] = 24;
        aucPortId[4] = 25;

	aucAdmCri[0] = 1;
	
	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 1; ucJ++) {
        		K_TrkSetPortAdmCri(aucPortId[ucI], aucAdmCri[ucJ]);
        		K_TrkGetPortAdmCri(aucPortId[ucI], &ucAdmCriRet);
        		if (ucAdmCriRet == aucAdmCri[ucJ]) {
        		        DBG0(printk("  [ OK ] K_TrkSetPortAdmCri(%d, %d)\n", aucPortId[ucI], aucAdmCri[ucJ]));
        		}
        		else {
				DBG0(printk("  [FAIL] K_TrkSetPortAdmCri(%d, %d)\n", aucPortId[ucI], aucAdmCri[ucJ]));
				DBG1(printk("         Step 1: Set K_TrkSetPortAdmCri with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  admission criteria = %d\n", aucAdmCri[ucJ]));
                		DBG1(printk("         Step 2: Get K_TrkGetPortAdmCri\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  admission criteria = %d\n", aucAdmCri[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  admission criteria = %d\n", ucAdmCriRet));
        		}
		}
	}
}

void
K_Test_Case_15 ()
{
        DBG0(printk("Case ID: 15.1\n"));
        K_TrkTest_15_1();
        DBG0(printk("Case ID: 15.2\n"));
        K_TrkTest_15_2();
        DBG0(printk("Case ID: 15.3\n"));
        K_TrkTest_15_3();
        DBG0(printk("Case ID: 15.4\n"));
        K_TrkTest_15_4();
        DBG0(printk("Case ID: 15.5\n"));
        K_TrkTest_15_5();
}

