#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnsys.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_SysTest_14_1 ()
{
	Tuint8	aucMacAddr[2][6];
	Tuint8	aucMacAddrRet[6];
	Tuint8	ucI;

	aucMacAddr[0][0] = 0x00;
	aucMacAddr[0][1] = 0x01;
	aucMacAddr[0][2] = 0x02;
	aucMacAddr[0][3] = 0x03;
	aucMacAddr[0][4] = 0x04;
	aucMacAddr[0][5] = 0x05;

	aucMacAddr[1][0] = 0x05;
	aucMacAddr[1][1] = 0x04;
	aucMacAddr[1][2] = 0x03;
	aucMacAddr[1][3] = 0x02;
	aucMacAddr[1][4] = 0x01;
	aucMacAddr[1][5] = 0x00;

	for (ucI = 0; ucI < 2; ucI++) {
		K_SysSetMac(aucMacAddr[ucI]);
		memset(aucMacAddrRet, 0, 6);
		K_SysGetMac(aucMacAddrRet);
		if (memcmp(aucMacAddr[ucI], aucMacAddrRet, 6) == 0) {
			DBG0(printk("  [ OK ] K_SysSetMac(%02X:%02X:%02X:%02X:%02X:%02X)\n", aucMacAddr[ucI][0], aucMacAddr[ucI][1], aucMacAddr[ucI][2], aucMacAddr[ucI][3], aucMacAddr[ucI][4], aucMacAddr[ucI][5]));
		}
		else {
			DBG0(printk("  [FAIL] K_SysSetMac(%02X:%02X:%02X:%02X:%02X:%02X)\n", aucMacAddr[ucI][0], aucMacAddr[ucI][1], aucMacAddr[ucI][2], aucMacAddr[ucI][3], aucMacAddr[ucI][4], aucMacAddr[ucI][5]));
			DBG1(printk("         Step 1: Set K_SysSetMac mac address: %02X:%02X:%02X:%02X:%02X:%02X\n", aucMacAddr[ucI][0], aucMacAddr[ucI][1], aucMacAddr[ucI][2], aucMacAddr[ucI][3], aucMacAddr[ucI][4], aucMacAddr[ucI][5]));
			DBG1(printk("         Step 2: Get K_SysGetMac\n"));
			DBG1(printk("         Step 3: Return value should be %02X:%02X:%02X:%02X:%02X:%02X\n", aucMacAddr[ucI][0], aucMacAddr[ucI][1], aucMacAddr[ucI][2], aucMacAddr[ucI][3], aucMacAddr[ucI][4], aucMacAddr[ucI][5]));
			DBG1(printk("                 But return value is %02X:%02X:%02X:%02X:%02X:%02X\n", aucMacAddrRet[0], aucMacAddrRet[1], aucMacAddrRet[2], aucMacAddrRet[3], aucMacAddrRet[4], aucMacAddrRet[5]));
		}
	}
}

void
K_Test_Case_14 (
        )
{
        DBG0(printk("Case ID: 14.1\n"));
        K_SysTest_14_1();
}

