#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnstp.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_StpTest_13_1 ()
{
        Tbool   bEbl;

        K_StpSetEbl(Enable);
	bEbl = Disable;
        K_StpGetEbl(&bEbl);
        if (bEbl == Enable) {
                DBG0(printk("  [ OK ] K_StpSetEbl(Enable)\n"));
        }
        else {
		DBG0(printk("  [FAIL] K_StpSetEbl(Enable)\n"));
		DBG1(printk("         Step 1: Set K_StpSetEbl \"Enable\"\n"));
                DBG1(printk("         Step 2: Get K_StpGetEbl\n"));
                DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                DBG1(printk("                 But return value is \"Disable\"\n"));
        }

        K_StpSetEbl(Disable);
        bEbl = Enable;
        K_StpGetEbl(&bEbl);
        if (bEbl == Disable) {
                DBG0(printk("  [ OK ] K_StpSetEbl(Disable)\n"));
        }
        else {
		DBG0(printk("  [FAIL] K_StpSetEbl(Disable)\n"));
		DBG1(printk("         Step 1: Set K_StpSetEbl \"Disable\"\n"));
                DBG1(printk("         Step 2: Get K_StpGetEbl\n"));
                DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                DBG1(printk("                 But return value is \"Enable\"\n"));
        }
}

void
K_StpTest_13_2 ()
{
	Tuint8	aucPortId[5];
	Tuint8	aucState[5];
	Tuint8	ucStateRet;
	Tuint8	ucI;
	Tuint8	ucJ;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;
	
	aucState[0] = 0;
	aucState[1] = 1;
	aucState[2] = 2;
	aucState[3] = 3;
	aucState[4] = 4;

	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 5; ucJ++) {
			K_StpSetPort(aucPortId[ucI], aucState[ucJ]);
			K_StpGetPort(aucPortId[ucI], &ucStateRet);
        		if (ucStateRet == aucState[ucJ]) {
        		        DBG0(printk("  [ OK ] K_StpSetPort(%d, %d)\n", aucPortId[ucI], aucState[ucJ]));
        		}
        		else {
				DBG0(printk("  [FAIL] K_StpSetPort(%d, %d)\n", aucPortId[ucI], aucState[ucJ]));
				DBG1(printk("         Step 1: Set K_StpSetPort with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  state = %d\n", aucState[ucJ]));
                		DBG1(printk("         Step 2: Get K_StpGetPort\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  state = %d\n", aucState[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  state = %d\n", ucStateRet));
        		}
		}
	}
}

void
K_Test_Case_13 ()
{
        DBG0(printk("Case ID: 13.1\n"));
        K_StpTest_13_1();
        DBG0(printk("Case ID: 13.2\n"));
        K_StpTest_13_2();
}

