#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnport.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_PortTest_12_1 ()
{
        Tuint8   ucPortId;
	Tbool	 bLink;

	ucPortId = 5;
        K_PortGetLink(ucPortId, &bLink);
        if (bLink == Enable) {
                DBG0(printk("  port %d is link up.\n", ucPortId));
        }
        else if (bLink == Disable) {
                DBG0(printk("  port %d is link down.\n", ucPortId));
        }
        /*if (bLink == Enable) {
                DBG0(printk("  [ OK ] K_PortGetLink(%d, &bLink), port %d is up\n", ucPortId, ucPortId);
        }
        else if (bLink == Disable) {
                DBG0(printk("  [FAIL] K_PortGetLink(%d, &bLink), port %d is down\n", ucPortId, ucPortId);
        }

        K_PortGetLink(ucPortId, &bLink);
        if (bLink == Disable) {
                DBG0(printk("  [ OK ] K_PortGetLink(%d, &blink), port %d is down\n", ucPortId, ucPortId);
        }
        else if (bLink == Enable) {
                DBG0(printk("  [FAIL] K_PortGetLink(%d, &bLink), port %d is up\n", ucPortId, ucPortId);
        }
*/
}

void
K_PortTest_12_2 ()
{
        Tuint8  aucPortId[5];
	Tbool   bEbl;
	Tuint8	ucI;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	for (ucI = 0; ucI < 5; ucI++) {
		bEbl = Enable;
        	K_PortSetEbl(aucPortId[ucI], bEbl);
        	K_PortGetEbl(aucPortId[ucI], &bEbl);
        	if (bEbl == Enable) {
                	DBG0(printk("  [ OK ] K_PortSetEbl(%d, Enable)\n", aucPortId[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_PortSetEbl(%d, Enable)\n", aucPortId[ucI]));
			DBG1(printk("         Step 1: Set K_PortSetEbl \"Enable\" with port id %d\n", aucPortId[ucI]));
                	DBG1(printk("         Step 2: Get K_PortGetEbl\n"));
                	DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                	DBG1(printk("                 But return value is \"Disable\"\n"));
        	}

		bEbl = Disable;
        	K_PortSetEbl(aucPortId[ucI], bEbl);
        	K_PortGetEbl(aucPortId[ucI], &bEbl);
        	if (bEbl == Disable) {
        	        DBG0(printk("  [ OK ] K_PortSetEbl(%d, Disable)\n", aucPortId[ucI]));
        	}
        	else {
			DBG0(printk("  [FAIL] K_PortSetEbl(%d, Disable)\n", aucPortId[ucI]));
			DBG1(printk("         Step 1: Set K_PortSetEbl \"Disable\" with port id %d\n", aucPortId[ucI]));
                	DBG1(printk("         Step 2: Get K_PortGetEbl\n"));
                	DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                	DBG1(printk("                 But return value is \"Enable\"\n"));
        	}
	}
}

void
K_PortTest_12_3 ()
{
	Tuint8	aucPortId[5];
	Tuint8	aucNego[3];
	Tuint8	ucNegoRet;
	Tuint8	ucI;
	Tuint8	ucJ;
	
	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	aucNego[0] = PORT_NEGO_FORCE;
	aucNego[1] = PORT_NEGO_AUTO;
	aucNego[2] = PORT_NEGO_NWAY_FORCE;
	
	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 3; ucJ++) {
        		K_PortSetNego(aucPortId[ucI], aucNego[ucJ]);
        		K_PortGetNego(aucPortId[ucI], &ucNegoRet);
        		if (ucNegoRet == aucNego[ucJ]) {
        		        DBG0(printk("  [ OK ] K_PortSetNego(%d, %d)\n", aucPortId[ucI], aucNego[ucJ]));
        		}
        		else {
				DBG0(printk("  [FAIL] K_PortSetNego(%d, %d)\n", aucPortId[ucI], aucNego[ucJ]));
				DBG1(printk("         Step 1: Set K_PortSetNego with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  negotiation mode = %d\n", aucNego[ucJ]));
                		DBG1(printk("         Step 2: Get K_PortGetNego\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  negotiation mode = %d\n", aucNego[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  negotiation mode = %d\n", ucNegoRet));
        		}
		}
	}
}

void
K_PortTest_12_4 (
	)
{
	Tuint8	aucPortId[5];
	Tuint8	aucSpeed[3];
	Tuint8	aucDuplex[2];
	Tuint8	ucSpeedRet;
	Tuint8	ucDuplexRet;
	Tuint8	ucI;
	Tuint8	ucJ;
	Tuint8	ucK;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;
	
	aucSpeed[0] = PORT_SPEED_10;
	aucSpeed[1] = PORT_SPEED_100;
	aucSpeed[2] = PORT_SPEED_1000;
	
	aucDuplex[0] = PORT_DUPLEX_HALF;
	aucDuplex[1] = PORT_DUPLEX_FULL;
        
	for (ucI = 0; ucI < 5; ucI++) {
		K_PortSetNego(aucPortId[ucI], PORT_NEGO_FORCE);
		for (ucJ = 0; ucJ < 3; ucJ++) {
			for (ucK = 0; ucK < 2; ucK++) {
				if (aucPortId[ucI] <= 23 && aucSpeed[ucJ] == PORT_SPEED_1000) {
					continue;  //port id 0 ~ 23 doesn't have 1000Mbps capability, so skip it
				}

				K_PortSetSpeedDuplex(aucPortId[ucI], aucSpeed[ucJ], aucDuplex[ucK]);
        			K_PortGetSpeedDuplex(aucPortId[ucI], &ucSpeedRet, &ucDuplexRet);
				if (ucSpeedRet == aucSpeed[ucJ] && ucDuplexRet == aucDuplex[ucK]) {
        			        DBG0(printk("  [ OK ] K_PortSetSpeedDuplex(%d, %d, %d)\n", aucPortId[ucI], aucSpeed[ucJ], aucDuplex[ucK]));
        			}
        			else {
					DBG0(printk("  [FAIL] K_PortSetSpeedDuplex(%d, %d, %d)\n", 
						aucPortId[ucI], aucSpeed[ucJ], aucDuplex[ucK]));
					DBG1(printk("         Step 1: Set K_PortSetSpeedDuplex with parameter:\n"));
					DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
					DBG1(printk("         	  speed mode = %d\n", aucSpeed[ucJ]));
					DBG1(printk("         	  duplex mode = %d\n", aucDuplex[ucK]));
                			DBG1(printk("         Step 2: Get K_PortGetSpeedDuplex\n"));
                			DBG1(printk("         Step 3: Return value should be\n"));
					DBG1(printk("         	  speed mode = %d\n", aucSpeed[ucJ]));
					DBG1(printk("         	  duplex mode = %d\n", aucDuplex[ucK]));
                			DBG1(printk("                 But return value is\n"));
					DBG1(printk("         	  speed mode = %d\n", ucSpeedRet));
					DBG1(printk("         	  duplex mode = %d\n", ucDuplexRet));
        			}
			}
		}
		K_PortSetNego(aucPortId[ucI], PORT_NEGO_AUTO);
	}
	
}

void
K_PortTest_12_5 ()
{
	Tuint8	aucPortId[5];
	Tuint8	aucSpeed[3];
	Tbool	bEblRet;
	Tuint8	ucI;
	Tuint8	ucJ;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	aucSpeed[0] = PORT_SPEED_10;
	aucSpeed[1] = PORT_SPEED_100;
	aucSpeed[2] = PORT_SPEED_1000;
	
	for (ucI = 0; ucI < 5; ucI++) {
		K_PortSetNego(aucPortId[ucI], PORT_NEGO_FORCE);
		for (ucJ = 0; ucJ < 3; ucJ++) {
			if (aucPortId[ucI] <= 23 && aucSpeed[ucJ] == PORT_SPEED_1000) {
				continue;  //port id 0 ~ 23 doesn't have 1000Mbps capability, so skip it
			}

#if 0
			DBG0(printk("  Port %d, speed %d, full duplex:\n", aucPortId[ucI], aucSpeed[ucJ]));
			K_PortSetSpeedDuplex(aucPortId[ucI], aucSpeed[ucJ], PORT_DUPLEX_FULL);
			/* set full duplex Enable */
			K_PortSetFlowCtrl(aucPortId[ucI], Enable, Disable);
			K_PortGetFlowCtrl(aucPortId[ucI], &bEblRet);
			if (bEblRet == Enable) {
				DBG0(printk("  [ OK ] K_PortSetFlowCtrl(%d, Enable, Disable)\n", aucPortId[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_PortSetFlowCtrl(%d, Enable, Disable)\n", aucPortId[ucI]));
				DBG1(printk("         Step 1: Set K_PortSetFlowCtrl with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  full duplex mode = \"Enable\"\n"));
				DBG1(printk("         	  half duplex mode = \"Disable\"\n"));
				DBG1(printk("         Step 2: Get K_PortGetFlowCtrl\n"));
				DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
				DBG1(printk("                 But return value is \"Disable\"\n"));
			}

			/* set full duplex Disable */
			K_PortSetFlowCtrl(aucPortId[ucI], Disable, Disable);
			K_PortGetFlowCtrl(aucPortId[ucI], &bEblRet);
			if (bEblRet == Disable) {
				DBG0(printk("  [ OK ] K_PortSetFlowCtrl(%d, Disable, Disable)\n", aucPortId[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_PortSetFlowCtrl(%d, Disable, Disable)\n", aucPortId[ucI]));
				DBG1(printk("         Step 1: Set K_PortSetFlowCtrl with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  full duplex mode = \"Disable\"\n"));
				DBG1(printk("         	  half duplex mode = \"Disable\"\n"));
				DBG1(printk("         Step 2: Get K_PortGetFlowCtrl\n"));
				DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
				DBG1(printk("                 But return value is \"Disable\"\n"));
			}

			DBG0(printk("  Port %d, speed %d, half duplex:\n", aucPortId[ucI], aucSpeed[ucJ]));
			K_PortSetSpeedDuplex(aucPortId[ucI], aucSpeed[ucJ], PORT_DUPLEX_HALF);
			/* set half duplex Enable */
			K_PortSetFlowCtrl(aucPortId[ucI], Enable, Enable);
			K_PortGetFlowCtrl(aucPortId[ucI], &bEblRet);
			if (bEblRet == Enable) {
				DBG0(printk("  [ OK ] K_PortSetFlowCtrl(%d, Enable, Enable)\n", aucPortId[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_PortSetFlowCtrl(%d, Enable, Enable)\n", aucPortId[ucI]));
				DBG1(printk("         Step 1: Set K_PortSetFlowCtrl with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  full duplex mode = \"Enable\"\n"));
				DBG1(printk("         	  half duplex mode = \"Enable\"\n"));
				DBG1(printk("         Step 2: Get K_PortGetFlowCtrl\n"));
				DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
				DBG1(printk("                 But return value is \"Enable\"\n"));
			}

			/* set half duplex Disable */
			K_PortSetFlowCtrl(aucPortId[ucI], Disable, Disable);
			K_PortGetFlowCtrl(aucPortId[ucI], &bEblRet);
			if (bEblRet == Disable) {
				DBG0(printk("  [ OK ] K_PortSetFlowCtrl(%d, Disable, Disable)\n", aucPortId[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_PortSetFlowCtrl(%d, Disable, Disable)\n", aucPortId[ucI]));
				DBG1(printk("         Step 1: Set K_PortSetFlowCtrl with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  full duplex mode = \"Disable\"\n"));
				DBG1(printk("         	  half duplex mode = \"Disable\"\n"));
				DBG1(printk("         Step 2: Get K_PortGetFlowCtrl\n"));
				DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
				DBG1(printk("                 But return value is \"Disable\"\n"));
			}
#endif
		}
		K_PortSetNego(aucPortId[ucI], PORT_NEGO_AUTO);
	}
}

void
K_PortTest_12_6 ()
{
	Tuint8	aucPortId[5];
	Tbool	bEbl;
	Tuint8 	ucI;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	for (ucI = 0; ucI < 5; ucI++) {
		bEbl = Enable;
		K_PortSetSecurity(aucPortId[ucI], bEbl);
		K_PortGetSecurity(aucPortId[ucI], &bEbl);
        	if (bEbl == Enable) {
                	DBG0(printk("  [ OK ] K_PortSetSecurity(%d, Enable)\n", aucPortId[ucI]));
	        }
        	else {
			DBG0(printk("  [FAIL] K_PortSetSecurity(%d, Enable)\n", aucPortId[ucI]));
			DBG1(printk("         Step 1: Set K_PortSetSecurity \"Enable\" with port id %d\n", aucPortId[ucI]));
                	DBG1(printk("         Step 2: Get K_PortGetSecurity\n"));
                	DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                	DBG1(printk("                 But return value is \"Disable\"\n"));
	        }
		
		bEbl = Disable;
		K_PortSetSecurity(aucPortId[ucI], bEbl);
		K_PortGetSecurity(aucPortId[ucI], &bEbl);
        	if (bEbl == Disable) {
                	DBG0(printk("  [ OK ] K_PortSetSecurity(%d, Disable)\n", aucPortId[ucI]));
	        }
        	else {
			DBG0(printk("  [FAIL] K_PortSetSecurity(%d, Disable)\n", aucPortId[ucI]));
			DBG1(printk("         Step 1: Set K_PortSetSecurity \"Disable\" with port id %d\n", aucPortId[ucI]));
                	DBG1(printk("         Step 2: Get K_PortGetSecurity\n"));
                	DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                	DBG1(printk("                 But return value is \"Enable\"\n"));
	        }
	}
}

void
K_PortTest_12_7 ()
{
	Tuint8	aucPortId[5];
	Tuint16	usRate;
	Tuint16	usRateRet;
	Tuint8 	ucI;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	for (ucI = 0; ucI < 5; ucI++) {
		usRate = 50;
		K_PortSetRateIngrs(aucPortId[ucI], usRate);
		K_PortGetRateIngrs(aucPortId[ucI], &usRateRet);
        	if (usRateRet == usRate) {
                	DBG0(printk("  [ OK ] K_PortSetRateIngrs(%d, %d)\n", aucPortId[ucI], usRate));
	        }
        	else {
			DBG0(printk("  [FAIL] K_PortSetRateIngrs(%d, %d)\n", aucPortId[ucI], usRate));
			DBG1(printk("         Step 1: Set K_PortSetRateIngrs with parameter:\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRate));
                	DBG1(printk("         Step 2: Get K_PortGetRateIngrs\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRate));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRateRet));
	        }
	}
}

void
K_PortTest_12_8 ()
{
	Tuint8	aucPortId[5];
	Tuint16	usRate;
	Tuint16	usRateRet;
	Tuint8 	ucI;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	for (ucI = 0; ucI < 5; ucI++) {
		usRate = 50;
		K_PortSetRateEgrs(aucPortId[ucI], usRate);
		K_PortGetRateEgrs(aucPortId[ucI], &usRateRet);
        	if (usRateRet == usRate) {
                	DBG0(printk("  [ OK ] K_PortSetRateEgrs(%d, %d)\n", aucPortId[ucI], usRate));
	        }
        	else {
			DBG0(printk("  [FAIL] K_PortSetRateEgrs(%d, %d)\n", aucPortId[ucI], usRate));
			DBG1(printk("         Step 1: Set K_PortSetRateEgrs with parameter:\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRate));
                	DBG1(printk("         Step 2: Get K_PortGetRateEgrs\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRate));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
			DBG1(printk("         	  bandwidth control = %d\n", usRateRet));
	        }
	}
}

void
K_Test_Case_12 ()
{
        DBG0(printk("Case ID: 12.1\n"));
        K_PortTest_12_1();
        DBG0(printk("Case ID: 12.2\n"));
        K_PortTest_12_2();
        DBG0(printk("Case ID: 12.3\n"));
        K_PortTest_12_3();
        DBG0(printk("Case ID: 12.4\n"));
        K_PortTest_12_4();
        DBG0(printk("Case ID: 12.5\n"));
        K_PortTest_12_5();
        DBG0(printk("Case ID: 12.6\n"));
        K_PortTest_12_6();
        DBG0(printk("Case ID: 12.7\n"));
        K_PortTest_12_7();
        DBG0(printk("Case ID: 12.8\n"));
        K_PortTest_12_8();
}

