/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

#ifdef __LINUX_2_6_19__
#include <asm/uaccess.h>
#else
#include <linux/compatmac.h>
#endif
#include <linux/netfilter.h>

#include "krndef.h"
#include "krnerr.h"
#include "krnfwd.h"
#include "krngmrp.h"
#include "krngvrp.h"
#include "krnigmp.h"
#include "krnipmcst.h"
#include "krnlacp.h"
#include "krnmac.h"
#include "krnmib.h"
#include "krnmib_etherlike.h"
#include "krnmib_rmon.h"
#include "krnmod.h"
#include "krnport.h"
#include "krnstp.h"
#include "krnsys.h"
#include "krntrk.h"
#include "krntype.h"
#include "krnvlan.h"
#include "../cclmx/ccl_mx.h"
#include "../cclmx/ccl.h"

#include "krntest_log.h"
#include "krntest_netfilter.h"

/* This function is called whenever a process tries to do setsockopt */
int do_krntest_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
	switch (cmd)
	{
	case KRN_TEST_SET_TEST:
		break;
	default:
		break;
	}

	return 0;
}


/* This function is called whenever a process tries to do getsockopt */
int do_krntest_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{
	TstKrnTest	stKrnTest;

	switch (cmd)
	{
	case KRN_TEST_GET_TEST:
		copy_from_user(&stKrnTest, user, sizeof(TstKrnTest));
		if (stKrnTest.usCaseID == 0)
			K_Test_All(&stKrnTest);
		switch	(stKrnTest.usCaseID / 100) {
			case	1:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_1();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_Dot1xTest_1_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	2:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_2();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_FwdTest_2_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_FwdTest_2_2();
				else if (stKrnTest.usCaseID % 100 == 3)
					K_FwdTest_2_3();
				else if (stKrnTest.usCaseID % 100 == 4)
					K_FwdTest_2_4();
				else if (stKrnTest.usCaseID % 100 == 5)
					K_FwdTest_2_5();
				else if (stKrnTest.usCaseID % 100 == 6)
					K_FwdTest_2_6();
				else if (stKrnTest.usCaseID % 100 == 7)
					K_FwdTest_2_7();
				else if (stKrnTest.usCaseID % 100 == 8)
					K_FwdTest_2_8();
				else if (stKrnTest.usCaseID % 100 == 9)
					K_FwdTest_2_9();
				else if (stKrnTest.usCaseID % 100 == 10)
					K_FwdTest_2_10();
				else if (stKrnTest.usCaseID % 100 == 11)
					K_FwdTest_2_11();
				else if (stKrnTest.usCaseID % 100 == 12)
					K_FwdTest_2_12();
				else if (stKrnTest.usCaseID % 100 == 13)
					K_FwdTest_2_13();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	3:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_3();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_GmrpTest_3_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	4:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_4();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_GvrpTest_4_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	5:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_5();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_MacTest_5_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_MacTest_5_2();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	6:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_6();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_IgmpTest_6_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	7:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_7();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_IpMcstTest_7_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_IpMcstTest_7_2();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	8:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_8();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_LacpTest_8_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	9:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_9();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	10:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_10();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	11:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_11();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	12:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_12();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_PortTest_12_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_PortTest_12_2();
				else if (stKrnTest.usCaseID % 100 == 3)
					K_PortTest_12_3();
				else if (stKrnTest.usCaseID % 100 == 4)
					K_PortTest_12_4();
				else if (stKrnTest.usCaseID % 100 == 5)
					K_PortTest_12_5();
				else if (stKrnTest.usCaseID % 100 == 6)
					K_PortTest_12_6();
				else if (stKrnTest.usCaseID % 100 == 7)
					K_PortTest_12_7();
				else if (stKrnTest.usCaseID % 100 == 8)
					K_PortTest_12_8();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	13:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_13();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_StpTest_13_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_StpTest_13_2();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	14:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_14();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_SysTest_14_1();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	15:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_15();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_TrkTest_15_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_TrkTest_15_2();
				else if (stKrnTest.usCaseID % 100 == 3)
					K_TrkTest_15_3();
				else if (stKrnTest.usCaseID % 100 == 4)
					K_TrkTest_15_4();
				else if (stKrnTest.usCaseID % 100 == 5)
					K_TrkTest_15_5();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			case	16:
				if (stKrnTest.usCaseID % 100 == 0)
					K_Test_Case_16();
				else if (stKrnTest.usCaseID % 100 == 1)
					K_VlanTest_16_1();
				else if (stKrnTest.usCaseID % 100 == 2)
					K_VlanTest_16_2();
				else if (stKrnTest.usCaseID % 100 == 3)
					K_VlanTest_16_3();
				else if (stKrnTest.usCaseID % 100 == 4)
					K_VlanTest_16_4();
				else if (stKrnTest.usCaseID % 100 == 5)
					K_VlanTest_16_5();
				else if (stKrnTest.usCaseID % 100 == 6)
					K_VlanTest_16_6();
				else if (stKrnTest.usCaseID % 100 == 7)
					K_VlanTest_16_7();
				else
					DBG0(printk("Invalid case ID!\n"));
				break;
			default:
				break;
		}
		copy_to_user(user, &stKrnTest, sizeof(TstKrnTest));
		break;
	default:
		break;
	}

	return 0;
}

struct nf_sockopt_ops krntest_sockopts = {
	{ NULL, NULL }, PF_INET,
	KRN_TEST_BASE_CTL, KRN_TEST_SET_MAX+1, do_krntest_set_ctl, NULL,
	KRN_TEST_BASE_CTL, KRN_TEST_GET_MAX+1, do_krntest_get_ctl, NULL
};

