#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnmac.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_MacTest_5_1 ()
{
        Tuint8 		aucMac[2][6];
	Tuint16		ausFid[3];
	Tuint16		usFidRet;
	Tbool		bstatic;
	TstPPortMask	astPortMask[4];
	TstPPortMask	stPortMaskRet;
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint16		usRet;

	/* set aucMac[0] as 00:01:02:03:04:05, unicast address */
	aucMac[0][0] = 0x00;
	aucMac[0][1] = 0x01;
	aucMac[0][2] = 0x02;
	aucMac[0][3] = 0x03;
	aucMac[0][4] = 0x04;
	aucMac[0][5] = 0x05;
	
	/* set aucMac[0] as 01:00:5E:01:02:03, multicast address */
	aucMac[1][0] = 0x01;
	aucMac[1][1] = 0x00;
	aucMac[1][2] = 0x5E;
	aucMac[1][3] = 0x01;
	aucMac[1][4] = 0x02;
	aucMac[1][5] = 0x03;

	ausFid[0] = 1;
	ausFid[1] = 7;
	ausFid[2] = 4094;

	astPortMask[0].ulMask[0] = 0x0;		//no port
	astPortMask[1].ulMask[0] = 0x40;	//port 7
	astPortMask[2].ulMask[0] = 0x484;	//port 3, 8, 11
	astPortMask[3].ulMask[0] = 0x3FFFFFF;	//all ports

	/* unicast */
	for (ucI = 0; ucI < 3; ucI++) {	
		/* unicast static */
		K_MacInsEntry(aucMac[0], ausFid[ucI], True, &(astPortMask[1]));
		usFidRet = 0;
		bstatic = False;
		memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
		K_MacGetEntry(aucMac[0], &usFidRet, &bstatic, &stPortMaskRet);
		stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
		if (usFidRet == ausFid[ucI] && bstatic == True && stPortMaskRet.ulMask[0] == astPortMask[1].ulMask[0]) {
			DBG0(printk("  [ OK ] K_MacInsEntry(00:01:02:03:04:05, %d, True, 0x%X)\n", ausFid[ucI], astPortMask[1].ulMask[0]));
		}
		else {
			DBG0(printk("  [FAIL] K_MacInsEntry(00:01:02:03:04:05, %d, True, 0x%x)\n", 
				ausFid[ucI], astPortMask[1].ulMask[0]));
			DBG1(printk("         Step 1: Set K_MacInsEntry with parameter:\n"));
			DBG1(printk("         	  mac address = 00:01:02:03:04:05\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
			DBG1(printk("         	  static\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[1].ulMask[0]));
                	DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
			DBG1(printk("         	  static\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[1].ulMask[0]));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  filtering database id = %d\n", usFidRet));
			if (bstatic == True) {
				DBG1(printk("         	  static\n"));
			}
			else {
				DBG1(printk("         	  dynamic\n"));
			}
			DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
		}
		K_MacDelEntry(aucMac[0], ausFid[ucI]);
		usFidRet = 0;
		bstatic = False;
		memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
		usRet = K_MacGetEntry(aucMac[0], &usFidRet, &bstatic, &stPortMaskRet);
		stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
		if (usRet != KRN_RET_OK) {
			DBG0(printk("  [ OK ] K_MacDelEntry(00:01:02:03:04:05, %d)\n", ausFid[ucI]));
		}
		else {
			DBG0(printk("  [FAIL] K_MacDelEntry(00:01:02:03:04:05, %d)\n", ausFid[ucI]));
			DBG1(printk("         Step 1: Set K_MacdelEntry with parameter:\n"));
			DBG1(printk("         	  mac address = 00:01:02:03:04:05\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
                	DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                	DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
		}
		/* unicast dynamic */
		K_MacInsEntry(aucMac[0], ausFid[ucI], False, &(astPortMask[1]));
		usFidRet = 0;
		bstatic = True;
		memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
		K_MacGetEntry(aucMac[0], &usFidRet, &bstatic, &stPortMaskRet);
		stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
		if (usFidRet == ausFid[ucI] && bstatic == False && stPortMaskRet.ulMask[0] == astPortMask[1].ulMask[0]) {
			DBG0(printk("  [ OK ] K_MacInsEntry(00:01:02:03:04:05, %d, False, 0x%X)\n", ausFid[ucI], astPortMask[1].ulMask[0]));
		}
		else {
			DBG0(printk("  [FAIL] K_MacInsEntry(00:01:02:03:04:05, %d, False, 0x%x)\n", ausFid[ucI], astPortMask[1].ulMask[0]));
			DBG1(printk("         Step 1: Set K_MacInsEntry with parameter:\n"));
			DBG1(printk("         	  mac address = 00:01:02:03:04:05\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
			DBG1(printk("         	  dynamic\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[1].ulMask[0]));
                	DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
			DBG1(printk("         	  dynamic\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[1].ulMask[0]));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  filtering database id = %d\n", usFidRet));
			if (bstatic == True) {
				DBG1(printk("         	  static\n"));
			}
			else {
				DBG1(printk("         	  dynamic\n"));
			}
			DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
		}
		K_MacDelEntry(aucMac[0], ausFid[ucI]);
		usFidRet = 0;
		bstatic = True;
		memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
		usRet = K_MacGetEntry(aucMac[0], &usFidRet, &bstatic, &stPortMaskRet);
		stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
		if (usRet != KRN_RET_OK) {
			DBG0(printk("  [ OK ] K_MacDelEntry(01:02:03:04:05:06, %d)\n", ausFid[ucI]));
		}
		else {
			DBG0(printk("  [FAIL] K_MacDelEntry(00:01:02:03:04:05, %d)\n", ausFid[ucI]));
			DBG1(printk("         Step 1: Set K_MacDelEntry with parameter:\n"));
			DBG1(printk("         	  mac address = 00:01:02:03:04:05\n"));
			DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
                	DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                	DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
		}
	}

	/* multicast */
	for (ucI = 0; ucI < 3; ucI++) {
		for (ucJ = 0; ucJ < 4; ucJ++) {
			/* multicast static */
			K_MacInsEntry(aucMac[1], ausFid[ucI], True, &(astPortMask[ucJ]));
			usFidRet = 0;
			bstatic = False;
			memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
			K_MacGetEntry(aucMac[1], &usFidRet, &bstatic, &stPortMaskRet);
			stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
			if (usFidRet == ausFid[ucI] && bstatic == True && stPortMaskRet.ulMask[0] == astPortMask[ucJ].ulMask[0]) {
				DBG0(printk("  [ OK ] K_MacInsEntry(01:00:5E:01:02:03, %d, True, 0x%X)\n", ausFid[ucI], astPortMask[ucJ].ulMask[0]));
			}
			else {
				DBG0(printk("  [FAIL] K_MacInsEntry(01:00:5E:01:02:03, %d, True, 0x%x)\n", 
					ausFid[ucI], astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         Step 1: Set K_MacInsEntry with parameter:\n"));
				DBG1(printk("         	  mac address = 01:00:5E:01:02:03\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
				DBG1(printk("         	  static\n"));
				DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
                		DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
				DBG1(printk("         	  static\n"));
				DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  filtering database id = %d\n", usFidRet));
				if (bstatic == True) {
					DBG1(printk("         	  static\n"));
				}
				else {
					DBG1(printk("         	  dynamic\n"));
				}
				DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
			}
			K_MacDelEntry(aucMac[1], ausFid[ucI]);
			usFidRet = 0;
			bstatic = False;
			memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
			usRet = K_MacGetEntry(aucMac[1], &usFidRet, &bstatic, &stPortMaskRet);
			stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
			if (usRet != KRN_RET_OK) {
				DBG0(printk("  [ OK ] K_MacDelEntry(01:00:5E:01:02:03, %d)\n", ausFid[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_MacDelEntry(01:00:5E:01:02:03, %d)\n", ausFid[ucI]));
				DBG1(printk("         Step 1: Set K_MacDelEntry with parameter:\n"));
				DBG1(printk("         	  mac address = 01:00:5E:01:02:03\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
                		DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                		DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
			}
		
			/* multicast dynamic */
			K_MacInsEntry(aucMac[1], ausFid[ucI], False, &(astPortMask[ucJ]));
			usFidRet = 0;
			bstatic = True;
			memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
			K_MacGetEntry(aucMac[1], &usFidRet, &bstatic, &stPortMaskRet);
			stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
			if (usFidRet == ausFid[ucI] && bstatic == False && stPortMaskRet.ulMask[0] == astPortMask[ucJ].ulMask[0]) {
				DBG0(printk("  [ OK ] K_MacInsEntry(01:00:5E:01:02:03, %d, False, 0x%X)\n", ausFid[ucI], astPortMask[ucJ].ulMask[0]));
			}
			else {
				DBG0(printk("  [FAIL] K_MacInsEntry(01:00:5E:01:02:03, %d, False, 0x%x)\n", ausFid[ucI], astPortMask[ucJ].ulMask[0]));
				DBG1(printk("         Step 1: Set K_MacInsEntry with parameter:\n"));
				DBG1(printk("         	  mac address = 01:00:5E:01:02:03\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
				DBG1(printk("         	  dynamic\n"));
				DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
                		DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
				DBG1(printk("         	  dynamic\n"));
				DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucJ].ulMask[0]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  filtering database id = %d\n", usFidRet));
				if (bstatic == True) {
					DBG1(printk("         	  static\n"));
				}
				else {
					DBG1(printk("         	  dynamic\n"));
				}
				DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
			}
			K_MacDelEntry(aucMac[1], ausFid[ucI]);
			usFidRet = 0;
			bstatic = True;
			memset(&stPortMaskRet, 0, sizeof(TstPPortMask));
			usRet = K_MacGetEntry(aucMac[1], &usFidRet, &bstatic, &stPortMaskRet);
			stPortMaskRet.ulMask[0] &= 0x3FFFFFF; /* disregard CPU port */
			if (usRet != KRN_RET_OK) {
				DBG0(printk("  [ OK ] K_MacDelEntry(01:00:5E:01:02:03, %d)\n", ausFid[ucI]));
			}
			else {
				DBG0(printk("  [FAIL] K_MacDelEntry(01:00:5E:01:02:03, %d)\n", ausFid[ucI]));
				DBG1(printk("         Step 1: Set K_MacDelEntry with parameter:\n"));
				DBG1(printk("         	  mac address = 01:00:5E:01:02:03\n"));
				DBG1(printk("         	  filtering database id = %d\n", ausFid[ucI]));
                		DBG1(printk("         Step 2: Get K_MacGetEntry\n"));
                		DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                		DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
			}
		}
	}
}

void
K_MacTest_5_2 (
        )
{
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint8		ucK;
	Tuint16		usL;
	Tuint16		usAll;
	Tuint16		usStatic;
	Tuint16		usDynamic;
	Tuint8		aucType[3];
        Tuint8 		aucMac[2][6];
	Tuint8		aucMacRet[6];
	Tuint16		ausFid[3];
	Tuint16		usFidRet;
	Tbool		bStaticRet;
	TstPPortMask	astPortMask[4];
	TstPPortMask	stPortMaskRet;
	Tuint16		usRet;
	Tuint16		usSize;

	aucType[0] = MAC_CLR_ALL;	//clear all entry
	aucType[1] = MAC_CLR_STTC;	//clear static entry
	aucType[2] = MAC_CLR_DYNMC;	//cear dynamic entry

	/* set aucMac[0] as 01:02:03:04:05:07, static entry */
	aucMac[0][0] = 0x01;
	aucMac[0][1] = 0x02;
	aucMac[0][2] = 0x03;
	aucMac[0][3] = 0x04;
	aucMac[0][4] = 0x05;
	aucMac[0][5] = 0x07;
	
	/* set aucMac[1] as 01:02:03:04:05:08, dynamic entry */
	aucMac[1][0] = 0x01;
	aucMac[1][1] = 0x02;
	aucMac[1][2] = 0x03;
	aucMac[1][3] = 0x04;
	aucMac[1][4] = 0x05;
	aucMac[1][5] = 0x08;

	ausFid[0] = 1;
	ausFid[1] = 7;
	ausFid[2] = 4094;

	astPortMask[0].ulMask[0] = 0x1;		//port 1
	astPortMask[1].ulMask[0] = 0x10;	//port 5
	astPortMask[2].ulMask[0] = 0x800000;	//port 24
	astPortMask[3].ulMask[0] = 0x1000000;	//port 25
	astPortMask[3].ulMask[0] = 0x3000000;	//port 26
	
	for (ucI = 0; ucI < 3; ucI++) {
		for (ucJ = 0; ucJ < 4; ucJ++) {
			for (ucK = 0; ucK < 3; ucK++) {
				DBG0(printk("  Static MAC entry %02X:%02X:%02X:%02X:%02X:%02X, port mask 0x%X\n", aucMac[0][0], aucMac[0][1], aucMac[0][2], aucMac[0][3], aucMac[0][4], aucMac[0][5], astPortMask[ucJ]));
				DBG0(printk("  Dynamic MAC entry %02X:%02X:%02X:%02X:%02X:%02X, port mask 0x%X\n", aucMac[1][0], aucMac[1][1], aucMac[1][2], aucMac[1][3], aucMac[1][4], aucMac[1][5], astPortMask[ucJ]));
				usAll = 0;
				usStatic = 0;
				usDynamic = 0;
				K_MacInsEntry(aucMac[0], ausFid[ucI], True, &(astPortMask[ucJ]));
				K_MacInsEntry(aucMac[1], ausFid[ucI], False, &(astPortMask[ucJ]));
				K_MacClrTbl(aucType[ucK]);
				K_MacGetTblSize(&usSize);
				/* check multicast entry */
				for (usL = 0; usL < usSize; usL++) {
					usRet = K_MacGetTblEntry( True, usL, aucMacRet, &usFidRet, &bStaticRet, &stPortMaskRet);
					if (usRet == KRN_RET_OK) {
						usAll++;
						if (bStaticRet) {
							usStatic++;
						}	
						else {
							usDynamic++;
						}
					}
				}
				switch (aucType[ucK])
				{
				case MAC_CLR_ALL:
					if (usAll == 0) {
						DBG0(printk("  [ OK ] K_MacClrTbl(MAC_CLR_ALL)\n"));
					}
					else {
						DBG0(printk("  [FAIL] K_MacClrTbl(MAC_CLR_ALL)\n"));
						DBG0(printk("         There are %d entries in the MAC table\n", usAll));
					}
					break;
				case MAC_CLR_STTC:
					if (usStatic == 0) {
						DBG0(printk("  [ OK ] K_MacClrTbl(MAC_CLR_STTC)\n"));
					}
					else {
						DBG0(printk("  [FAIL] K_MacClrTbl(MAC_CLR_STTC)\n"));
						DBG0(printk("         There are %d static entries in the MAC table\n", usStatic));
					}
					break;
				case MAC_CLR_DYNMC:
					if (usDynamic == 0) {
						DBG0(printk("  [ OK ] K_MacClrTbl(MAC_CLR_DYNMC)\n"));
					}
					else {
						DBG0(printk("  [FAIL] K_MacClrTbl(MAC_CLR_DYNMC)\n"));
						DBG0(printk("         There are %d dynamic entries in the MAC table\n", usDynamic));
					}
					break;
				default:
					break;
				}
			}
		}
	}
}

void
K_Test_Case_5 ()
{
        DBG0(printk("Case ID: 5.1\n"));
        K_MacTest_5_1();

        DBG0(printk("Case ID: 5.2\n"));
        K_MacTest_5_2();
}

