#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnipmcst.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_IpMcstTest_7_1 ()
{
        Tuint32		ulIp;
	Tbool		bStatic;
	Tbool		bStaticRet;
	TstPPortMask	astPortMask[4];
	TstPPortMask	stPortMaskRet;
	Tuint16		usRet;
	Tuint8		ucI;

	astPortMask[0].ulMask[0] = 0x0;		//no port
	astPortMask[1].ulMask[0] = 0x1;		//port 1
	astPortMask[2].ulMask[0] = 0x1E;	//port 1, 2, 3, 4
	astPortMask[3].ulMask[0] = 0x7FFFFFF;	//all port

        ulIp = 0xE0000005;	//ip: 224.0.0.5

	for (ucI = 0; ucI < 4; ucI++) {
		/* static */
		bStatic = True;
		/* insert */
		K_IpMcstInsEntry(ulIp, bStatic, &(astPortMask[ucI]));
		K_IpMcstGetEntry(ulIp, &bStaticRet, &stPortMaskRet);
		if (bStaticRet == bStatic && stPortMaskRet.ulMask[0] == astPortMask[ucI].ulMask[0]) {
        	        DBG0(printk("  [ OK ] K_IpMcstInsEntry(0x%x, True, 0x%x)\n", ulIp, astPortMask[ucI].ulMask[0]));
        	}
		else {
			DBG0(printk("  [FAIL] K_IpMcstInsEntry(0x%x, True, 0x%x)\n", ulIp, astPortMask[ucI].ulMask[0]));
			DBG1(printk("         Step 1: Set K_IpMcstInsEntry with parameter:\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			DBG1(printk("         	  True\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucI].ulMask[0]));
                	DBG1(printk("         Step 2: Get K_IpMcstGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			DBG1(printk("         	  True\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucI].ulMask[0]));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			if (bStaticRet == bStatic) {
				DBG1(printk("         	  True\n"));
			}
			else {
				DBG1(printk("         	  False\n"));
			}
			DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
        	}
		/* delete */
		K_IpMcstDelEntry(ulIp);
		usRet = K_IpMcstGetEntry(ulIp, &bStaticRet, &stPortMaskRet);
		if (usRet != KRN_RET_OK) {
        	        DBG0(printk("  [ OK ] K_IpMcstDelEntry(0x%x)\n", ulIp));
        	}
		else {
			DBG0(printk("  [FAIL] K_IpMcstDelEntry(0x%x)\n", ulIp));
			DBG1(printk("         Step 1: Set K_IpMcstDelEntry with ip: 0x%x (224.0.0.5)\n", ulIp));
                	DBG1(printk("         Step 2: Get K_IpMcstGetEntry with ip: 0x%x (224.0.0.5)\n", ulIp));
                	DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                	DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
        	}

		/* dynamic */
		bStatic = False;
		/* insert */
		K_IpMcstInsEntry(ulIp, bStatic, &(astPortMask[ucI]));
		K_IpMcstGetEntry(ulIp, &bStaticRet, &stPortMaskRet);
		if (bStaticRet == bStatic && stPortMaskRet.ulMask[0] == astPortMask[ucI].ulMask[0]) {
        	        DBG0(printk("  [ OK ] K_IpMcstInsEntry(0x%x, False, 0x%x)\n", ulIp, stPortMaskRet.ulMask[0]));
        	}
		else {
			DBG0(printk("  [FAIL] K_IpMcstInsEntry(0x%x, False, 0x%x)\n", ulIp, astPortMask[ucI].ulMask[0]));
			DBG1(printk("         Step 1: Set K_IpMcstInsEntry with parameter:\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			DBG1(printk("         	  False\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucI].ulMask[0]));
                	DBG1(printk("         Step 2: Get K_IpMcstGetEntry\n"));
                	DBG1(printk("         Step 3: Return value should be\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			DBG1(printk("         	  False\n"));
			DBG1(printk("         	  port mask = 0x%x\n", astPortMask[ucI].ulMask[0]));
                	DBG1(printk("                 But return value is\n"));
			DBG1(printk("         	  ip = 0x%x (224.0.0.5)\n", ulIp));
			if( bStaticRet == bStatic)
				DBG1(printk("         	  False\n"));
			else	
				DBG1(printk("         	  True\n"));
			DBG1(printk("         	  port mask = 0x%x\n", stPortMaskRet.ulMask[0]));
        	}
		/* delete */
		K_IpMcstDelEntry(ulIp);
		usRet = K_IpMcstGetEntry(ulIp, &bStaticRet, &stPortMaskRet);
		if (usRet != KRN_RET_OK) {
        	        DBG0(printk("  [ OK ] K_IpMcstDelEntry(0x%x)\n", ulIp));
        	}
		else {
			DBG0(printk("  [FAIL] K_IpMcstDelEntry(0x%x)\n", ulIp));
			DBG1(printk("         Step 1: Set K_IpMcstDelEntry with ip: 0x%x (224.0.0.5)\n", ulIp));
                	DBG1(printk("         Step 2: Get K_IpMcstGetEntry with ip: 0x%x (224.0.0.5)\n", ulIp));
                	DBG1(printk("         Step 3: Return value should not be \"KRN_RET_OK\"\n"));
                	DBG1(printk("                 But return value is \"KRN_RET_OK\"\n"));
        	}
	}
	
}

void
K_IpMcstTest_7_2 (
        )
{
        Tuint32		aulIp[2];
	Tuint32		ulIpRet;
	Tbool		bStatic;
	Tbool		bStaticRet;
	TstPPortMask	astPortMask[4];
	TstPPortMask	stPortMaskRet;
	Tuint16		usRet;
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint8		aucType[3];
	Tuint16		usSize;
	Tuint16		usK;
	Tuint16		usAll;
	Tuint16		usStatic;
	Tuint16		usDynamic;

	astPortMask[0].ulMask[0] = 0x0;		//no port
	astPortMask[1].ulMask[0] = 0x40;	//port 7
	astPortMask[2].ulMask[0] = 0x484;	//port 3, 8, 11
	astPortMask[3].ulMask[0] = 0x3FFFFFF;	//all ports

        aulIp[0] = 0xE0000006;	//ip: 224.0.0.6
        aulIp[1] = 0xE0000007;	//ip: 224.0.0.7

	aucType[0] = IP_MCST_CLR_ALL;	//clear all
	aucType[1] = IP_MCST_CLR_STTC;	//clear static
	aucType[2] = IP_MCST_CLR_DYNMC;	//clear dynamic	

	for (ucI = 0; ucI < 4; ucI++) {
		DBG0(printk("  Static IP multicast entry %d.%d.%d.%d, port mask 0x%X\n", (aulIp[0] & 0xFF000000L) >> 24, (aulIp[0] & 0x00FF0000L) >> 16, (aulIp[0] & 0x0000FF00L) >> 8, (aulIp[0] & 0x000000FFL), astPortMask[ucI].ulMask[0]));
		DBG0(printk("  Dynamic IP multicast entry %d.%d.%d.%d, port mask 0x%X\n", (aulIp[1] & 0xFF000000L) >> 24, (aulIp[1] & 0x00FF0000L) >> 16, (aulIp[1] & 0x0000FF00L) >> 8, (aulIp[1] & 0x000000FFL), astPortMask[ucI].ulMask[0]));
		for (ucJ = 0; ucJ < 3; ucJ++) {
			usAll = 0;
			usStatic = 0;
			usDynamic = 0;
			/* insert a static entry */
			K_IpMcstInsEntry(aulIp[0], True, &(astPortMask[ucI]));
			/* insert a dynamic entry */
			K_IpMcstInsEntry(aulIp[1], False, &(astPortMask[ucI]));
			
			K_IpMcstClrTbl(aucType[ucJ]);
			K_IpMcstGetTblSize(&usSize);
			for (usK = 0; usK < usSize; usK++) {
				usRet = K_IpMcstGetTblEntry(usK, &ulIpRet, &bStaticRet, &stPortMaskRet);
				if (usRet == KRN_RET_OK) {
					usAll++;
					if (bStaticRet) {
						usStatic++;
					}
					else {
						usDynamic++;
					}
				}
			}
			switch (aucType[ucJ])
			{
			case IP_MCST_CLR_ALL:
				if (usAll == 0) {
					DBG0(printk("  [ OK ] K_IpMcstClrTbl(IP_MCST_CLR_ALL)\n"));
				}
				else {
					DBG0(printk("  [FAIL] K_IpMcstCrlTbl(IP_MCST_CLR_ALL)\n"));
					DBG0(printk("         There are %d entries in the IP multicast table\n", usAll));
				}
				break;
			case IP_MCST_CLR_STTC:
				if (usStatic == 0) {
					DBG0(printk("  [ OK ] K_IpMcstClrTbl(IP_MCST_CLR_STTC)\n"));
				}
				else {
					DBG0(printk("  [FAIL] K_IpMcstCrlTbl(IP_MCST_CLR_STTC)\n"));
					DBG0(printk("         There are %d static entries in the IP multicast table\n", usStatic));
				}
				break;
			case IP_MCST_CLR_DYNMC:
				if (usDynamic == 0) {
					DBG0(printk("  [ OK ] K_IpMcstClrTbl(IP_MCST_CLR_DYNMC)\n"));
				}
				else {
					DBG0(printk("  [FAIL] K_IpMcstCrlTbl(IP_MCST_CLR_DYNMC)\n"));
					DBG0(printk("         There are %d dynamic entries in the IP multicast table\n", usDynamic));
				}
				break;
			default:
				break;
			}
		}
	}
}

void
K_Test_Case_7 ()
{
        DBG0(printk("Case ID: 7.1\n"));
        K_IpMcstTest_7_1();
        DBG0(printk("Case ID: 7.2\n"));
        K_IpMcstTest_7_2();
}

