#include "krndef.h"
#include "krntype.h"
#include "krnerr.h"
#include "krnfwd.h"
#include "krntest_netfilter.h"
#include "krntest_log.h"

void
K_FwdTest_2_1 ()
{
	Tbool	bEbl;

	K_FwdSetMacAge(Enable);
	K_FwdGetMacAge(&bEbl);
	if (bEbl == Enable) {
		DBG0(printk("  [ OK ] K_FwdSetMacAge(Enable)\n"));
	}
	else {
		DBG0(printk("  [FAIL] K_FwdSetMacAge(Enable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetMacAge \"Enable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetMacAge\n"));
                DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                DBG1(printk("                 But return value is \"Disable\"\n"));
	}
	
	K_FwdSetMacAge(Disable);
	K_FwdGetMacAge(&bEbl);
	if (bEbl == Disable) {
		DBG0(printk("  [ OK ] K_FwdSetMacAge(Disable)\n"));
	}
	else {
		DBG0(printk("  [FAIL] K_FwdSetMacAge(Disable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetMacAge \"Disable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetMacAge\n"));
                DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                DBG1(printk("                 But return value is \"Enable\"\n"));
	}
}

void
K_FwdTest_2_2 ()
{
	Tuint32	aulTime[3];
	Tuint32	ulTimeRet;
	Tuint8	ucI;

	aulTime[0] = 765;
	aulTime[1] = 300;
	aulTime[2] = 0;
	
	K_FwdSetMacAge(Enable);
	for (ucI = 0; ucI < 3; ucI++) {
		K_FwdSetMacAgeTime(aulTime[ucI]);
		K_FwdGetMacAgeTime(&ulTimeRet);
		if (ulTimeRet == aulTime[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetMacAgeTime(%d)\n", aulTime[ucI]));
		}
		else {
			DBG0(printk("  [FAIL] K_FwdSetMacAgeTime(%d)\n", aulTime[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetMacAgeTime = %d\n", aulTime[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetMacAgeTime\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aulTime[ucI]));
                	DBG1(printk("                 But return value is %d\n", ulTimeRet));
		}
	}
	K_FwdSetMacAge(Disable);
}

void
K_FwdTest_2_3 ()
{
	Tuint8	aucMode[6];
	Tuint8	ucModeRet;
	Tuint8	ucI;

	aucMode[0] = 0;
	aucMode[1] = 1;
	aucMode[2] = 2;
	aucMode[3] = 3;
	aucMode[4] = 4;
	aucMode[5] = 5;
	
	for (ucI = 0; ucI < 6; ucI++) {
		K_FwdSetBcstStrmFltr(aucMode[ucI]);
		K_FwdGetBcstStrmFltr(&ucModeRet);
		if (ucModeRet == aucMode[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetBcstStrmFltr(%d)\n", aucMode[ucI]));
		}
		else {
			DBG0(printk("  [FAIL] K_FwdSetBcstStrmFltr(%d)\n", aucMode[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetBcstStrmFltr = %d\n", aucMode[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetBcstStrmFltr\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucMode[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucModeRet));
		}
	}
}

void
K_FwdTest_2_4 ()
{
	Tuint8	aucMode[4];
	Tuint8  ucModeRet;
	Tuint8	ucI;

	aucMode[0] = 0;
	aucMode[1] = 1;
	aucMode[2] = 2;
	aucMode[3] = 3;
	
	for (ucI = 0; ucI < 4; ucI++) {
		K_FwdSetTrnsmtDlyBnd(aucMode[ucI]);
		K_FwdGetTrnsmtDlyBnd(&ucModeRet);
		if (ucModeRet == aucMode[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetTrnsmtDlyBnd(%d)\n", aucMode[ucI]));
		}
		else {
			DBG0(printk("  [FAIL] K_FwdSetTrnsmtDlyBnd(%d)\n", aucMode[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetTrnsmtDlyBnd = %d\n", aucMode[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetTrnsmtDlyBnd\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucMode[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucModeRet));
		}
	}
	
}

void
K_FwdTest_2_5 ()
{
	Tuint8	aucMode[3];
	Tuint8	aucHighQueWght[1];
	Tuint8	aucLowQueWght[1];
	Tuint8	ucModeRet;
	Tuint8	ucHighQueWghtRet;
	Tuint8	ucLowQueWghtRet;
	Tuint8	ucI;
	Tuint8	ucJ;
	Tuint8	ucK;
	
	aucMode[0] = 0;
	aucMode[1] = 1;
	aucMode[2] = 2;

	aucHighQueWght[0] = 2;
	
	aucLowQueWght[0] = 1;

	for (ucI = 0; ucI < 3; ucI++) {
		for (ucJ = 0; ucJ < 1; ucJ++) {
			for (ucK = 0; ucK < 1; ucK++) {
				K_FwdSetQos(aucMode[ucI], aucHighQueWght[ucJ], aucLowQueWght[ucK]);
				K_FwdGetQos(&ucModeRet, &ucHighQueWghtRet, &ucLowQueWghtRet);
				if (ucModeRet == aucMode[ucI] && ucHighQueWghtRet == aucHighQueWght[ucJ] &&
					ucLowQueWghtRet == aucLowQueWght[ucK]) {
					DBG0(printk("  [ OK ] K_FwdSetQos(%d, %d, %d)\n", aucMode[ucI], aucHighQueWght[ucJ], aucLowQueWght[ucK]));
				}
				else if (ucModeRet != aucMode[ucI] || ucHighQueWghtRet != aucHighQueWght[ucJ] 
					|| ucLowQueWghtRet != aucLowQueWght[ucK]) {
					DBG0(printk("  [FAIL] K_FwdSetQos(%d, %d, %d)\n", 
						aucMode[ucI], aucHighQueWght[ucJ], aucLowQueWght[ucK]));
					DBG1(printk("         Step 1: Set K_FwdSetQos with parameter:\n"));
					DBG1(printk("         	  mode = %d\n", aucMode[ucI]));
					DBG1(printk("         	  High Queue Weight = %d\n", aucHighQueWght[ucJ]));
					DBG1(printk("         	  Low Queue Weight = %d\n", aucLowQueWght[ucK]));
                			DBG1(printk("         Step 2: Get K_FwdGetQos\n"));
                			DBG1(printk("         Step 3: Return value should be\n"));
					DBG1(printk("         	  mode = %d\n", aucMode[ucI]));
					DBG1(printk("         	  High Queue Weight = %d\n", aucHighQueWght[ucJ]));
					DBG1(printk("         	  Low Queue Weight = %d\n", aucLowQueWght[ucK]));
                			DBG1(printk("                 But return value is\n"));
					DBG1(printk("         	  mode = %d\n", ucModeRet));
					DBG1(printk("         	  High Queue Weight = %d\n", ucHighQueWghtRet));
					DBG1(printk("         	  Low Queue Weight = %d\n", ucLowQueWghtRet));
				}
			}
		}
	}

}

void
K_FwdTest_2_6 ()
{
	Tuint8	aucHighQuePtn[3];
	Tuint8	ucHighQuePtnRet;	
	Tuint8	ucI;

	aucHighQuePtn[0] = 0xFF;
	aucHighQuePtn[1] = 0xAA;
	aucHighQuePtn[2] = 0x0;
	
	for (ucI = 0; ucI < 3; ucI++) {
		K_FwdSetHighQuePtn(aucHighQuePtn[ucI]);
		K_FwdGetHighQuePtn(&ucHighQuePtnRet);
		if (ucHighQuePtnRet == aucHighQuePtn[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetHighQuePtn(%x)\n", aucHighQuePtn[ucI]));
		}
		else if (ucHighQuePtnRet != aucHighQuePtn[ucI]) {
			DBG0(printk("  [FAIL] K_FwdSetHighQuePtn(%x)\n", aucHighQuePtn[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetHignQuePtn = %x:\n", aucHighQuePtn[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetHignQuePtn\n"));
                	DBG1(printk("         Step 3: Return value should be %x\n", aucHighQuePtn[ucI]));
                	DBG1(printk("                 But return value is %x\n", ucHighQuePtnRet));
		}
	}

}

void
K_FwdTest_2_7 ()
{
	Tbool	bEbl;

	K_FwdSetLowQueDlyBnd(Enable);
	K_FwdGetLowQueDlyBnd(&bEbl);
	if (bEbl == Enable) {
		DBG0(printk("  [ OK ] K_FwdSetLowQueDlyBnd(Enable)\n"));
	}
	else if (bEbl == Disable) {
		DBG0(printk("  [FAIL] K_FwdSetLowQueDlyBnd(Enable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetLowQueDlyBnd \"Enable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetLowQueDlyBnd\n"));
                DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                DBG1(printk("                 But return value is \"Disable\"\n"));
	}
	
	K_FwdSetLowQueDlyBnd(Disable);
	K_FwdGetLowQueDlyBnd(&bEbl);
	if (bEbl == Disable) {
		DBG0(printk("  [ OK ] K_FwdSetLowQueDlyBnd(Disable)\n"));
	}
	else if (bEbl == Enable) {
		DBG0(printk("  [FAIL] K_FwdSetLowQueDlyBnd(Disable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetLowQueDlyBnd \"Disable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetLowQueDlyBnd\n"));
                DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                DBG1(printk("                 But return value is \"Enable\"\n"));
	}
}

void
K_FwdTest_2_8 ()
{
	Tuint32	aulTime[3];
	Tuint32	ulTimeRet;
	Tuint8	ucI;

	aulTime[0] = 510;
	aulTime[1] = 200;
	aulTime[2] = 0;
	
	for (ucI = 0; ucI < 3; ucI++) {
		K_FwdSetLowQueDlyBndTime(aulTime[ucI]);
		K_FwdGetLowQueDlyBndTime(&ulTimeRet);
		if (ulTimeRet == aulTime[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetLowQueDlyBndTime(%d)\n", aulTime[ucI]));
		}
		else if (ulTimeRet != aulTime[ucI]) {
			DBG0(printk("  [FAIL] K_FwdSetLowQueDlyBndTime(%d)\n", aulTime[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetLowQueDlyBndTime = %d\n", aulTime[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetLowQueDlyBndTime\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aulTime[ucI]));
                	DBG1(printk("                 But return value is %d\n", ulTimeRet));
		}
	}

}

void
K_FwdTest_2_9 ()
{
	Tuint8	aucPortId[5];
	Tuint8	aucPrio[3];
	Tuint8	ucPrioRet;
	Tuint8	ucI;
	Tuint8	ucJ;

	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	aucPrio[0] = 0;
	aucPrio[1] = 1;
	aucPrio[2] = 2;
	
	for (ucI = 0; ucI < 5; ucI++) {
		for (ucJ = 0; ucJ < 3; ucJ++) {
			K_FwdSetPortPrio( aucPortId[ucI], aucPrio[ucJ]);
			K_FwdGetPortPrio( aucPortId[ucI], &ucPrioRet);
			if (ucPrioRet == aucPrio[ucJ]) {
				DBG0(printk("  [ OK ] K_FwdSetPortPrio( %d, %d)\n", aucPortId[ucI], aucPrio[ucJ]));
			}
			else if (ucPrioRet != aucPrio[ucJ]) {
				DBG0(printk("  [FAIL] K_FwdSetPortPrio(%d, %d)\n", aucPortId[ucI], aucPrio[ucJ]));
				DBG1(printk("         Step 1: Set K_FwdSetPortPrio with parameter:\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  priority = %d\n", aucPrio[ucJ]));
                		DBG1(printk("         Step 2: Get K_FwdGetQos\n"));
                		DBG1(printk("         Step 3: Return value should be\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  priority = %d\n", aucPrio[ucJ]));
                		DBG1(printk("                 But return value is\n"));
				DBG1(printk("         	  port id = %d\n", aucPortId[ucI]));
				DBG1(printk("         	  priority = %d\n", ucPrioRet));
			}
		}
	}

}

void
K_FwdTest_2_10 ()
{
	Tbool	bEbl;

	K_FwdSetCllsnRtry(Enable);
	K_FwdGetCllsnRtry(&bEbl);
	if (bEbl == Enable) {
		DBG0(printk("  [ OK ] K_FwdSetCllsnRtry(Enable)\n"));
	}
	else if (bEbl == Disable) {
		DBG0(printk("  [FAIL] K_FwdSetCllsnRtry(Enable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetCllsnRtry \"Enable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetCllsnRtry\n"));
                DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                DBG1(printk("                 But return value is \"Disable\"\n"));
	}
	
	K_FwdSetCllsnRtry(Disable);
	K_FwdGetCllsnRtry(&bEbl);
	if (bEbl == Disable) {
		DBG0(printk("  [ OK ] K_FwdSetCllsnRtry(Disable)\n"));
	}
	else if (bEbl == Enable) {
		DBG0(printk("  [FAIL] K_FwdSetCllsnRtry(Disable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetCllsnRtry \"Disable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetCllsnRtry\n"));
                DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                DBG1(printk("                 But return value is \"Enable\"\n"));
	}
}

void
K_FwdTest_2_11 ()
{
	Tuint8	aucAlg[2];
	Tuint8	ucAlgRet;
	Tuint8	ucI;

	aucAlg[0] = 0;
	aucAlg[1] = 1;
	
	for (ucI = 0; ucI < 2; ucI++) {
		K_FwdSetHashAlg(aucAlg[ucI]);
		K_FwdGetHashAlg(&ucAlgRet);
		if (ucAlgRet == aucAlg[ucI]) {
			DBG0(printk("  [ OK ] K_FwdSetHashAlg(%d)\n", aucAlg[ucI]));
		}
		else if (ucAlgRet != aucAlg[ucI]) {
			DBG0(printk("  [FAIL] K_FwdSetHashAlg(%d)\n", aucAlg[ucI]));
			DBG1(printk("         Step 1: Set K_FwdSetHashAlg = %d\n", aucAlg[ucI]));
                	DBG1(printk("         Step 2: Get K_FwdGetHashAlg\n"));
                	DBG1(printk("         Step 3: Return value should be %d\n", aucAlg[ucI]));
                	DBG1(printk("                 But return value is %d\n", ucAlgRet));
		}
	}

}


void
K_FwdTest_2_12 ()
{
	Tbool	bEbl;

	K_FwdSetIFGCpsn(Enable);
	K_FwdGetIFGCpsn(&bEbl);
	if (bEbl == Enable) {
		DBG0(printk("  [ OK ] K_FwdSetIFGCpsn(Enable)\n"));
	}
	else if (bEbl == Disable) {
		DBG0(printk("  [FAIL] K_FwdSetIFGCpsn(Enable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetIFGCpsn \"Enable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetIFGCpsn\n"));
                DBG1(printk("         Step 3: Return value should be \"Enable\"\n"));
                DBG1(printk("                 But return value is \"Disable\"\n"));
	}
	
	K_FwdSetIFGCpsn(Disable);
	K_FwdGetIFGCpsn(&bEbl);
	if (bEbl == Disable) {
		DBG0(printk("  [ OK ] K_FwdSetIFGCpsn(Disable)\n"));
	}
	else if (bEbl == Enable) {
		DBG0(printk("  [FAIL] K_FwdSetIFGCpsn(Disable)\n"));
		DBG1(printk("         Step 1: Set K_FwdSetIFGCpsn \"Disable\"\n"));
                DBG1(printk("         Step 2: Get K_FwdGetIFGCpsn\n"));
                DBG1(printk("         Step 3: Return value should be \"Disable\"\n"));
                DBG1(printk("                 But return value is \"Enable\"\n"));
	}
}

void
K_FwdTest_2_13 ()
{
	Tuint8		aucMode[4];
	Tuint8		aucPortId[5];
	TstPPortMask 	astPortMask[1];
	Tuint8		ucModeRet;
	Tuint8		ucPortIdRet;
	TstPPortMask 	stPortMaskRet;
	Tuint8		ucI;
	Tuint8		ucJ;
	Tuint8		ucK;

	aucMode[0] = 0;
	aucMode[1] = 1;
	aucMode[2] = 2;
	aucMode[3] = 3;
	
	aucPortId[0] = 0;
	aucPortId[1] = 5;
	aucPortId[2] = 23;
	aucPortId[3] = 24;
	aucPortId[4] = 25;

	astPortMask[0].ulMask[0] = 0x1FF800;
	
	for (ucI = 0; ucI < 4; ucI++) {
		for (ucJ = 0; ucJ < 5; ucJ++) {
			for (ucK = 0; ucK < 1; ucK++) {
				K_FwdSetPortMirror(aucMode[ucI], aucPortId[ucJ], &(astPortMask[ucK]));
				K_FwdGetPortMirror(&ucModeRet, &ucPortIdRet, &stPortMaskRet);
				if (ucModeRet == aucMode[ucI] && ucPortIdRet == aucPortId[ucJ] 
					&& stPortMaskRet.ulMask[0] == astPortMask[ucK].ulMask[0]) {
					DBG0(printk("  [ OK ] K_FwdSetPortMirror(%d, %d, %x)\n", aucMode[ucI], aucPortId[ucJ], astPortMask[ucK].ulMask[0]));
				}
				else {
					DBG0(printk("  [FAIL] K_FwdSetPotMirror(%d, %d, %x)\n", aucMode[ucI], aucPortId[ucJ], astPortMask[ucK].ulMask[0]));
					DBG1(printk("         Step 1: Set K_FwdSetPortPrio with parameter:\n"));
					DBG1(printk("         	  mode = %d\n", aucMode[ucI]));
					DBG1(printk("         	  port id = %d\n", aucPortId[ucJ]));
					DBG1(printk("         	  port mask = %x\n", astPortMask[ucK].ulMask[0]));
                			DBG1(printk("         Step 2: Get K_FwdGetQos\n"));
                			DBG1(printk("         Step 3: Return value should be\n"));
					DBG1(printk("         	  mode = %d\n", aucMode[ucI]));
					DBG1(printk("         	  port id = %d\n", aucPortId[ucJ]));
					DBG1(printk("         	  port mask = %x\n", astPortMask[ucK].ulMask[0]));
                			DBG1(printk("                 But return value is\n"));
					DBG1(printk("         	  mode = %d\n", ucModeRet));
					DBG1(printk("         	  port id = %d\n", ucPortIdRet));
					DBG1(printk("         	  port mask = %x\n", stPortMaskRet.ulMask[0]));
				}
			}
		}
	}
}

void
K_Test_Case_2 ()
{
	DBG0(printk("Case ID: 2.1\n"));
	K_FwdTest_2_1();

	DBG0(printk("Case ID: 2.2\n"));
	K_FwdTest_2_2();

	DBG0(printk("Case ID: 2.3\n"));
	K_FwdTest_2_3();

	DBG0(printk("Case ID: 2.4\n"));
	K_FwdTest_2_4();

	DBG0(printk("Case ID: 2.5\n"));
	K_FwdTest_2_5();

	DBG0(printk("Case ID: 2.6\n"));
	K_FwdTest_2_6();

	DBG0(printk("Case ID: 2.7\n"));
	K_FwdTest_2_7();

	DBG0(printk("Case ID: 2.8\n"));
	K_FwdTest_2_8();

	DBG0(printk("Case ID: 2.9\n"));
	K_FwdTest_2_9();

	DBG0(printk("Case ID: 2.10\n"));
	K_FwdTest_2_10();

	DBG0(printk("Case ID: 2.11\n"));
	K_FwdTest_2_11();

	DBG0(printk("Case ID: 2.12\n"));
	K_FwdTest_2_12();

	DBG0(printk("Case ID: 2.13\n"));
	K_FwdTest_2_13();
}

