/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 *  Author: Winfred Lu (N300, CCL/ITRI)
 *
 ***************************************************************************/

#ifndef _IGMPSNP_UTIL_H
#define _IGMPSNP_UTIL_H

#define IGMPI_UPSTREAM		1
#define IGMPI_DOWNSTREAM	2

#include <linux/skbuff.h>	/* for sk_buff */

#include "krntype.h"		/* for Tuint8, Tuint32 */
#include "krndef.h"


void debug (const char *, ...);
unsigned short in_cksum (unsigned short *, int);
void update_portmasks (void);
void igmpsnp_xmit_dir (struct sk_buff *, int);
void igmpsnp_xmit_portmask (struct sk_buff * skb, TstLPortMask mask);
void igmpsnp_xmit_exc_port (struct sk_buff * skb, unsigned char port_no);
int table_test_group_existence (Tuint32 ulGroup);
int table_del_group_with_port (Tuint32 ulGroup, Tuint8 ucPort);
int table_add_group_with_port (Tuint32 ulGroup, Tuint8 ucPort);
void del_from_upstream (unsigned char);
void _igmp_stp_port_forwarding (int port_no);
void _igmp_stp_port_disabled (int port_no);
int is_port_disabled (unsigned char port_no);
void update_router_port  (unsigned char);


#endif


