/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 *  Author: Winfred Lu (N300, CCL/ITRI)
 *
 ***************************************************************************/

#include <linux/kernel.h>
#include <linux/init.h>

#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
#include "krnmac.h"
#include "krnsys.h"
#endif

#include <linux/netfilter.h>	/* for nf_register_sockopt */

#include "../cclmx/ccl_mx.h"	/* for ccl mutiplexer registration */

#include "db.h"		/* for igmp_if_list_create declaration */
#include "util.h"	/* igmp_stp_port_forwarding/disabled support */
#include "igmp_netfilter.h"


#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
Tuint8	sys_mac[6]; /* system MAC address */
#endif

static char multicast_mac[6] =  {0x01,0x00,0x5e,0x00,0x00,0x00};
static char multicast_mask[6] = {0xff,0xff,0xff,0x00,0x00,0x00};

extern struct nf_sockopt_ops igmpsnp_sockopts;

int igmp_received (struct sk_buff *);
int igmp_report_cleaner (void * vp);

extern void (*igmp_stp_port_forwarding)(int);
extern void (*igmp_stp_port_disabled)(int);


int __init init_igmpsnooping(void)
{
	debug ("starting IGMP snooping functions..\n");
	if (nf_register_sockopt (&igmpsnp_sockopts))
	{
		debug ("IGMP snooping: cannot register sockopt..\n");
		return 1;
	}
	ccl_mx_register (multicast_mac, multicast_mask, igmp_received);

#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
	K_SysGetMac(sys_mac); /* get system MAC address for later use */
#endif

	igmp_snooping_stats_init (1);
	igmp_snooping_db_init (1);
	igmp_stp_port_forwarding = _igmp_stp_port_forwarding;
	igmp_stp_port_disabled = _igmp_stp_port_disabled;
	update_portmasks ();

	kernel_thread ((int (*)(void *))igmp_report_cleaner, NULL, 0);

	return 0;
}


void __exit cleanup_igmpsnooping(void)
{
	debug ("leaving IGMP snooping functions..\n");
	nf_unregister_sockopt (&igmpsnp_sockopts);
	ccl_mx_unregister (multicast_mac, multicast_mask);
}


module_init(init_igmpsnooping);
module_exit(cleanup_igmpsnooping);


