/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 *  Author: Winfred Lu (N300, CCL/ITRI)
 *
 ***************************************************************************/

#ifndef _IGMPSNP_NETFILTER_IGMP_H
#define _IGMPSNP_NETFILTER_IGMP_H

#include <linux/netfilter.h>

#define IGMP_SNP_BASE			(64+1024+64+64+800)

#define SET_IGMPSNP_ENABLE		(IGMP_SNP_BASE+1)
#define SET_IGMPSNP_DISABLE		(IGMP_SNP_BASE+2)
#define SET_IGMPSNP_PROXY_ENABLE	(IGMP_SNP_BASE+3)
#define SET_IGMPSNP_PROXY_DISABLE	(IGMP_SNP_BASE+4)
#define SET_IGMPSNP_FASTLEAVE_ENABLE	(IGMP_SNP_BASE+5)
#define SET_IGMPSNP_FASTLEAVE_DISABLE	(IGMP_SNP_BASE+6)
#define SET_IGMPSNP_QUERIER_ENABLE	(IGMP_SNP_BASE+7)
#define SET_IGMPSNP_QUERIER_DISABLE	(IGMP_SNP_BASE+8)
#define SET_IGMPSNP_DEBUG_ENABLE	(IGMP_SNP_BASE+9)
#define SET_IGMPSNP_DEBUG_DISABLE	(IGMP_SNP_BASE+10)
#define SET_IGMPSNP_ROOTPORT		(IGMP_SNP_BASE+11)
#define SET_IGMPSNP_RESET_STATISTICS	(IGMP_SNP_BASE+12)
#define IGMPSNP_SET_MAX			(IGMP_SNP_BASE+20)

#define SHOW_IGMPSNP_STATUS		(IGMP_SNP_BASE+1)
#define SHOW_IGMPSNP_ENABLED		(IGMP_SNP_BASE+2)
#define SHOW_IGMPSNP_PROXY_ENABLED	(IGMP_SNP_BASE+3)
#define SHOW_IGMPSNP_DEBUG_ENABLED	(IGMP_SNP_BASE+4)
#define SHOW_IGMPSNP_FASTLEAVE_ENABLED	(IGMP_SNP_BASE+5)
#define SHOW_IGMPSNP_QUERIER_ENABLED	(IGMP_SNP_BASE+6)
#define SHOW_IGMPSNP_ROUTER		(IGMP_SNP_BASE+7)
#define SHOW_IGMPSNP_ROOTPORT		(IGMP_SNP_BASE+8)
#define SHOW_IGMPSNP_GROUP_SIZE		(IGMP_SNP_BASE+9)
#define SHOW_IGMPSNP_GROUP_ENTRY	(IGMP_SNP_BASE+10)
#define IGMPSNP_GET_MAX			(IGMP_SNP_BASE+20)

typedef struct igmp_snooping_status
{
	unsigned char	igmpsnp_enable;
	unsigned char	fastleave_enable;
	unsigned char	querier_enable;
	unsigned char	debug_enable;
#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
	unsigned char	proxy_enable;
	unsigned char	reserved1;
	unsigned char	reserved2;
	unsigned char	reserved3; /* prevent alignment error */
#endif

	unsigned long	total_pkt_rcvd;
	unsigned long	valid_pkt_rcvd;
	unsigned long	invalid_pkt_rcvd;

	unsigned long	g_query_rcvd;
	unsigned long	gs_query_rcvd;
	unsigned long	leave_rcvd;
	unsigned long	report_rcvd;
	unsigned long	other_rcvd;

	unsigned long	g_query_xmit;
	unsigned long	gs_query_xmit;
	unsigned long	leave_xmit;
	unsigned long	report_xmit;
} TstIgmpSnpStatus;

typedef struct igmp_group_entry
{
	unsigned short	index;
	unsigned long	addr;
} TstIgmpGroupEntry;

#endif

