/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 *  Author: Winfred Lu (N300, CCL/ITRI)
 *
 ***************************************************************************/

#include <linux/kernel.h>
#include <asm/uaccess.h>	/* for copy_to_user() */
#include "krndef.h"
#include "krnigmp.h"
#include "krnipmcst.h"

#include "igmp_netfilter.h"
#include "db.h"
#include "util.h"


extern TstIgmpSnpStatus igmpsnp_global_stats;


int do_igmpsnp_setsockopt(struct sock *, int, void *, unsigned int);
int do_igmpsnp_getsockopt(struct sock *, int, void *, int *);

struct nf_sockopt_ops igmpsnp_sockopts =
{
list:		{NULL, NULL},
pf:		PF_INET,
set_optmin:	IGMP_SNP_BASE,
set_optmax:	IGMPSNP_SET_MAX+1,
set:		do_igmpsnp_setsockopt,
compat_set: NULL,
get_optmin:	IGMP_SNP_BASE,
get_optmax:	IGMPSNP_GET_MAX+1,
get:		do_igmpsnp_getsockopt,
compat_get: NULL,
use:		0,
cleanup_task:	NULL
};


int do_igmpsnp_setsockopt (struct sock *sk, int cmd, void *user,
		unsigned int len)
{
	unsigned char port_index;

	switch (cmd){
	case SET_IGMPSNP_ENABLE:
		igmpsnp_global_stats.igmpsnp_enable = 1;
		K_IgmpSetEbl(Enable);
		break;
	case SET_IGMPSNP_DISABLE:
		igmp_snooping_stats_init (0);
		igmp_db_del_all ();
		igmp_snooping_db_init (0); /* warn: call igmp_db_del_all first */
		K_IgmpSetEbl(Disable);
		K_IpMcstClrTbl(IP_MCST_CLR_DYNMC);
		break;
#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
	case SET_IGMPSNP_PROXY_ENABLE:
		igmpsnp_global_stats.proxy_enable = 1;
		break;
	case SET_IGMPSNP_PROXY_DISABLE:
		igmpsnp_global_stats.proxy_enable = 0;
		break;
#endif
	case SET_IGMPSNP_FASTLEAVE_ENABLE:
		igmpsnp_global_stats.fastleave_enable = 1;
		break;
	case SET_IGMPSNP_FASTLEAVE_DISABLE:
		igmpsnp_global_stats.fastleave_enable = 0;
		break;
	case SET_IGMPSNP_QUERIER_ENABLE:
		igmpsnp_global_stats.querier_enable = 1;
		break;
	case SET_IGMPSNP_QUERIER_DISABLE:
		igmpsnp_global_stats.querier_enable = 0;
		break;
	case SET_IGMPSNP_DEBUG_ENABLE:
		igmpsnp_global_stats.debug_enable = 1;
		break;
	case SET_IGMPSNP_DEBUG_DISABLE:
		igmpsnp_global_stats.debug_enable = 0;
		break;
	case SET_IGMPSNP_ROOTPORT:
		copy_from_user (&port_index, user, sizeof(unsigned char));
		update_router_port (port_index - 1);
		break;
	case SET_IGMPSNP_RESET_STATISTICS:
		igmp_snooping_stats_reset_counter ();
		break;
	default:
		debug("unknown socket option\n");
		break;
	}
	return 0;
}


int do_igmpsnp_getsockopt (struct sock *sk, int cmd, void *user, int *len)
{
	unsigned long ipaddr;
	unsigned short size;
	unsigned char port;
	TstIgmpGroupEntry entry;

	switch (cmd){
	case SHOW_IGMPSNP_STATUS:
		copy_to_user (user, &igmpsnp_global_stats, sizeof(TstIgmpSnpStatus));
		break;
	case SHOW_IGMPSNP_ENABLED:
		copy_to_user (user, &igmpsnp_global_stats.igmpsnp_enable, 1);
		break;
#ifdef __DRAFT_IETF_MAGMA_IGMP_PROXY__
	case SHOW_IGMPSNP_PROXY_ENABLED:
		copy_to_user (user, &igmpsnp_global_stats.proxy_enable, 1);
		break;
#endif
	case SHOW_IGMPSNP_DEBUG_ENABLED:
		copy_to_user (user, &igmpsnp_global_stats.debug_enable, 1);
		break;
	case SHOW_IGMPSNP_FASTLEAVE_ENABLED:
		copy_to_user (user, &igmpsnp_global_stats.fastleave_enable, 1);
		break;
	case SHOW_IGMPSNP_QUERIER_ENABLED:
		copy_to_user (user, &igmpsnp_global_stats.querier_enable, 1);
		break;
	case SHOW_IGMPSNP_ROUTER:
		ipaddr = get_mcast_router ();
		copy_to_user (user, &ipaddr, sizeof(unsigned long));
		break;
	case SHOW_IGMPSNP_ROOTPORT:
		if (0 == get_mcast_router ())
			port = 0;
		else
			port = get_mcast_router_port ();
		copy_to_user (user, &port, sizeof(unsigned char));
		break;
	case SHOW_IGMPSNP_GROUP_SIZE:
		size = get_mcast_groups_size();
		copy_to_user (user, &size, sizeof(unsigned short));
		break;
	case SHOW_IGMPSNP_GROUP_ENTRY:
		copy_from_user (&entry, user, sizeof(TstIgmpGroupEntry));
		entry.addr = get_mcast_group_entry (entry.index);
		copy_to_user (user, &entry, sizeof(TstIgmpGroupEntry));
		break;
	default:
		break;
	}
	return 0;
}


