/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 *  Author: Winfred Lu (N300, CCL/ITRI)
 *
 ***************************************************************************/

#ifndef _IGMPSNP_DB_H
#define _IGMPSNP_DB_H


#define	IGMPSNP_DFT_ENABLE		0
#define	FASTLEAVE_DFT_ENABLE		1
#define	QUERIER_DFT_ENABLE		0
#define	DEBUG_DFT_ENABLE		0


#define ROBUSTNESS_VAR			2
#define QUERY_INTV			125	/* 125 seconds */
#define QUERY_RESPONSE_INTV		10	/* 10 seconds */
#define GS_QUERY_RESP_INTV		1	/* 1 second */
#define GROUP_MEMBERSHIP_INTV		(ROBUSTNESS_VAR * QUERY_INTV + QUERY_RESPONSE_INTV)


typedef struct igmp_snooping_db_entry
{
	struct	igmp_snooping_db_entry * hnext;	/* next in db */
	struct	igmp_snooping_db_entry * pnext;	/* next with the same GDA */
	__u32		gda;		/* group destination address */
	__u32		life;
	__u8		port;
	//__u8		v1_present;
} igmp_db_t;


typedef struct _igmp_router_struct
{
	//struct	_igmp_routers_struct * rnext;
	__u32	addr;		/* ip addr of this router */
	__u8	port;
} igmp_router_t;


#if 0
typedef struct igmp_proxy_report_state
{
	struct	igmp_proxy_report_state * next;
	struct	in_addr gda;	/* group destination address */
	__u32	state;
	int	proxy_int;	/* proxy interval */
	int	num_report;	/* number of reports received */

	/* information need by handling leave messages */
	int	num_gs_query;	/* leave gs-query sent */
	struct	timer_list tlist;	/* leave gs-query porxy report */
	int	lgs_port;
} proxy_state_t;
#endif


void igmp_snooping_stats_reset_counter (void);
void igmp_snooping_stats_init (int boot);
void igmp_snooping_db_init (int boot);

void igmp_db_copy_entry (igmp_db_t * to, igmp_db_t * from);
igmp_db_t * igmp_db_new_entry (__u32 gda, __u8 port, __u32 life);

int igmp_db_find_gda (igmp_db_t * ret, __u32 gda);
int igmp_db_find_entry (igmp_db_t * ret, __u32 gda, __u8 port);
int igmp_db_find_port (igmp_db_t * ret, __u8 port);
int igmp_db_insert_entry (igmp_db_t * ins);
int igmp_db_del_entry (igmp_db_t del);
void igmp_db_del_all (void);

int igmp_db_modify_life (igmp_db_t mod, __u32 life);
void igmp_db_decrease_life (void);
int igmp_db_find_dead (igmp_db_t * ret);
void igmp_db_debug_print (char * title);

int get_mcast_groups_size (void);
unsigned long get_mcast_group_entry (int index);
unsigned long get_mcast_router (void);
unsigned char get_mcast_router_port (void);


#endif

