/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/


// ********************************************
// Name   : vfdb.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : API for VLAN table access
// ********************************************


#include "common.h"
#include "garp_common.h"
#include "gvrp_common.h"

extern Tuint32 		gvrp_debug_level;
extern Tuint32 		ulVlanNumDeletes;
extern Tuint32 		aulPerVlanCreationTime[4096];
extern TstLPortMask 	astStaticVlanGrp[4096];

#if 0
extern void (*mstp_vlan_add)(int,unsigned long *);
extern void (*mstp_vlan_del)(int,unsigned long *);
#endif

// remove member port for this vid
Tbool vfdb_filter( Tuint32 port_no, Tuint16 vlan_id)
{
 Tbool          bStatic=0;
 TstPPortMask   stPortPhyMask, stTagPhyMask;
 TstLPortMask   stPortLogMask, stTagLogMask, stLPortMask;

#if 0
 TstLPortMask 	stVlanMask;
#endif

 if(gvrp_debug_level & GVRP_DEBUG_VLAN) {
   printk(" GVRP:Delete Vlan ID (port_no=%lu vlan_id=%u)\n",port_no+1,vlan_id);
 }

 //GVRP can't modify original static vlan setting
 //if(astStaticVlanGrp[vlan_id].ulMask[port_no/32] & (0x01 << (port_no%32) )) {
 if(K_LPortMaskGetPort(&astStaticVlanGrp[vlan_id], port_no)) {
    return False;
 }


 if(K_VlanGetEntry(vlan_id, &bStatic, &stPortPhyMask, &stTagPhyMask)!= KRN_RET_OK ){
    return False;
 }   
 else 
  {
    cclmx_PMask2LMask( &stPortLogMask, &stPortPhyMask);
    cclmx_PMask2LMask( &stTagLogMask, &stTagPhyMask);
    
    //stPortLogMask.ulMask[port_no/32]  &= ~(1<< (port_no%32) ); //member port
    K_LPortMaskClrPort(&stPortLogMask, port_no); //member port
    //stTagLogMask.ulMask[port_no/32]  &=  ~(1<< (port_no%32) ); //tag port
    K_LPortMaskClrPort(&stTagLogMask, port_no); //tag port

    // if the port is the last member for this vid
    // delete this vlan entry
    //if(!(stPortLogMask.ulMask[0] & 0xfbffffff) && !(stPortLogMask.ulMask[1] & 0xffffffff) ){ //no other member port
    K_LPortMaskCopy(&stLPortMask, &stPortLogMask);
    K_LPortMaskClrPort(&stLPortMask, PORT_ID_CPU);
    if(K_LPortMaskIsZero(&stLPortMask)) {
       K_VlanDelEntry(vlan_id);
       ulVlanNumDeletes++; //for VLAN MIB
    } else { 
      cclmx_LMask2PMask( &stPortPhyMask, &stPortLogMask);
      cclmx_LMask2PMask( &stTagPhyMask, &stTagLogMask);
      K_VlanInsEntry(vlan_id, bStatic, &stPortPhyMask, &stTagPhyMask);
    }

#if 0
    if( mstp_vlan_del!=NULL ){
       stVlanMask[port_no/32]=0x01<<(port_no%32);
       mstp_vlan_del(vlan_id,stVlanMask.ulMask);
    }
#endif    
  }

 return True;
}


// add member port for this vid
Tbool vfdb_forward(Tuint32 port_no, Tuint16 vlan_id)
{
 Tbool          bStatic=0;
 TstPPortMask   stPortPhyMask, stTagPhyMask;
 TstLPortMask   stPortLogMask, stTagLogMask;

#if 0
 TstLPortMask 	stVlanMask;
#endif

 memset(&stPortLogMask,0,sizeof(TstPPortMask));
 memset(&stTagLogMask,0,sizeof(TstPPortMask));
 
 if(gvrp_debug_level & GVRP_DEBUG_VLAN) {
    printk(" GVRP:Insert Vlan ID (port_no=%lu vlan_id=%u)\n",port_no+1,vlan_id);
 }

 //if the static vlan entry already exist in the vlan table.
 //we can't change to dynamic state
 if(K_VlanGetEntry(vlan_id, &bStatic, &stPortPhyMask, &stTagPhyMask)!= KRN_RET_OK ){
     bStatic = False;
 }
 else {
     cclmx_PMask2LMask( &stPortLogMask, &stPortPhyMask);
     cclmx_PMask2LMask( &stTagLogMask, &stTagPhyMask);
 }

 //stPortLogMask.ulMask[port_no/32]  |= (0x01 << (port_no%32) ); //member port
 K_LPortMaskSetPort(&stPortLogMask, port_no); //member port
 //stTagLogMask.ulMask[port_no/32] |= (0x01 << (port_no%32) ); //tag port
 K_LPortMaskSetPort(&stTagLogMask, port_no); //tag port
 aulPerVlanCreationTime[vlan_id] = jiffies/HZ; 

 cclmx_LMask2PMask( &stPortPhyMask, &stPortLogMask);
 cclmx_LMask2PMask( &stTagPhyMask, &stTagLogMask);
 K_VlanInsEntry(vlan_id, bStatic, &stPortPhyMask, &stTagPhyMask);

#if 0
 if(mstp_vlan_add!=NULL) {
    stVlanMask.ulMask[port_no/32]=0x01<<(port_no%32);
    mstp_vlan_add(usVlanId,stVlanMask.ulMask);
 }
#endif

 return True;
}

