
/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : sys.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : OS dependent system call
// ********************************************

#ifndef GARP_SYS_H__
#define GARP_SYS_H__

/******************************************************************************
* SYS : SYSTEM SUPPLIED ROUTINES AND PRIMITIVES
******************************************************************************
*
* This header file represents system supplied routines and primitives grouped
* into five categories:
*
* SYS     : System conventions.
* SYSMEM  : General memory allocation.
* SYSPDU  : Protocol buffer allocation, access, transmit, and receive.
* SYSTIME : Scheduling routines : immediate, in fixed (approximate) time, in random time period.
* SYSERR  : System error routines for gross errors in program logic detected
* in the course of execution, for which there is no sensible course
* of action at the poTuint32 of detection.
*/

// random number
#define GMRP_PROCESS_ID 0x300
#define GVRP_PROCESS_ID 0x310

/******************************************************************************
* SYS : SYSTEM SUPPLIED MEMORY ALLOCATION ROUTINES
*******************************************************************************/
extern Tbool sysmalloc(Tuint32 size, void **allocated);
extern void  sysfree(void *allocated);

/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED PDU ACCESS PRIMITIVES
*******************************************************************************/
typedef struct sk_buff Pdu;
typedef enum   {All_attributes, Vlan_attribute}  Attribute_type;
extern Tbool   syspdu_alloc(Pdu **pdu);
extern void    syspdu_free( Pdu *pdu);
extern Tbool   syspdu_tx( Pdu *pdu, Tuint32 port_no);
extern int     gvrp_pdu_rcv(Pdu *rcv_pdu);
extern int     gmrp_pdu_rcv(Pdu *rcv_pdu);

/******************************************************************************
* SYSTIME : SYSTEM SUPPLIED SCHEDULING FUNCTIONS
*******************************************************************************/
typedef struct
{
  Garp    *application;
  Tuint32 port_no;
}in_parm;

extern void systime_start_random_timer(Tuint32 process_id,
       void (*expiry_fn)(Tuint32),Tuint32 instance_id,Tuint32 timeout,struct timer_list *tEntry);

extern void systime_start_timer(Tuint32 process_id,
       void (*expiry_fn)(Tuint32),Tuint32 instance_id,Tuint32 timeout,struct timer_list *tEntry);

extern Tbool systime_stop_timer(struct timer_list *tEntry);

extern void systime_schedule(Tuint32 process_id,
       void (*expiry_fn)(Tuint32),Tuint32 instance_id,struct timer_list *tEntry);

/******************************************************************************
* SYSERR : FATAL ERROR HANDLING
*******************************************************************************/
extern void syserr_panic(void);

/******************************************************************************
* memory read/write : 
******************************************************************************/
extern Tuint8  check_1_byte(Tuint8 **pdu);
extern Tuint8  get_1_byte(Tuint8 **pdu);
extern Tuint16 get_2_bytes(Tuint8 **pdu);
extern Tuint32 get_4_bytes(Tuint8 **pdu);

/******************************************************************************
* string compare function : 
******************************************************************************/
extern Tbool mac_compare(Mac_addr src,Mac_addr dst);
extern Tbool mac_clone(Mac_addr src,Mac_addr dst);

#endif /* sys_h__ */

