/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : sys.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : OS dependent system call
// ********************************************

#include "common.h"
#include "garp_common.h"

#ifdef __GVRP__
#include "gvrp_common.h"
extern   Gvr *my_gvr;
#endif

#ifdef __GMRP__
#include "gmrp_common.h"
extern   Gmr *my_gmr;
#endif

//global variable declaration
Tuint32 	Gid_default_join_time     = 20; 
Tuint32 	Gid_default_leave_time    = 60; 
Tuint32 	Gid_default_leaveall_time = 1000; 
Tuint32 	Gid_default_hold_time     = 10; 
Tuint32 	Gid_leaveall_count        = 4;

Tbool   	gvrp_enable=False, gmrp_enable=False; 
Tuint32 	gvrp_debug_level=0, gmrp_debug_level=0;
Tuint8 		 bLastRcvMac[MAX_LOGIC_PORT][MAC_ADDR_LEN];//for VLAN MIB
garp_statistics gvrp_statistics[MAX_LOGIC_PORT], gmrp_statistics[MAX_LOGIC_PORT];

/******************************************************************************
* SYS : SYSTEM SUPPLIED MEMORY ALLOCATION ROUTINES
*******************************************************************************/

Tbool sysmalloc(Tuint32 size, void **allocated)
{
 *allocated=(void *)kmalloc(size, GFP_ATOMIC);
 
 if(*allocated==NULL)
   return(False);
   
 memset(*allocated,0,size);
 return(True);
}


void sysfree(void *allocated)
{
 kfree(allocated);
}

/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED SOCKET BUFFER ALLOCATION ROUTINES
*******************************************************************************/
Tbool syspdu_alloc(Pdu **pdu)
{
 *pdu=dev_alloc_skb(1518);
	
 if (*pdu == NULL) 
    return(False);
 
 return(True);
}

void syspdu_free( Pdu *pdu)
{
#ifdef __LINUX_2_6_19__
#else
  skb_unlink(pdu);
#endif
  kfree_skb(pdu);
}

/******************************************************************************
* SYSPDU : SYSTEM SUPPLIED PDU READ/WRITE
*******************************************************************************/

// call driver API to send GARP PDU
Tbool syspdu_tx(Pdu *tx_pdu,Tuint32 port_no)
{
  Tuint16 pkt_len= tx_pdu->tail - tx_pdu->data;
  Tuint16 n_pkt_len=htons(pkt_len); 
  int 	  i;

  if(gvrp_debug_level & GVRP_DEBUG_PDU){
    printk("GVRP: PDU tx (dst port=%lu pkt_len=%d).......\n",port_no+1,tx_pdu->len);
  }

  // Dump GMRP PDU
  if(gmrp_debug_level & GMRP_DEBUG_PDU) {
   for(i=0;i< pkt_len ;i++){
      printk("%x=",*(tx_pdu->data+i));
   }

   printk("\n");
  }
  
  // 12bytes=skip Dst Mac + Src Mac 
  put_unaligned(n_pkt_len,(Tuint16 *)(tx_pdu->data+12)); //rewrite packet len field
 
  tx_pdu->nh.raw=tx_pdu->data;
  //CCL_LP(tx_pdu)->dwDstPortMsk.ulMask[port_no/32]= (0x01<< (port_no%32));
  K_LPortMaskClrAll(&CCL_LP(tx_pdu)->dwDstPortMsk);
  K_LPortMaskSetPort(&CCL_LP(tx_pdu)->dwDstPortMsk, port_no);
  cclmx_TxPkt(tx_pdu);
    
  return True; 
}


#ifdef __GVRP__
// GARP PDU processing function
// called by network driver if garp pdu received
int gvrp_pdu_rcv(Pdu *rcv_pdu)
{
  Gid *my_gid;
  Garp *application=&my_gvr->garp;
  Tuint32 src_port=CCL_LP(rcv_pdu)->bySrcPortId;

  if(gvrp_debug_level & GVRP_DEBUG_PDU){
    printk("GVRP: PDU Rcv (src port=%lu pkt len=%d).......\n",src_port+1,rcv_pdu->len);
  }
  
  if(gvrp_enable==0){
    return CCL_MX_DROP;
  }

  //When a Port is in the blocking state as defined by spanning tree,
  //and registrations received on that port should not be propagated on
  //the other ports within the GIP Context. (IOL: Test12.2.2.7)
  if(cclmx_PortGetStpState(src_port) != STP_PORT_FORWARDING){
    return CCL_MX_DROP; 
  }

  // for VLAN MIB  
#ifdef __LINUX_2_6_19__
  memcpy( bLastRcvMac[src_port] ,eth_hdr(rcv_pdu)->h_source,MAC_ADDR_LEN);
#else
  memcpy( bLastRcvMac[src_port] ,rcv_pdu->mac.ethernet->h_source,MAC_ADDR_LEN);
#endif

  //find the gid of received port, and pass the packet to this gid 
  if(gid_find_port(application->gid, src_port , &my_gid)){  
     gid_rcv_pdu( &my_gvr->garp , src_port , (void *)rcv_pdu);
  }
  
  return CCL_MX_DROP;
}

#endif

#ifdef __GMRP__ 
// GARP pdu processing function
// called by network driver if garp pdu received
int gmrp_pdu_rcv(Pdu *rcv_pdu)
{
 
  Gid *my_gid;
  Garp *application=&my_gmr->garp;
  Tuint32 src_port=CCL_LP(rcv_pdu)->bySrcPortId;
  
  if(gmrp_debug_level & GMRP_DEBUG_PDU){
    printk("GMRP_PDU_RCV (src port=%lu pkt len=%d).......\n",src_port+1,rcv_pdu->len);
  }
  
  if(gmrp_enable==False){
    return CCL_MX_DROP;
  }

  //When a Port is in the blocking state as defined by spanning tree,
  //and registrations received on that port should not be propagated on
  //the other ports within the GIP Context. (IOL: Test12.2.2.7)
  if(cclmx_PortGetStpState(src_port) != STP_PORT_FORWARDING){
    return CCL_MX_DROP; 
  }
 
  //find the gid of this port, and pass the packet to the gid 
  if(gid_find_port(application->gid, src_port , &my_gid)){
     gid_rcv_pdu( &my_gmr->garp, src_port , (void *)rcv_pdu);
  }

  return CCL_MX_DROP;
}
#endif

/******************************************************************************
* SYSTIME : SYSTEM SUPPLIED SCHEDULING FUNCTIONS
*******************************************************************************/

// timer resolution = 1/100 sec
void systime_start_random_timer(Tuint32 process_id,
     void (*expiry_fn)(Tuint32),Tuint32 instance_id,Tuint32 timeout,struct timer_list *tEntry)
{
  Tuint32 tv;
  in_parm *parm=(in_parm *)tEntry->data;

  tv=net_random();

  //tv can't equal to zero, min value is 5
  if(tv < 0) {
    tv=((-tv) % timeout)+ 5;
  }
  else {
    tv=(tv % timeout)+ 5;
  }
  
#ifdef __GMRP__
  if(process_id==GMRP_PROCESS_ID){
    parm->application=&my_gmr->garp;
  }
#endif

#ifdef __GVRP__
  if (process_id==GVRP_PROCESS_ID) {
    parm->application=&my_gvr->garp;
  }
#endif

  parm->port_no=instance_id;

  init_timer(tEntry);
  (*tEntry).expires = jiffies+tv*HZ/100;
  (*tEntry).data=(Tuint32)parm;
  (*tEntry).function = expiry_fn;
  add_timer(tEntry);

}

// timer resolution = 1/100 sec
void systime_start_timer(Tuint32 process_id, 
       void (*expiry_fn) (Tuint32),Tuint32 instance_id,Tuint32 timeout,struct timer_list *tEntry)
{
  in_parm *parm=(in_parm *)tEntry->data;
 
#ifdef __GMRP__ 
  if(process_id==GMRP_PROCESS_ID) {  
    parm->application= &my_gmr->garp;
  }
#endif

#ifdef __GVRP__ 
  if (process_id==GVRP_PROCESS_ID) {
    parm->application= &my_gvr->garp;
  }
#endif

  parm->port_no=instance_id;
  
  init_timer(tEntry);
  (*tEntry).expires = jiffies+timeout*HZ/100;
  (*tEntry).data=(Tuint32)parm;
  (*tEntry).function = expiry_fn;
  add_timer(tEntry);
}

Tbool systime_stop_timer(struct timer_list *tEntry)
{
  if(tEntry->expires!=0)
  {
    del_timer(tEntry);
    return True;
  }
  else{
    return False;
  }
}

//schedule this function immediately
void systime_schedule(Tuint32 process_id, 
       void (*expiry_fn) (Tuint32),Tuint32 instance_id,struct timer_list *tEntry)
{
  in_parm *parm=(in_parm *)tEntry->data;

#ifdef __GMRP__ 
  if(process_id==GMRP_PROCESS_ID){  
    parm->application=&my_gmr->garp;
  }
#endif

#ifdef __GVRP__ 
  if (process_id==GVRP_PROCESS_ID) {
    parm->application=&my_gvr->garp;
  }
#endif

  parm->port_no=instance_id;
  expiry_fn((Tuint32)parm); 
}

/******************************************************************************
* SYSERR : FATAL ERROR HANDLING
*******************************************************************************/
void syserr_panic()
{
  printk("GVRP: system error panic...\n");
}

/******************************************************************************
* memory read/write : 
******************************************************************************/

Tuint8 check_1_byte(Tuint8 **pdu)
{
  return **pdu;
}

Tuint8 get_1_byte(Tuint8 **pdu)
{
  Tuint8 data= get_unaligned(*pdu);
  
  *pdu=*pdu+1;//shift 1 byte after reading
  return data;
}

Tuint16 get_2_bytes(Tuint8 **pdu)
{
  Tuint16 *data= (Tuint16 *)*pdu ;
  
  *pdu=*pdu+2;//shift 2 bytes after reading
  return ntohs(get_unaligned(data));

}

Tuint32 get_4_bytes(Tuint8 **pdu)
{
  Tuint32 *data=(Tuint32 *)*pdu;
  
  *pdu=*pdu+4; //shift 4 bytes after reading
  return ntohl(get_unaligned(data));
}

/******************************************************************************
* MAC compare/dup function : 
******************************************************************************/

Tbool mac_compare(Mac_addr src,Mac_addr dst)
{
  if(memcmp(src,dst,MAC_ADDR_LEN)==0){
    return True;
  }
  else {
    return False;    
  }
}

Tbool mac_clone(Mac_addr src,Mac_addr dst)
{
   memcpy(dst,src,MAC_ADDR_LEN);
   return True;
}

