/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : mfdb.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : Interface API of Multicast forwarding database
// ********************************************

#ifndef GARP_MFDB_H__
#define GARP_MFDB_H__

//#include "garp_common.h"

/******************************************************************************
* VFDB : Multicast ACTIVE FILTERING DATABASE INTERFACE
*******************************************************************************/

extern Tbool mfdb_filter( Tuint16 vid , Tuint32 port_no, Mac_addr dst_mac);
extern Tbool mfdb_forward(Tuint16 vid , Tuint32 port_no, Mac_addr dst_mac);

extern Tbool set_router_port_at_once(Tuint32 portmask);
extern Tbool set_normal_port_at_once(Tuint32 portmask);
extern Tbool fdb_forward_all_by_default(Tuint16 vid, Tuint32 port_no);
extern Tbool fdb_forward_unregistered_by_default(Tuint16 vid, Tuint32 port_no);
extern Tbool fdb_filter_by_default(Tuint16 vid, Tuint32 port_no);

#endif /* vfdb_h__ */

