/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : mfdb.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : Interface API of Multicast forwarding database
// ********************************************

#include "common.h"
#include "garp_common.h"
#include "gmrp_common.h"

extern Tuint32 gmrp_debug_level;
extern Gmr *my_gmr;

Tbool bIfMcstEntry=True, bIfOverWrite=True;

//set port x become routing port
//routing port is a member port for all multicast groups
static Tbool set_to_router_port(Tuint32 port_no)
{
  Tuint16 usSize;
  Tuint16 usIndex;
  Tuint8  aucMac[MAC_ADDR_LEN];
  Tuint16 usFid;
  Tbool   bStatic;
  Tuint32 gid_index;

  TstPPortMask   stMcstPhyMask;
  TstLPortMask   stMcstLogMask;

  K_MacGetTblSize(&usSize);
  for (usIndex = 0; usIndex < usSize; ++usIndex) {

    if (K_MacGetTblEntry(True, usIndex, aucMac, &usFid, &bStatic, &stMcstPhyMask) != KRN_RET_OK) {
 	continue;
    }

    cclmx_PMask2LMask( &stMcstLogMask, &stMcstPhyMask);
    
    if(gmd_find_entry(((Gmr *)my_gmr)->gmd, aucMac, &gid_index )) {
       //stMcstLogMask.ulMask[port_no/32] |= (0x01 << (port_no%32));
       K_LPortMaskSetPort(&stMcstLogMask, port_no);
       cclmx_LMask2PMask( &stMcstPhyMask, &stMcstLogMask);
       K_MacInsEntry(aucMac, usFid, bStatic, &stMcstPhyMask);
    }
     
  } 

 return True;
}

// set port x can't forward any multicast group packets
// filterd port is not a member port for any multicast group
static Tbool set_to_filtered_port(Tuint32 port_no)
{

  Gid     	 *my_port;
  Garp    	 *application=&my_gmr->garp;
  Tuint16 	 usSize;
  Tuint16 	 usIndex;
  Tuint8  	 aucMac[MAC_ADDR_LEN];
  Tuint16	 usFid;
  Tbool  	 bStatic;
  Tuint32 	 gid_index;
  TstPPortMask   stMcstPhyMask;
  TstLPortMask   stMcstLogMask, stLPortMask;

  if(!gid_find_port( application->gid, port_no , &my_port)){
     return False;
  }
 
  K_MacGetTblSize(&usSize);
  for(usIndex = 0; usIndex < usSize; ++usIndex) {
      
     if(K_MacGetTblEntry(True, usIndex, aucMac, &usFid, &bStatic, &stMcstPhyMask ) != KRN_RET_OK) {
	  continue;
     }
  
     cclmx_PMask2LMask( &stMcstLogMask, &stMcstPhyMask);
     if(gmd_find_entry(((Gmr *)my_gmr)->gmd, aucMac, &gid_index)) { 
     
        if(!gid_registered_here(my_port, gid_index)) { 
  	   //stMcstLogMask.ulMask[port_no/32] &= ~(0x01 << (port_no%32) );
  	   K_LPortMaskClrPort(&stMcstLogMask, port_no);
           
	   //if( !(stMcstLogMask.ulMask[0] & 0xfbffffff)  && !(stMcstLogMask.ulMask[1] & 0xffffffff)){ //no other member port
	   K_LPortMaskCopy(&stLPortMask, &stMcstLogMask);
	   K_LPortMaskClrPort(&stLPortMask, PORT_ID_CPU);
	   if(K_LPortMaskIsZero(&stLPortMask)) {
                  K_MacDelEntry(aucMac , usFid );
	   }else{
		  cclmx_LMask2PMask( &stMcstPhyMask, &stMcstLogMask);
	          K_MacInsEntry(aucMac, usFid, bStatic, &stMcstPhyMask);
	   }
	}
     }
  }//for

  return True;
}


//True: entry found   
//False: entry no found   
static Tbool find_multicast_mac(Tuint16 vid, Mac_addr dst_mac, Tuint8 *aucMac, Tuint16 *usFid, Tbool *bStatic,
                                TstLPortMask *stMcstLogMask)   
{   
  Tuint16 usSize;
  Tuint16 usIndex;
  TstPPortMask   stMcstPhyMask;
 
  K_MacGetTblSize(&usSize);

  for (usIndex = 0; usIndex < usSize; ++usIndex) {

      if (K_MacGetTblEntry(True, usIndex, aucMac, usFid, bStatic, &stMcstPhyMask) != KRN_RET_OK) {
          continue;
      }

      if( mac_compare(aucMac, dst_mac) ){
          cclmx_PMask2LMask( stMcstLogMask, &stMcstPhyMask);
          return True;   
      }   
  }//while   
   
  memset(stMcstLogMask,0,sizeof(TstLPortMask));  
  return False;   
} 



// remove portmask setting for the multicast mac addr
Tbool mfdb_filter( Tuint16 vid,Tuint32 port_no, Mac_addr dst_mac)
{
  Tuint8  aucMac[MAC_ADDR_LEN];
  Tuint16 usFid;
  Tbool   bStatic;
  TstPPortMask   stMcstPhyMask;
  TstLPortMask   stMcstLogMask, stLPortMask;

  if(gmrp_debug_level & GMRP_DEBUG_DB){
   printk("GMRP: Port%lu Filter Multicast Mac %02x:%02x:%02x:%02x:%02x:%02x VID=%02x\n",
           port_no+1,dst_mac[5],dst_mac[4], dst_mac[3], dst_mac[2], dst_mac[1] , dst_mac[0], vid );
  }

  // there is  exist mac address in mac table
  if(find_multicast_mac(vid, dst_mac, aucMac, &usFid, &bStatic, &stMcstLogMask)) { 

     //stMcstLogMask.ulMask[port_no/32] &= ~(0x01<< (port_no%32) );
     K_LPortMaskClrPort(&stMcstLogMask, port_no);
   
     //if( !(stMcstLogMask.ulMask[0] & 0xfbffffff) && !(stMcstLogMask.ulMask[1] & 0xffffffff)) { //no other member port
     K_LPortMaskCopy(&stLPortMask, &stMcstLogMask);
     K_LPortMaskClrPort(&stLPortMask, PORT_ID_CPU);
     if(K_LPortMaskIsZero(&stLPortMask)) {
           K_MacDelEntry(aucMac , vid);
     }
     else{
         cclmx_LMask2PMask( &stMcstPhyMask, &stMcstLogMask);
         K_MacInsEntry(aucMac, usFid, bStatic, &stMcstPhyMask);
     }
     
     return True;			
  }
     
  return False;
}

// add portmask setting for the multicast mac addr
Tbool mfdb_forward(Tuint16 vid, Tuint32 port_no, Mac_addr dst_mac)
{
  Tuint8  aucMac[MAC_ADDR_LEN];
  Tuint16 usFid;
  Tbool   bStatic;
  TstPPortMask   stMcstPhyMask;
  TstLPortMask   stMcstLogMask;

  if(gmrp_debug_level & GMRP_DEBUG_DB){
    printk("GMRP: Port%lu forward Multicast Mac %02x:%02x:%02x:%02x:%02x:%02x VID=%02x\n",
           port_no+1,dst_mac[5],dst_mac[4], dst_mac[3], dst_mac[2], dst_mac[1] , dst_mac[0] , vid);
  }

  // if there is already have static vlan, we just modify member port setting.
  // if vlan not exist, we add new dynamic vlan entry
  if(!find_multicast_mac(vid, dst_mac, aucMac, &usFid, &bStatic, &stMcstLogMask)) {
    memcpy(aucMac, dst_mac, MAC_ADDR_LEN);
    bStatic=1;
  }
  
  usFid=vid;
  //stMcstLogMask.ulMask[port_no/32] |= (0x01 << (port_no%32) );
  K_LPortMaskSetPort(&stMcstLogMask, port_no);
  cclmx_LMask2PMask( &stMcstPhyMask, &stMcstLogMask);
  K_MacDelEntry(aucMac , vid);
  K_MacInsEntry(aucMac, usFid, bStatic, &stMcstPhyMask);

  return True;			
}


// call this function when one port want to become router port.
Tbool fdb_forward_all_by_default( Tuint16 vid, Tuint32 port_no)
{
 if(gmrp_debug_level & GMRP_DEBUG_DB){
   printk("fdb_forward_all_by_default called: vid=%u port_no=%lu\n",vid, port_no+1);
 }
 
 set_to_router_port(port_no);
 return True;
 
}


//call this function when one port back to normal port.
Tbool fdb_filter_by_default(Tuint16 vid, Tuint32 port_no)
{

 if(gmrp_debug_level & GMRP_DEBUG_DB){
   printk("fdb_filter_by_default called: vid=%u port_no=%lu\n",vid, port_no+1);
 }
 
 set_to_filtered_port(port_no);
 return True;

}


// When switch receives an unregistered multicast packet, it will flooding to all ports
// It's mean we do not need to do anything
Tbool fdb_forward_unregistered_by_default( Tuint16 vid, Tuint32 port_no)
{
  return True;
}


