/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gvrp_netfilter.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : communicate with user land program(CLI/Web)
// ********************************************

#include "krndef.h"
#include "krntype.h"

#ifndef GVRP_NETFILTER_H
#define GVRP_NETFILTER_H

#define GVRP_DB_END			    (0)
#define GVRP_BASE_CTL		            (64+1024+64+64+1300)

#define SET_GVRP_GLOBAL_ENABLE              (GVRP_BASE_CTL+1)
#define SET_GVRP_GLOBAL_DISABLE        	    (GVRP_BASE_CTL+2)
#define SET_PORT_GVRP_ENABLE         	    (GVRP_BASE_CTL+3)
#define SET_PORT_GVRP_DISABLE	    	    (GVRP_BASE_CTL+4)
#define SET_GVRP_DEBUG_ENABLE          	    (GVRP_BASE_CTL+5)
#define SET_GVRP_DEBUG_DISABLE         	    (GVRP_BASE_CTL+6)
#define SET_GVRP_APPLICANT_NORMAL           (GVRP_BASE_CTL+7)
#define SET_GVRP_APPLICANT_ACTIVE	    (GVRP_BASE_CTL+8)
#define ADD_STATIC_VLAN_ENTRY       	    (GVRP_BASE_CTL+9)
#define EDIT_STATIC_VLAN_ENTRY       	    (GVRP_BASE_CTL+10)
#define DEL_STATIC_VLAN_ENTRY   	    (GVRP_BASE_CTL+11)
#define CLEAR_GVRP_STATISTICS_COUNTER 	    (GVRP_BASE_CTL+12)
#define SET_PVID			    (GVRP_BASE_CTL+13)
#define	SET_GVRP_TRUNK_ADD		    (GVRP_BASE_CTL+14)
#define	SET_GVRP_TRUNK_DEL		    (GVRP_BASE_CTL+15)
#define GVRP_SET_MAX	     	            (GVRP_BASE_CTL+50)


#define SHOW_GVRP_STATISTICS 	            (GVRP_BASE_CTL+1)
#define SHOW_GVRP_TIMER       	            (GVRP_BASE_CTL+2)
#define SHOW_GVRP_GIP         	            (GVRP_BASE_CTL+3)
#define SHOW_GVRP_MACHINE		    (GVRP_BASE_CTL+4)	
#define SHOW_GVRP_DB          	            (GVRP_BASE_CTL+5)
#define SHOW_GVRP_STATUS      	            (GVRP_BASE_CTL+6)
#define SHOW_PORT_GVRP                      (GVRP_BASE_CTL+7)
#define SHOW_PORT_LAST_PDU_ORIGIN           (GVRP_BASE_CTL+8)
#define GVRP_GET_MAX	       	            (GVRP_BASE_CTL+50)

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : IMPLEMENTATION SIZING
*******************************************************************************/
enum {GVRP_DB_SIZE = 128};

//data structure is used when gvrp communicate with userland program
typedef struct
{
  Tuint16	attr;
  Tuint8	used;
} gvrp_db;

typedef struct
{
  Tuint16	vid;
  Tuint8	name[8];
  Tuint32	member_port;
  Tuint8	status:1;
} vlan_data;

typedef struct _set_pvid {
  Tuint8	port_id;
  Tuint16	pvid;
} set_pvid;

typedef struct {
  Tuint16	usVlanId;
  TstLPortMask	stPortMask;
} TstGvrpVlan;

#endif

