/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************************
// Name   : gvrp_netfilter.c
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : Communicate with CLI/Web using netfilter method
// ********************************************************

#include "common.h"
#include "garp_common.h"
#include "gvrp_common.h"


extern Gvr 		*my_gvr;
extern Tbool 		gvrp_enable;
extern Tuint32 		gvrp_debug_level;
extern Tuint8 		bLastRcvMac[MAX_LOGIC_PORT][MAC_ADDR_LEN];
extern garp_statistics  gvrp_statistics[MAX_LOGIC_PORT];

extern void 		(*gvrp_stp_port_forwarding)(Tuint32 );
extern void		(*gvrp_stp_port_disabled)(Tuint32 );

Tuint8 			aucGvrpPortEbl[MAX_LOGIC_PORT]; 
TstLPortMask 		astStaticVlanGrp[4096];

/* This function is called whenever a process tries to do setsockopt */
int do_gvrp_set_ctl(struct sock *sk, int cmd, void *user, unsigned int len)
{
  
 Garp 		 *application= &my_gvr->garp;
 Tuint8		 trunk_id;
 Tuint16	 vlan_id;
 Tuint32 	 i=0;
 Tuint32	 debug_ebl=0;
 TstGarpTrk      stTrkInfo;
 TstLPortMask    logic_pm;
 TstGvrpVlan     vlan_info;

 switch (cmd)
 {
  // enable GVRP protocol      
  case SET_GVRP_GLOBAL_ENABLE:
        if(gvrp_enable==False) {

        gvrp_stp_port_forwarding = gvrp_stp_connect_port;
        gvrp_stp_port_disabled = gvrp_stp_disconnect_port;
	
	gip_create_gip(GVRP_DB_SIZE, &application->gip);//create one gip per box
        gvd_create_gvd(GVRP_DB_SIZE, &my_gvr->gvd);//create one gvd per box
        
	for(i=0;i < MAX_LOGIC_PORT; i++) {
          if(aucGvrpPortEbl[i] == True){
	     gid_create_port( &my_gvr->garp,i);
	  }
	}
	
	gvrp_enable=True;
	reset_gvrp_db();
	set_gvrp_db_from_reg_init();
	K_GvrpSetEbl(True);//forward GVRP packet to cpu
       }
       break;
 
  // disable GVRP protocol      
  case SET_GVRP_GLOBAL_DISABLE:
       if(gvrp_enable==True) {
         K_GvrpSetEbl(False);//Don't forward GVRP packet to cpu, just broadcast it.
         gvrp_enable=False; 
        
	 gvrp_stp_port_forwarding=NULL;
         gvrp_stp_port_disabled=NULL;
         
	 gvr_destroy_gvr(my_gvr);
	}
      
       break;
     
  case SET_GVRP_DEBUG_ENABLE:
       copy_from_user(&debug_ebl,user,len); 
       gvrp_debug_level=gvrp_debug_level | debug_ebl;
       break;
      
  case SET_GVRP_DEBUG_DISABLE:
       copy_from_user(&debug_ebl,user,len); 
       gvrp_debug_level=gvrp_debug_level & ~debug_ebl;
       break;
      
  //Enabling GVRP on Individual 802.1Q Trunk Ports,  create one gid per port 
  case SET_PORT_GVRP_ENABLE:
      
       copy_from_user(&logic_pm,user,len); 
      
       // reading vlan info , and set into gvrp db
       gid_port_enable(application,&logic_pm); 
       reset_gvrp_db();
       set_gvrp_db_from_reg();
       break;

  case ADD_STATIC_VLAN_ENTRY:
       copy_from_user(&vlan_info,user,len); //get port info
       memcpy(&astStaticVlanGrp[vlan_info.usVlanId],&vlan_info.stPortMask,sizeof(vlan_info.stPortMask));
       gid_add_edit_static_vlan(vlan_info.usVlanId,&vlan_info.stPortMask);
       break;

  case DEL_STATIC_VLAN_ENTRY:   
       copy_from_user(&vlan_id,user,len); //get port info
       memset(&astStaticVlanGrp[vlan_id],0 ,sizeof(TstLPortMask)); //clear static vlan setting
       gid_del_static_vlan(vlan_id);
       break;


  case SET_PVID:
  	if(gvrp_enable==True) {
	  reset_gvrp_db();
	  set_gvrp_db_from_reg();
       }
       break;
      

  case CLEAR_GVRP_STATISTICS_COUNTER:
       copy_from_user(&logic_pm,user,len); //get port info
       for(i=0;i < MAX_LOGIC_PORT;i++) { 
          //if(logic_pm.ulMask[i/32] & (1<<(i%32) ))
          if(K_LPortMaskGetPort(&logic_pm, i)) {
             memset(&gvrp_statistics[i],0,sizeof(gvrp_statistics[i]));
          }
       }
       break;     
   
  case SET_GVRP_TRUNK_ADD:
       copy_from_user(&stTrkInfo,user,len);
       if(gid_trunk_add(application, stTrkInfo)) {
	  reset_gvrp_db();
	  set_gvrp_db_from_reg();
       }
       break;

  case SET_GVRP_TRUNK_DEL:
       copy_from_user(&trunk_id,user,len);
       if (gid_trunk_del(application, trunk_id)) {
	   reset_gvrp_db();
	   set_gvrp_db_from_reg();
       }
       break;

  default:
      if(gvrp_debug_level & GVRP_DEBUG_ERR)
        printk("GVRP: ioctl_num error..\n");
      break;  
  }

  return 0;
}


/* This function is called whenever a process tries to do getsockopt */
int do_gvrp_get_ctl(struct sock *sk, int cmd, void *user, int *len)
{

 Garp 		*application= &my_gvr->garp;
 Tuint8 	gip_ring[MAX_LOGIC_PORT+1]; // store gip ring info
 Tuint8		ucPortId;
 TstLPortMask   logic_pm;
 gvrp_db 	show_db[GVRP_DB_SIZE];    // used by show_garp_db command
 Gid_machine    gvrp_machine[GVRP_DB_SIZE * MAX_LOGIC_PORT]; // store machine state
 
 switch(cmd)
 {
   case SHOW_GVRP_STATISTICS:
	copy_to_user(user,gvrp_statistics,sizeof(gvrp_statistics));
	break;
   
   case SHOW_GVRP_GIP:
 	gip_ring_info(application,gip_ring);
    	copy_to_user(user,gip_ring,sizeof(gip_ring));
 	break;
  
   case SHOW_GVRP_MACHINE:
 	gidtt_machine_info(application,gvrp_machine);
  	copy_to_user(user,gvrp_machine,  sizeof(gvrp_machine));
 	break; 
  
   case SHOW_GVRP_DB:
	gvrp_db_info(show_db);
	copy_to_user(user,show_db, sizeof(show_db));
 	break;
      
   case SHOW_GVRP_STATUS:
	copy_to_user(user,&gvrp_enable,sizeof(gvrp_enable));
	break;

   case SHOW_PORT_GVRP:
	memset(&logic_pm,0,sizeof(logic_pm));
	if(gvrp_enable==True) {
           for(ucPortId=0; ucPortId< MAX_LOGIC_PORT; ucPortId++) {
             if(aucGvrpPortEbl[ucPortId] == True) {
               //logic_pm.ulMask[ucPortId/32] |= (0x01<<(ucPortId%32) );
               K_LPortMaskSetPort(&logic_pm, ucPortId);
	     }
	   }
	}
	copy_to_user(user,&logic_pm,sizeof(logic_pm));
	break; 

   case SHOW_PORT_LAST_PDU_ORIGIN:
	copy_to_user(user,bLastRcvMac,sizeof(bLastRcvMac));
	break;

   default:
	if(gvrp_debug_level & GVRP_DEBUG_ERR)
        printk("GVRP: ioctl_num error..\n");
	break;  
    }

 return 0;
}

struct nf_sockopt_ops gvrp_sockopts = {
   { NULL, NULL }, PF_INET,
   GVRP_BASE_CTL, GVRP_SET_MAX+1, do_gvrp_set_ctl, NULL,
   GVRP_BASE_CTL, GVRP_GET_MAX+1, do_gvrp_get_ctl, NULL
};


