/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gvr.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   : GARP VLAN registration
// ********************************************


#ifndef GARP_GVR_H__
#define GARP_GVR_H__


/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : GARP ATTRIBUTES
******************************************************************************/
typedef Tuint16 Vlan_id;

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : CREATION, DESTRUCTION
*******************************************************************************/

typedef struct /* Gvr */
{
  Garp      garp;
  void      *gvd; /* VLAN Registration Entry Database */
  Tuint32   vlan_id;
  Tuint32   number_of_gvd_entries;
  Tuint32   last_gvd_used_plus1;
} Gvr;

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : CREATION, DESTRUCTION
*******************************************************************************/
extern Tbool gvr_create_gvr(Tuint32 process_id, void **gvr);
extern void  gvr_destroy_gvr(void *gvr);
extern void  gvr_added_port(void *my_gvr, Tuint32 port_no);
extern void  gvr_removed_port(void *my_gvr, Tuint32 port_no);

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : JOIN, LEAVE INDICATIONS
*******************************************************************************/
extern void gvr_join_indication(void *my_gvr, void *my_port,Tuint32 joining_gid_index);
extern void gvr_join_leave_propagated(void *my_gvr, void *my_port,Tuint32 gid_index);
extern void gvr_leave_indication(void *my_gvr, void *my_port,Tuint32 leaving_gid_index);

/******************************************************************************
* GVR : GARP VLAN REGISTRATION APPLICATION : PROTOCOL & MGT EVENTS
*******************************************************************************/
/* Process an entire received pdu for this instance of GVR. */
extern Tuint32 gvr_rcv(void *my_gvr, void *port, void *rx_pdu);

/* Transmit a pdu for this instance of GVR. */
extern void gvr_tx(void *my_gvr, void *my_port);


#endif /* gvr_h__ */
