/***************************************************************************
 *
 *  Copyright (C) 2003-2005 CCL, ITRI.  All Rights Reserved.
 *
 *  THIS IS AN UNPUBLISHED WORK WHICH CONTAINS CONFIDENTIAL INFORMATION
 *  FROM CCL, ITRI.  NO PART OF THIS WORK MAY BE USED IN ANY WAY WITHOUT
 *  THE PRIOR WRITTEN PERMISSION.  ANY UNAUTHORIZED USE COULD SUBJECT THE
 *  PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
 *
 *  CCL, ITRI IS NOT RESPONSIBLE OR LIABLE FOR ANY DIRECT, INDIRECT,
 *  SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES THAT MAY RESULT FROM
 *  THE USE, OR INABILITY TO USE OF THIS WORK.  ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *
 ***************************************************************************/

// ********************************************
// Name   : gvd.h
// Author : Liu, Ren Hao (N300, CCL/ITRI)
// Date   : 2003/06/26
// Note   :GARP VLAN Database
// ********************************************

#ifndef GARP_GVD_H__
#define GARP_GVD_H__

#include "gvrp_netfilter.h"

/******************************************************************************
 * GVD : GARP VLAN DATABASE
 ******************************************************************************
 *
 * The GARP VLAN Database maps VLAN IDs into compact GID indexes and
 * vice versa. It contains VLAN ID to index mappings for all the VLAN IDs
 * dynamically registered (except when there is a database overflow which
 * should be an event that is kept exceedingly rare through appropriate
 * sizing) and for all those for which static controls exist.
 *
 * Taken together with the GID machines for each port (which are identified
 * by the GID indexes provided by GVD), GVD logically provides the Static VLAN
 * Entries and the VLAN Registration Entries of the abstract Filtering Database
 * (P802.1Q, Clause 3.9).
 *
 * Static VLAN Entries are included in this database (and have GID machines
 * defined) on an as needed basis as ports are added to the GVR Application.
 * This example implementation assumes that the necessary information is taken
 * from Static Filtering Entries kept in a Permanent Database outside the
 * example implementation. Static VLAN Entries can also be added, changed, or
 * removed as the running system is managed.
 *
 * VLAN Registration Entries are added and removed by GVRP. Note that a
 * single VLAN ID will only give rise to one entry in this database, and one
 * GID machine per port. That machine provides the functionality for both
 * the Static VLAN Entry and the VLAN Registration Entry.
 */

extern Tbool gvd_create_gvd(Tuint32 max_vlans, void **gvd);
extern void gvd_destroy_gvd(void *gvd);

extern Tbool gvd_find_entry(void *my_gvd, Vlan_id key,Tuint32 *found_at_index);
extern Tbool gvd_create_entry(void *my_gvd, Vlan_id key,Tuint32 *created_at_index);
extern Tbool gvd_delete_entry(void *my_gvd,Tuint32  delete_at_index);
extern Tbool gvd_get_key(void *my_gvd, Tuint32 index, Vlan_id *key);

/*
* syc register and gvrp database
*/
extern void set_gvrp_db_from_reg(void);
extern void set_gvrp_db_from_reg_init(void);
extern void reset_gvrp_db(void);
extern void gvrp_db_info(gvrp_db show_db[]);


#endif /* gvd_h__ */

